/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.cache;

import com.evermind.server.ApplicationServerTransactionSynchronization;
import com.evermind.server.ejb.EntityEJBObject;
import com.evermind.server.ejb.ExtendedContainerManagedObject;
import com.evermind.server.ejb.cache.AbstractCacheManager;
import com.evermind.server.ejb.cache.BMPCacheManager;
import com.evermind.server.ejb.cache.CMPCacheManager;
import com.evermind.server.ejb.cache.CacheManagerException;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;

public final class EntityCacheManager
extends AbstractCacheManager {
    private static EntityCacheManager _instance = null;
    private AbstractCacheManager _bmpcm = BMPCacheManager.instance();
    private AbstractCacheManager _cmpcm = CMPCacheManager.instance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityCacheManager instance() {
        if (_instance == null) {
            Object object = _CacheManagerLock;
            synchronized (object) {
                if (_instance == null) {
                    _instance = new EntityCacheManager();
                }
            }
        }
        return _instance;
    }

    public void update(EntityEJBObject[] entries, int entriesCount) {
        this._bmpcm.update(entries, entriesCount);
        this._cmpcm.update(entries, entriesCount);
    }

    public void update(EntityEJBObject[] entries, int entriesCount, boolean isBMP) {
        if (isBMP) {
            this._bmpcm.update(entries, entriesCount);
        } else {
            this._cmpcm.update(entries, entriesCount);
        }
    }

    public final Object put(Object key, EntityEJBObject bean) {
        if (bean._isBMP()) {
            return this._bmpcm.put(key, bean);
        }
        return this._cmpcm.put(key, bean);
    }

    public final Object clone(Object key, BeanDescriptor desc, Object dest) {
        EntityBeanDescriptor desc2 = (EntityBeanDescriptor)desc;
        if (desc2.isBMP()) {
            return this._bmpcm.clone(key, desc, dest);
        }
        return this._cmpcm.clone(key, desc, dest);
    }

    public ExtendedContainerManagedObject remove(Object key, BeanDescriptor desc) {
        EntityBeanDescriptor desc2 = (EntityBeanDescriptor)desc;
        if (desc2.isBMP()) {
            return this._bmpcm.remove(key, desc);
        }
        return this._cmpcm.remove(key, desc);
    }

    public void checkForUpdate(EntityEJBObject[] entries, int entriesCount, ApplicationServerTransactionSynchronization tx) throws CacheManagerException {
        this._bmpcm.checkForUpdate(entries, entriesCount, tx);
        this._cmpcm.checkForUpdate(entries, entriesCount, tx);
    }

    public void checkForUpdate(EntityEJBObject[] entries, int entriesCount, ApplicationServerTransactionSynchronization tx, boolean isBMP) throws CacheManagerException {
        if (isBMP) {
            this._bmpcm.checkForUpdate(entries, entriesCount, tx);
        } else {
            this._cmpcm.checkForUpdate(entries, entriesCount, tx);
        }
    }

    public boolean allowToUpdate(EntityEJBObject bean, String controlFieldName) {
        return false;
    }
}

