/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.cache;

import com.evermind.server.ejb.cache.AlternateHashTable;
import com.evermind.server.ejb.cache.EntityCacheManager;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.util.EJBProperties;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CacheManagerTask
implements Runnable {
    public static final int MIN_INTERVAL = EJBProperties.getCacheManagerClearingMin();
    private static CacheManagerTask _instance = null;
    private EntityCacheManager _cm;
    private int _wakeInterval = Integer.MAX_VALUE;
    private static Logger m_logger = EJBTraceLogger.getLogger(CacheManagerTask.class);

    public CacheManagerTask() {
        this._cm = EntityCacheManager.instance();
        this._cm.setTime(System.currentTimeMillis());
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "CacheManagerTask min interval:" + MIN_INTERVAL);
        }
    }

    public void run() {
        if (!this._cm.isUsed()) {
            return;
        }
        if (this._wakeInterval == Integer.MAX_VALUE) {
            return;
        }
        this._cm.setTime(System.currentTimeMillis());
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "CacheManagerTask time:" + this._cm.getTime());
        }
        HashMap map = this._cm.getDescriptors();
        Iterator it = map.values().iterator();
        int cleaned = 0;
        while (it.hasNext()) {
            BeanDescriptor bd = (BeanDescriptor)it.next();
            if (bd.getTTL() <= 0) continue;
            AlternateHashTable cache = bd.getCache();
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.log(Level.FINER, "Invoking Cache Cleanup for " + bd.getName() + " size:" + cache.size() + " ttl:" + bd.getTTL());
            }
            cleaned = cache.cleanUp(bd.getTTL());
            if (!m_logger.isLoggable(Level.FINEST) || cleaned <= 0) continue;
            m_logger.log(Level.FINEST, ">> Purged " + cleaned + " entries in " + bd.getName());
        }
    }

    public static CacheManagerTask instance() {
        if (_instance == null) {
            _instance = new CacheManagerTask();
        }
        return _instance;
    }

    public final void updateTTL(int newTTL) {
        if (newTTL < this._wakeInterval && newTTL != -1) {
            this._wakeInterval = newTTL;
            if (this._wakeInterval < MIN_INTERVAL) {
                this._wakeInterval = MIN_INTERVAL;
            }
        }
    }

    public final int getWakeInterval() {
        return this._wakeInterval;
    }
}

