/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.cache;

import com.evermind.server.ApplicationServerTransactionSynchronization;
import com.evermind.server.ejb.DataSourceConnection;
import com.evermind.server.ejb.EntityEJBHome;
import com.evermind.server.ejb.EntityEJBObject;
import com.evermind.server.ejb.ExtendedContainerManagedObject;
import com.evermind.server.ejb.cache.AbstractCacheManager;
import com.evermind.server.ejb.cache.CacheManagerException;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CMPCacheManager
extends AbstractCacheManager {
    private static AbstractCacheManager _instance;
    private static Logger m_logger;

    protected CMPCacheManager() {
        _instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractCacheManager instance() {
        if (_instance == null) {
            Object object = _CacheManagerLock;
            synchronized (object) {
                if (_instance == null) {
                    _instance = new CMPCacheManager();
                }
            }
        }
        return _instance;
    }

    public void update(EntityEJBObject[] entries, int entriesCount) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "- update -> " + entriesCount);
        }
        for (int i = 0; i < entriesCount; ++i) {
            EntityEJBObject bean = entries[i];
            if (!bean.OC4J_isCacheable() || bean._isBMP()) continue;
            try {
                ExtendedContainerManagedObject value = (ExtendedContainerManagedObject)bean.getEntityBean();
                if (value != null) {
                    Object key = bean.getPrimaryKey_X();
                    byte state = value._getState();
                    byte flag = value._getFlag();
                    int ocn = value._getBaseVersion();
                    if ((state & 8) == 8) {
                        value = bean.getBeanDescriptor().removeFromCache(key);
                        if (!m_logger.isLoggable(Level.FINE)) continue;
                        m_logger.log(Level.FINE, "-- update - remove object " + key + " ocn=" + ocn + " " + bean.getBeanDescriptor().getEJBClassName());
                        continue;
                    }
                    if ((state & 4) == 4 || (state & 2) == 2) {
                        value = (ExtendedContainerManagedObject)bean.getBeanDescriptor().updateCache(key, value);
                        if (!m_logger.isLoggable(Level.FINE)) continue;
                        if (value != null) {
                            m_logger.log(Level.FINE, "-+ update - updated object " + key + " ocn=" + ocn + " " + bean.getBeanDescriptor().getEJBClassName());
                            continue;
                        }
                        m_logger.log(Level.FINE, "-+ update - created object " + key + " ocn=" + ocn + " " + bean.getBeanDescriptor().getEJBClassName());
                        continue;
                    }
                    if ((state & 0x10) == 16) {
                        if (m_logger.isLoggable(Level.FINE)) {
                            m_logger.log(Level.FINE, "-+ update - loaded " + key + " ocn=" + ocn + " " + bean.getBeanDescriptor().getEJBClassName());
                        }
                        value = (ExtendedContainerManagedObject)bean.getBeanDescriptor().updateCache(key, value);
                        continue;
                    }
                    if ((state & 1) == 1) {
                        if (value._isChanged()) {
                            if (m_logger.isLoggable(Level.FINE)) {
                                m_logger.log(Level.FINE, "-+ update - noop - write " + key + " ocn=" + ocn + " " + bean.getBeanDescriptor().getEJBClassName());
                            }
                            value = (ExtendedContainerManagedObject)bean.getBeanDescriptor().updateCache(key, value);
                            continue;
                        }
                        if (!m_logger.isLoggable(Level.FINE)) continue;
                        m_logger.log(Level.FINE, "-+ skip - noop " + key + " ocn=" + ocn + " " + bean.getBeanDescriptor().getEJBClassName());
                        continue;
                    }
                    if (!m_logger.isLoggable(Level.FINE)) continue;
                    m_logger.log(Level.FINE, "-+ update - illegal state " + state + "for key " + key + " ocn=" + ocn + " " + bean.getBeanDescriptor().getEJBClassName());
                    continue;
                }
                if (!m_logger.isLoggable(Level.FINE)) continue;
                m_logger.log(Level.FINE, "-? update value is null for " + bean.getPrimaryKey_X() + " " + bean.getBeanDescriptor().getEJBClassName());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Object put(Object key, EntityEJBObject bean) {
        ExtendedContainerManagedObject obj = (ExtendedContainerManagedObject)bean.getBeanDescriptor().updateCache(key, bean.getEntityBean());
        if (m_logger.isLoggable(Level.FINE)) {
            int ocn = 0;
            if (obj != null) {
                ocn = obj._getBaseVersion();
                m_logger.log(Level.FINE, "+ put - updated object " + key + " ocn=" + ocn + " " + bean.getBeanDescriptor().getEJBClassName());
            } else {
                m_logger.log(Level.FINE, "+ put - created object " + key + " ocn=" + ocn + " " + bean.getBeanDescriptor().getEJBClassName());
            }
        }
        return obj;
    }

    public Object clone(Object key, BeanDescriptor desc, Object dest) {
        if (m_logger.isLoggable(Level.FINE) && dest == null) {
            m_logger.log(Level.FINE, "+ clone - error " + key + " dest=" + dest + " " + desc.getEJBClassName());
        }
        ExtendedContainerManagedObject obj = (ExtendedContainerManagedObject)desc.cloneFromCache(key, dest);
        if (m_logger.isLoggable(Level.FINE)) {
            int ocn = 0;
            if (obj != null) {
                ocn = obj._getBaseVersion();
                m_logger.log(Level.FINE, "+ clone - cache hit " + key + " ocn=" + ocn + " " + desc.getEJBClassName() + " " + dest);
            } else {
                m_logger.log(Level.FINE, "+ clone - not found " + key + " ocn=" + ocn + " " + desc.getEJBClassName());
                new Throwable().printStackTrace();
            }
        }
        return obj;
    }

    public ExtendedContainerManagedObject remove(Object key, BeanDescriptor desc) {
        ExtendedContainerManagedObject obj = desc.removeFromCache(key);
        if (m_logger.isLoggable(Level.FINE)) {
            int ocn = 0;
            if (obj != null) {
                ocn = obj._getBaseVersion();
                m_logger.log(Level.FINE, "+ remove - cache hit " + key + " ocn=" + ocn + " " + desc.getEJBClassName());
            } else {
                m_logger.log(Level.FINE, "+ remove - not found " + key + " ocn=" + ocn + " " + desc.getEJBClassName());
            }
        }
        return obj;
    }

    public void checkForUpdate(EntityEJBObject[] entries, int entriesCount, ApplicationServerTransactionSynchronization tx) throws CacheManagerException {
        for (int i = 0; i < entriesCount; ++i) {
            EntityEJBObject bean = entries[i];
            if (!bean.OC4J_isCacheable() || bean._isBMP()) continue;
            try {
                ExtendedContainerManagedObject value = (ExtendedContainerManagedObject)bean.getEntityBean();
                if (value != null) {
                    Object key = bean.getPrimaryKey_X();
                    byte flag = value._getFlag();
                    byte state = value._getState();
                    if ((state & 2) == 2 || (state & 8) == 8 || flag != 1 && flag != 3) continue;
                    DataSourceConnection connection = tx.getConnection(((EntityEJBHome)bean.getMyHome()).dataSourceContainer);
                    if (m_logger.isLoggable(Level.FINE)) {
                        m_logger.log(Level.FINE, "-* lock " + key + " " + this.flagAndState(value));
                    }
                    if (value._lock(connection)) continue;
                    if (m_logger.isLoggable(Level.FINE)) {
                        m_logger.log(Level.FINE, "-* lock Optimisitc Control Exception for " + key + " " + this.flagAndState(value));
                        m_logger.log(Level.FINE, "*** lock Optimisitc Control Exception for " + key + " " + this.flagAndState(value));
                    }
                    throw new CacheManagerException("Optimisitc Control Exception for " + key + " " + this.flagAndState(value));
                }
                if (!m_logger.isLoggable(Level.FINE)) continue;
                m_logger.log(Level.FINE, "-! update value is null for " + bean.getPrimaryKey_X());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean allowToUpdate(EntityEJBObject bean, String controlFieldName) {
        return false;
    }

    static {
        m_logger = EJBTraceLogger.getLogger(CMPCacheManager.class);
    }
}

