/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.cache;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ApplicationServerTransactionSynchronization;
import com.evermind.server.ejb.EntityEJBObject;
import com.evermind.server.ejb.ExtendedContainerManagedObject;
import com.evermind.server.ejb.cache.CacheManagerException;
import com.evermind.server.ejb.cache.CacheManagerTask;
import com.evermind.server.ejb.cache.CachePolicy;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.util.TaskManager;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;

public abstract class AbstractCacheManager
implements Synchronization,
CachePolicy {
    private static HashMap _descriptors = null;
    protected static Object _CacheManagerLock = new Object();
    private static volatile long _time = System.currentTimeMillis();
    private boolean _isUsed = false;
    private static Logger m_logger = EJBTraceLogger.getLogger(AbstractCacheManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCacheManager() {
        Object object = _CacheManagerLock;
        synchronized (object) {
            _descriptors = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCacheManagerTask(TaskManager tm) {
        Object object = _CacheManagerLock;
        synchronized (object) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "AbstractCacheManager initialized " + tm);
            }
            tm.addTask(CacheManagerTask.instance(), CacheManagerTask.MIN_INTERVAL);
        }
    }

    public abstract void update(EntityEJBObject[] var1, int var2);

    public abstract Object put(Object var1, EntityEJBObject var2);

    public abstract Object clone(Object var1, BeanDescriptor var2, Object var3);

    public abstract boolean allowToUpdate(EntityEJBObject var1, String var2);

    public abstract ExtendedContainerManagedObject remove(Object var1, BeanDescriptor var2);

    public void beforeCompletion() {
        if (!this.isUsed()) {
            return;
        }
        ApplicationServerTransaction tx = null;
        try {
            tx = (ApplicationServerTransaction)ApplicationServer.getInstance().getTransactionManager().getTransaction();
        }
        catch (SystemException systemException) {
            m_logger.log(Level.WARNING, ">> beforeCompletion SystemException from getTransaction" + (Object)((Object)systemException));
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, ">> beforeCompletion " + tx);
        }
        try {
            tx.prepareChangesToCache();
        }
        catch (CacheManagerException e) {
            tx.addException(e);
        }
    }

    public void afterCompletion(int status) {
        if (!this.isUsed()) {
            return;
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            try {
                m_logger.log(Level.FINEST, ">> afterCompletion " + ApplicationServer.getInstance().getTransactionManager().getTransaction());
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
        if (status == 3) {
            ApplicationServerTransaction tx = null;
            try {
                tx = (ApplicationServerTransaction)ApplicationServer.getInstance().getTransactionManager().getTransaction();
            }
            catch (SystemException systemException) {
                m_logger.log(Level.WARNING, ">> afterCompletion SystemException from getTransaction" + (Object)((Object)systemException));
            }
            if (tx != null) {
                tx.mergeChangesToCache();
            }
        }
    }

    public abstract void checkForUpdate(EntityEJBObject[] var1, int var2, ApplicationServerTransactionSynchronization var3) throws CacheManagerException;

    protected String flagAndState(ExtendedContainerManagedObject value) {
        String str = new String();
        str = str + " F:";
        str = str + ExtendedContainerManagedObject.Flag.toString(value._getFlag());
        str = str + " S:";
        str = str + ExtendedContainerManagedObject.State.toString(value._getState());
        str = str + " OCN:";
        str = str + value._getVersion();
        str = str + "/";
        str = str + value._getBaseVersion();
        str = str + " ";
        return str;
    }

    public final BeanDescriptor registerDescriptor(String cls, BeanDescriptor desc) {
        BeanDescriptor rdesc = _descriptors.put(cls, desc);
        CacheManagerTask.instance().updateTTL(desc.getTTL());
        boolean bl = this._isUsed = _descriptors.size() > 0;
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "* registerDescriptor for " + cls + " desc: " + desc);
        }
        return rdesc;
    }

    public final BeanDescriptor getDescriptor(String cls) {
        BeanDescriptor desc = (BeanDescriptor)_descriptors.get(cls);
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "* getDescriptor for " + cls + " desc: " + desc);
        }
        return desc;
    }

    public final HashMap getDescriptors() {
        return _descriptors;
    }

    public boolean isUsed() {
        return this._isUsed;
    }

    public long getTime() {
        return _time;
    }

    public long update(long oldVal) {
        return _time;
    }

    public boolean expired(long lastAccessed, int ttl) {
        if (ttl == -1) {
            return false;
        }
        return _time > lastAccessed + (long)ttl;
    }

    public long setTime(long time) {
        long oldTime = _time;
        _time = time;
        return oldTime;
    }
}

