/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ejb.AnnotationListener;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.logging.EJBAnnotationMessages;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

public class POJOEntityAnnotationListener
implements AnnotationListener {
    private static final String ENTITY_ANNOTATION = "javax.persistence.Entity";
    private static final String GET_ANNOTATION_METHOD = "getAnnotation";
    private static Method getAnnotationMethod;
    private static Class entityAnnotationClass;
    private ArrayList annotatedClasses = new ArrayList();
    private ArrayList annotatedClassNames = new ArrayList();

    public void parseAnnotatedClass(Class annotatedClass, ClassLoader loader, Object annotationManager) {
        if (getAnnotationMethod == null) {
            return;
        }
        try {
            if (getAnnotationMethod.invoke((Object)annotatedClass, entityAnnotationClass) != null) {
                this.annotatedClasses.add(annotatedClass);
                this.annotatedClassNames.add(annotatedClass.getName());
            }
        }
        catch (IllegalArgumentException e) {
            throw EJBUtils.createEJBException(e);
        }
        catch (IllegalAccessException e) {
            throw EJBUtils.createEJBException(e);
        }
        catch (InvocationTargetException e) {
            throw EJBUtils.createEJBException(e);
        }
    }

    public Collection getAnnotatedClasses() {
        return this.annotatedClasses;
    }

    public Collection getAnnotatedClassNames() {
        return this.annotatedClassNames;
    }

    static {
        try {
            getAnnotationMethod = Class.class.getMethod(GET_ANNOTATION_METHOD, Class.class);
            entityAnnotationClass = Class.forName(ENTITY_ANNOTATION);
        }
        catch (Exception e) {
            EJBAnnotationMessages.warningEJB3WithoutJDK15();
        }
    }
}

