/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.AbstractEJBObject;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.EntityContainer;
import com.evermind.server.ejb.EntityEJBHome;
import com.evermind.server.ejb.EvermindEntityContext;
import com.oracle.server.ejb.persistence.pm.CmpEntityBean;
import com.oracle.server.ejb.persistence.pm.CmpEntityContext;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;

public class OracleEntityContext
extends EvermindEntityContext
implements CmpEntityContext {
    private Object primaryKey = null;
    private boolean reentrancyAllowed;
    private ThreadState currentCaller;
    private boolean isDeleted = false;
    private boolean isReadOnly = false;

    public EJBHome getEJBHome() {
        if (this.remoteHome == null) {
            throw new IllegalStateException("The enterprise bean does not have remote home interface");
        }
        return (EJBHome)this.remoteHome;
    }

    public EJBLocalHome getEJBLocalHome() {
        if (this.localHome == null) {
            throw new IllegalStateException("The enterprise bean does not have local home interface");
        }
        return (EJBLocalHome)this.localHome;
    }

    public void check_illegalState_get_an_object(String _actionString) throws IllegalStateException {
        if (this.actionTaken == 4) {
            throw new IllegalStateException(_actionString + " cannot be called from setEntityContext(...) method");
        }
        if (this.actionTaken == 5) {
            throw new IllegalStateException(_actionString + " cannot be called from unsetEntityContext(...) method");
        }
        if (this.actionTaken == 6) {
            throw new IllegalStateException(_actionString + " cannot be called from ejbCreate(...) method");
        }
        if (this.actionTaken == 2) {
            throw new IllegalStateException(_actionString + " cannot be called from ejbHome(...) method");
        }
    }

    public AbstractEJBObject get_an_object(String _methodName, AbstractEJBHome _home, String _lr) {
        this.check_illegalState_get_an_object(_methodName);
        if (_home == null) {
            throw new IllegalStateException(_methodName + " not successful because this bean does not have " + _lr + " interface");
        }
        try {
            return ((EntityContainer)((Object)_home)).getWrapperByPK(null, this.internalGetPrimaryKey());
        }
        catch (Exception e) {
            IllegalStateException ie = new IllegalStateException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public EJBLocalObject getEJBLocalObject() {
        if (this.actionTaken == 6) {
            throw new IllegalStateException("getEJBLocalObject cannot be called from ejbCreate(...) method");
        }
        if (this.localWrapper == null) {
            this.setLocalWrapper(this.get_an_object("getEJBLocalObject", this.localHome, "local"));
        }
        return (EJBLocalObject)this.localWrapper;
    }

    public EJBObject getEJBObject() {
        if (this.actionTaken == 6) {
            throw new IllegalStateException("getEJBObject cannot be called from ejbCreate(...) method");
        }
        if (this.remoteWrapper == null) {
            this.setRemoteWrapper(this.get_an_object("getEJBObject", this.remoteHome, "remote"));
        }
        return (EJBObject)this.remoteWrapper;
    }

    public void setLocalWrapper(AbstractEJBObject _localWrapper) {
        this.localWrapper = _localWrapper;
    }

    public void setRemoteWrapper(AbstractEJBObject _remoteWrapper) {
        this.remoteWrapper = _remoteWrapper;
    }

    public OracleEntityContext(EntityEJBHome _home, EntityBean _object, boolean _reentrant) {
        super(_home, _object);
        if (_home.isRemote) {
            this.localHome = _home.theOtherHome;
        } else {
            this.remoteHome = _home.theOtherHome;
        }
        this.reentrancyAllowed = _reentrant;
        this.isReadOnly = ((CmpEntityBean)_object).isReadOnly();
    }

    public Object getPrimaryKey() {
        if (this.actionTaken == 4) {
            throw new IllegalStateException("Cannot call getPrimaryKey from within the setEntityContext(...) method");
        }
        if (this.actionTaken == 6) {
            throw new IllegalStateException("Cannot call getPrimaryKey from within the ejbCreate(...) method");
        }
        if (this.actionTaken == 2) {
            throw new IllegalStateException("Cannot call getPrimaryKey from within an ejbHome(...) method");
        }
        return this.internalGetPrimaryKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrimaryKey(Object _pk) throws RemoteException {
        this.internalSetPrimaryKey(_pk);
        if (_pk != null) {
            AbstractEJBHome ejbHome = this.remoteHome != null ? this.remoteHome : this.localHome;
            ThreadState thread = ThreadState.getCurrentState();
            ContextContainer previousContainer = thread.contextContainer;
            try {
                thread.contextContainer = ejbHome;
                ejbHome.getBeanDescriptor().getLifecycleManager().postActivate(this.getObject(), this);
            }
            finally {
                thread.contextContainer = previousContainer;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetPrimaryKey() throws RemoteException {
        if (this.internalGetPrimaryKey() != null && !this.isDeleted()) {
            AbstractEJBHome ejbHome = this.remoteHome != null ? this.remoteHome : this.localHome;
            ThreadState thread = ThreadState.getCurrentState();
            ContextContainer previousContainer = thread.contextContainer;
            try {
                thread.contextContainer = ejbHome;
                ejbHome.getBeanDescriptor().getLifecycleManager().prePassivate(this.getObject(), this);
            }
            finally {
                thread.contextContainer = previousContainer;
            }
        }
        this.setLocalWrapper(null);
        this.setRemoteWrapper(null);
        this.setDeleted(false);
        this.internalSetPrimaryKey(null);
    }

    public void internalSetPrimaryKey(Object newPK) {
        this.primaryKey = newPK;
    }

    protected Object internalGetPrimaryKey() {
        return this.primaryKey;
    }

    public void setDeleted(boolean deleted) {
        this.isDeleted = deleted;
    }

    private boolean isDeleted() {
        return this.isDeleted;
    }

    public void resetFields() {
        this.setLocalWrapper(null);
        this.setRemoteWrapper(null);
    }

    public void __setCallbackContext(byte _callbacktype) {
        this.setActionTaken(_callbacktype);
    }

    public final boolean startCall(ThreadState newCaller, long timeout, boolean overrideReentrant) {
        if (!this.isReadOnly) {
            boolean inCall;
            boolean bl = inCall = this.currentCaller == newCaller;
            if (inCall && !this.reentrancyAllowed && !overrideReentrant) {
                throw EJBUtils.createEJBException("Recursive call to non-reentrant bean. Thread: " + newCaller);
            }
            if (this.currentCaller != null && this.currentCaller != newCaller) {
                throw EJBUtils.createEJBException("Two different threads accessing the same bean.\n\tCurrent Thread: " + this.currentCaller + "\n\tCalling Thread: " + newCaller);
            }
            this.currentCaller = newCaller;
            return inCall;
        }
        return false;
    }

    public final synchronized void endCall(boolean inCall) {
        if (!this.isReadOnly) {
            if (this.currentCaller != ThreadState.getCurrentState()) {
                throw new InternalError("Current caller was not state[" + ThreadState.getCurrentState() + "] vs [" + this.currentCaller + "] for bean[" + this + "]");
            }
            if (!inCall) {
                this.currentCaller = null;
            }
        }
    }
}

