/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ejb.ChangedValue;
import com.evermind.server.ejb.ORSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ORSetIterator
implements Iterator {
    private ORSet set;
    private int pos;
    private int lastPos;
    private Object currentObject;

    public ORSetIterator(ORSet set) {
        this.set = set;
        this.getNextObject();
    }

    public boolean hasNext() {
        return this.currentObject != null;
    }

    public Object next() {
        Object current = this.currentObject;
        if (current == null) {
            throw new NoSuchElementException();
        }
        this.getNextObject();
        return current;
    }

    protected void getNextObject() {
        this.lastPos = this.pos - 1;
        this.set.checkScope();
        while (this.pos < this.set.objects.length) {
            Object object;
            if ((object = this.set.objects[this.pos++]) instanceof ChangedValue) {
                ChangedValue change = (ChangedValue)object;
                if (change.newValue == null) continue;
                this.currentObject = change.newValue;
                return;
            }
            this.currentObject = object;
            return;
        }
        this.currentObject = null;
    }

    public void remove() {
        if (this.lastPos < 0) {
            throw new IllegalStateException("Attempt to remove from invalid iterator position");
        }
        this.set.remove(this.lastPos);
        this.lastPos = -1;
    }
}

