/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ejb.CMRCollectionField;
import com.evermind.server.ejb.ChangedValue;
import com.evermind.server.ejb.DataSourceConnection;
import com.evermind.server.ejb.EntityEJBObject;
import com.evermind.server.ejb.EvermindEntityContext;
import com.evermind.server.ejb.ORCollectionIterator;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class ORCollection
extends AbstractCollection
implements CMRCollectionField {
    public EvermindEntityContext context;
    public Object primaryKey;
    protected Object[] objects;
    protected Set added;
    protected int deleted;
    protected boolean dirty;
    protected boolean loaded = false;
    protected Set removed;

    public abstract Object[] getObjects();

    public abstract void checkScope();

    public abstract boolean isImmutable();

    public abstract void persist(DataSourceConnection var1) throws SQLException;

    public abstract void deleteEntries(DataSourceConnection var1) throws SQLException;

    public Object getReplacement() {
        return new ArrayList(this);
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean notifyRemoved) {
        if (this.objects == null || this.isPopulationRequired()) {
            this.objects = this.getObjects();
        }
        for (int i = 0; i < this.objects.length; ++i) {
            if (this.objects[i] instanceof ChangedValue) {
                ChangedValue changed = (ChangedValue)this.objects[i];
                if (changed.newValue == null) continue;
                if (notifyRemoved) {
                    this.notifyRemovedObject(changed.newValue);
                }
                changed.newValue = null;
                ++this.deleted;
                continue;
            }
            if (notifyRemoved) {
                this.notifyRemovedObject(this.objects[i]);
            }
            this.objects[i] = new ChangedValue(this.objects[i], null);
            ++this.deleted;
        }
        this.dirty = true;
    }

    public int size() {
        if (this.objects == null) {
            this.objects = this.getObjects();
        }
        return this.objects.length - this.deleted;
    }

    public Iterator iterator() {
        this.checkScope();
        if (this.objects == null) {
            this.objects = this.getObjects();
        }
        if (!this.isImmutable()) {
            this.dirty = true;
        }
        return new ORCollectionIterator(this);
    }

    public void remove(int pos) {
        this.dirty = true;
        if (this.objects[pos] instanceof ChangedValue) {
            if (((ChangedValue)this.objects[pos]).newValue != null) {
                this.notifyRemovedObject(((ChangedValue)this.objects[pos]).newValue);
                ++this.deleted;
                ((ChangedValue)this.objects[pos]).newValue = null;
            }
        } else {
            this.notifyRemovedObject(this.objects[pos]);
            this.objects[pos] = new ChangedValue(this.objects[pos], null);
            ++this.deleted;
        }
    }

    public boolean remove(Object object) {
        return this.remove(object, true, true);
    }

    public boolean remove(Object object, boolean triggerChange, boolean notifyRemoved) {
        if (triggerChange) {
            if (this.objects == null || this.isPopulationRequired()) {
                this.objects = this.getObjects();
            }
            for (int i = 0; i < this.objects.length; ++i) {
                Object other = this.objects[i];
                if (other instanceof ChangedValue) {
                    ChangedValue change = (ChangedValue)other;
                    if (change.newValue == null || object != change.newValue && !object.equals(change.newValue) && !((EntityEJBObject)object).hasSamePrimaryKey(change.newValue)) continue;
                    if (notifyRemoved) {
                        this.notifyRemovedObject(object);
                    }
                    change.newValue = null;
                    ++this.deleted;
                    this.dirty = true;
                    return true;
                }
                if (object != other && !object.equals(other) && !((EntityEJBObject)object).hasSamePrimaryKey(other)) continue;
                if (notifyRemoved) {
                    this.notifyRemovedObject(object);
                }
                this.objects[i] = new ChangedValue(other, null);
                ++this.deleted;
                this.dirty = true;
                return true;
            }
        } else {
            if (this.objects == null) {
                if (this.removed == null) {
                    this.removed = new HashSet();
                    this.removed.add(object);
                } else {
                    this.removed.add(object);
                }
                if (this.added != null) {
                    this.removeEntityEJBObject(this.added, object);
                    if (this.added.size() == 0) {
                        this.added = null;
                    }
                }
                this.dirty = true;
                return true;
            }
            if (this.isPopulationRequired()) {
                this.objects = this.getObjects();
            }
            for (int i = 0; i < this.objects.length; ++i) {
                Object other = this.objects[i];
                if (other instanceof ChangedValue) {
                    ChangedValue change = (ChangedValue)other;
                    if ((change.newValue == null || other != change.newValue && !other.equals(change.newValue)) && !((EntityEJBObject)change.newValue).hasSamePrimaryKey(object)) continue;
                    Object[] newObjects = new Object[this.objects.length - 1];
                    System.arraycopy(this.objects, 0, newObjects, 0, i);
                    System.arraycopy(this.objects, i + 1, newObjects, i, this.objects.length - (i + 1));
                    this.objects = newObjects;
                    return true;
                }
                if (object != other && !object.equals(other) && !((EntityEJBObject)object).hasSamePrimaryKey(other)) continue;
                Object[] newObjects = new Object[this.objects.length - 1];
                System.arraycopy(this.objects, 0, newObjects, 0, i);
                System.arraycopy(this.objects, i + 1, newObjects, i, this.objects.length - (i + 1));
                this.objects = newObjects;
                return true;
            }
        }
        return false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setToLoaded() {
        this.loaded = true;
    }

    public boolean add(Object object, boolean triggerChange, boolean notifyAdded) {
        if (object == null) {
            throw new IllegalArgumentException("Illegal adding of null to a collection cmr-field, see the EJB specification 10.3.8");
        }
        if (this.objects == null && !triggerChange && !notifyAdded) {
            if (this.added == null) {
                this.added = new HashSet();
            }
            this.added.add(triggerChange ? new ChangedValue(null, object) : object);
            if (this.removed != null) {
                this.removeEntityEJBObject(this.removed, object);
                if (this.removed.size() == 0) {
                    this.removed = null;
                }
            }
            return true;
        }
        if (this.isPopulationRequired() && this.contains(object)) {
            return false;
        }
        if (notifyAdded) {
            this.notifyAddedObject(object);
        }
        if (!triggerChange && this.objects == null) {
            this.objects = this.getObjects();
        }
        if (triggerChange) {
            this.dirty = true;
        }
        if (this.objects != null) {
            Object[] oldArray = this.objects;
            Object[] newArray = new Object[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = triggerChange ? new ChangedValue(null, object) : object;
            this.objects = newArray;
            return true;
        }
        if (this.added == null) {
            this.added = new HashSet();
        }
        this.added.add(triggerChange ? new ChangedValue(null, object) : object);
        if (this.removed != null) {
            this.removeEntityEJBObject(this.removed, object);
            if (this.removed.size() == 0) {
                this.removed = null;
            }
        }
        return true;
    }

    public boolean contains(Object other) {
        if (other == null) {
            return false;
        }
        if (this.objects == null) {
            this.objects = this.getObjects();
        }
        return this.contains(this.objects, other);
    }

    protected boolean contains(Object[] objects, Object other) {
        if (objects == null) {
            return false;
        }
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (object instanceof ChangedValue) {
                ChangedValue change = (ChangedValue)object;
                if (change.newValue == null || other != change.newValue && !other.equals(change.newValue) && !((EntityEJBObject)other).hasSamePrimaryKey(change.newValue)) continue;
                return true;
            }
            if (other != object && !other.equals(object) && !((EntityEJBObject)other).hasSamePrimaryKey(object)) continue;
            return true;
        }
        return false;
    }

    protected boolean contains(Collection objects, Object other) {
        if (objects == null) {
            return false;
        }
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof ChangedValue) {
                ChangedValue change = (ChangedValue)object;
                if (change.newValue == null) continue;
                object = change.newValue;
            }
            if (other != object && !other.equals(object) && !((EntityEJBObject)other).hasSamePrimaryKey(object)) continue;
            return true;
        }
        return false;
    }

    public void __setDirty(Object referer) {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearRemoved() {
        int length = this.objects.length;
        for (int i = 0; i < length; ++i) {
            if (!(this.objects[i] instanceof ChangedValue)) continue;
            this.objects[i] = this.objects[length-- - 1];
            --i;
        }
        if (length != this.objects.length) {
            Object[] newValues = new Object[length];
            System.arraycopy(this.objects, 0, newValues, 0, length);
            this.objects = newValues;
        }
        this.deleted = 0;
    }

    public void initializeObject(Object object) {
    }

    public void __clearDirty() {
    }

    public void __setDirty() {
        this.dirty = true;
    }

    public EvermindEntityContext __getContext() {
        return this.context;
    }

    public boolean add(Object object) {
        return this.add(object, true, true);
    }

    public void updateManyToMany(Object instance, boolean add) {
        if (add) {
            this.add(instance, false, true);
        } else {
            this.remove(instance, false, true);
        }
    }

    public void notifyRemovedObject(Object object) {
    }

    public void notifyAddedObject(Object object) {
        this.initializeObject(object);
    }

    private boolean isPopulationRequired() {
        try {
            if (!this.context.isSqlExecuted() && !((EntityBeanDescriptor)this.context.getHome().getBeanDescriptor()).getSelectBeforeInsert()) {
                return false;
            }
            if (this.isLoaded()) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void setLoaded(boolean aValue) {
        this.loaded = aValue;
    }

    public void applyAdded(Collection found) {
        if (this.added == null) {
            return;
        }
        Iterator it = this.added.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (this.contains(found, object)) continue;
            found.add(object);
        }
        this.added = null;
    }

    public void applyRemoved(Collection found) {
        if (this.removed == null) {
            return;
        }
        Iterator it = found.iterator();
        block0: while (it.hasNext() && this.removed != null && this.removed.size() > 0) {
            Object foundValue = it.next();
            if (this.removed.remove(foundValue)) {
                it.remove();
                continue;
            }
            Iterator itRemoved = this.removed.iterator();
            while (itRemoved.hasNext()) {
                Object removedValue = itRemoved.next();
                if (!((EntityEJBObject)removedValue).hasSamePrimaryKey(found)) continue;
                it.remove();
                itRemoved.remove();
                continue block0;
            }
        }
        this.removed = null;
    }

    private void removeEntityEJBObject(Set src, Object target) {
        Iterator it = src.iterator();
        while (it.hasNext()) {
            Object checkedObject = it.next();
            if (checkedObject instanceof ChangedValue) {
                checkedObject = ((ChangedValue)checkedObject).newValue;
            }
            if (checkedObject != target && !checkedObject.equals(target) && !((EntityEJBObject)checkedObject).hasSamePrimaryKey(target)) continue;
            it.remove();
            break;
        }
    }
}

