/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.bytecode.ClassData;
import com.evermind.bytecode.ClassSerialization;
import com.evermind.bytecode.MethodData;
import com.evermind.bytecode.RawCodeAttribute;
import com.evermind.io.IOUtils;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;

public class NoOpMethodHelper {
    private ClassData classData;

    public NoOpMethodHelper(BeanDescriptor descriptor) {
        this.classData = this.getClassData(descriptor);
    }

    public boolean isEmptyLifecycleMethod(Method method) {
        ByteString signature;
        if (method == null) {
            return true;
        }
        ByteString name = new ByteString(method.getName());
        byte[] methodDataBytes = this.getMethodData(this.classData, name, signature = new ByteString(ClassUtils.getCodedArguments(method)));
        if (methodDataBytes != null) {
            return methodDataBytes.length < 2;
        }
        return false;
    }

    private byte[] getMethodData(ClassData classData, ByteString name, ByteString signature) {
        if (classData != null) {
            for (int i = 0; i < classData.methodCount; ++i) {
                MethodData method = classData.methods[i];
                if (!method.name.equals(name) || !method.descriptor.equals(signature)) continue;
                RawCodeAttribute code = method.getCodeAttribute();
                return code == null ? null : code.getCode().data;
            }
        }
        return null;
    }

    private ClassData getClassData(BeanDescriptor descriptor) {
        ClassData classData = null;
        if (descriptor.getPackage().getEJBClassLoader() == null) {
            return null;
        }
        URL classURL = descriptor.getPackage().getEJBClassLoader().getResource(descriptor.getEJBClassName().replace('.', '/') + ".class");
        if (classURL != null) {
            try {
                byte[] data = IOUtils.getContent(classURL);
                DataInputStream classIn = new DataInputStream(new ByteArrayInputStream(data));
                ClassSerialization beanClassSerialization = new ClassSerialization();
                classData = beanClassSerialization.read(descriptor.getEJBClassName(), classIn, null, 3, false);
            }
            catch (IOException e) {
            }
            catch (ClassFormatError e) {
                // empty catch block
            }
        }
        return classData;
    }
}

