/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ejb.AbstractEJBContext;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.MessageDrivenHome;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import java.security.Identity;
import java.security.Principal;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.MessageDrivenContext;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;

public class MessageDrivenContextImpl
extends AbstractEJBContext
implements MessageDrivenContext {
    private static Logger m_logger = EJBTraceLogger.getLogger(MessageDrivenContextImpl.class);
    private MessageDrivenHome home;
    private Object bean;
    private boolean toBeDiscarded = false;

    protected MessageDrivenContextImpl(MessageDrivenHome home) {
        this.home = home;
    }

    public boolean getRollbackOnly() {
        if (this.home.descriptor.getTransactionType() == 1) {
            throw new IllegalStateException("Cannot call getRollbackOnly() when bean-managed transactions are specified");
        }
        Transaction transaction = null;
        try {
            transaction = ApplicationServer.getInstance().getTransactionManager().getTransaction();
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        if (transaction == null) {
            throw new IllegalStateException("Cannot call getRollbackOnly() when current thread is NOT associated with a transaction");
        }
        try {
            int status = transaction.getStatus();
            return status == 1 || status == 4 || status == 9;
        }
        catch (SystemException e) {
            return true;
        }
    }

    public void setRollbackOnly() {
        this.home.updateFailureDMSCount();
        if (this.home.descriptor.getTransactionType() == 1) {
            throw new IllegalStateException("Cannot call setRollbackOnly() when bean-managed transactions are specified");
        }
        EJBTransactionManager.getInstance().setContainerRollbackOnly();
    }

    public UserTransaction getUserTransaction() {
        if (this.home.descriptor.getTransactionType() == 0) {
            throw new IllegalStateException("Only message-driven beans with user-managed transactions can invoke getUserTransaction()");
        }
        return (UserTransaction)ApplicationServer.getInstance().getTransactionManager();
    }

    public Principal getCallerPrincipal() {
        if (this.actionTaken == 6) {
            throw new IllegalStateException("Cannot call getCallerPrincipal() from ejbCreate");
        }
        return super.getCallerPrincipal();
    }

    public boolean isCallerInRole(String role) {
        throw new IllegalStateException("MessageDriven beans cannot invoke isCallerInRole()");
    }

    public boolean isCallerInRole(Identity identity) {
        throw new IllegalStateException("MessageDriven beans cannot invoke isCallerInRole()");
    }

    public EJBHome getEJBHome() {
        throw new IllegalStateException("MessageDriven beans have no EJBHome");
    }

    public EJBLocalHome getEJBLocalHome() {
        throw new IllegalStateException("MessageDriven beans cannot invoke EJBLocalHome");
    }

    public BeanDescriptor getBeanDescriptor() {
        return this.home.getMessageDrivenBeanDescriptor();
    }

    public EJBObject getEJBObject() {
        throw new IllegalStateException("MessageDriven beans have no EJBObject");
    }

    public AbstractEJBHome getEvermindHome() {
        throw new IllegalStateException("MessageDriven beans have no EJBHome");
    }

    public EJBLocalObject getEJBLocalObject() {
        throw new IllegalStateException("MessageDriven beans cannot invoke EJBLocalObject");
    }

    public void resetFields() {
        this.timersvc = null;
    }

    protected Application getApplication() {
        return this.home.getContainer().getApplication();
    }

    public final MessageDrivenHome getMessageDrivenHome() {
        return this.home;
    }

    public final Object getBean() {
        return this.bean;
    }

    protected final void setBean(Object bean) {
        this.bean = bean;
    }

    protected boolean isToBeDiscarded() {
        return this.toBeDiscarded;
    }

    protected void setToBeDiscarded(boolean toBeDiscarded) {
        this.toBeDiscarded = toBeDiscarded;
    }
}

