/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBContext;
import com.evermind.server.ejb.EJBDependencyManager;
import com.evermind.server.ejb.EJBThreadContext;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.InvocationContextPool;
import com.evermind.server.ejb.NoOpMethodHelper;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.InterceptorDescriptor;
import com.evermind.server.ejb.exception.DeploymentException;
import com.evermind.server.ejb.interceptor.InterceptorManager;
import com.evermind.server.ejb.interceptor.MethodState;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.EJBContext;
import javax.ejb.EntityContext;
import javax.ejb.MessageDrivenContext;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;

public class LifecycleManager {
    protected static final String EJB_CREATE = "ejbCreate";
    protected static final String EJB_POST_CREATE = "ejbPostCreate";
    public static final String POST_CONSTRUCT = "postConstruct";
    protected static final String EJB_REMOVE = "ejbRemove";
    public static final String PRE_DESTROY = "preDestroy";
    protected static final String EJB_ACTIVATE = "ejbActivate";
    public static final String POST_ACTIVATE = "postActivate";
    protected static final String EJB_PASSIVATE = "ejbPassivate";
    public static final String PRE_PASSIVATE = "prePassivate";
    protected static final String EJB_LOAD = "ejbLoad";
    protected static final String EJB_STORE = "ejbStore";
    private static final String SET_SESSION_CONTEXT = "setSessionContext";
    private static final String SET_MESSAGE_CONTEXT = "setMessageDrivenContext";
    private static final String SET_ENTITY_CONTEXT = "setEntityContext";
    private static final String UNSET_ENTITY_CONTEXT = "unsetEntityContext";
    private static final Class SESSION_CONTEXT_CLASS = SessionContext.class;
    private static final Class MESSAGE_CONTEXT_CLASS = MessageDrivenContext.class;
    private static final Class ENTITY_CONTEXT_CLASS = EntityContext.class;
    private MethodState postConstructMethodState;
    private MethodState preDestroyMethodState;
    private MethodState postActivateMethodState;
    private MethodState prePassivateMethodState;
    private MethodState setContextMethodState;
    private MethodState unsetContextMethodState;
    private MethodState ejbLoadMethodState;
    private MethodState ejbStoreMethodState;
    private EJBDependencyManager dependencyManager;
    private InterceptorManager interceptorManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct(Object bean, EJBContext ctx) throws CreateException, RemoteException {
        try {
            if (ctx != null && this.getDependendencyManager() != null && (this.getDependendencyManager().hasDependencies() || !this.interceptorManager.getUserInterceptorsList().isEmpty())) {
                ThreadState state = ThreadState.getCurrentState();
                EJBThreadContext tc = state.getEJBThreadContext();
                EJBContext oldContext = tc.context;
                AbstractEJBContext currentCtx = (AbstractEJBContext)ctx;
                byte oldAction = currentCtx.getActionTaken();
                try {
                    tc.context = ctx;
                    currentCtx.setActionTaken((byte)4);
                    try {
                        InitialContext j2eeContext = new InitialContext();
                        this.getDependendencyManager().resolveDependencies(j2eeContext, bean);
                        this.interceptorManager.resolveDependencies(currentCtx, j2eeContext);
                    }
                    catch (InstantiationException e) {
                        throw EJBUtils.createEJBException(e);
                    }
                }
                finally {
                    currentCtx.setActionTaken(oldAction);
                    tc.context = oldContext;
                }
            }
            if (this.getPostConstructMethodState() != null) {
                this.invokeLifecycleMethod(this.getPostConstructMethodState(), bean, ctx);
            }
        }
        catch (Exception ex) {
            if (ex instanceof CreateException) {
                throw (CreateException)((Object)ex);
            }
            this.handleException(ex);
        }
    }

    public void preDestroy(Object bean, EJBContext ctx) throws RemoveException, RemoteException {
        if (this.getPreDestroyMethodState() != null) {
            try {
                this.invokeLifecycleMethod(this.getPreDestroyMethodState(), bean, ctx);
            }
            catch (Exception ex) {
                if (ex instanceof RemoveException) {
                    throw (RemoveException)((Object)ex);
                }
                this.handleException(ex);
            }
        }
    }

    public void postActivate(Object bean, EJBContext ctx) throws RemoteException {
        if (this.getPostActivateMethodState() != null) {
            try {
                this.invokeLifecycleMethod(this.getPostActivateMethodState(), bean, ctx);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    public void prePassivate(Object bean, EJBContext ctx) throws RemoteException {
        if (this.getPrePassivateMethodState() != null) {
            try {
                this.invokeLifecycleMethod(this.getPrePassivateMethodState(), bean, ctx);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    public void setContext(Object bean, EJBContext ctx) throws RemoteException {
        if (this.getSetContextMethodState() != null) {
            try {
                this.invokeLifecycleMethod(this.getSetContextMethodState(), bean, ctx, new Object[]{ctx});
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    public void unsetContext(Object bean, EJBContext ctx) throws RemoteException {
        if (this.getUnsetContextMethodState() != null) {
            try {
                this.invokeLifecycleMethod(this.getUnsetContextMethodState(), bean, ctx);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    public void ejbLoad(Object bean, EJBContext ctx) throws RemoteException {
        if (this.getEjbLoadMethodState() != null) {
            try {
                this.invokeLifecycleMethod(this.getEjbLoadMethodState(), bean, ctx);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    public void ejbStore(Object bean, EJBContext ctx) throws RemoteException {
        if (this.getEjbStoreMethodState() != null) {
            try {
                this.invokeLifecycleMethod(this.getEjbStoreMethodState(), bean, ctx);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    protected void invokeLifecycleMethod(MethodState callbackMethodState, Object target, EJBContext ctx) throws Exception {
        this.invokeLifecycleMethod(callbackMethodState, target, ctx, null);
    }

    protected void invokeLifecycleMethod(MethodState callbackMethodState, Object target, EJBContext ctx, Object[] args) throws Exception {
        InvocationContextPool.invoke(ThreadState.getCurrentState(), callbackMethodState, target, ctx, args, null, null);
    }

    public Method getPostConstructMethod() {
        if (this.getPostConstructMethodState() != null) {
            return this.getPostConstructMethodState().getJoinPoint().getMethod();
        }
        return null;
    }

    public Method getPreDestroyMethod() {
        if (this.getPreDestroyMethodState() != null) {
            return this.getPreDestroyMethodState().getJoinPoint().getMethod();
        }
        return null;
    }

    private void handleException(Exception ex) throws RemoteException {
        if (ex instanceof RemoteException) {
            throw (RemoteException)ex;
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw EJBUtils.createEJBException(ex);
    }

    public LifecycleManager initialize(BeanDescriptor beanDescriptor) {
        NoOpMethodHelper noOpHelper = new NoOpMethodHelper(beanDescriptor);
        InterceptorDescriptor interceptorDesc = beanDescriptor.getBeanInterceptor();
        if (beanDescriptor.isEntity()) {
            this.setPostConstructMethodState(this.buildNonInterceptorLifecycleMethod(beanDescriptor, (byte)6, EJB_CREATE, null, noOpHelper));
            this.setPreDestroyMethodState(this.buildNonInterceptorLifecycleMethod(beanDescriptor, (byte)8, EJB_REMOVE, null, noOpHelper));
            this.setPostActivateMethodState(this.buildNonInterceptorLifecycleMethod(beanDescriptor, (byte)9, EJB_ACTIVATE, null, noOpHelper));
            this.setPrePassivateMethodState(this.buildNonInterceptorLifecycleMethod(beanDescriptor, (byte)10, EJB_PASSIVATE, null, noOpHelper));
            this.setEjbLoadMethodState(this.buildNonInterceptorLifecycleMethod(beanDescriptor, (byte)11, EJB_LOAD, null, noOpHelper));
            this.setEjbStoreMethodState(this.buildNonInterceptorLifecycleMethod(beanDescriptor, (byte)12, EJB_STORE, null, noOpHelper));
            this.setSetContextMethodState(this.buildNonInterceptorLifecycleMethod(beanDescriptor, (byte)4, SET_ENTITY_CONTEXT, new Class[]{ENTITY_CONTEXT_CLASS}, null));
            this.setUnsetContextMethodState(this.buildNonInterceptorLifecycleMethod(beanDescriptor, (byte)5, UNSET_ENTITY_CONTEXT, null, noOpHelper));
        } else {
            this.setPostConstructMethodState(this.buildLifecycleMethod(beanDescriptor, (byte)6, EJB_CREATE, POST_CONSTRUCT, interceptorDesc.getPostConstructMethods(), null, noOpHelper));
            this.setPreDestroyMethodState(this.buildLifecycleMethod(beanDescriptor, (byte)8, EJB_REMOVE, PRE_DESTROY, interceptorDesc.getPreDestroyMethods(), null, noOpHelper));
            if (beanDescriptor.isStateful()) {
                this.setPostActivateMethodState(this.buildLifecycleMethod(beanDescriptor, (byte)9, EJB_ACTIVATE, POST_ACTIVATE, interceptorDesc.getPostActivateMethods(), null, noOpHelper));
                this.setPrePassivateMethodState(this.buildLifecycleMethod(beanDescriptor, (byte)10, EJB_PASSIVATE, PRE_PASSIVATE, interceptorDesc.getPrePassivateMethods(), null, noOpHelper));
            }
            if (beanDescriptor.isSession()) {
                this.setSetContextMethodState(this.buildNonInterceptorLifecycleMethod(beanDescriptor, (byte)4, SET_SESSION_CONTEXT, new Class[]{SESSION_CONTEXT_CLASS}, noOpHelper));
            } else {
                this.setSetContextMethodState(this.buildNonInterceptorLifecycleMethod(beanDescriptor, (byte)4, SET_MESSAGE_CONTEXT, new Class[]{MESSAGE_CONTEXT_CLASS}, noOpHelper));
            }
        }
        return this;
    }

    protected MethodState buildLifecycleMethod(BeanDescriptor beanDescriptor, byte callbackType, String ejb21CallbackName, String ejb30CallbackName, List userDefinedBeanCallbacks, Class[] argTypes, NoOpMethodHelper noOpHelper) {
        Method callbackMethod;
        block5: {
            callbackMethod = null;
            try {
                callbackMethod = beanDescriptor.getEJBClass().getMethod(ejb21CallbackName, argTypes);
                if (userDefinedBeanCallbacks.isEmpty()) break block5;
                boolean matchFound = false;
                Iterator iter = userDefinedBeanCallbacks.iterator();
                while (iter.hasNext()) {
                    if (!((InterceptorDescriptor.InterceptorCallback)iter.next()).methodName.equals(ejb21CallbackName)) continue;
                    matchFound = true;
                    break;
                }
                if (matchFound) {
                    callbackMethod = null;
                    break block5;
                }
                throw DeploymentException.invalidLifecycleCallbackName(beanDescriptor, ejb30CallbackName, ejb21CallbackName);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        MethodState methodState = new MethodState(callbackType, beanDescriptor, callbackMethod);
        if (!(userDefinedBeanCallbacks.isEmpty() && noOpHelper.isEmptyLifecycleMethod(callbackMethod) && beanDescriptor.getInterceptorManager().getUserInterceptors(methodState).isEmpty())) {
            return methodState.initialize();
        }
        return null;
    }

    private MethodState buildNonInterceptorLifecycleMethod(BeanDescriptor beanDescriptor, byte callbackType, String callbackName, Class[] argTypes, NoOpMethodHelper noOpHelper) {
        try {
            Method callbackMethod = beanDescriptor.getEJBClass().getMethod(callbackName, argTypes);
            MethodState methodState = new MethodState(callbackType, beanDescriptor, callbackMethod);
            if (noOpHelper == null || !noOpHelper.isEmptyLifecycleMethod(callbackMethod)) {
                return methodState.initialize();
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return null;
    }

    private MethodState getPostActivateMethodState() {
        return this.postActivateMethodState;
    }

    private void setPostActivateMethodState(MethodState postActivateMethod) {
        this.postActivateMethodState = postActivateMethod;
    }

    private MethodState getPostConstructMethodState() {
        return this.postConstructMethodState;
    }

    private void setPostConstructMethodState(MethodState postConstructMethod) {
        this.postConstructMethodState = postConstructMethod;
    }

    private MethodState getPreDestroyMethodState() {
        return this.preDestroyMethodState;
    }

    private void setPreDestroyMethodState(MethodState preDestroyMethod) {
        this.preDestroyMethodState = preDestroyMethod;
    }

    private MethodState getPrePassivateMethodState() {
        return this.prePassivateMethodState;
    }

    private void setPrePassivateMethodState(MethodState prePassivateMethod) {
        this.prePassivateMethodState = prePassivateMethod;
    }

    private MethodState getSetContextMethodState() {
        return this.setContextMethodState;
    }

    private void setSetContextMethodState(MethodState setContextMethod) {
        this.setContextMethodState = setContextMethod;
    }

    private MethodState getUnsetContextMethodState() {
        return this.unsetContextMethodState;
    }

    private void setUnsetContextMethodState(MethodState unsetContextMethod) {
        this.unsetContextMethodState = unsetContextMethod;
    }

    private MethodState getEjbLoadMethodState() {
        return this.ejbLoadMethodState;
    }

    private void setEjbLoadMethodState(MethodState ejbLoadMethod) {
        this.ejbLoadMethodState = ejbLoadMethod;
    }

    private MethodState getEjbStoreMethodState() {
        return this.ejbStoreMethodState;
    }

    private void setEjbStoreMethodState(MethodState ejbStoreMethod) {
        this.ejbStoreMethodState = ejbStoreMethod;
    }

    public EJBDependencyManager getDependendencyManager() {
        return this.dependencyManager;
    }

    public void setDependencyManager(EJBDependencyManager dependencyManager) {
        this.dependencyManager = dependencyManager;
    }

    public void setInterceptorManager(InterceptorManager interceptorManager) {
        this.interceptorManager = interceptorManager;
    }
}

