/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ejb.EntityEJBHome;
import com.evermind.server.ejb.RemoteDBEntityEJBObject;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import oracle.oc4j.rmi.OracleRemoteException;

public class EntityHandle
implements Handle,
Serializable {
    public static final long serialVersionUID = 3586458424780631535L;
    public String homePath;
    public Object key;
    public transient EJBObject object;

    public EntityHandle(RemoteDBEntityEJBObject object) throws RemoteException {
        this.object = object;
        this.key = object.getPrimaryKey();
        this.homePath = object.getMyHome().OC4J_getBindingPath();
    }

    public EJBObject getEJBObject() throws RemoteException {
        if (this.object != null) {
            return this.object;
        }
        try {
            this.object = EntityHandle.getEJBObject(this.homePath, this.key, new InitialContext());
            return this.object;
        }
        catch (NamingException e) {
            OracleRemoteException re = new OracleRemoteException("Error creating InitialContext: " + e.getMessage(), e);
            throw re;
        }
    }

    public static EJBObject getEJBObject(String path, Object key, Context context) throws RemoteException {
        try {
            Object home = context.lookup(path);
            if (home instanceof EntityEJBHome) {
                EntityEJBHome entityHome = (EntityEJBHome)home;
                return (EJBObject)entityHome.getLazyInstance(key);
            }
            Method[] methods = home.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals("findByPrimaryKey")) continue;
                try {
                    Object response = methods[i].invoke(home, key);
                    return (EJBObject)response;
                }
                catch (InvocationTargetException e) {
                    OracleRemoteException re = new OracleRemoteException("Error invoking findByPrimaryKey(...)", e.getTargetException());
                    throw re;
                }
                catch (Throwable t) {
                    OracleRemoteException re = new OracleRemoteException("Error invoking findByPrimaryKey(...)", t);
                    throw re;
                }
            }
            throw new OracleRemoteException("findByPrimaryKey(...) method not found in home object");
        }
        catch (EJBException e) {
            throw new OracleRemoteException("The EJBObject could not be found within the home" + (e.getMessage() == null ? "" : " (" + e.getMessage() + ")"), e.getCausedByException());
        }
        catch (NameNotFoundException e) {
            throw new OracleRemoteException("The EJBHome could not be found at location '" + path + "' (possibly due to connection errors)", e);
        }
        catch (NamingException e) {
            OracleRemoteException re = new OracleRemoteException("Error looking up EJBHome at location '" + path + "': " + e, e);
            throw re;
        }
    }
}

