/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.compiler.CompilationException;
import com.evermind.naming.ContextUtils;
import com.evermind.naming.archive.ContentArchiveContext;
import com.evermind.naming.archive.MemoryArchiveContext;
import com.evermind.naming.file.FileContext;
import com.evermind.net.AddressContainer;
import com.evermind.security.User;
import com.evermind.server.ApplicationContext;
import com.evermind.server.ApplicationServer;
import com.evermind.server.RuntimeSecurityRole;
import com.evermind.server.ThreadState;
import com.evermind.server.administration.ApplicationResourceFinder;
import com.evermind.server.deployment.EJBModule;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.deployment.SecurityRole;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.AnnotationParser;
import com.evermind.server.ejb.BeanAnnotationListener;
import com.evermind.server.ejb.BeanBinding;
import com.evermind.server.ejb.EJBClassTransformer;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.EntityManagerDeployer;
import com.evermind.server.ejb.MessageDrivenHome;
import com.evermind.server.ejb.POJOEntityAnnotationListener;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.evermind.server.ejb.admin.EJBMBeanFactory;
import com.evermind.server.ejb.compilation.Compilation;
import com.evermind.server.ejb.compilation.EJBCompilationUtils;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.EJBJ2EEContextDescriptor;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.evermind.server.ejb.deployment.InterceptorBinding;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.deployment.MessageDrivenBeanDescriptor;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.server.ejb.logging.EJBAnnotationMessages;
import com.evermind.server.ejb.logging.EJBDeploymentMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.server.ejb.persistence.PersistenceUnitManager;
import com.evermind.server.ejb.persistence.PersistenceUnitManagerFactory;
import com.evermind.server.ejb.proxy.ProxyClassLoader;
import com.evermind.server.ejb.proxy.ProxyFactory;
import com.oracle.bricks.j2ee.JGroupConfig;
import com.oracle.bricks.j2ee.ReplicationPolicy;
import com.oracle.naming.J2EEContext;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalHome;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.security.jacc.PolicyContextException;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.ias.container.timer.EJBTimerServiceImpl;
import oracle.j2ee.deployment.AnnotationParsingMessages;
import oracle.j2ee.ws.server.deployment.oc4j.WebServiceAnnotationListener;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.mbeans.EjbBase;
import oracle.oc4j.admin.management.util.NotifyingMap;
import oracle.oc4j.corba.ORBInitializationException;
import oracle.oc4j.corba.ServerOrbManager;
import oracle.oc4j.corba.transport.CorbaTransportManager;
import oracle.oc4j.loader.OC4JProtectionPolicy;
import oracle.oc4j.loader.config.OC4JConfigurationType;

public class EJBPackageDeployment {
    private static final String IIOP_CLIENT_JAR_NAME = "_iiopClient.jar";
    public static final String appClientJarName = "_iiopClient.jar";
    private static String DEFAULT_GENERATED_HOME_CACHE = "default-gen-home.jar";
    protected static int CANCEL_TIMER = 0;
    protected static int PASSIVATE_TIMER = 1;
    protected static int ACTIVATE_TIMER = 2;
    private EnterpriseArchive application;
    private EJBContainer container;
    private EJBPackage ejbPackage;
    private Map runtimeRoles;
    private Context context;
    private Context deploymentContext;
    private Context wrapperClassContext;
    private Context clientJarContext = null;
    private SharedCodeSource wrapperCodeSource;
    private SharedCodeSource generatedInterfaceCodeSource;
    private Context generatedInterfaceContext;
    private EntityManagerDeployer entityManagerDeployer;
    private PersistenceUnitManager persistenceUnitManager;
    private RuntimeSecurityRole defaultRole;
    private Map roleMappings;
    private EJBModule module;
    private boolean isIncrementalDeployed = false;
    private boolean hasAnnotatedClass = false;
    private Map instances = new NotifyingMap();
    private Map messageDrivenHomes = new NotifyingMap();
    private static Logger m_logger = EJBTraceLogger.getLogger(EJBPackageDeployment.class);

    public EJBPackageDeployment(EnterpriseArchive application, EJBContainer container, Context context, EJBModule module) {
        this.application = application;
        this.container = container;
        this.context = context;
        this.module = module;
    }

    public EJBModule getModule() {
        return this.module;
    }

    public Context getContext() {
        return this.context;
    }

    public void checkAndResetContext() throws InstantiationException {
        if (this.deploymentContext == null) {
            this.getDeploymentContext();
            if (this.isExpandedModule() && this.isArchiveDeployment()) {
                this.context = this.deploymentContext;
            }
        }
    }

    public Context getDeploymentContext() throws InstantiationException {
        if (this.deploymentContext == null) {
            String path = this.module.getName();
            try {
                this.deploymentContext = (Context)this.application.getDeploymentContext().lookup(path);
            }
            catch (NamingException e) {
                if (this.isExpandedModule() && this.isArchiveDeployment() && this.application.getDeploymentContext() instanceof FileContext) {
                    try {
                        this.deploymentContext = ((FileContext)this.application.getDeploymentContext()).createSubContext(new File(File.separator + path));
                        return this.deploymentContext;
                    }
                    catch (Exception ex) {
                        InstantiationException ie = new InstantiationException("Error the expanded deployment directory is not existed: " + e.getMessage());
                        ie.initCause(ex);
                        throw ie;
                    }
                }
                if (this.isExpandedModule() && !this.isArchiveDeployment()) {
                    Context ctx = null;
                    try {
                        this.deploymentContext = ctx = (Context)this.getContext().lookup("META-INF");
                        return this.deploymentContext;
                    }
                    catch (Exception ex1) {
                        try {
                            this.deploymentContext = this.getContext().createSubcontext("META-INF");
                            ctx = ((FileContext)this.application.getDeploymentContext()).createSubContext(new File(File.separator + path));
                            return this.deploymentContext;
                        }
                        catch (Throwable thr) {
                            // empty catch block
                        }
                    }
                }
                try {
                    this.deploymentContext = this.application.getDeploymentContext().createSubcontext(path);
                }
                catch (NamingException ne) {
                    InstantiationException ie = new InstantiationException("Error creating deployment directory: " + e.getMessage());
                    ie.initCause(ne);
                    throw ie;
                }
            }
            catch (ClassCastException e) {
                InstantiationException ie = new InstantiationException("Error creating deployment directory, " + path + " was not a directory");
                ie.initCause(e);
                throw ie;
            }
        }
        return this.deploymentContext;
    }

    private boolean isExpandedModule() {
        return !this.getModule().getPath().endsWith(".jar") && !this.getModule().getPath().startsWith("file:/");
    }

    private boolean isArchiveDeployment() {
        return this.container.getApplication().getarchivePath() != null;
    }

    public PolicyClassLoader getEJBClassLoader() {
        return this.container.getBeansClassLoader();
    }

    public void addModuleCodeSource() {
        if (this.context == null) {
            return;
        }
        File file = ContextUtils.getFile(this.context, false);
        String source = "unknown";
        try {
            source = this.application.getContext().getNameInNamespace();
        }
        catch (Exception e) {
            // empty catch block
        }
        ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.APPLICATION_EJB, source);
        try {
            this.getEJBClassLoader().addCodeSource(file, origin);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public String getDeploymentCacheName() {
        return "deployment-cache.jar";
    }

    public Context getWrapperClassContext() throws InstantiationException {
        if (this.wrapperClassContext == null) {
            this.wrapperClassContext = this.initializeArchiveContext(this.getDeploymentContext(), this.getDeploymentCacheName());
        }
        return this.wrapperClassContext;
    }

    public void addWrapperCodeSource() throws InstantiationException {
        if (this.wrapperCodeSource == null) {
            this.wrapperCodeSource = this.addSharedCodeSource(this.getEJBClassLoader(), this.getWrapperClassContext(), "wrappers");
        }
    }

    public Context getGeneratedInterfaceClassContext() throws InstantiationException {
        if (this.generatedInterfaceContext == null) {
            this.generatedInterfaceContext = this.initializeArchiveContext(this.getDeploymentContext(), DEFAULT_GENERATED_HOME_CACHE);
        }
        return this.generatedInterfaceContext;
    }

    public SharedCodeSource addGeneratedInterfaceCodeSource() throws InstantiationException {
        if (this.generatedInterfaceCodeSource == null) {
            this.generatedInterfaceCodeSource = this.addSharedCodeSource(this.getEJBClassLoader(), this.getGeneratedInterfaceClassContext(), "default-gen-home");
        }
        return this.generatedInterfaceCodeSource;
    }

    public ClassLoader getWrapperClassLoader() throws InstantiationException {
        this.addWrapperCodeSource();
        return this.getEJBClassLoader();
    }

    private SharedCodeSource addSharedCodeSource(PolicyClassLoader loader, Context ctx, String name) throws InstantiationException {
        File file = ContextUtils.getFile(ctx, false);
        if (!file.exists() || file.length() == 0L) {
            return null;
        }
        SharedCodeSource[] list = loader.getCodeSources(true);
        for (int i = 0; i < list.length; ++i) {
            SharedCodeSource s = list[i];
            if (!s.getFile().equals(file)) continue;
            return s;
        }
        SharedCodeSource ret = null;
        ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.APPLICATION_EJB, name);
        try {
            ret = loader.addCodeSource(file, origin, OC4JProtectionPolicy.EJB_WRAPPER_PERMISSIONS);
        }
        catch (IOException e) {
            InstantiationException ie = new InstantiationException();
            ie.initCause(e);
            throw ie;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindHomes() throws InstantiationException {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.entering(EJBPackageDeployment.class.toString(), "bindHomes", new Object[]{this.container});
        }
        Map map = this.instances;
        synchronized (map) {
            ApplicationContext context = this.container.getApplication().getContext();
            Iterator iterator = this.getPackage().getAllBeans().iterator();
            while (iterator.hasNext()) {
                BeanDescriptor descriptor = (BeanDescriptor)iterator.next();
                if (descriptor instanceof ExposableBeanDescriptor) {
                    ExposableBeanDescriptor exposable = (ExposableBeanDescriptor)descriptor;
                    try {
                        if (exposable.getRemoteInterfaceName() != null) {
                            this.bindRemoteHome(context, exposable);
                        }
                        if (exposable.getLocalInterfaceName() == null) continue;
                        this.bindLocalHome(context, exposable);
                        continue;
                    }
                    catch (NameAlreadyBoundException e) {
                        InstantiationException ie = new InstantiationException("Illegal/occupied name for " + descriptor.getName() + ": " + e.getMessage());
                        ie.initCause(e);
                        throw ie;
                    }
                    catch (NamingException e) {
                        InstantiationException ie = new InstantiationException("Error binding home for " + descriptor.getName() + " to context: " + e.getMessage());
                        ie.initCause(e);
                        throw ie;
                    }
                }
                if (!(descriptor instanceof MessageDrivenBeanDescriptor)) continue;
                EJBDeploymentMessages.finerCreateMDBHome(descriptor);
                if (this.messageDrivenHomes.containsKey(descriptor.getName())) continue;
                MessageDrivenHome home = new MessageDrivenHome(this.container, this.ejbPackage, (MessageDrivenBeanDescriptor)descriptor);
                this.messageDrivenHomes.put(descriptor.getName(), home);
            }
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.exiting(EJBPackageDeployment.class.toString(), "bindHomes", new Object[]{this.container});
        }
    }

    private void bindLocalHome(ApplicationContext context, ExposableBeanDescriptor descriptor) throws InstantiationException, NamingException {
        AbstractEJBHome home = this.getHomeInstance(this.container, descriptor.getName(), true);
        try {
            EJBDeploymentMessages.finerBindLocalHome(descriptor, descriptor.getQualifiedLocalLocation());
            context.bind(descriptor.getQualifiedLocalLocation(), home, 0);
        }
        catch (NamingException e) {
            throw (InstantiationException)new InstantiationException("Unable to bind local home for " + descriptor.getName() + " into JNDI location " + descriptor.getLocalLocation()).initCause(e);
        }
        if (!descriptor.getLocalLocation().equals(descriptor.getQualifiedLocalLocation())) {
            if (descriptor.getPackage().getCompatibility() >= 3 && descriptor.isGeneratedLocalHome()) {
                EJBDeploymentMessages.finerBindLocalBeanFactory(descriptor, descriptor.getLocalLocation());
                Reference factory = BeanBinding.createBinding(descriptor.getQualifiedLocalLocation(), null);
                try {
                    context.bind(descriptor.getLocalLocation(), factory, 0);
                }
                catch (NamingException e) {
                    context.rebind(descriptor.getLocalLocation(), factory, 0);
                }
            } else {
                EJBDeploymentMessages.finerBindLocalHome(descriptor, descriptor.getLocalLocation());
                Reference factory = BeanBinding.createHomeBinding(EJBLocalHome.class, descriptor.getQualifiedLocalLocation(), null);
                try {
                    context.bind(descriptor.getLocalLocation(), factory, 0);
                }
                catch (NamingException e) {
                    context.rebind(descriptor.getLocalLocation(), factory, 0);
                }
            }
        }
    }

    private void bindRemoteHome(ApplicationContext context, ExposableBeanDescriptor descriptor) throws InstantiationException, NamingException {
        AbstractEJBHome home = this.getHomeInstance(this.container, descriptor.getName(), false);
        try {
            EJBDeploymentMessages.finerBindRemoteHome(descriptor, descriptor.getQualifiedLocation());
            context.bind(descriptor.getQualifiedLocation(), home, 3);
        }
        catch (NamingException e) {
            throw (InstantiationException)new InstantiationException("Unable to bind remote home for " + descriptor.getName() + " into JNDI location " + descriptor.getLocation() + " RMI context.").initCause(e);
        }
        if (!descriptor.getLocation().equals(descriptor.getQualifiedLocation())) {
            if (descriptor.getPackage().getCompatibility() >= 3 && descriptor.isGeneratedRemoteHome()) {
                EJBDeploymentMessages.finerBindRemoteBeanFactory(descriptor, descriptor.getLocation());
                Reference factory = BeanBinding.createBinding(descriptor.getQualifiedLocation(), null);
                try {
                    context.bind(descriptor.getLocation(), factory, 3);
                }
                catch (NamingException e) {
                    context.rebind(descriptor.getLocation(), factory, 3);
                }
            } else {
                EJBDeploymentMessages.finerBindRemoteHome(descriptor, descriptor.getLocation());
                try {
                    context.bind(descriptor.getLocation(), home, 3);
                }
                catch (NamingException e) {
                    context.rebind(descriptor.getLocation(), home, 3);
                }
            }
        }
        if (descriptor.getGenerateIIOP()) {
            try {
                home.setCorbaReferenceGenerator(CorbaTransportManager.getInstance().deployHome(home));
            }
            catch (ORBInitializationException e) {
                throw (InstantiationException)new InstantiationException(e.toString()).initCause(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTimers(EJBContainer container, int operation) {
        Iterator<Object> iterator;
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.entering(EJBPackageDeployment.class.toString(), "processTimers()");
        }
        Map map = this.instances;
        synchronized (map) {
            Collection homeCol = this.instances.values();
            if (homeCol != null) {
                HashSet set = new HashSet(this.instances.values());
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    this.processTimers(iterator.next(), operation);
                }
            }
        }
        map = this.messageDrivenHomes;
        synchronized (map) {
            iterator = this.messageDrivenHomes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.processTimers(entry.getValue(), operation);
            }
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.exiting(EJBPackageDeployment.class.toString(), "processTimers()");
        }
    }

    private void processTimers(Object home, int operation) {
        if (operation == CANCEL_TIMER) {
            EJBTimerServiceImpl.removeBeanTimers(home);
        } else if (operation == PASSIVATE_TIMER) {
            EJBTimerServiceImpl.passivateBeanTimers(home);
        } else if (operation == ACTIVATE_TIMER) {
            EJBTimerServiceImpl.activateBeanTimers(home);
        }
    }

    public void destroy(boolean undeploy) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.entering(EJBPackageDeployment.class.toString(), "destroy()");
        }
        this.destroyMBeans();
        this.destroyComponentHomes(undeploy);
        this.destroyMessageDrivenBeans(undeploy);
        this.destroyBeanPools();
        this.destroyPersistenceUnitManager();
        this.destroyMethodStates();
        this.unloadCodeSources();
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.exiting(EJBPackageDeployment.class.toString(), "destroy()");
        }
    }

    protected void persistSession(AbstractEJBHome home) {
        if (home instanceof StatefulSessionEJBHome) {
            try {
                String fileName = ((SessionBeanDescriptor)home.getBeanDescriptor()).getPersistenceFilename();
                this.container.storeSessions(fileName, (StatefulSessionEJBHome)home);
            }
            catch (IOException e) {
                m_logger.log(Level.WARNING, "Error persisting sessions", e);
            }
        }
    }

    public void unbindHomes(ExposableBeanDescriptor bd) {
        ApplicationContext context = this.container.getApplication().getContext();
        if (bd.getRemoteInterfaceName() != null) {
            try {
                EJBDeploymentMessages.finerUnBindHome(bd, bd.getQualifiedLocation());
                context.destroy(bd.getQualifiedLocation());
            }
            catch (NamingException e) {
                m_logger.log(Level.WARNING, "Error unbinding home at " + bd.getQualifiedLocation(), e);
            }
            if (!bd.getLocation().equals(bd.getQualifiedLocation())) {
                try {
                    EJBDeploymentMessages.finerUnBindHome(bd, bd.getLocation());
                    context.destroy(bd.getLocation());
                }
                catch (NamingException e) {
                    m_logger.log(Level.WARNING, "Error unbinding home at " + bd.getLocation(), e);
                }
            }
        }
        if (bd.getLocalInterfaceName() != null) {
            try {
                EJBDeploymentMessages.finerUnBindHome(bd, bd.getQualifiedLocalLocation());
                context.destroy(bd.getQualifiedLocalLocation());
            }
            catch (NamingException e) {
                m_logger.log(Level.WARNING, "Error unbinding home at " + bd.getQualifiedLocalLocation(), e);
            }
            if (!bd.getLocalLocation().equals(bd.getQualifiedLocalLocation())) {
                try {
                    EJBDeploymentMessages.finerUnBindHome(bd, bd.getLocalLocation());
                    context.destroy(bd.getLocalLocation());
                }
                catch (NamingException e) {
                    m_logger.log(Level.WARNING, "Error unbinding home at " + bd.getLocalLocation(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyComponentHomes(boolean undeploy) {
        Map map = this.instances;
        synchronized (map) {
            Iterator iterator = this.instances.values().iterator();
            while (iterator.hasNext()) {
                AbstractEJBHome home = (AbstractEJBHome)iterator.next();
                ExposableBeanDescriptor desc = (ExposableBeanDescriptor)home.getBeanDescriptor();
                this.persistSession(home);
                this.unbindHomes(desc);
                if (undeploy) {
                    this.processTimers(home, CANCEL_TIMER);
                }
                iterator.remove();
                if (desc.getRemoteInterfaceName() == null || !desc.getGenerateIIOP()) continue;
                CorbaTransportManager.getInstance().undeployApplication(home.getApplicationName());
            }
        }
    }

    protected void destroyMessageDrivenBeans(boolean undeploy) {
        if (this.messageDrivenHomes != null) {
            MessageDrivenHome home;
            Map.Entry entry;
            Iterator iterator = this.messageDrivenHomes.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                home = (MessageDrivenHome)entry.getValue();
                home.shutdown();
            }
            iterator = this.messageDrivenHomes.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                home = (MessageDrivenHome)entry.getValue();
                home.stop();
                if (undeploy) {
                    this.processTimers(home, CANCEL_TIMER);
                }
                iterator.remove();
            }
        }
    }

    protected void destroyPersistenceUnitManager() {
        if (this.getPersistenceUnitManager() != null) {
            this.getPersistenceUnitManager().destroy();
            this.setPersistenceUnitManager(null);
        }
        if (this.getEntityManagerDeployer() != null) {
            this.getEntityManagerDeployer().undeploy();
            this.setEntityManagerDeployer(null);
        }
    }

    protected void destroyBeanPools() {
        Iterator i = this.getPackage().getAllBeans().iterator();
        while (i.hasNext()) {
            BeanDescriptor bd = (BeanDescriptor)i.next();
            if (bd.getBeanPool() == null) continue;
            bd.getBeanPool().shutdown();
        }
    }

    protected void destroyMethodStates() {
        Iterator i = this.getPackage().getAllBeans().iterator();
        while (i.hasNext()) {
            Object bd = i.next();
            if (!(bd instanceof ExposableBeanDescriptor)) continue;
            ExposableBeanDescriptor descriptor = (ExposableBeanDescriptor)bd;
            descriptor.destroyMethodStates();
        }
    }

    protected void destroyMBeans() {
        EJBPackage module = this.getPackage();
        Iterator i = this.getPackage().getAllBeans().iterator();
        while (i.hasNext()) {
            BeanDescriptor descriptor = (BeanDescriptor)i.next();
            try {
                this.removeEJBMBean(descriptor);
            }
            catch (RuntimeException e) {
                m_logger.log(Level.WARNING, "Error unregistering MBean " + descriptor.getName(), e);
            }
        }
    }

    public void unloadCodeSources() {
        if (this.generatedInterfaceCodeSource != null) {
            this.generatedInterfaceCodeSource = null;
        }
        if (this.wrapperCodeSource != null) {
            this.wrapperCodeSource = null;
        }
    }

    public Collection getDeployedHomes() {
        return this.instances.values();
    }

    public boolean isCallerInRole(String roleName, AddressContainer addressContainer) {
        RuntimeSecurityRole role;
        RuntimeSecurityRole runtimeSecurityRole = role = this.roleMappings == null ? null : (RuntimeSecurityRole)this.roleMappings.get(roleName);
        if (role == null) {
            throw new IllegalArgumentException("No such role: " + roleName);
        }
        User user = ThreadState.getCurrentState().getUser();
        if (user == null) {
            return false;
        }
        if (user == ApplicationServer.NO_PERMISSIONS_USER) {
            throw new IllegalStateException("Not allowed to call isCallerInRole(...) from within setEntityContext/setSessionContext methods, see the EJB 2.0 specification chapter 10.5.4");
        }
        return role.impliesUser(user, addressContainer);
    }

    public void setRuntimeSecurityRoles(EJBContainer container) throws InstantiationException, IOException {
        List roles = this.getPackage().getSecurityRoles();
        if (roles.isEmpty()) {
            this.roleMappings = null;
            return;
        }
        this.roleMappings = new HashMap();
        for (int i = 0; i < roles.size(); ++i) {
            SecurityRole role = (SecurityRole)roles.get(i);
            if (this.application != null && this.application.getSecurityRole(role.getName()) != null) {
                role = this.application.getSecurityRole(role.getName());
            }
            HashSet<SecurityRole> roleSet = new HashSet<SecurityRole>();
            roleSet.add(role);
            this.roleMappings.put(role.getName(), container.getRuntimeSecurityRole(roleSet));
            try {
                this.getPackage().registerWithJACC(role);
                continue;
            }
            catch (PolicyContextException pce) {
                m_logger.log(Level.WARNING, "Exception registering role mapping with jacc provider", pce);
            }
        }
    }

    public RuntimeSecurityRole getRuntimeRole(String[] names) throws InstantiationException {
        RuntimeSecurityRole role;
        if (names.length == 1 && names[0].equals("<<default>>")) {
            if (this.defaultRole == null) {
                HashSet<SecurityRole> roles = new HashSet<SecurityRole>();
                roles.add(this.getPackage().getDefaultSecurityRole());
                this.defaultRole = new RuntimeSecurityRole(this.container.getApplication().getUserManager(), roles);
            }
            return this.defaultRole;
        }
        if (this.runtimeRoles == null) {
            this.runtimeRoles = new HashMap();
        }
        if ((role = (RuntimeSecurityRole)this.runtimeRoles.get(Arrays.asList(names))) != null) {
            return role;
        }
        HashSet<SecurityRole> securityRoles = new HashSet<SecurityRole>();
        for (int i = 0; i < names.length; ++i) {
            SecurityRole securityRole = this.getPackage().getSecurityRole(names[i]);
            if (securityRole == null) {
                throw new InstantiationException("No such role: " + names[i]);
            }
            securityRoles.add(securityRole);
        }
        role = new RuntimeSecurityRole(this.container.getApplication().getUserManager(), securityRoles);
        this.runtimeRoles.put(Arrays.asList(names), role);
        return role;
    }

    public RuntimeSecurityRole getRuntimeSecurityRole(Method method, String beanName, boolean isWebServiceCall) throws InstantiationException {
        List result = this.getPackage().getRuntimeSecurityRoles(method, beanName, isWebServiceCall);
        String[] roles = new String[result.size()];
        roles = result.toArray(roles);
        return this.getRuntimeRole(roles);
    }

    public void flushCachedInfo() {
        this.defaultRole = null;
        this.runtimeRoles = null;
    }

    public EJBContainer getContainer() {
        return this.container;
    }

    public void parseMetaData() throws InstantiationException {
        Object wsDeplPlan;
        EJBClassTransformer transformer = null;
        boolean hasEntities = false;
        if (this.ejbPackage.getCompatibility() >= 3) {
            transformer = new EJBClassTransformer();
            if (EJBUtils.isJdk50()) {
                AnnotationParser annotationParser = new AnnotationParser();
                this.setPersistenceUnitManager(PersistenceUnitManagerFactory.createPersistenceUnitManager(this));
                POJOEntityAnnotationListener pojoEntityAnnotationListener = new POJOEntityAnnotationListener();
                annotationParser.addAnnotationListener(pojoEntityAnnotationListener);
                if (!this.ejbPackage.isEjbJarFull()) {
                    annotationParser.addAnnotationListener(new BeanAnnotationListener(this.createPackage()));
                }
                annotationParser.addAnnotationListener(this.getWebServicesAnnotationListener());
                AnnotationParsingMessages.fineBeginParsingAnnotations(this.getPackage().getName());
                this.hasAnnotatedClass = annotationParser.parseAnnotations((ClassLoader)this.ejbPackage.getContainer().getTempMetadataParsingLoader(), this.getContext());
                boolean bl = hasEntities = !pojoEntityAnnotationListener.getAnnotatedClasses().isEmpty();
                if (this.getPersistenceUnitManager() == null) {
                    EntityManagerDeployer emDeployer = new EntityManagerDeployer(this);
                    emDeployer.setPOJOEntityClasses(pojoEntityAnnotationListener.getAnnotatedClasses());
                    emDeployer.setPOJOEntityClassNames(pojoEntityAnnotationListener.getAnnotatedClassNames());
                    emDeployer.predeploy(this.ejbPackage.getContainer().getTempMetadataParsingLoader(), this.getContext(), transformer);
                    this.setEntityManagerDeployer(emDeployer);
                }
            } else {
                EJBAnnotationMessages.warningEJB3WithoutJDK15();
            }
        }
        if (this.ejbPackage.hasAssemblyDescriptor()) {
            this.ejbPackage.parseEJBModule();
        }
        if ((wsDeplPlan = this.application.getExtraParam(this.getModule().getPath() + ":webservices")) != null) {
            this.ejbPackage.setWSDeploymentData(wsDeplPlan);
        }
        this.ejbPackage.setDeploymentData((String)this.application.getExtraParam(this.getModule().getPath()));
        this.ejbPackage.initDeployment();
        if (hasEntities && this.getPersistenceUnitManager() != null && !this.getPackage().disableDefaultPersistentUnit()) {
            this.getPersistenceUnitManager().enableDefaultPersistenceUnit(true);
        }
        if (this.getPackage().getCompatibility() >= 3) {
            List beans = this.getPackage().getBeans();
            Iterator i = beans.iterator();
            while (i.hasNext()) {
                BeanDescriptor descriptor = (BeanDescriptor)i.next();
                if (!descriptor.isSession()) continue;
                transformer.addRemoteInterfaceNames(((ExposableBeanDescriptor)descriptor).getRemoteInterfaceNames());
                if (!descriptor.isStateful()) continue;
                transformer.addSerializableClassName(descriptor.getEJBClassName());
                List bindings = this.getPackage().getDefaultInterceptorBindings();
                if (bindings != null && !bindings.isEmpty()) {
                    transformer.addSerializableClassNames(((InterceptorBinding)bindings.get(0)).getInterceptorClassNames());
                }
                if ((bindings = (List)this.getPackage().getInterceptorBindings().get(descriptor.getName())) == null) continue;
                Iterator iter = bindings.iterator();
                while (iter.hasNext()) {
                    transformer.addSerializableClassNames(((InterceptorBinding)iter.next()).getInterceptorClassNames());
                }
            }
            EJBUtils.setClassPreprocessor(this.getEJBClassLoader(), transformer);
        }
    }

    protected void initializePersistenceUnitManager() {
        if (this.getEntityManagerDeployer() != null) {
            this.getEntityManagerDeployer().deploy();
        }
        if (this.getPersistenceUnitManager() != null) {
            this.getPersistenceUnitManager().initialize();
        }
    }

    private WebServiceAnnotationListener getWebServicesAnnotationListener() throws InstantiationException {
        EJBPackage pkg = this.getPackage();
        File deploymentDir = ContextUtils.getFile(pkg.getDeploymentContext(), false);
        return new WebServiceAnnotationListener(deploymentDir, pkg);
    }

    public EJBPackage getPackage() {
        return this.ejbPackage;
    }

    public synchronized EJBPackage createPackage() throws InstantiationException {
        if (this.ejbPackage == null) {
            this.ejbPackage = new EJBPackage(this.getContainer(), this.getContext(), this.getDeploymentContext(), this, this.module.isRemote());
            this.ejbPackage.setName(this.module.getName());
        }
        return this.ejbPackage;
    }

    public AbstractEJBHome getHomeInstance(EJBContainer container, String ejbName, boolean local, boolean location) throws InstantiationException {
        return location ? this.getHomeInstanceByLocation(container, ejbName, local) : this.getHomeInstance(container, ejbName, local);
    }

    public AbstractEJBHome getHomeInstanceByLocation(EJBContainer container, String ejbName, boolean local) throws InstantiationException {
        BeanDescriptor bean = this.getPackage().getBeanByLocation(ejbName);
        if (bean == null) {
            throw new InstantiationException("No EJB found at location: '" + ejbName + "'");
        }
        return this.getHomeInstance(container, bean.getName(), local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractEJBHome getHomeInstanceCore(EJBContainer container, String ejbName, boolean local) throws InstantiationException {
        Map map = this.instances;
        synchronized (map) {
            ExposableBeanDescriptor bean;
            AbstractEJBHome home = (AbstractEJBHome)this.instances.get(new HomeNameId(ejbName, local));
            if (home != null) {
                return home;
            }
            try {
                bean = (ExposableBeanDescriptor)this.getPackage().getBeanX(ejbName);
                if (bean == null) {
                    throw new InstantiationException("No such EJB: '" + ejbName + "'");
                }
            }
            catch (ClassCastException e) {
                InvalidEJBAssemblyException ie = new InvalidEJBAssemblyException("MessageDrivenBeans do not have exposable homes", null);
                ie.initCause(e);
                throw ie;
            }
            home = bean.createHomeInstance(container, this.getWrapperClassLoader(), local);
            home.supportBoth_L_R = local ? bean.getRemoteHomeWrapperName() != null : bean.getLocalHomeWrapperName() != null;
            bean.initialize(home);
            List mailSessions = null;
            if (this.container.getApplication() != null && this.container.getApplication().getConfig() != null) {
                mailSessions = this.container.getApplication().getConfig().getAllMailSessions();
            }
            EJBJ2EEContextDescriptor j2eeDesc = new EJBJ2EEContextDescriptor(home.getBeanDescriptor());
            J2EEContext j2eeContext = J2EEContext.create(j2eeDesc, new ApplicationResourceFinder(this.getContainer().getApplication()), this.getContainer().getApplication().getContext(), mailSessions);
            if (this.getPersistenceUnitManager() != null) {
                this.getPersistenceUnitManager().bindPersistenceReferences(j2eeDesc, j2eeContext);
            }
            home.setContext(j2eeContext);
            home.isRemote = !local;
            home.setPM(this.getPackage().getPM(bean.getName()));
            if (home instanceof StatefulSessionEJBHome) {
                StatefulSessionEJBHome sfsh = (StatefulSessionEJBHome)home;
                SessionBeanDescriptor desc = (SessionBeanDescriptor)bean;
                JGroupConfig jConfig = this.container.getApplication().getConfig().getClusterConfig();
                ReplicationPolicy replicationPolicy = sfsh.replicationPolicy = jConfig != null ? jConfig.getReplicationPolicy() : new ReplicationPolicy();
                if (!desc.getReplicationPolicy().isNone()) {
                    sfsh.replicationPolicy = desc.getReplicationPolicy();
                }
                container.restoreCache(this, desc, home);
            }
            this.instances.put(new HomeNameId(ejbName, local), home);
            return home;
        }
    }

    public AbstractEJBHome getHomeInstance(EJBContainer container, String ejbName, boolean local) throws InstantiationException {
        AbstractEJBHome _home = this.getHomeInstanceCore(container, ejbName, local);
        if (_home.supportBoth_L_R && _home.theOtherHome == null) {
            AbstractEJBHome _home2;
            _home.theOtherHome = _home2 = this.getHomeInstanceCore(container, ejbName, !local);
            _home2.theOtherHome = _home;
        }
        return _home;
    }

    public String toString() {
        return "EJB-deployment " + this.ejbPackage;
    }

    public MessageDrivenHome getMessageDrivenHome(String name) {
        return (MessageDrivenHome)this.messageDrivenHomes.get(name);
    }

    public void startMessageDrivenHomes() throws InstantiationException {
        Iterator iterator = this.messageDrivenHomes.values().iterator();
        while (iterator.hasNext()) {
            MessageDrivenHome home = (MessageDrivenHome)iterator.next();
            if (!home.descriptor.isEnabled()) continue;
            home.start();
        }
    }

    public void stopMessageDrivenHomes() {
        Iterator iterator = this.messageDrivenHomes.values().iterator();
        while (iterator.hasNext()) {
            ((MessageDrivenHome)iterator.next()).stop();
        }
    }

    public Context getClientJarContext() throws InstantiationException {
        if (this.clientJarContext == null) {
            this.clientJarContext = this.initializeMemoryArchiveContext(this.getDeploymentContext(), "_iiopClient.jar", true);
        }
        return this.clientJarContext;
    }

    public Context getAppClientJarContext() throws InstantiationException {
        return this.initializeMemoryArchiveContext(this.application.getDeploymentContext(), "_iiopClient.jar", false);
    }

    public void initializeJMX() throws InstantiationException {
        Iterator i = this.getPackage().getAllBeans().iterator();
        while (i.hasNext()) {
            BeanDescriptor descriptor = (BeanDescriptor)i.next();
            this.addEJBMBean(descriptor);
        }
    }

    private final void addEJBMBean(BeanDescriptor descriptor) {
        String ejbModuleName;
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        String appName = this.container.getApplication().getName();
        EjbBase mbean = EJBMBeanFactory.createMBean(appName, ejbModuleName = EJBContainer.getEJBModuleName(this.getModule()), descriptor);
        if (mbean == null) {
            return;
        }
        mbean.setDmsModuleId(this.getModule().getName());
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            RuntimeException re = new RuntimeException(e);
            throw re;
        }
    }

    private final void removeEJBMBean(BeanDescriptor descriptor) {
        String ejbModuleName;
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        String appName = this.container.getApplication().getName();
        EjbBase mbean = EJBMBeanFactory.createMBean(appName, ejbModuleName = EJBContainer.getEJBModuleName(this.getModule()), descriptor);
        if (mbean == null) {
            return;
        }
        mbean.setDmsModuleId(this.getModule().getName());
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void notifyPMs(int op, Compilation comp) {
        this.ejbPackage.notifyPMs(op, comp);
    }

    public Context getApplicationContext() {
        Context c = this.container.getConfig().getContext();
        if (c == null) {
            try {
                return ContextUtils.getContext(this.container.getConfig().getURL(), false);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to get deployment context for application: " + this.container.application.getName());
            }
        }
        return c;
    }

    public EntityManagerDeployer getEntityManagerDeployer() {
        return this.entityManagerDeployer;
    }

    public void setEntityManagerDeployer(EntityManagerDeployer deployer) {
        this.entityManagerDeployer = deployer;
    }

    public PersistenceUnitManager getPersistenceUnitManager() {
        return this.persistenceUnitManager;
    }

    public void setPersistenceUnitManager(PersistenceUnitManager mgr) {
        this.persistenceUnitManager = mgr;
    }

    private Context initializeMemoryArchiveContext(Context parentContext, String jarName, boolean bindInParentContext) throws InstantiationException {
        try {
            byte[] data;
            block7: {
                try {
                    data = (byte[])parentContext.lookup(jarName);
                }
                catch (NameNotFoundException e) {
                    data = new byte[]{};
                    if (bindInParentContext) {
                        parentContext.bind(jarName, (Object)data);
                    }
                }
                catch (ClassCastException e) {
                    data = new byte[]{};
                    if (!bindInParentContext) break block7;
                    parentContext.bind(jarName, (Object)data);
                }
            }
            return new MemoryArchiveContext(parentContext, jarName, data, 0, data.length, false);
        }
        catch (NamingException e) {
            InstantiationException ie = new InstantiationException("Unable to create archive context: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        catch (IOException e) {
            InstantiationException ie = new InstantiationException("Unable to create archive context: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    private Context initializeArchiveContext(Context parentContext, String jarName) {
        return new ContentArchiveContext(ContextUtils.getFile(parentContext, jarName, false), true);
    }

    public void initializeBeanPooling() {
        Iterator i = this.getPackage().getAllBeans().iterator();
        while (i.hasNext()) {
            BeanDescriptor desc = (BeanDescriptor)i.next();
            if (desc.getBeanPool() == null) continue;
            desc.getBeanPool().initialize();
        }
    }

    protected void waitForActiveEjbMethodsToFinish() {
        Iterator<Object> i = this.instances.values().iterator();
        while (i.hasNext()) {
            AbstractEJBHome home = (AbstractEJBHome)i.next();
            if (!(home instanceof StatefulSessionEJBHome)) continue;
            Iterator j = ((StatefulSessionEJBHome)home).getInstances().values().iterator();
            while (j.hasNext()) {
                StatefulSessionEJBObject bean = (StatefulSessionEJBObject)j.next();
                bean.OC4J_waitForWrapper();
            }
        }
        i = this.getPackage().getBeans().iterator();
        while (i.hasNext()) {
            BeanDescriptor descriptor = (BeanDescriptor)i.next();
            if (descriptor.isStateless()) {
                descriptor.getBeanPool().waitForPool();
            }
            descriptor.getCallManager().waitForActiveMethodCalls(descriptor.getName());
        }
    }

    public boolean isIncrementalDeployed() {
        return this.isIncrementalDeployed;
    }

    public void setIncrementalDeployed(boolean isIncrementalDeployed) {
        this.isIncrementalDeployed = isIncrementalDeployed;
    }

    public boolean hasAnnotatedClass() {
        return this.hasAnnotatedClass;
    }

    public void initializeProxies() {
        boolean generateIIOP = ServerOrbManager.isIiopConfigured(this.getContainer().getApplication());
        ProxyClassLoader cl = new ProxyClassLoader((ClassLoader)this.getEJBClassLoader());
        if (generateIIOP) {
            try {
                String root = EJBCompilationUtils.getWrapperCodeGenDir(this.getPackage());
                new File(root).mkdirs();
                cl.setClassFileDirectory(root);
            }
            catch (CompilationException e) {
                throw new EJBException((Exception)e);
            }
        }
        ProxyFactory factory = new ProxyFactory(cl);
        Iterator iterator = this.getPackage().getAllBeans().iterator();
        while (iterator.hasNext()) {
            EntityBeanDescriptor ed;
            BeanDescriptor bd = (BeanDescriptor)iterator.next();
            if (bd instanceof EntityBeanDescriptor && (ed = (EntityBeanDescriptor)bd).isTopLinkCMP()) {
                ed.setRemoteHomeWrapperName(null);
                ed.setRemoteHomeWrapper(null);
                ed.setLocalHomeWrapperName(null);
                ed.setLocalHomeWrapper(null);
                ed.setRemoteWrapperName(null);
                ed.setRemoteWrapper(null);
                ed.setLocalWrapperName(null);
                ed.setLocalWrapper(null);
            }
            if (generateIIOP && bd instanceof ExposableBeanDescriptor) {
                ((ExposableBeanDescriptor)bd).setGenerateIIOP(true);
            }
            factory.buildProxies(bd);
        }
    }

    public void loadProxyClasses() throws ClassNotFoundException {
        Iterator j = this.getPackage().getAllBeans().iterator();
        while (j.hasNext()) {
            ExposableBeanDescriptor ed;
            BeanDescriptor bd = (BeanDescriptor)j.next();
            if (!(bd instanceof ExposableBeanDescriptor) || !(ed = (ExposableBeanDescriptor)bd).getGenerateIIOP()) continue;
            if (ed.getRemoteHomeWrapperName() != null) {
                ed.setRemoteHomeWrapper(this.getEJBClassLoader().loadClass(ed.getRemoteHomeWrapperName()));
            }
            if (ed.getRemoteWrapperName() == null) continue;
            ed.setRemoteWrapper(this.getEJBClassLoader().loadClass(ed.getRemoteWrapperName()));
        }
    }

    public class HomeNameId {
        String ejbName;
        boolean local;

        public HomeNameId(String _ejbName, boolean _local) {
            this.ejbName = _ejbName;
            this.local = _local;
        }

        public int hashCode() {
            return this.ejbName.hashCode();
        }

        public boolean equals(Object o2) {
            try {
                HomeNameId h2 = (HomeNameId)o2;
                return this.ejbName.equals(h2.ejbName) && this.local == h2.local;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

