/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.reflect.Proxy;
import com.evermind.server.ApplicationContext;
import com.evermind.server.ejb.ContainerManagedObject;
import com.evermind.server.ejb.EntityBeanReferenceHolder;
import com.evermind.server.ejb.EntityHandle;
import com.evermind.server.ejb.InitialContextHolder;
import com.evermind.server.ejb.LocalContextHolder;
import com.evermind.server.ejb.ORCollection;
import com.evermind.server.ejb.ORSet;
import com.evermind.server.ejb.SessionBeanReferenceHolder;
import com.evermind.server.ejb.StatefulSessionContext;
import com.evermind.server.ejb.StatefulSessionHandle;
import com.evermind.server.ejb.StatefulSessionRemoteInvocationHandler;
import com.evermind.server.ejb.StatelessSessionHandle;
import com.evermind.server.ejb.persistence.ContainerEntityManager;
import com.evermind.server.ejb.persistence.EntityManagerHolder;
import com.evermind.server.rmi.Replaceable;
import com.evermind.server.rmi.SingletonHolder;
import com.oracle.naming.J2EEContext;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.CORBA.Stub;
import javax.transaction.TransactionManager;

public class EJBOutputStream
extends ObjectOutputStream {
    public StatefulSessionContext sessionContext;

    public EJBOutputStream(OutputStream out) throws IOException {
        super(out);
        this.enableReplaceObject(true);
    }

    protected Object replaceObject(Object object) throws IOException {
        return EJBOutputStream.replaceEJBObject(object, this.sessionContext);
    }

    public static Object replaceEJBObject(Object object, StatefulSessionContext sessionContext) throws IOException {
        if (object instanceof SessionContext) {
            return new SingletonHolder("sessionContext");
        }
        if (object instanceof EJBObject) {
            if (sessionContext != null && sessionContext.remoteWrapper == object) {
                return new SingletonHolder("sessionEJBObject");
            }
            Handle handle = ((EJBObject)object).getHandle();
            if (handle instanceof StatefulSessionHandle) {
                StatefulSessionHandle sessionHandle = (StatefulSessionHandle)handle;
                SessionBeanReferenceHolder holder = new SessionBeanReferenceHolder();
                holder.id = sessionHandle.id;
                holder.checksum = sessionHandle.checksum;
                holder.path = sessionHandle.homePath;
                if (object instanceof Proxy) {
                    try {
                        holder.remoteEnvironment = ((StatefulSessionRemoteInvocationHandler)((Proxy)object).getInvocationHandler()).getContextEnvironment();
                    }
                    catch (NamingException nmex) {
                        nmex.printStackTrace();
                    }
                }
                return holder;
            }
            if (handle instanceof StatelessSessionHandle) {
                SingletonHolder holder = new SingletonHolder("session:" + ((StatelessSessionHandle)handle).bindingPath);
                return holder;
            }
            if (handle instanceof EntityHandle) {
                EntityHandle entityHandle = (EntityHandle)handle;
                EntityBeanReferenceHolder holder = new EntityBeanReferenceHolder();
                holder.homePath = entityHandle.homePath;
                holder.primaryKey = entityHandle.key;
                return holder;
            }
            return object;
        }
        if (object instanceof EJBHome && !(object instanceof Stub)) {
            return ((EJBHome)object).getHomeHandle();
        }
        if (object instanceof J2EEContext) {
            return LocalContextHolder.INSTANCE;
        }
        if (object instanceof InitialContext) {
            return InitialContextHolder.INSTANCE;
        }
        if (object instanceof ApplicationContext) {
            return InitialContextHolder.INSTANCE;
        }
        if (object instanceof TransactionManager) {
            return new SingletonHolder("UserTransaction");
        }
        if (object instanceof ContainerEntityManager) {
            ContainerEntityManager em = (ContainerEntityManager)object;
            if ("TRANSACTION".equals(em.getType())) {
                return new EntityManagerHolder(em.getPersistenceUnit().getName(), em.getProperties());
            }
        } else {
            if (object.getClass().getName().equals("oracle.toplink.internal.ejb.cmp3.EntityManagerImpl")) {
                return new SingletonHolder("EntityManager");
            }
            if (object instanceof ContainerManagedObject) {
                if (object instanceof ORSet) {
                    return new HashSet((Set)object);
                }
                if (object instanceof ORCollection) {
                    return new ArrayList((Collection)object);
                }
            } else if (object instanceof Replaceable) {
                return ((Replaceable)object).getReplacement();
            }
        }
        return object;
    }
}

