/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ApplicationContext;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.EJBInputStream;
import com.evermind.server.ejb.EntityEJBHome;
import com.evermind.server.ejb.LocalEJBHomeReferenceHolder;
import com.evermind.server.ejb.LocalEntityBeanReferenceHolder;
import com.evermind.server.ejb.LocalSessionBeanReferenceHolder;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.evermind.server.ejb.StatelessSessionEJBHome;
import com.evermind.server.rmi.SingletonHolder;
import java.io.IOException;
import java.io.InputStream;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;

public class EJBInternalInputStream
extends EJBInputStream {
    public EJBInternalInputStream(InputStream in, AbstractEJBHome home) throws IOException {
        super(in, home == null ? Thread.currentThread().getContextClassLoader() : home.container.getBeansClassLoader());
        this.home = home;
        this.context = home == null ? null : home.container.getApplication().getContext();
        this.enableResolveObject(true);
    }

    public Object resolveObject(Object object) throws IOException {
        if (object instanceof LocalEntityBeanReferenceHolder) {
            LocalEntityBeanReferenceHolder holder = (LocalEntityBeanReferenceHolder)object;
            EntityEJBHome home = (EntityEJBHome)this.getHomeInstance("entity", holder.homePath, true);
            return home.getLazyInstance(holder.primaryKey);
        }
        if (object instanceof LocalSessionBeanReferenceHolder) {
            LocalSessionBeanReferenceHolder holder = (LocalSessionBeanReferenceHolder)object;
            StatefulSessionEJBHome home = (StatefulSessionEJBHome)this.getHomeInstance("session", holder.path, true);
            StatefulSessionEJBObject wrapper = home.getEJBObject(holder.id);
            if (wrapper != null && wrapper.OC4J_getChecksum() == holder.checksum) {
                return (EJBLocalObject)wrapper;
            }
            throw new IOException("Unable to find session object " + holder.id + " for location '" + holder.path + "'");
        }
        if (object instanceof LocalEJBHomeReferenceHolder) {
            LocalEJBHomeReferenceHolder holder = (LocalEJBHomeReferenceHolder)object;
            EJBLocalHome home = (EJBLocalHome)this.getHomeInstance("entity", holder.homePath, true);
            return home;
        }
        if (object instanceof SingletonHolder && ((SingletonHolder)object).getName().startsWith("session:local:")) {
            String name = ((SingletonHolder)object).getName().substring("session:local:".length());
            StatelessSessionEJBHome home = (StatelessSessionEJBHome)this.getHomeInstance("session", name, true);
            return home.getSingletonInstance();
        }
        return super.resolveObject(object);
    }

    private AbstractEJBHome getHomeInstance(String type, String path, boolean local) throws IOException {
        try {
            if (path == null) {
                throw new NullPointerException("path was null");
            }
            if (!(this.getInitialContext() instanceof ApplicationContext)) {
                throw new Exception("Not in an application scope, unable to resolve object reference");
            }
            return ((ApplicationContext)this.getInitialContext()).getApplication().getEJBContainer().getHomeInstance(path, true);
        }
        catch (Exception e) {
            throw (IOException)new IOException("Unable to resolve " + type + " '" + path + "'").initCause(e);
        }
    }
}

