/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.compiler.CompilationException;
import com.evermind.io.IOUtils;
import com.evermind.naming.ContextUtils;
import com.evermind.naming.file.FileContext;
import com.evermind.server.Application;
import com.evermind.server.ApplicationComponentCallBackIf;
import com.evermind.server.ContextContainer;
import com.evermind.server.RuntimeSecurityRole;
import com.evermind.server.ThreadState;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.EJBContainerConfig;
import com.evermind.server.ejb.EJBInternalInputStream;
import com.evermind.server.ejb.EJBInternalOutputStream;
import com.evermind.server.ejb.EJBPackageDeployment;
import com.evermind.server.ejb.EJBTask;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.EntityEJBHome;
import com.evermind.server.ejb.IncrementalDeploymentHandler;
import com.evermind.server.ejb.JGroupEJBService;
import com.evermind.server.ejb.LocalReplicationService;
import com.evermind.server.ejb.MessageDrivenHome;
import com.evermind.server.ejb.PersistenceEJBService;
import com.evermind.server.ejb.SessionReplicationService;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.evermind.server.ejb.StatelessSessionEJBHome;
import com.evermind.server.ejb.admin.EJBModuleCallbackIfImpl;
import com.evermind.server.ejb.compilation.Compilation;
import com.evermind.server.ejb.database.DatabaseSchema;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.EJBDeploymentContext;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.EJBReference;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.deployment.PersistenceManagerDescriptor;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.server.ejb.logging.EJBDeploymentMessages;
import com.evermind.server.ejb.logging.EJBIiopMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.util.ConfigUtils;
import com.evermind.util.EJBProperties;
import com.evermind.xml.XMLUtils;
import com.oracle.bricks.j2ee.JGroupConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OptionalDataException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.jms.JMSException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import oracle.classloader.PolicyClassLoader;
import oracle.ias.container.timer.EJBTimerImpl;
import oracle.ias.container.timer.Timer;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.EJBModuleCallBackIf;
import oracle.oc4j.admin.management.mbeans.EJBModule;
import oracle.oc4j.admin.management.mbeans.StateManageable;
import oracle.oc4j.corba.ServerOrbManager;
import org.jgroups.ChannelException;

public class EJBContainer
implements EJBDeploymentContext,
ApplicationComponentCallBackIf {
    public static boolean ejbDeploySingleThread = EJBProperties.getEJBDeploySingleThread();
    private static Logger m_logger = EJBTraceLogger.getLogger(EJBContainer.class);
    private List installedPackages = new ArrayList();
    private List packageQueue;
    protected EJBTask task;
    protected SessionReplicationService replicationService;
    protected Map roleCombinations;
    protected EJBContainerConfig config;
    private boolean undeployPending;
    private PolicyClassLoader appRootLoader;
    private PolicyClassLoader tempMetadataParsingLoader = null;
    EJBContainer parent;
    Application application;
    List remotePackages;
    private Collection _ejbModules;
    private int currentState;
    private final Object stateManagementLock = new Object();
    private IncrementalDeploymentHandler incrementalDeploymentHandler = null;

    public EJBContainer(Application application, EJBContainer parent) {
        this.application = application;
        this.parent = parent;
        this.setState(3);
        this.replicationService = new LocalReplicationService();
    }

    public void initReplicationService() throws InstantiationException {
        JGroupConfig jconfig = this.application.getConfig().getClusterConfig();
        try {
            if (jconfig != null && jconfig.useDatabase()) {
                this.replicationService = new PersistenceEJBService(this, this.application.getConfig());
            } else if (jconfig != null && jconfig.isEnabled()) {
                this.replicationService = new JGroupEJBService(this, this.application.getConfig());
            }
        }
        catch (ChannelException e) {
            m_logger.log(Level.WARNING, "Error initialize replication service", e);
        }
    }

    private void initTaskManagerTask() {
        if (this.task == null) {
            this.task = new EJBTask(this);
        }
        this.application.getServer().getTaskManager().addTask(this.task, EJBProperties.getEjbtaskInterval());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void preInit(EJBContainerConfig config, PolicyClassLoader appRootLoader) throws InstantiationException {
        try {
            this.config = config;
            this.appRootLoader = appRootLoader;
            this._ejbModules = this.application.getConfig().getEJBPackages();
            this.packageQueue = new ArrayList();
            this.remotePackages = null;
            this.initTaskManagerTask();
            this.unbindHomes(true, false);
            Iterator moduleIterator = this._ejbModules.iterator();
            while (moduleIterator.hasNext()) {
                com.evermind.server.deployment.EJBModule ejbModule = (com.evermind.server.deployment.EJBModule)moduleIterator.next();
                try {
                    EJBPackageDeployment ejbDeployment;
                    Context parentContext = config.getContext();
                    Context assemblyContext = parentContext == null ? ContextUtils.getContext(ConfigUtils.getURL(config.getURL(), ejbModule.getPath()), false) : (parentContext instanceof FileContext ? ContextUtils.getContext(ConfigUtils.getURL(((FileContext)parentContext).getFile().toURL(), ejbModule.getPath()), false) : ContextUtils.getContext(parentContext, ejbModule.getPath(), false));
                    if (ejbModule.isRemote()) {
                        ejbDeployment = new EJBPackageDeployment((EnterpriseArchive)this.application.getConfig(), this, assemblyContext, ejbModule);
                        if (this.remotePackages == null) {
                            this.remotePackages = new ArrayList();
                        }
                        ejbDeployment.checkAndResetContext();
                        this.remotePackages.add(ejbDeployment);
                        continue;
                    }
                    ejbDeployment = new EJBPackageDeployment((EnterpriseArchive)this.application.getConfig(), this, assemblyContext, ejbModule);
                    ejbDeployment.checkAndResetContext();
                    this.packageQueue.add(ejbDeployment);
                }
                catch (NamingException e) {
                    try {
                        InstantiationException ie = new InstantiationException("Unable to load EJB-jar '" + ejbModule.getPath() + "' in '" + this.application.getConfig().getDisplayName() + "' (" + config.getContext().getNameInNamespace() + ")");
                        ie.initCause(e);
                        throw ie;
                    }
                    catch (NamingException ne) {
                        InstantiationException te = new InstantiationException("Unable to load EJB-jar '" + ejbModule.getPath() + "' in '" + this.application.getConfig().getDisplayName() + "'");
                        te.initCause(ne);
                        throw te;
                        return;
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            InstantiationException ie = new InstantiationException("Error initializing ejb-module, malformed URL: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        catch (IOException e) {
            InstantiationException ie = new InstantiationException("Error initializing ejb-module, IO Error: " + e.getMessage());
            ie.initCause(ie);
            throw ie;
        }
    }

    public int getState() {
        return this.currentState;
    }

    public int getComponentState() {
        return this.getState();
    }

    public void setState(int s) {
        if (!this.isValidState(s)) {
            throw new IllegalStateException("Invalid state constant: " + s);
        }
        this.currentState = s;
    }

    private boolean isValidState(int s) {
        for (int i = 0; i < StateManageable.VALID_STATES.length; ++i) {
            if (s != StateManageable.VALID_STATES[i]) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentStop(List appSubComponentList) {
        this.stop();
        List list = appSubComponentList;
        synchronized (list) {
            Iterator itr = appSubComponentList.iterator();
            while (itr.hasNext()) {
                Object obj = itr.next();
                if (!obj.equals(this)) continue;
                itr.remove();
            }
            appSubComponentList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.stateManagementLock;
        synchronized (object) {
            try {
                switch (this.getState()) {
                    case 3: {
                        return;
                    }
                    case 0: {
                        throw new IllegalStateException("EJBContainer in STARTING mode on call to stop()");
                    }
                    case 4: {
                        throw new IllegalStateException("EJBContainer in FAILED mode on call to stop()");
                    }
                    case 2: {
                        throw new IllegalStateException("EJBContainer in STOPPING mode on call to stop()");
                    }
                }
                this.setState(2);
                this.processTimers(EJBPackageDeployment.PASSIVATE_TIMER);
                Iterator i = this.installedPackages.iterator();
                while (i.hasNext()) {
                    ((EJBPackageDeployment)i.next()).stopMessageDrivenHomes();
                }
                this.waitForActiveEjbMethodsToFinish();
                this.setState(3);
            }
            catch (Exception e) {
                this.setState(4);
                throw new JMXRuntimeException((Throwable)e);
            }
        }
    }

    public void start() {
        Object object = this.stateManagementLock;
        synchronized (object) {
            String state = "";
            switch (this.getState()) {
                case 3: {
                    this.setState(1);
                    return;
                }
                case 1: {
                    state = "RUNNING";
                    break;
                }
                case 0: {
                    state = "STARTING";
                    break;
                }
                case 4: {
                    state = "FAILED";
                    break;
                }
                case 2: {
                    state = "STOPPING";
                }
            }
            throw new IllegalStateException("EJBContainer in " + state + " mode on call to start()");
        }
    }

    public boolean isRunning() {
        return this.currentState == 1;
    }

    private void waitForActiveEjbMethodsToFinish() {
        Iterator i = this.installedPackages.iterator();
        while (i.hasNext()) {
            EJBPackageDeployment deployment = (EJBPackageDeployment)i.next();
            deployment.waitForActiveEjbMethodsToFinish();
        }
    }

    public void removeEJBModuleMBean(String name) {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        EJBModule mbean = new EJBModule(null, this.application.getName(), name);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (MBeanRegistrationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void addEJBModuleMBean(EJBModuleCallBackIf cback, String name) {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        EJBModule mbean = new EJBModule(cback, this.application.getName(), name);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                this.removeEJBModuleMBean(name);
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (MBeanRegistrationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public EJBPackageDeployment getEJBPackage(String path) {
        path = path.replace('\\', '/');
        for (int i = 0; i < this.installedPackages.size(); ++i) {
            EJBPackageDeployment ejbPackage = (EJBPackageDeployment)this.installedPackages.get(i);
            String tempPath = ejbPackage.getModule().getPath().replace('\\', '/');
            if (!tempPath.equals(path)) continue;
            return ejbPackage;
        }
        return null;
    }

    public EJBPackageDeployment getEJBPackageByName(String name) {
        for (int i = 0; i < this.installedPackages.size(); ++i) {
            EJBPackageDeployment ejbPackage = (EJBPackageDeployment)this.installedPackages.get(i);
            if (!ejbPackage.getModule().getPath().equals(name) && !ejbPackage.getModule().getName().equals(name) && !ejbPackage.getModule().getShortName().equals(name)) continue;
            return ejbPackage;
        }
        return null;
    }

    public DatabaseSchema getDatabaseSchema(String location) throws InstantiationException {
        return this.application.getDatabaseSchema(location);
    }

    public String getProperCMTSourceName(String location) {
        return this.application.getProperCMTSourceName(location);
    }

    public synchronized EJBPackageDeployment getEJBPackage(com.evermind.server.deployment.EJBModule module) {
        for (int i = 0; i < this.installedPackages.size(); ++i) {
            EJBPackageDeployment ejbPackage = (EJBPackageDeployment)this.installedPackages.get(i);
            if (ejbPackage.getModule() != module) continue;
            return ejbPackage;
        }
        return null;
    }

    public synchronized RuntimeSecurityRole getRuntimeSecurityRole(Set roles) {
        RuntimeSecurityRole role;
        if (this.roleCombinations == null) {
            this.roleCombinations = new HashMap();
        }
        if ((role = (RuntimeSecurityRole)this.roleCombinations.get(roles)) == null) {
            role = new RuntimeSecurityRole(this.application.getUserManager(), roles);
            this.roleCombinations.put(roles, role);
        }
        return role;
    }

    public synchronized BeanDescriptor getBeanByLocation(String location) {
        if (this.packageQueue == null) {
            Iterator iterator = this.installedPackages.iterator();
            while (iterator.hasNext()) {
                EJBPackageDeployment ejbDeployment = (EJBPackageDeployment)iterator.next();
                BeanDescriptor bean = ejbDeployment.getPackage().getBeanByLocation(location);
                if (bean == null) continue;
                return bean;
            }
        } else {
            Iterator iterator = this.packageQueue.iterator();
            while (iterator.hasNext()) {
                EJBPackageDeployment ejbDeployment = (EJBPackageDeployment)iterator.next();
                BeanDescriptor bean = ejbDeployment.getPackage().getBeanByLocation(location);
                if (bean == null) continue;
                return bean;
            }
        }
        if (this.parent != null) {
            return this.parent.getBeanByLocation(location);
        }
        return null;
    }

    public synchronized Collection getBeansByInterface(String homeName, String remoteName, String type, String link, boolean local) throws InstantiationException {
        return this.getBeansByInterface(homeName, remoteName, type, link, new Boolean(local));
    }

    public synchronized Collection getBeansByInterface(String homeName, String remoteName, String link) throws InstantiationException {
        return this.getBeansByInterface(homeName, remoteName, null, link, null);
    }

    private synchronized Collection getBeansByInterface(String homeName, String remoteName, String type, String link, Boolean local) throws InstantiationException {
        EJBPackageDeployment ejbDeployment;
        Iterator iterator;
        if (homeName != null && homeName.equals(remoteName)) {
            throw new InvalidEJBAssemblyException("ejb-ref had same name for home and remote (" + homeName + ")", "20.3.2");
        }
        ArrayList instances = new ArrayList();
        if (this.packageQueue == null) {
            iterator = this.installedPackages.iterator();
            while (iterator.hasNext()) {
                ejbDeployment = (EJBPackageDeployment)iterator.next();
                ejbDeployment.getPackage().getBeansByInterface(instances, homeName, remoteName, type, link, local);
            }
        } else {
            iterator = this.packageQueue.iterator();
            while (iterator.hasNext()) {
                ejbDeployment = (EJBPackageDeployment)iterator.next();
                ejbDeployment.getPackage().getBeansByInterface(instances, homeName, remoteName, type, link, local);
            }
        }
        if (this.remotePackages != null) {
            iterator = this.remotePackages.iterator();
            while (iterator.hasNext()) {
                ejbDeployment = (EJBPackageDeployment)iterator.next();
                ejbDeployment.getPackage().getBeansByInterface(instances, homeName, remoteName, type, link, local);
            }
        }
        if (this.parent != null) {
            instances.addAll(this.parent.getBeansByInterface(homeName, remoteName, type, link, local));
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSessions(EJBInternalOutputStream out, StatefulSessionEJBHome home, boolean migrated) throws IOException {
        ThreadState state = ThreadState.getCurrentState();
        Iterator iterator = home.getInstances().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            try {
                StatefulSessionEJBObject wrapper = (StatefulSessionEJBObject)entry.getValue();
                if (m_logger.isLoggable(Level.FINE)) {
                    if (migrated) {
                        m_logger.log(Level.FINE, "Sending across: " + wrapper.getClass().getName());
                    } else {
                        m_logger.log(Level.FINE, "Passivating:" + wrapper.getClass().getName());
                    }
                }
                ContextContainer oldContext = state.contextContainer;
                try {
                    if (wrapper.invalidated) continue;
                    if (home.sessionTimeout > 0L && System.currentTimeMillis() - wrapper.lastAccessedTime >= home.sessionTimeout) {
                        wrapper.remove_X();
                        continue;
                    }
                    if (!migrated) {
                        if (wrapper.allowPassivate) {
                            if (wrapper.OC4J_isPassivated() || wrapper.passivateBean()) continue;
                            wrapper.remove_X();
                            continue;
                        }
                        wrapper.remove_X();
                        continue;
                    }
                    if (this.replicationService instanceof LocalReplicationService) continue;
                    wrapper.OC4J_waitForWrapper();
                    this.replicationService.flushSession(null, wrapper, false);
                }
                finally {
                    state.contextContainer = oldContext;
                }
            }
            catch (Throwable t) {
                this.application.log("Error serializing EJB-Session", t);
                m_logger.log(Level.WARNING, "Error serializing EJB-Session: " + t.getMessage());
            }
        }
    }

    protected static void flushSession(EJBInternalOutputStream out, StatefulSessionEJBObject wrapper, boolean passivate) throws Exception {
        out.writeLong(wrapper.OC4J_getId());
        out.writeLong(wrapper.OC4J_getChecksum());
        out.writeUTF(wrapper.OC4J_getUserName() == null ? "" : wrapper.OC4J_getUserName());
        out.writeLong(wrapper.creationTime);
        out.writeLong(wrapper.lastAccessedTime);
        out.sessionContext = wrapper.context;
        out.writeObject(wrapper.context.attributes);
        out.writeObject(passivate ? wrapper.passivate() : wrapper.getObject());
        out.writeObject(wrapper.context.getUserInterceptorInstances());
    }

    public synchronized boolean needsRestart(EJBContainerConfig config) {
        if (this.installedPackages == null || this.installedPackages.size() != this._ejbModules.size()) {
            return true;
        }
        Iterator iterator = this._ejbModules.iterator();
        while (iterator.hasNext()) {
            EJBPackageDeployment deployment = this.getEJBPackage((com.evermind.server.deployment.EJBModule)iterator.next());
            try {
                if (deployment != null && deployment.getPackage().isDeployed() == null) continue;
                return true;
            }
            catch (InstantiationException e) {
                return true;
            }
        }
        return false;
    }

    public void storeSessions(String storeFile, StatefulSessionEJBHome home) throws IOException {
        URL dirURL;
        boolean storedToCluster = false;
        if (!home.replicationPolicy.isNone()) {
            storedToCluster = this.replicationService.attemptSessionMigration(home);
        }
        if ((dirURL = this.config.getPersistenceURL()) == null) {
            return;
        }
        if (storeFile == null) {
            return;
        }
        URL url = ConfigUtils.getURL(dirURL, storeFile + ".ser");
        IOUtils.makePath(new File(url.getFile()));
        FileOutputStream fileOut = new FileOutputStream(url.getFile());
        EJBInternalOutputStream out = new EJBInternalOutputStream(fileOut);
        out.writeLong(home.getCurrentID());
        if (!storedToCluster) {
            if (this.application.getServer().getConfig().getSFSBEnablePassivation()) {
                this.storeSessions(out, home, false);
            } else {
                home.invalidateSessions();
            }
        }
        out.writeLong(-1L);
        out.flush();
        out.close();
        fileOut.close();
    }

    public Collection getDeployedPackages() {
        if (this.installedPackages == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this.installedPackages);
    }

    public PolicyClassLoader getBeansClassLoader() {
        return this.appRootLoader;
    }

    public Application getApplication() {
        return this.application;
    }

    public EJBContainerConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void postInit(EJBContainerConfig config, Notifier notifier) throws InstantiationException {
        block52: {
            Class clazz;
            block55: {
                block53: {
                    if (m_logger.isLoggable(Level.FINE)) {
                        m_logger.entering(EJBContainer.class.toString(), "postInit", config);
                    }
                    long start_run = System.currentTimeMillis();
                    long stop_run = 0L;
                    Compilation batchCompilation = null;
                    ArrayList<Compilation> compilationQueue = new ArrayList<Compilation>();
                    boolean hasDeployed = false;
                    try {
                        try {
                            String[] params;
                            URL codebase;
                            URL configURL;
                            com.evermind.server.deployment.EJBModule ejbModule;
                            EJBPackageDeployment ejbDeployment;
                            Iterator i;
                            block51: {
                                boolean hasEJB30Modules = false;
                                i = this.packageQueue.iterator();
                                while (i.hasNext()) {
                                    ejbDeployment = (EJBPackageDeployment)i.next();
                                    if (notifier != null) {
                                        String[] params2 = new String[]{ejbDeployment.getModule().getPath()};
                                        notifier.sendNotification("PROCESSING_EJB_MODULE", params2);
                                    }
                                    ejbDeployment.createPackage().init();
                                    ejbDeployment.addModuleCodeSource();
                                    hasEJB30Modules |= ejbDeployment.getPackage().getCompatibility() >= 3;
                                }
                                try {
                                    if (hasEJB30Modules && EJBUtils.isJdk50()) {
                                        this.tempMetadataParsingLoader = this.appRootLoader.copy(false, false);
                                    }
                                    i = this.packageQueue.iterator();
                                    while (i.hasNext()) {
                                        ((EJBPackageDeployment)i.next()).parseMetaData();
                                    }
                                    Object var15_14 = null;
                                    if (this.tempMetadataParsingLoader == null) break block51;
                                }
                                catch (Throwable throwable) {
                                    Object var15_15 = null;
                                    if (this.tempMetadataParsingLoader != null) {
                                        this.tempMetadataParsingLoader.close();
                                        this.tempMetadataParsingLoader = null;
                                    }
                                    throw throwable;
                                }
                                this.tempMetadataParsingLoader.close();
                                this.tempMetadataParsingLoader = null;
                            }
                            i = this.packageQueue.iterator();
                            while (i.hasNext()) {
                                ((EJBPackageDeployment)i.next()).initializePersistenceUnitManager();
                            }
                            i = this.packageQueue.iterator();
                            while (i.hasNext()) {
                                PersistenceManagerDescriptor pm;
                                EJBPackageDeployment deployment = (EJBPackageDeployment)i.next();
                                EJBPackage ejbPackage = deployment.getPackage();
                                ejbPackage.initialize(this);
                                deployment.initializeProxies();
                                if (notifier == null || (pm = ejbPackage.getPersistenceManagerDescriptor()) == null || !pm.isOrionPM()) continue;
                                String[] params3 = new String[]{ejbPackage.getName()};
                                notifier.sendNotification("EJB_ORION_CMP_DESUPPORTED", params3);
                            }
                            i = this.packageQueue.iterator();
                            while (i.hasNext()) {
                                Object var20_24;
                                ejbDeployment = (EJBPackageDeployment)i.next();
                                ejbModule = ejbDeployment.getModule();
                                configURL = config.getURL();
                                codebase = configURL == null ? null : ConfigUtils.getURL(configURL.getFile().endsWith(".ear") ? new URL(configURL.toExternalForm() + "/") : configURL, ejbModule.getPath());
                                String deployed = null;
                                try {
                                    try {
                                        deployed = ejbDeployment.getPackage().isDeployed();
                                        ejbDeployment.notifyPMs(1, null);
                                        if (deployed != null) {
                                            EJBDeploymentMessages.infoEJBModuleDeployed(this.getApplication().getName(), ejbModule.getName(), ejbModule.getPath(), deployed);
                                            ejbDeployment.flushCachedInfo();
                                            String classpath = this.application.getClasspath();
                                            if (classpath.endsWith(File.pathSeparator)) {
                                                classpath = classpath.substring(0, classpath.length() - 1);
                                            }
                                            Compilation compilation = new Compilation(this, ejbDeployment, classpath);
                                            compilation.doGenerateCode();
                                            compilationQueue.add(compilation);
                                            hasDeployed = true;
                                        }
                                    }
                                    catch (Exception e) {
                                        if (notifier != null) {
                                            params = new String[]{codebase.toString()};
                                            notifier.sendNotification("ERROR_WHILE_COMPILING_EJB_COMPONENT", params, e);
                                        }
                                        m_logger.log(Level.WARNING, "Error generating wrappers for " + codebase, e);
                                        throw (InstantiationException)new InstantiationException("Error generating wrappers for " + codebase + ": " + e.getMessage()).initCause(e);
                                    }
                                    var20_24 = null;
                                    if (this.incrementalDeploymentHandler == null || !this.incrementalDeploymentHandler.getEjbModuleName().equals(ejbModule.getName())) continue;
                                    this.incrementalDeploymentHandler.deleteBackupEJBArchive(ejbDeployment);
                                    this.incrementalDeploymentHandler = null;
                                    ejbDeployment.setIncrementalDeployed(true);
                                }
                                catch (Throwable throwable) {
                                    var20_24 = null;
                                    if (this.incrementalDeploymentHandler != null && this.incrementalDeploymentHandler.getEjbModuleName().equals(ejbModule.getName())) {
                                        this.incrementalDeploymentHandler.deleteBackupEJBArchive(ejbDeployment);
                                        this.incrementalDeploymentHandler = null;
                                        ejbDeployment.setIncrementalDeployed(true);
                                    }
                                    throw throwable;
                                }
                            }
                            if (compilationQueue.size() > 0) {
                                if (notifier != null) {
                                    notifier.sendNotification("COMPILING EJB GENERATED CODE");
                                }
                                if (!EJBProperties.getEJBDeployInBatch()) {
                                    EJBDeploymentMessages.warningBatchCompileSystemProperty(this.getApplication());
                                }
                                if (this.getConfig().getEJBDeployInBatch()) {
                                    HashMap sources = new HashMap();
                                    Iterator i2 = compilationQueue.iterator();
                                    while (i2.hasNext()) {
                                        Compilation c = (Compilation)i2.next();
                                        Map generatedSources = c.getBatchSources();
                                        Iterator genKeys = generatedSources.keySet().iterator();
                                        while (genKeys.hasNext()) {
                                            String genKey = (String)genKeys.next();
                                            if (sources.get(genKey) != null && generatedSources.get(genKey) != null) {
                                                ((Collection)sources.get(genKey)).addAll((Collection)generatedSources.get(genKey));
                                                continue;
                                            }
                                            sources.put(genKey, generatedSources.get(genKey));
                                        }
                                    }
                                    ejbDeployment = (EJBPackageDeployment)this.packageQueue.get(0);
                                    String classpath = this.application.getClasspath();
                                    if (classpath.endsWith(File.pathSeparator)) {
                                        classpath = classpath.substring(0, classpath.length() - 1);
                                    }
                                    batchCompilation = new Compilation(this, ejbDeployment, classpath);
                                    batchCompilation.doBatchCompile(sources);
                                } else {
                                    i = compilationQueue.iterator();
                                    while (i.hasNext()) {
                                        Compilation c = (Compilation)i.next();
                                        c.doBatchCompile(c.getBatchSources());
                                    }
                                }
                            }
                            i = compilationQueue.iterator();
                            while (i.hasNext()) {
                                Compilation compilation = (Compilation)i.next();
                                EJBPackageDeployment ejbDeployment2 = compilation.getEJBPackageDeployment();
                                com.evermind.server.deployment.EJBModule ejbModule2 = ejbDeployment2.getModule();
                                URL configURL2 = config.getURL();
                                URL codebase2 = configURL2 == null ? null : ConfigUtils.getURL(configURL2.getFile().endsWith(".ear") ? new URL(configURL2.toExternalForm() + "/") : configURL2, ejbModule2.getPath());
                                try {
                                    try {
                                        compilation.doLoadCode(ejbDeployment2.getPackage().getName());
                                    }
                                    catch (CompilationException e) {
                                        if (notifier != null) {
                                            params = new String[]{codebase2.toString()};
                                            notifier.sendNotification("ERROR_WHILE_COMPILING_EJB_COMPONENT", params, e);
                                        }
                                        String msg = "Error loading module " + codebase2.toString() + ": " + e.getMessage();
                                        throw (InstantiationException)new InstantiationException(msg).initCause(e);
                                    }
                                }
                                catch (InstantiationException e) {
                                    if (notifier != null) {
                                        params = new String[]{codebase2.toString(), this.getApplication().getName()};
                                        notifier.sendNotification("ERROR_LOADING_PACKAGE_FOR_APP", params, e);
                                    }
                                    EJBDeploymentMessages.warningLoadingEJBModule(this.getApplication().getName(), ejbModule2.getName(), codebase2.toString(), e.getMessage());
                                    throw e;
                                }
                            }
                            i = this.packageQueue.iterator();
                            while (i.hasNext()) {
                                ejbDeployment = (EJBPackageDeployment)i.next();
                                ejbModule = ejbDeployment.getModule();
                                configURL = config.getURL();
                                codebase = configURL == null ? null : ConfigUtils.getURL(configURL.getFile().endsWith(".ear") ? new URL(configURL.toExternalForm() + "/") : configURL, ejbModule.getPath());
                                ejbDeployment.addWrapperCodeSource();
                                ejbDeployment.loadProxyClasses();
                                ejbDeployment.bindHomes();
                                ejbDeployment.setRuntimeSecurityRoles(this);
                                this.addEJBPackage(ejbDeployment);
                                EJBModuleCallbackIfImpl impl = new EJBModuleCallbackIfImpl(ejbDeployment.getPackage());
                                this.addEJBModuleMBean(impl, EJBContainer.getEJBModuleName(ejbDeployment.getModule()));
                                ejbDeployment.initializeJMX();
                                ThreadState state = ThreadState.getCurrentState();
                                ContextContainer previousContainer = state.contextContainer;
                                ejbDeployment.getPackage().storeEJBJarXML();
                                try {
                                    state.contextContainer = this.application;
                                    ejbDeployment.notifyPMs(3, null);
                                }
                                finally {
                                    state.contextContainer = previousContainer;
                                }
                            }
                            if (this.installedPackages.size() > 0) {
                                this.logIIOPMessage();
                            }
                            this.setState(1);
                            i = this.packageQueue.iterator();
                            while (i.hasNext()) {
                                ejbDeployment = (EJBPackageDeployment)i.next();
                                ejbDeployment.startMessageDrivenHomes();
                                ejbDeployment.initializeBeanPooling();
                            }
                            Object var23_27 = null;
                            if (batchCompilation != null) {
                                batchCompilation.postCompilationCleanup();
                            }
                            this.packageQueue = null;
                            if (!m_logger.isLoggable(Level.FINE)) break block52;
                            if (class$com$evermind$server$ejb$EJBContainer != null) break block53;
                        }
                        catch (Exception e) {
                            this.setState(4);
                            try {
                                this.cleanupPersistenceManager(this.packageQueue);
                            }
                            catch (InstantiationException e1) {
                                m_logger.log(Level.WARNING, "Error cleaning up persistence manager", e1);
                            }
                            EJBDeploymentMessages.severeDeploymentFailure(this.getApplication(), e);
                            throw (InstantiationException)new InstantiationException("Error initializing ejb-modules: " + e.getMessage()).initCause(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var23_28 = null;
                        if (batchCompilation != null) {
                            batchCompilation.postCompilationCleanup();
                        }
                        this.packageQueue = null;
                        if (m_logger.isLoggable(Level.FINE)) {
                            m_logger.exiting(EJBContainer.class.toString(), "postInit");
                        }
                        throw throwable;
                    }
                    clazz = class$com$evermind$server$ejb$EJBContainer = EJBContainer.class$("com.evermind.server.ejb.EJBContainer");
                    break block55;
                }
                clazz = class$com$evermind$server$ejb$EJBContainer;
            }
            m_logger.exiting(clazz.toString(), "postInit");
        }
        this.initializeSessions(notifier);
        this.processTimers(EJBPackageDeployment.ACTIVATE_TIMER);
    }

    private void logIIOPMessage() {
        if (ServerOrbManager.isIiopConfigured(this.getApplication())) {
            EJBIiopMessages.finestIiopBeansAvailableInApplication(this.getApplication());
        } else {
            EJBIiopMessages.finestIiopBeansNotAvailableInApplication(this.getApplication(), Compilation.iiopGen, this.getApplication().getApplicationConfigReference().isIiopEnabled(), ServerOrbManager.isOrbConfigured());
        }
    }

    public void destroy_noSync() {
        this.orig_destroy();
    }

    public void destroy() {
        if (ejbDeploySingleThread) {
            this.destroy_noSync();
        } else {
            this.destroy_sync();
        }
    }

    public synchronized void destroy_sync() {
        this.orig_destroy();
    }

    public void orig_destroy() {
        try {
            this.setState(2);
            this.getApplication().getServer().getTaskManager().removeTask(this.task);
            this.processTimers(EJBPackageDeployment.PASSIVATE_TIMER);
            this.unbindHomes(false, this.undeployPending);
            this.replicationService.destroy();
            if (this.appRootLoader != null) {
                this.appRootLoader = null;
            }
            this.setState(3);
        }
        catch (Throwable t) {
            this.setState(4);
        }
    }

    public void destroyNonTimerObjects() {
        try {
            this.getApplication().getServer().getTaskManager().removeTask(this.task);
            this.unbindHomes(false, false);
            this.replicationService.destroy();
            this.setState(3);
        }
        catch (Throwable t) {
            this.setState(4);
        }
    }

    private void verifyLinkedReference(EJBReference reference, ExposableBeanDescriptor bean) throws InstantiationException {
        String interfaceName = reference.getRemoteName();
        String homeName = reference.getHomeName();
        if (homeName != null && !(reference.isLocal() ? bean.getLocalHomeName() : bean.getRemoteHomeName()).equals(homeName)) {
            throw new InvalidEJBAssemblyException("No location specified and no suitable instance found for the ejb-" + (reference.isLocal() ? "local-" : "") + "ref '" + reference.getName() + "', an EJB matching it's ejb-link '" + reference.getLink() + "' was found, but it contained the wrong home type ('" + (reference.isLocal() ? bean.getLocalHomeName() : bean.getRemoteHomeName()) + "' vs '" + reference.getHomeName() + "'): " + reference, "20.3.2");
        }
        if (interfaceName != null && !reference.isEndpoint() && !(reference.isLocal() ? bean.getLocalInterfaceNames() : bean.getRemoteInterfaceNames()).contains(interfaceName)) {
            throw new InvalidEJBAssemblyException("No location specified and no suitable instance found for the ejb-" + (reference.isLocal() ? "local-" : "") + "ref '" + reference.getName() + "', an EJB matching it's ejb-link '" + reference.getLink() + "' was found, but it contained the wrong " + (reference.isLocal() ? "local" : "remote") + " type ('" + (reference.isLocal() ? bean.getLocalInterfaceName() : bean.getRemoteInterfaceName()) + "' vs '" + reference.getRemoteName() + "'): " + reference, "20.3.2");
        }
        if (reference.getType() != null && reference.getType().equalsIgnoreCase("Entity") && !(bean instanceof EntityBeanDescriptor)) {
            throw new InvalidEJBAssemblyException("Bean " + reference.getEJBLink() + " is not an Entity bean: " + reference, "20.3.2");
        }
        if (reference.getType() != null && reference.getType().equalsIgnoreCase("Session") && !(bean instanceof SessionBeanDescriptor)) {
            throw new InvalidEJBAssemblyException("Bean " + reference.getEJBLink() + " is not a Session bean: " + reference, "20.3.2");
        }
    }

    private void verifyReferenceVersion(EJBReference reference, ExposableBeanDescriptor descriptor) throws InstantiationException {
        if (descriptor.getPackage().getCompatibility() < 3) {
            if (reference.getInjectionTargets() != null && !reference.getInjectionTargets().isEmpty() || reference.isCreatedByAnnotation()) {
                return;
            }
            if (reference.getRemoteName() == null) {
                throw new InvalidEJBAssemblyException("No " + (reference.isLocal() ? "local" : "remote") + " specified for the ejb-" + (reference.isLocal() ? "local-" : "") + "ref " + reference.getName() + ": " + reference, "20.3.1.2");
            }
            if (!reference.isEndpoint() && reference.getHomeName() == null) {
                throw new InvalidEJBAssemblyException("No " + (reference.isLocal() ? "local-" : "") + "home specified for the ejb-" + (reference.isLocal() ? "local-" : "") + "ref " + reference.getName() + ": " + reference, "20.3.1.2");
            }
            if (!reference.isEndpoint() && reference.getType() == null) {
                throw new InvalidEJBAssemblyException("No ref type specified for the ejb-" + (reference.isLocal() ? "local-" : "") + "ref " + reference.getName() + ": " + reference, "20.3.1.2");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void resolveReference(EJBReference reference) throws InstantiationException {
        Iterator i;
        BeanDescriptor match;
        if (reference.isRemoteServerRef()) {
            this.resolveRemoteReference(reference);
            return;
        }
        this.resloveAnnotatedEJBReference(reference);
        if (reference.getLocation() != null) {
            return;
        }
        String homeName = reference.getHomeName();
        String interfaceName = reference.getRemoteName();
        String ejbLinkName = reference.getEJBLink();
        String ejbLinkJar = null;
        if (ejbLinkName != null && ejbLinkName.indexOf(35) >= 0) {
            ejbLinkJar = ejbLinkName.substring(0, ejbLinkName.indexOf(35));
            ejbLinkName = ejbLinkName.substring(ejbLinkName.indexOf(35) + 1);
        }
        if (ejbLinkJar != null || ejbLinkName != null) {
            Collection result = this.getBeansByInterface((String)null, (String)null, (String)null, ejbLinkName, reference.isLocal());
            match = null;
            i = result.iterator();
        } else {
            ExposableBeanDescriptor descriptor;
            block18: {
                Collection result = this.getBeansByInterface(homeName, interfaceName, reference.getType(), (String)null, reference.isLocal());
                if (result.isEmpty() && (homeName != null && homeName.equals("javax.management.j2ee.ManagementHome") || interfaceName.equals("javax.management.j2ee.Management"))) {
                    if (reference.isLocal()) {
                        throw new InstantiationException("Only remote references to MEJB are permitted: " + reference);
                    }
                    reference.setLocation("ejb/mgmt/MEJB");
                    return;
                }
                if (result.isEmpty() && reference.getType() != null && !(result = this.getBeansByInterface(homeName, interfaceName, (String)null, (String)null, reference.isLocal())).isEmpty()) {
                    String newType = reference.getType().equalsIgnoreCase("Session") ? "Entity" : "Session";
                    m_logger.warning("Reference " + reference.getName() + " with type " + reference.getType() + " cannot be resolved. Converting to " + newType + " for match: " + reference);
                    reference.setType(newType);
                }
                descriptor = null;
                if (result.size() == 0) {
                    throw new InvalidEJBAssemblyException("Unable to resolve reference " + reference, "20.3.1.2");
                }
                if (result.size() > 1) {
                    if (reference.getLocation() == null) {
                        throw new InvalidEJBAssemblyException("Unable to uniquely resolve reference " + reference, "20.3.2");
                    }
                    ExposableBeanDescriptor match2 = (ExposableBeanDescriptor)this.getBeanByLocation(reference.getLocation());
                    if (match2 != null && match2.getRemoteHomeName().equals(reference.getHomeName()) && match2.getRemoteInterfaceName().equals(reference.getRemoteName())) {
                        m_logger.warning("Unable to uniquely resolve reference " + reference.getName() + ". Using mapped location to match: " + reference);
                        descriptor = match2;
                        break block18;
                    } else {
                        if (match2 != null) {
                            throw new InvalidEJBAssemblyException("Home and interface for reference " + reference.getName() + " with location " + reference.getLocation() + " do not match target bean (" + match2.getRemoteHomeName() + "," + match2.getRemoteInterfaceName() + "):" + reference, "20.3.2");
                        }
                        throw new InvalidEJBAssemblyException("Unable to resolve reference " + reference.getName() + ". Mapped location is invalid: " + reference, "20.3.1.2");
                    }
                }
                descriptor = (ExposableBeanDescriptor)result.iterator().next();
            }
            if (descriptor.getPackage().isRemote() && reference.isLocal()) {
                throw new InstantiationException("Cannot use a local reference to a bean in a remote module ('" + descriptor.getName() + "'): " + reference);
            }
            String jarName = descriptor.getPackage().getDeployment().getModule().getPath();
            reference.setLocation(reference.isLocal() ? descriptor.getQualifiedLocalLocation() : descriptor.getQualifiedLocation());
            reference.setEJBLink(jarName + "#" + descriptor.getName());
            this.verifyReferenceVersion(reference, descriptor);
            return;
        }
        while (i.hasNext()) {
            BeanDescriptor bd = (BeanDescriptor)i.next();
            String jarName = bd.getPackage().getDeployment().getModule().getPath();
            if (ejbLinkJar != null && (ejbLinkJar == null || !ejbLinkJar.equals(jarName))) continue;
            if (match != null) {
                throw new InvalidEJBAssemblyException("Link " + reference.getEJBLink() + " refers to more than one bean: " + reference, "20.3.2");
            }
            match = bd;
        }
        if (match == null) {
            throw new InvalidEJBAssemblyException("No bean with link " + ejbLinkName + " found: " + reference, "20.3.2");
        }
        ExposableBeanDescriptor bd = (ExposableBeanDescriptor)match;
        reference.setLocation(reference.isLocal() ? bd.getQualifiedLocalLocation() : bd.getQualifiedLocation());
        String jarName = bd.getPackage().getDeployment().getModule().getPath();
        reference.setEJBLink(jarName + "#" + ejbLinkName);
        this.verifyLinkedReference(reference, bd);
        this.verifyReferenceVersion(reference, bd);
    }

    public void resloveAnnotatedEJBReference(EJBReference reference) throws InstantiationException {
        if (reference.isCreatedByAnnotation()) {
            Collection beanDescriptors = this.getBeansByInterface(reference.getHomeName(), null, reference.getEJBLink());
            if (beanDescriptors.isEmpty()) {
                beanDescriptors = this.getBeansByInterface(null, reference.getRemoteName(), reference.getEJBLink());
                reference.setHomeName(null);
            } else {
                reference.setRemoteName(null);
            }
            if (beanDescriptors.isEmpty()) {
                throw new InstantiationException("Unable to resolve @EJB annotation with name = " + reference.getName() + " and business interface = " + reference.getHomeName() == null ? reference.getRemoteName() : reference.getHomeName() + " to a bean");
            }
            if (beanDescriptors.size() > 1) {
                throw new InstantiationException("The @EJB annotation  with business interface " + reference.getHomeName() == null ? reference.getRemoteName() : reference.getHomeName() + " resolves to more than one possible bean");
            }
            ExposableBeanDescriptor desc = (ExposableBeanDescriptor)beanDescriptors.iterator().next();
            if (reference.getHomeName() != null) {
                reference.setLocal(reference.getHomeName().equals(desc.getLocalHomeName()));
            } else if (reference.getEJBLink() != null && reference.getRemoteName() == null) {
                if (!desc.getLocalInterfaceNames().isEmpty() && !desc.getRemoteInterfaceNames().isEmpty()) {
                    throw new InstantiationException("Unable to resolve @EJB annotation with name '" + reference.getName() + "' - annotating 'beanName' without 'beanInterface' requires that the bean '" + desc.getName() + "' implements a single local/remote interface.  Specify 'beanInterface' to correct this problem.");
                }
                reference.setLocal(desc.getRemoteInterfaceNames().isEmpty());
            } else {
                reference.setLocal(desc.getLocalInterfaceNames().contains(reference.getRemoteName()));
            }
        }
    }

    public void resolveRemoteReference(EJBReference reference) throws InstantiationException {
        if (reference.getLocation() == null) {
            reference.setLocation(reference.getName());
        }
        if (!reference.isCreatedByAnnotation()) {
            return;
        }
        String homeName = reference.getHomeName();
        if (homeName != null && !homeName.trim().equals("")) {
            try {
                Class<?> homeClass = Thread.currentThread().getContextClassLoader().loadClass(reference.getHomeName());
                if (EJBHome.class.isAssignableFrom(homeClass)) {
                    reference.setRemoteName(null);
                } else {
                    reference.setHomeName(null);
                }
            }
            catch (ClassNotFoundException e) {
                throw new InstantiationException("Unable to resolve @EJB annotation with name '" + reference.getName() + " - Unable to find class : " + reference.getHomeName());
            }
        }
        this.verifyRemoteReference(reference);
    }

    private void verifyRemoteReference(EJBReference reference) throws InstantiationException {
        if (reference.isLocal()) {
            throw new InvalidEJBAssemblyException("Remote EJB reference can not be defined as local reference, ref :" + reference.getName());
        }
    }

    public AbstractEJBHome getHomeInstance(String location, boolean local) throws InstantiationException {
        Iterator i = this.installedPackages.iterator();
        while (i.hasNext()) {
            EJBPackageDeployment pkg = (EJBPackageDeployment)i.next();
            BeanDescriptor bd = pkg.getPackage().getBeanByLocation(location);
            if (bd == null) continue;
            return pkg.getHomeInstance(this, bd.getName(), local);
        }
        if (local && this.parent != null) {
            return this.parent.getHomeInstance(location, local);
        }
        throw new InvalidEJBAssemblyException("No bean with location '" + location + "' found in application '" + this.application.getName() + "'", "20.3.2");
    }

    public AbstractEJBHome getHomeInstance(String module, String name, boolean local) throws InstantiationException {
        Iterator i = this.installedPackages.iterator();
        while (i.hasNext()) {
            BeanDescriptor bd;
            EJBPackageDeployment pkg = (EJBPackageDeployment)i.next();
            String moduleName = pkg.getPackage().getName();
            String jarName = pkg.getPackage().getDeployment().getModule().getPath();
            if (module != null && !jarName.equals(module) && !moduleName.equals(module) || (bd = pkg.getPackage().getBeanX(name)) == null) continue;
            return pkg.getHomeInstance(this, bd.getName(), local);
        }
        if (local && this.parent != null) {
            return this.parent.getHomeInstance(module, name, local);
        }
        if (module != null) {
            throw new InvalidEJBAssemblyException("No bean named at '" + name + "' found in ejb-jar '" + module + "'", "20.3.2");
        }
        throw new InvalidEJBAssemblyException("No bean named at '" + name + "' found in application '" + this.application.getName() + "'", "20.3.2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreCache(EJBPackageDeployment deployment, SessionBeanDescriptor sessionDescriptor, AbstractEJBHome home) throws InstantiationException {
        block8: {
            if (sessionDescriptor.getPersistenceFilename() == null) {
                return;
            }
            ThreadState state = ThreadState.getCurrentState();
            URL dirURL = this.config.getPersistenceURL();
            if (dirURL == null) {
                return;
            }
            try {
                URL url = ConfigUtils.getURL(dirURL, sessionDescriptor.getPersistenceFilename() + ".ser");
                File file = new File(url.getFile());
                try {
                    FileInputStream fileIn = new FileInputStream(file);
                    this.restoreSessions((StatefulSessionEJBHome)home, fileIn, state, true);
                    Object var10_11 = null;
                    if (!file.exists()) break block8;
                    file.delete();
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (file.exists()) {
                        file.delete();
                        this.restorePassivatedSessions((StatefulSessionEJBHome)home, state);
                    }
                    throw throwable;
                }
                this.restorePassivatedSessions((StatefulSessionEJBHome)home, state);
                {
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                m_logger.log(Level.WARNING, "Error restoring instances for " + sessionDescriptor.getLocation() + ": " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreSessions(StatefulSessionEJBHome sessionHome, InputStream fileIn, ThreadState state, boolean setCurrentID) throws IOException {
        ContextContainer oldContext = state.contextContainer;
        try {
            long id;
            state.contextContainer = sessionHome;
            EJBInternalInputStream in = new EJBInternalInputStream(fileIn, sessionHome);
            if (setCurrentID) {
                sessionHome.setCurrentID(in.readLong());
            }
            while ((id = in.readLong()) != -1L) {
                String message;
                try {
                    long checksum = in.readLong();
                    in.readSession(sessionHome, id, checksum);
                }
                catch (OptionalDataException e) {
                    message = "Error deserializing EJB-session, corrupt stream (optional data, " + e.length + " bytes" + (e.getMessage() == null ? "" : ", '" + e.getMessage() + "'") + ") '" + sessionHome.OC4J_getBindingPath() + "'";
                    this.application.log(message, e);
                    m_logger.log(Level.WARNING, message + " in application '" + this.application.getName() + "': " + e);
                }
                catch (Throwable t) {
                    message = "Error deserializing EJB-session '" + sessionHome.OC4J_getBindingPath() + "'";
                    this.application.log(message, t);
                    m_logger.log(Level.WARNING, message + " in application '" + this.application.getName() + "': " + t);
                }
            }
            in.close();
            fileIn.close();
        }
        finally {
            state.contextContainer = oldContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restorePassivatedSessions(StatefulSessionEJBHome sessionHome, ThreadState state) {
        ContextContainer oldContext = state.contextContainer;
        try {
            state.contextContainer = sessionHome;
            File dirFile = sessionHome.getPassivationDirectory(false);
            if (dirFile == null) {
                return;
            }
            File[] sessionFiles = dirFile.listFiles();
            for (int i = 0; i < sessionFiles.length; ++i) {
                try {
                    FileInputStream fileIn = new FileInputStream(sessionFiles[i]);
                    EJBInternalInputStream in = new EJBInternalInputStream((InputStream)fileIn, sessionHome);
                    try {
                        long id = in.readLong();
                        long checksum = in.readLong();
                        in.readSession(sessionHome, id, checksum, true);
                        continue;
                    }
                    finally {
                        in.close();
                        fileIn.close();
                    }
                }
                catch (Throwable t) {
                    sessionFiles[i].delete();
                }
            }
        }
        catch (Throwable t) {
        }
        finally {
            state.contextContainer = oldContext;
        }
    }

    public static String getEJBModuleName(com.evermind.server.deployment.EJBModule module) {
        String moduleName = module.getShortName();
        moduleName = XMLUtils.encode(moduleName);
        return ObjectName.quote(moduleName);
    }

    protected void unbindHomes(boolean _log, boolean undeploy) {
        try {
            this.cleanupPersistenceManager(this.installedPackages);
            Iterator iterator = this.installedPackages.iterator();
            while (iterator.hasNext()) {
                com.evermind.server.deployment.EJBModule module;
                EJBPackageDeployment ejbDeployment = (EJBPackageDeployment)iterator.next();
                if (_log && !this._ejbModules.contains(module = ejbDeployment.getModule())) {
                    this.application.logAndPrint("Uninstalling " + module.getPath() + " from application " + this.application.getName() + "...");
                }
                ejbDeployment.destroy(undeploy);
                String moduleName = EJBContainer.getEJBModuleName(ejbDeployment.getModule());
                this.removeEJBModuleMBean(moduleName);
                iterator.remove();
            }
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Error unbind home", e);
        }
    }

    private void cleanupPersistenceManager(List packages) throws InstantiationException {
        Iterator i = packages.iterator();
        while (i.hasNext()) {
            EJBPackageDeployment deployment = (EJBPackageDeployment)i.next();
            deployment.destroyPersistenceUnitManager();
            EJBPackage module = deployment.getPackage();
            if (module == null || module.getPPMs().size() <= 0) continue;
            deployment.notifyPMs(0, null);
        }
    }

    private void processTimers(int operation) {
        try {
            Iterator iterator = this.installedPackages.iterator();
            while (iterator.hasNext()) {
                EJBPackageDeployment ejbDeployment = (EJBPackageDeployment)iterator.next();
                ejbDeployment.processTimers(this, operation);
            }
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Error process Timer", e);
        }
    }

    public void invokeTimer(String module, String bean, Timer timer) throws Exception {
        EJBPackageDeployment epd = this.getEJBPackageByName(module);
        if (epd == null) {
            if (module.endsWith(".jar")) {
                throw EJBUtils.createEJBException("Invalid EJB module: " + module);
            }
            epd = this.getEJBPackageByName(module = module + ".jar");
            if (epd == null) {
                throw EJBUtils.createEJBException("Invalid EJB module: " + module);
            }
        }
        timer.getTimerEntry().setReadObjectClassLoader((ClassLoader)this.getBeansClassLoader());
        if (timer.getBeanType() == 3) {
            MessageDrivenHome home = epd.getMessageDrivenHome(bean);
            if (home == null) {
                throw EJBUtils.createEJBException("Invalid bean: " + bean);
            }
            home.invokeTimer(new EJBTimerImpl(timer));
        } else {
            BeanDescriptor bd = epd.getPackage().getBeanX(bean);
            if (bd == null) {
                throw EJBUtils.createEJBException("Invalid bean: " + bean);
            }
            AbstractEJBHome home = epd.getHomeInstance(this, bd.getName(), timer.isLocal());
            if (timer.getBeanType() == 2) {
                ((StatelessSessionEJBHome)home).invokeTimer(new EJBTimerImpl(timer));
            } else {
                ((EntityEJBHome)home).invokeTimer(new EJBTimerImpl(timer), timer.getTimerEntry().getPK());
            }
        }
    }

    protected synchronized void addEJBPackage(EJBPackageDeployment deployment) {
        this.installedPackages.add(deployment);
    }

    protected void initializeSessions(Notifier notifier) {
        if (notifier != null) {
            notifier.sendNotification("INITIALIZING_EJB_SESSIONS");
        }
        try {
            this.replicationService.restoreSessions();
        }
        catch (JMSException e) {
            if (notifier != null) {
                notifier.sendWarningNotification(e);
            }
            m_logger.log(Level.FINE, "JMSException in ClusterEJBService#restoreSessions()", e);
        }
    }

    public void updateEJBModule(String ejbModulePath, byte[] newJarData) throws InstantiationException {
        EJBPackageDeployment pkgDeployment = this.getEJBPackage(ejbModulePath);
        if (pkgDeployment == null) {
            throw new InstantiationException("Cannot find deployed ejb module " + ejbModulePath + ". The fully qualified ejb module must be defined in the application's deployment descriptor file (e.g. application.xml). " + "Use -file mode to specify the ejb jar file local path");
        }
        String ejbModuleName = ejbModulePath;
        if (ejbModulePath.endsWith(".jar")) {
            ejbModuleName = ejbModulePath.substring(0, ejbModulePath.lastIndexOf("."));
        }
        this.incrementalDeploymentHandler = new IncrementalDeploymentHandler(ejbModuleName);
        try {
            this.incrementalDeploymentHandler.updateEJBModule(newJarData, pkgDeployment);
        }
        catch (InstantiationException instantiationEx) {
            this.incrementalDeploymentHandler = null;
            throw instantiationEx;
        }
    }

    protected void setAppRootLoader(PolicyClassLoader appRootLoader) {
        this.appRootLoader = appRootLoader;
    }

    public void undeployCleanup(String root) throws DeployerException {
        try {
            Iterator iterator = this.application.getConfig().getEJBPackages().iterator();
            while (iterator.hasNext()) {
                com.evermind.server.deployment.EJBModule module = (com.evermind.server.deployment.EJBModule)iterator.next();
                String path = module.getPath();
                File file = new File(root, path);
                ContextUtils.purgeCache(file);
            }
        }
        catch (Exception e) {
            throw new DeployerException("Unable to clean ejb context cache: " + e.getMessage());
        }
        this.undeployPending = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object lookupInEJBModuleContext(String name) throws NamingException {
        EJBPackageDeployment deployment = null;
        if (name.equals("EntityManager")) {
            ContextContainer container = ThreadState.getCurrentState().getContextContainer();
            if (container instanceof AbstractEJBHome) {
                deployment = ((AbstractEJBHome)container).getEJBPackage();
            } else {
                if (!(container instanceof MessageDrivenHome)) throw new NamingException("java:comp/ejb/EntityManager may only be accessed within an EJB context");
                deployment = ((MessageDrivenHome)container).getEJBPackage().getDeployment();
            }
        } else {
            int pos = name.indexOf(47);
            if (pos != -1) {
                String moduleName = name.substring(0, pos);
                String type = name.substring(pos + 1);
                if (!type.equals("EntityManager")) {
                    return null;
                }
                Iterator i = this.installedPackages.iterator();
                while (i.hasNext()) {
                    EJBPackageDeployment d = (EJBPackageDeployment)i.next();
                    if (!d.getModule().getShortName().equals(moduleName)) continue;
                    deployment = d;
                    break;
                }
            }
        }
        if (deployment == null) return null;
        if (deployment.getPackage().getCompatibility() >= 3 && deployment.getEntityManagerDeployer() != null && deployment.getEntityManagerDeployer().getEntityManagerFactory() != null) return deployment.getEntityManagerDeployer().getEntityManagerFactory().getEntityManager();
        throw new NameNotFoundException("Default application EntityManager is not available; no deployed entities");
    }

    public IncrementalDeploymentHandler getIncrementalDeploymentHandler() {
        return this.incrementalDeploymentHandler;
    }

    public void setIncrementalDeploymentHandler(IncrementalDeploymentHandler incrementalDeploymentHandler) {
        this.incrementalDeploymentHandler = incrementalDeploymentHandler;
    }

    public PolicyClassLoader getTempMetadataParsingLoader() {
        return this.tempMetadataParsingLoader;
    }
}

