/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ejb.MarkerInterfaceEnhancer;
import com.oracle.server.ejb.entitymanager.ClassTransformer;
import java.io.Serializable;
import java.rmi.Remote;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import oracle.classloader.util.ClassPreprocessor;

public class EJBClassTransformer
implements ClassPreprocessor {
    Set remoteInterfaces;
    Set serializableClasses;
    Set entityBeans;
    ClassTransformer entityTransformer;

    public void addRemoteInterfaceNames(Collection names) {
        if (this.remoteInterfaces == null) {
            this.remoteInterfaces = new HashSet();
        }
        this.remoteInterfaces.addAll(names);
    }

    public void addSerializableClassName(String name) {
        if (this.serializableClasses == null) {
            this.serializableClasses = new HashSet();
        }
        this.serializableClasses.add(name);
    }

    public void addSerializableClassNames(Collection names) {
        if (this.serializableClasses == null) {
            this.serializableClasses = new HashSet();
        }
        this.serializableClasses.addAll(names);
    }

    public void addEntityBeanName(String name) {
        if (this.entityBeans == null) {
            this.entityBeans = new HashSet();
        }
        this.entityBeans.add(name);
    }

    public void setEntityTransformer(ClassTransformer entityTransformer) {
        this.entityTransformer = entityTransformer;
    }

    public ClassPreprocessor initialize(ClassLoader loader) {
        return this;
    }

    public byte[] processClass(String className, byte[] classBytes, int offset, int length, ProtectionDomain pd, ClassLoader loader) {
        byte[] result = null;
        if (this.remoteInterfaces != null && this.remoteInterfaces.contains(className)) {
            result = MarkerInterfaceEnhancer.transformClass(className, classBytes, Remote.class);
            this.remoteInterfaces.remove(className);
            if (this.remoteInterfaces.size() == 0) {
                this.remoteInterfaces = null;
            }
        } else if (this.serializableClasses != null && this.serializableClasses.contains(className)) {
            result = MarkerInterfaceEnhancer.transformClass(className, classBytes, Serializable.class);
            this.serializableClasses.remove(className);
            if (this.serializableClasses.size() == 0) {
                this.serializableClasses = null;
            }
        } else if (this.entityBeans != null && this.entityBeans.contains(className)) {
            result = this.entityTransformer.transform(className, classBytes);
            this.entityBeans.remove(className);
            if (this.entityBeans.size() == 0) {
                this.entityBeans = null;
                this.entityTransformer = null;
            }
        }
        if (result != null) {
            return result;
        }
        return classBytes;
    }
}

