/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.DataSourceConnection;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.database.DatabaseSchema;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.util.LogEvent;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.oc4j.rmi.OracleRemoteException;
import oracle.oc4j.sql.CommonDataSource;
import oracle.oc4j.sql.ManagedDataSource;

public class DataSourceConnectionContainer {
    private static Logger m_logger = EJBTraceLogger.getLogger(DataSourceConnectionContainer.class);
    private String name;
    public DataSource source;
    private com.evermind.util.Logger logger;
    protected ApplicationServer server;
    private DatabaseSchema schema;
    private int isolationLevel;
    private boolean isolationSet = false;

    public DataSourceConnectionContainer(ApplicationServer server, String name, int isolationLevel, DataSource source, com.evermind.util.Logger logger) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnectionContainer. Constructor(): begin");
        }
        this.name = name;
        this.server = server;
        this.isolationLevel = isolationLevel;
        this.source = source;
        this.logger = logger;
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnectionContainer." + "Constructor(): end--this.name = " + this.name);
            m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnectionContainer." + "Constructor(): end--this.isolationLevel = " + this.isolationLevel);
            m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnectionContainer." + "Constructor(): end--this.source = " + this.source);
            m_logger.log(Level.FINEST, "Thr[" + ThreadState.getCurrentState().toString() + "]-DataSourceConnectionContainer." + "Constructor(): end");
        }
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public boolean isOracleDatabase() {
        if (this.source instanceof CommonDataSource) {
            return ((CommonDataSource)this.source).isOracle();
        }
        return this.source instanceof OracleDataSource;
    }

    public boolean isDB2Database() {
        String dbUrl = null;
        if (this.source instanceof ManagedDataSource) {
            dbUrl = ((ManagedDataSource)this.source).getUrl();
        }
        if (dbUrl != null) {
            return dbUrl.indexOf("jdbc:db2:") >= 0;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public DataSourceConnection getConnection() throws RemoteException {
        try {
            return this.getLocalConnection();
        }
        catch (EJBException e) {
            OracleRemoteException oe = new OracleRemoteException(e.getMessage(), e.getCausedByException());
            throw oe;
        }
    }

    public DataSourceConnection getLocalConnection() {
        m_logger.entering("DataSourceConnectionContainer", "getLocalConnection()");
        try {
            DataSourceConnection dataSourceConnection = new DataSourceConnection(this, null);
            return dataSourceConnection;
        }
        catch (SQLException e) {
            if (this.logger != null) {
                this.logger.log(new LogEvent("SQL Error opening DataSource: ", e));
            }
            EJBException re = EJBUtils.createEJBException("SQL Error opening DataSource: " + e.getMessage(), e);
            throw re;
        }
        finally {
            m_logger.exiting("DataSourceConnectionContainer", "getLocalConnection()");
        }
    }

    public String toString() {
        return this.name;
    }

    public void setDatabaseSchema(DatabaseSchema schema) {
        this.schema = schema;
    }

    public DatabaseSchema getDatabaseSchema() {
        return this.schema;
    }

    public void setIsolationSet(boolean isolationSet) {
        this.isolationSet = isolationSet;
    }

    public boolean getIsolationSet() {
        return this.isolationSet;
    }

    public synchronized void removeUnusedCache(boolean all) {
    }
}

