/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBContext;
import com.evermind.server.ejb.BeanPoolConfig;
import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.TimeoutExpiredException;
import com.evermind.server.ejb.logging.EJBPoolingMessages;
import com.evermind.server.ejb.logging.EJBRuntimeMessages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.transaction.Transaction;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Refresh;
import oracle.dms.instrument.StateIntf;

public abstract class BeanPool
implements GroupRefresh {
    private static int DEFAULT_QUEUE_SIZE = 20;
    private static int DEFAULT_QUEUE_INCREMENT = 10;
    private static boolean suspendCurrentTx = Boolean.valueOf(System.getProperty("oc4j.ejb.pooling.suspend.tx", "true"));
    protected int min;
    protected int max;
    protected int waitingForInstance = 0;
    protected long maxWaitMilliSecond = 0L;
    protected long poolTimeout;
    private long lastPoolExpiration;
    private AbstractEJBContext[] pool;
    private int startIdx = 0;
    private int endIdx = 0;
    private int pooledCount = 0;
    private int pooledCountHighWaterMark = 0;
    private int activeCount = 0;
    private int activeCountHighWaterMark = 0;
    protected StateIntf pooledCountStatistic;
    protected StateIntf activeCountStatistic;
    private BeanPoolConfig config;

    public BeanPool(BeanPoolConfig config) {
        this.config = config;
        this.initDMSSensors();
        this.min = config.getMinInstances();
        this.max = config.getMaxInstances();
        this.maxWaitMilliSecond = config.getCallTimeout();
        this.poolTimeout = config.getCacheTimeout() * 1000;
        this.lastPoolExpiration = System.currentTimeMillis();
        if (this.max > 0 && this.max < this.min) {
            this.min = this.max;
        }
        if (this.min < 0) {
            this.min = 0;
        }
        int poolSize = DEFAULT_QUEUE_SIZE;
        if (this.max > 0) {
            poolSize = this.max;
        } else if (this.min > 0) {
            poolSize = this.min + DEFAULT_QUEUE_INCREMENT;
        }
        this.pool = new AbstractEJBContext[poolSize];
    }

    public void initialize() {
        EJBPoolingMessages.fineInitializingBeanPooling(this.getConfig());
        this.onMinInstanceUpdate();
    }

    public void shutdown() {
        EJBPoolingMessages.fineShutdownBeanPool(this.getConfig());
        this.max = -1;
        this.onMaxInstanceUpdate();
        this.config = null;
    }

    protected void enqueue(AbstractEJBContext context) {
        this.pool[this.endIdx] = context;
        if (++this.endIdx >= this.pool.length) {
            this.endIdx = 0;
        }
        ++this.pooledCount;
        if (this.pooledCount > this.pooledCountHighWaterMark) {
            this.pooledCountHighWaterMark = this.pooledCount;
        }
        context.poolTime = this.poolTimeout > 1L ? System.currentTimeMillis() : 1L;
        if (this.max == 0 && this.startIdx == this.endIdx) {
            this.resize(this.pool.length + DEFAULT_QUEUE_INCREMENT);
        }
    }

    protected void resize(int size) {
        AbstractEJBContext[] temp = new AbstractEJBContext[size];
        System.arraycopy(this.pool, this.startIdx, temp, 0, this.pool.length - this.startIdx);
        if (this.startIdx > 0) {
            System.arraycopy(this.pool, 0, temp, this.pool.length - this.startIdx, this.startIdx);
        }
        this.startIdx = 0;
        this.endIdx = this.pool.length;
        this.pool = temp;
    }

    protected AbstractEJBContext dequeue() {
        AbstractEJBContext context = this.pool[this.startIdx];
        this.pool[this.startIdx] = null;
        if (++this.startIdx >= this.pool.length) {
            this.startIdx = 0;
        }
        --this.pooledCount;
        context.poolTime = 0L;
        return context;
    }

    protected AbstractEJBContext peek() {
        return this.pool[this.startIdx];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public AbstractEJBContext allocateContext() {
        block21: {
            block20: {
                context = null;
                newCallTimeout = this.maxWaitMilliSecond;
                if (this.max >= 0) break block20;
                ++this.activeCount;
                break block21;
            }
            var4_3 = this;
            synchronized (var4_3) {
                while (true) lbl-1000:
                // 3 sources

                {
                    if (this.pooledCount > 0) {
                        ++this.activeCount;
                        context = this.dequeue();
                        break;
                    }
                    if (this.max == 0 || this.activeCount < this.max) {
                        ++this.activeCount;
                        break;
                    }
                    startTime = System.currentTimeMillis();
                    try {
                        block19: {
                            ++this.waitingForInstance;
                            if (newCallTimeout < 0L) break block19;
                            this.wait(newCallTimeout);
                        }
                        var9_8 = null;
                        --this.waitingForInstance;
                    }
                    catch (Throwable var8_9) {
                        var9_8 = null;
                        --this.waitingForInstance;
                        if ((newCallTimeout -= System.currentTimeMillis() - startTime) <= 0L) {
                            EJBPoolingMessages.warningTimeoutReached(this.getConfig());
                            throw new TimeoutExpiredException("timeout expired waiting for an instance");
                        }
                        throw var8_9;
                    }
                    if ((newCallTimeout -= System.currentTimeMillis() - startTime) > 0L) ** GOTO lbl-1000
                    EJBPoolingMessages.warningTimeoutReached(this.getConfig());
                    throw new TimeoutExpiredException("timeout expired waiting for an instance");
                    {
                        catch (InterruptedException e) {
                            var9_8 = null;
                            --this.waitingForInstance;
                            if ((newCallTimeout -= System.currentTimeMillis() - startTime) > 0L) continue;
                            EJBPoolingMessages.warningTimeoutReached(this.getConfig());
                            throw new TimeoutExpiredException("timeout expired waiting for an instance");
                        }
                    }
                    break;
                }
                if (this.activeCount > this.activeCountHighWaterMark) {
                    this.activeCountHighWaterMark = this.activeCount;
                }
            }
        }
        try {
            if (context == null) {
                context = this.createContext();
            }
            this.beforePassToClient(context);
        }
        catch (RuntimeException e) {
            var5_6 = this;
            synchronized (var5_6) {
                --this.activeCount;
            }
            throw e;
        }
        if (EJBPoolingMessages.m_logger.isLoggable(Level.FINEST)) {
            EJBPoolingMessages.finestAllocateInstance(this.getConfig(), context);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseContext(AbstractEJBContext context, boolean toBeDiscarded) {
        if (EJBPoolingMessages.m_logger.isLoggable(Level.FINEST)) {
            EJBPoolingMessages.finestReleaseInstance(this.getConfig(), context);
        }
        boolean addedToPool = false;
        if (this.max < 0) {
            --this.activeCount;
        } else {
            BeanPool beanPool = this;
            synchronized (beanPool) {
                if (context.poolTime != 0L) {
                    return;
                }
                --this.activeCount;
                if (!(toBeDiscarded || this.max > 0 && this.pooledCount + this.activeCount >= this.max)) {
                    this.enqueue(context);
                    addedToPool = true;
                    if (this.waitingForInstance > 0) {
                        this.notify();
                    }
                }
            }
        }
        if (!addedToPool) {
            this.destroyContext(context, toBeDiscarded);
            if (this.activeCount + this.pooledCount < this.min) {
                this.onMinInstanceUpdate();
            }
        }
    }

    private synchronized void onMinInstanceUpdate() {
        int total;
        if (this.max < 0) {
            this.reduceBeanInstances(this.pooledCount);
            return;
        }
        for (int i = total = this.activeCount + this.pooledCount; i < this.min; ++i) {
            this.enqueue(this.createContext());
        }
    }

    private synchronized void onMaxInstanceUpdate() {
        if (this.max == 0) {
            return;
        }
        if (this.max < 0) {
            this.reduceBeanInstances(this.pooledCount);
        } else {
            int total = this.activeCount + this.pooledCount;
            if (total > this.max) {
                int delta = total - this.max;
                this.reduceBeanInstances(delta > this.pooledCount ? this.pooledCount : delta);
            }
            if (this.max > this.pool.length) {
                this.resize(this.max);
            }
        }
    }

    private void reduceBeanInstances(int reduced) {
        for (int i = 0; i < reduced; ++i) {
            this.destroyContext(this.dequeue(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expirePool() {
        long currentTime = System.currentTimeMillis();
        if (this.poolTimeout <= 0L || currentTime - this.lastPoolExpiration < this.poolTimeout) {
            return;
        }
        EJBPoolingMessages.fineExpiringBeanPoolInstances(this.getConfig());
        ArrayList<AbstractEJBContext> expired = new ArrayList<AbstractEJBContext>();
        BeanPool beanPool = this;
        synchronized (beanPool) {
            long poolTime;
            while (this.pooledCount > this.min && currentTime - (poolTime = this.peek().poolTime) > this.poolTimeout) {
                expired.add(this.dequeue());
            }
        }
        Iterator i = expired.iterator();
        while (i.hasNext()) {
            this.destroyContext((AbstractEJBContext)i.next(), false);
        }
        this.lastPoolExpiration = currentTime;
    }

    protected long getLastPoolExpiration() {
        return this.lastPoolExpiration;
    }

    protected void setLastPoolExpiration(long time) {
        this.lastPoolExpiration = time;
    }

    protected AbstractEJBContext createContext() {
        if (EJBPoolingMessages.m_logger.isLoggable(Level.FINER)) {
            EJBPoolingMessages.finerCreateInstance(this.getConfig());
        }
        ThreadState threadState = ThreadState.getCurrentState();
        ContextContainer previousContainer = threadState.contextContainer;
        threadState.contextContainer = this.getContextContainer();
        Transaction tx = this.suspend();
        try {
            AbstractEJBContext abstractEJBContext = this.createContextImpl();
            return abstractEJBContext;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw EJBUtils.createEJBException("[" + this.getConfig().getContextId() + "] - Exception while creating bean/context instance", e);
        }
        finally {
            threadState.contextContainer = previousContainer;
            this.resume(tx);
        }
    }

    protected abstract AbstractEJBContext createContextImpl() throws Exception;

    protected abstract ContextContainer getContextContainer();

    protected void destroyContext(AbstractEJBContext context, boolean toBeDiscarded) {
        if (EJBPoolingMessages.m_logger.isLoggable(Level.FINER)) {
            EJBPoolingMessages.finerDestroyInstance(this.getConfig(), context, toBeDiscarded);
        }
        if (toBeDiscarded) {
            return;
        }
        ThreadState threadState = ThreadState.getCurrentState();
        ContextContainer previousContainer = threadState.contextContainer;
        threadState.contextContainer = this.getContextContainer();
        Transaction tx = this.suspend();
        try {
            this.destroyContextImpl(context, toBeDiscarded);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw EJBUtils.createEJBException("[" + this.getConfig().getContextId() + "] - Exception while removing/destroying bean/context instance", e);
        }
        finally {
            context.resetFields();
            threadState.contextContainer = previousContainer;
            this.resume(tx);
        }
    }

    protected abstract void destroyContextImpl(AbstractEJBContext var1, boolean var2) throws Exception;

    protected void beforePassToClient(AbstractEJBContext context) {
    }

    public void setMaxInstance(int _newMax) {
        if (_newMax > 0 && _newMax < this.min) {
            throw new IllegalArgumentException("new max is less than min");
        }
        if (this.max != _newMax) {
            this.max = _newMax;
            EJBPoolingMessages.fineMaxInstancesUpdated(this.getConfig(), _newMax);
            this.onMaxInstanceUpdate();
        }
    }

    public int getMaxInstance() {
        return this.max;
    }

    public void setMinInstance(int _newMin) {
        if (this.max >= 0 && this.max != 0 && _newMin > this.max) {
            throw new IllegalArgumentException("new min is greater than max");
        }
        if (this.min != _newMin) {
            this.min = _newMin;
            EJBPoolingMessages.fineMinInstancesUpdated(this.getConfig(), _newMin);
            this.onMinInstanceUpdate();
        }
    }

    public int getMinInstance() {
        return this.min;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public int getPooledCount() {
        return this.pooledCount;
    }

    public int getActiveCountHighWaterMark() {
        return this.activeCountHighWaterMark;
    }

    public int getPooledCountHighWaterMark() {
        return this.pooledCountHighWaterMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void waitForPool() {
        long startTime = System.currentTimeMillis();
        long waitTime = this.maxWaitMilliSecond;
        if (waitTime >= 0L) {
            while (this.activeCount > 0) {
                ++this.waitingForInstance;
                try {
                    this.wait(waitTime);
                }
                catch (InterruptedException e) {
                    break;
                }
                finally {
                    --this.waitingForInstance;
                }
                if ((waitTime -= System.currentTimeMillis() - startTime) > 0L) continue;
            }
        }
        if (this.activeCount > 0) {
            EJBRuntimeMessages.warningTimeoutWaitingForActiveCalls(this.getConfig().getContextId(), this.activeCount);
        }
    }

    protected BeanPoolConfig getConfig() {
        return this.config;
    }

    protected Transaction suspend() {
        if (suspendCurrentTx) {
            return EJBTransactionManager.getInstance().suspendLocal();
        }
        return null;
    }

    protected void resume(Transaction tx) {
        if (tx != null) {
            EJBTransactionManager.getInstance().resumeLocal(tx);
        }
    }

    protected void initDMSSensors() {
        this.activeCountStatistic = this.getConfig().getReadyCountState();
        this.pooledCountStatistic = this.getConfig().getPooledCountState();
        if (this.activeCountStatistic != null) {
            this.activeCountStatistic.setRefresh((Refresh)this);
        }
        if (this.pooledCountStatistic != null) {
            this.pooledCountStatistic.setRefresh((Refresh)this);
        }
    }

    public void refresh() {
        this.pooledCountStatistic.update(this.pooledCountHighWaterMark);
        this.pooledCountStatistic.update(this.pooledCount);
        this.activeCountStatistic.update(this.activeCountHighWaterMark);
        this.activeCountStatistic.update(this.activeCount);
    }
}

