/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ejb.AnnotationListener;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.logging.EJBAnnotationMessages;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BeanAnnotationListener
implements AnnotationListener {
    private static final String ANNOTATION_PARSER_CLASS = "com.evermind.server.ejb.deployment.BeanDescriptorAnnotationParser";
    private static final String PARSE_ANNOTATIONS_METHOD = "parseAnnotations";
    private static Method parseAnnotationsMethod;
    private EJBPackage ejbPackage;

    public BeanAnnotationListener(EJBPackage ejbPackage) {
        this.ejbPackage = ejbPackage;
    }

    public void parseAnnotatedClass(Class annotatedClass, ClassLoader loader, Object annotationManager) {
        if (parseAnnotationsMethod == null) {
            return;
        }
        try {
            parseAnnotationsMethod.invoke(null, this.ejbPackage, annotatedClass, annotationManager);
        }
        catch (IllegalArgumentException e) {
            throw EJBUtils.createEJBException(e);
        }
        catch (IllegalAccessException e) {
            throw EJBUtils.createEJBException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw EJBUtils.createEJBException((Exception)e.getCause());
            }
            throw EJBUtils.createEJBException(e);
        }
    }

    static {
        try {
            Class<?> annotationParserClass = Class.forName(ANNOTATION_PARSER_CLASS);
            parseAnnotationsMethod = annotationParserClass.getMethod(PARSE_ANNOTATIONS_METHOD, EJBPackage.class, Class.class, Object.class);
        }
        catch (Exception e) {
            EJBAnnotationMessages.warningEJB3WithoutJDK15();
        }
    }
}

