/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityIdentity
implements XMLizable {
    private String description;
    private String specifiedIdentity;
    private String specifiedIdentityDescription;
    private boolean useCallerIdentity = true;

    public SecurityIdentity() {
    }

    public SecurityIdentity(String specifiedIdentity) {
        this.specifiedIdentity = specifiedIdentity;
        this.useCallerIdentity = false;
    }

    public SecurityIdentity(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                String value = XMLUtils.getStringValue(node);
                if (name.equals("use-caller-identity")) {
                    this.useCallerIdentity = true;
                    continue;
                }
                if (name.equals("run-as")) {
                    this.parseRunAsSpecifiedIdentity(node);
                    continue;
                }
                if (!name.equals("description")) continue;
                this.description = value;
            }
        }
    }

    public void parseRunAsSpecifiedIdentity(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String value = XMLUtils.getStringValue(node);
                String name = node.getNodeName();
                if (name.startsWith("#")) continue;
                if (name.equals("role-name")) {
                    this.specifiedIdentity = value;
                    continue;
                }
                if (name.equals("description")) {
                    this.specifiedIdentityDescription = value;
                    continue;
                }
                throw new InstantiationException("Unknown run-as subtag: " + name);
            }
        }
        if (this.specifiedIdentity == null) {
            throw new InstantiationException("run-as with missing role-name subtag");
        }
        this.useCallerIdentity = false;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getUseCallerIdentity() {
        return this.useCallerIdentity;
    }

    public String getSpecifiedIdentity() {
        return this.specifiedIdentity;
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<security-identity>");
        if (this.description != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.description) + "</description>");
        }
        if (this.specifiedIdentity == null) {
            out.println(indention + "\t<use-caller-identity />");
        } else {
            out.println(indention + "\t<run-as>");
            if (this.specifiedIdentityDescription != null) {
                out.println(indention + "\t\t<description>" + XMLUtils.encode(this.specifiedIdentityDescription) + "</description>");
            }
            out.println(indention + "\t\t<role-name>" + XMLUtils.encode(this.specifiedIdentity) + "</role-name>");
            out.println(indention + "\t</run-as>");
        }
        out.println(indention + "</security-identity>");
    }
}

