/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.deployment.ClassUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationManager {
    Map<String, List<Field>> fields = new HashMap<String, List<Field>>();
    Map<String, List<Method>> methods = new HashMap<String, List<Method>>();
    Map<String, List<Field>> staticFields = new HashMap<String, List<Field>>();
    Map<String, List<Method>> staticMethods = new HashMap<String, List<Method>>();
    private final String OBJECT_CLASS_NAME = Object.class.getName();

    public List<Field> getFields(Class baseClass) {
        this.parse(baseClass);
        return this.fields.get(baseClass.getName());
    }

    public List<Method> getMethods(Class baseClass) {
        this.parse(baseClass);
        return this.methods.get(baseClass.getName());
    }

    public List<Field> getStaticFields(Class baseClass) {
        this.parse(baseClass);
        return this.staticFields.get(baseClass.getName());
    }

    public List<Method> getStaticMethods(Class baseClass) {
        this.parse(baseClass);
        return this.staticMethods.get(baseClass.getName());
    }

    protected void parse(Class baseClass) {
        if (this.isParsed(baseClass)) {
            return;
        }
        this.initialize(baseClass);
        List<Field> fieldList = this.fields.get(baseClass.getName());
        List<Method> methodList = this.methods.get(baseClass.getName());
        List<Field> staticFieldList = this.staticFields.get(baseClass.getName());
        List<Method> staticMethodList = this.staticMethods.get(baseClass.getName());
        for (Class tempClass = baseClass; tempClass != null && !tempClass.getName().equals(this.OBJECT_CLASS_NAME); tempClass = tempClass.getSuperclass()) {
            for (Field field : tempClass.getDeclaredFields()) {
                if (field.getAnnotations().length <= 0) continue;
                if (Modifier.isStatic(field.getModifiers())) {
                    staticFieldList.add(field);
                    continue;
                }
                fieldList.add(field);
            }
            for (AccessibleObject accessibleObject : tempClass.getDeclaredMethods()) {
                if (accessibleObject.getAnnotations().length <= 0) continue;
                if (Modifier.isStatic(((Method)accessibleObject).getModifiers())) {
                    staticMethodList.add(0, (Method)accessibleObject);
                    continue;
                }
                if (Modifier.isPrivate(((Method)accessibleObject).getModifiers())) {
                    methodList.add(0, (Method)accessibleObject);
                    continue;
                }
                if (ClassUtils.isMethodOverridden(baseClass, (Method)accessibleObject)) continue;
                methodList.add(0, (Method)accessibleObject);
            }
        }
    }

    protected void initialize(Class cls) {
        this.fields.put(cls.getName(), new ArrayList());
        this.methods.put(cls.getName(), new ArrayList());
        this.staticFields.put(cls.getName(), new ArrayList());
        this.staticMethods.put(cls.getName(), new ArrayList());
    }

    protected boolean isParsed(Class cls) {
        return this.fields.get(cls.getName()) != null || this.methods.get(cls.getName()) != null || this.staticFields.get(cls.getName()) != null || this.staticMethods.get(cls.getName()) != null;
    }
}

