/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.server.connector.deployment.PrincipalHolder;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.j2ee.connector.InitiatingPrincipal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PrincipalMappingEntries
extends AbstractDescribable
implements XMLizable {
    private Map m_principalMappings;
    private PrincipalHolder m_defaultEntry;
    public static final String CONFIG_PROPERTY_NAME = "xmlconfig";

    public PrincipalMappingEntries(String xmlString) throws InstantiationException {
        InputSource source = new InputSource(new StringReader(xmlString));
        source.setSystemId(".");
        try {
            Document document = XMLUtils.getDocument(source, null, null, false);
            Element element = document.getDocumentElement();
            this.parseNode(element);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PrincipalMappingEntries(Node parent) throws InstantiationException {
        if (parent == null) {
            return;
        }
        this.parseNode(parent);
    }

    protected void parseNode(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                if (nodeName.equals("description")) {
                    this.setDescription(XMLUtils.getStringValue(node));
                    continue;
                }
                if (nodeName.equals("default-mapping")) {
                    this.parseDefaultMapping(node);
                    continue;
                }
                if (nodeName.equals("principal-mapping-entry")) {
                    this.parsePrincipalMappingEntry(node);
                    continue;
                }
                throw new InstantiationException("Unknown 'principal-mapping-entries' subtag: " + nodeName);
            }
        }
    }

    protected void parseDefaultMapping(Node parent) throws InstantiationException {
        if (parent == null) {
            return;
        }
        NodeList nodes = parent.getChildNodes();
        String defaultUser = null;
        String defaultPassword = null;
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("description")) {
                    this.setDescription(value);
                    continue;
                }
                if (nodeName.equals("res-user")) {
                    defaultUser = value;
                    continue;
                }
                if (nodeName.equals("res-password")) {
                    defaultPassword = value;
                    continue;
                }
                throw new InstantiationException("Unknown 'default-mapping' subtag: " + nodeName);
            }
        }
        if (defaultUser != null || defaultPassword != null) {
            this.m_defaultEntry = new PrincipalHolder(defaultUser, defaultPassword);
        }
    }

    protected void parsePrincipalMappingEntry(Node parent) throws InstantiationException {
        if (parent == null) {
            return;
        }
        NodeList nodes = parent.getChildNodes();
        String initiatingPrincipal = null;
        String user = null;
        String password = null;
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("description")) {
                    this.setDescription(XMLUtils.getStringValue(node));
                    continue;
                }
                if (nodeName.equals("initiating-user")) {
                    initiatingPrincipal = value;
                    continue;
                }
                if (nodeName.equals("res-user")) {
                    user = value;
                    continue;
                }
                if (nodeName.equals("res-password")) {
                    password = value;
                    continue;
                }
                throw new InstantiationException("Unknown 'principal-mapping-entry' subtag: " + nodeName);
            }
        }
        if (initiatingPrincipal == null) {
            throw new InstantiationException("value for <initiating-principal> cannot be null. Use <default-mapping> for defining default resource user and password");
        }
        if (this.m_principalMappings == null) {
            this.m_principalMappings = new HashMap();
        }
        this.m_principalMappings.put(initiatingPrincipal, new PrincipalHolder(user, password));
    }

    public PrincipalHolder getResourceEntry(String initiatingUser, Principal principal) {
        if (this.m_principalMappings == null) {
            return this.m_defaultEntry;
        }
        PrincipalHolder entry = null;
        if (initiatingUser == null) {
            initiatingUser = "";
        }
        if ((entry = (PrincipalHolder)this.m_principalMappings.get(initiatingUser)) == null && initiatingUser.indexOf("/") > 0) {
            InitiatingPrincipal ip;
            String realmName = initiatingUser.substring(0, initiatingUser.indexOf("/"));
            String userName = initiatingUser.substring(initiatingUser.indexOf("/") + 1);
            if (principal instanceof InitiatingPrincipal && realmName.equals((ip = (InitiatingPrincipal)principal).getRealm())) {
                entry = (PrincipalHolder)this.m_principalMappings.get(userName);
            }
        }
        if (entry == null) {
            return this.m_defaultEntry;
        }
        return entry;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(this.toString(indention));
    }

    private String toString(String indention) {
        StringBuffer sb = new StringBuffer(indention);
        sb.append("<principal-mapping-entries>\n");
        if (this.getDescription() != null) {
            sb.append(indention);
            sb.append("\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>\n");
        }
        if (this.m_defaultEntry != null) {
            sb.append(indention);
            sb.append("\t<default-mapping>\n");
            sb.append(indention);
            sb.append("\t\t<res-user>" + XMLUtils.encode(this.m_defaultEntry.getUser()) + "</res-user>\n");
            sb.append(indention);
            sb.append("\t\t<res-password>" + XMLUtils.encode(this.m_defaultEntry.getObfuscatedPassword()) + "</res-password>\n");
            sb.append(indention);
            sb.append("\t</default-mapping>\n");
        }
        if (this.m_principalMappings != null) {
            Iterator iter = this.m_principalMappings.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String initUser = (String)entry.getKey();
                PrincipalHolder resUserPW = (PrincipalHolder)entry.getValue();
                String resUser = null;
                String resPw = null;
                if (resUserPW != null) {
                    resUser = resUserPW.getUser();
                    resPw = resUserPW.getObfuscatedPassword();
                }
                sb.append(indention);
                sb.append("\t<principal-mapping-entry>\n");
                sb.append(indention);
                sb.append("\t\t<initiating-user>" + XMLUtils.encode(initUser) + "</initiating-user>\n");
                sb.append(indention);
                sb.append("\t\t<res-user>" + XMLUtils.encode(resUser) + "</res-user>\n");
                sb.append(indention);
                sb.append("\t\t<res-password>" + XMLUtils.encode(resPw) + "</res-password>\n");
                sb.append(indention);
                sb.append("\t</principal-mapping-entry>\n");
            }
        }
        sb.append(indention);
        sb.append("</principal-mapping-entries>");
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public String getDefaultResourceUser() {
        if (this.m_defaultEntry != null) {
            return this.m_defaultEntry.getUser();
        }
        return null;
    }

    public String getDefaultResourcePassword() {
        if (this.m_defaultEntry != null) {
            return this.m_defaultEntry.getObfuscatedPassword();
        }
        return null;
    }

    public void setDefaultMapping(String user, String passwd) {
        this.m_defaultEntry = new PrincipalHolder(user, passwd);
    }

    public Map getMappings() {
        return this.m_principalMappings;
    }

    public void setMappings(Map map) {
        this.m_principalMappings = map;
    }

    public void addPrincipalMapping(String initiatingUser, String resourceUser, String resourcePassword) throws Exception {
        if (this.m_principalMappings == null) {
            this.m_principalMappings = new HashMap();
        }
        if (this.m_principalMappings.get(initiatingUser) != null) {
            throw new Exception("Principal mapping already exists for " + initiatingUser);
        }
        this.m_principalMappings.put(initiatingUser, new PrincipalHolder(resourceUser, resourcePassword));
    }

    public void removePrincipalMapping(String initiatingUser) throws Exception {
        if (this.m_principalMappings.get(initiatingUser) == null) {
            throw new Exception("Principal mapping does exists for " + initiatingUser);
        }
        this.m_principalMappings.remove(initiatingUser);
    }
}

