/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.server.connector.deployment.AuthenticationMechanism;
import com.evermind.server.connector.deployment.ConnectionDefinition;
import com.evermind.server.connector.deployment.OutboundResourceAdapter;
import com.evermind.server.connector.deployment.ResourceAdapter;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OutboundResourceAdapter15
extends AbstractDescribable
implements XMLizable,
OutboundResourceAdapter {
    protected int m_transactionSupport = 0;
    protected boolean m_reauthenticationSupport;
    protected List m_authenticationMechanisms;
    protected Map m_connectionDefinitions;

    public OutboundResourceAdapter15(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("connection-definition")) {
                    this.addConnectionDefinition(new ConnectionDefinition(node));
                    continue;
                }
                if (nodeName.equals("transaction-support")) {
                    this.setTransactionSupport(value);
                    continue;
                }
                if (nodeName.equals("authentication-mechanism")) {
                    this.addAuthenticationMechanism(new AuthenticationMechanism(node));
                    continue;
                }
                if (nodeName.equals("reauthentication-support")) {
                    this.setReauthenticationSupported("true".equals(value));
                    continue;
                }
                throw new InstantiationException("Unknown outbound-resourceadapter subtag: " + nodeName);
            }
        }
        if (this.m_transactionSupport == 0) {
            throw new InstantiationException("Missing 'transaction-support' subtag in outbound-resourceadapter tag");
        }
        if (this.m_connectionDefinitions == null || this.m_connectionDefinitions.isEmpty()) {
            throw new InstantiationException("Missing 'connection-definition' subtag in outbound-resourceadapter tag");
        }
    }

    public void addConnectionDefinition(ConnectionDefinition definition) {
        if (this.m_connectionDefinitions == null) {
            this.m_connectionDefinitions = new HashMap();
        }
        this.m_connectionDefinitions.put(definition.getConnectionFactoryInterface(), definition);
    }

    public ConnectionDefinition getConnectionDefinition(String connectionFactoryInterface) {
        ConnectionDefinition connDef = null;
        if (this.m_connectionDefinitions == null) {
            return null;
        }
        if (connectionFactoryInterface == null && this.m_connectionDefinitions.size() == 1) {
            Collection values = this.m_connectionDefinitions.values();
            Iterator iter = values.iterator();
            connDef = (ConnectionDefinition)iter.next();
        } else {
            connDef = (ConnectionDefinition)this.m_connectionDefinitions.get(connectionFactoryInterface);
        }
        return connDef;
    }

    public Iterator getConnectionDefinitions() {
        if (this.m_connectionDefinitions == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.m_connectionDefinitions.values().iterator();
    }

    public void setTransactionSupport(String value) {
        if (value.equalsIgnoreCase("NoTransaction")) {
            this.m_transactionSupport = 1;
        } else if (value.equalsIgnoreCase("LocalTransaction")) {
            this.m_transactionSupport = 2;
        } else if (value.equalsIgnoreCase("XATransaction")) {
            this.m_transactionSupport = 3;
        }
    }

    public int getTransactionSupport() {
        return this.m_transactionSupport;
    }

    public void addAuthenticationMechanism(AuthenticationMechanism auth) {
        if (this.m_authenticationMechanisms == null) {
            this.m_authenticationMechanisms = new ArrayList();
        }
        this.m_authenticationMechanisms.add(auth);
    }

    public List getAuthenticationMechanisms() {
        if (this.m_authenticationMechanisms == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_authenticationMechanisms;
    }

    public void setReauthenticationSupported(boolean support) {
        this.m_reauthenticationSupport = support;
    }

    public boolean isReauthenticationSupported() {
        return this.m_reauthenticationSupport;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<outbound-resourceadapter>");
        out.println(indention + "\t<transaction-support>" + ResourceAdapter.getTransactionSupportName(this.m_transactionSupport) + "</transaction-support>");
        out.println(indention + "<reauthentication-support>" + this.m_reauthenticationSupport + "</reauthentication-support>");
        if (this.m_authenticationMechanisms != null) {
            XMLUtils.writeAll(this.m_authenticationMechanisms, out, indention + "\t");
        }
        if (this.m_connectionDefinitions != null) {
            XMLUtils.writeAll(this.m_connectionDefinitions.values(), out, indention + "\t");
        }
        out.println(indention + "</outbound-resourceadapter>");
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
    }
}

