/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.naming.ContextUtils;
import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ContextContainer;
import com.evermind.server.ServerComponent;
import com.evermind.server.ThreadState;
import com.evermind.server.connector.ApplicationConnectionManager;
import com.evermind.server.connector.ConnectionSharingPool;
import com.evermind.server.connector.deployment.ActivationSpecConfig;
import com.evermind.server.connector.deployment.AdminObject;
import com.evermind.server.connector.deployment.AdminObjectInstance;
import com.evermind.server.connector.deployment.ConfigurationProperty;
import com.evermind.server.connector.deployment.ConnectionDefinition;
import com.evermind.server.connector.deployment.ConnectorPropertySet;
import com.evermind.server.connector.deployment.InboundResourceAdapter;
import com.evermind.server.connector.deployment.MessageListener;
import com.evermind.server.connector.deployment.OutboundResourceAdapter;
import com.evermind.server.connector.deployment.ResourceAdapter;
import com.evermind.server.connector.deployment.ResourceAdapter15;
import com.evermind.server.connector.deployment.ResourceAdapterDescriptor;
import com.evermind.server.connector.deployment.SharedConnectionPool;
import com.evermind.server.deployment.ConnectorModule;
import com.evermind.server.deployment.IconDescriptor;
import com.evermind.server.ejb.deployment.NameValueProperty;
import com.evermind.util.ClassUtils;
import com.evermind.util.Logger;
import com.evermind.util.LoggingDestroyable;
import com.evermind.util.ObjectUtils;
import com.evermind.util.TaskManager;
import com.evermind.xml.XMLUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveryManagerPresumedAbort;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationPolicy;
import oracle.classloader.ConfigurationType;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.ProtectionPolicy;
import oracle.classloader.SearchPolicy;
import oracle.classloader.SearchSequence;
import oracle.classloader.util.VersionNumber;
import oracle.dms.instrument.NounIntf;
import oracle.j2ee.connector.BootstrapContextAdminDetail;
import oracle.j2ee.connector.JCAMBeanFactory;
import oracle.j2ee.connector.ResourceAdapterWrapper;
import oracle.j2ee.connector.logging.JCADeploymentMessages;
import oracle.j2ee.connector.work.WorkManagerImpl;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.management.callbackinterfaces.JCAAdminObjectCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.JCAAdminObjectInstanceGatekeeperCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionFactoryCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionFactoryGatekeeperCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionPoolCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.ResourceAdapterCallBackIf;
import oracle.oc4j.admin.management.mbeans.JCAAdminObject;
import oracle.oc4j.admin.management.mbeans.JCAAdminObjectInstance;
import oracle.oc4j.admin.management.mbeans.JCAConnectionDefinition;
import oracle.oc4j.admin.management.mbeans.JCAConnectionFactory;
import oracle.oc4j.admin.management.mbeans.JCAConnectionPool;
import oracle.oc4j.admin.management.mbeans.JCAEndpointActivation;
import oracle.oc4j.admin.management.mbeans.JCAManagedConnectionFactory;
import oracle.oc4j.admin.management.mbeans.JCAMessageEndpointFactory;
import oracle.oc4j.admin.management.mbeans.JCAResource;
import oracle.oc4j.admin.management.mbeans.JCASharedConnectionPool;
import oracle.oc4j.admin.management.mbeans.WorkManagerResource;
import oracle.oc4j.loader.config.ConfigurationConsumer;
import oracle.oc4j.loader.config.ConfigurationException;
import oracle.oc4j.loader.config.OC4JConfigurationType;
import oracle.oc4j.loader.config.xml.ImportedSharedLibrariesElement;
import org.w3c.dom.Node;

public class ConnectorArchive
extends ServerComponent
implements ResourceAdapterCallBackIf,
LoggingDestroyable,
JCAAdminObjectInstanceGatekeeperCallBackIf,
JCAConnectionFactoryGatekeeperCallBackIf {
    private IconDescriptor icon;
    private String vendor;
    private String specificationVersion = "1.0";
    private String eisType;
    private String version = "1.0";
    private String licenseDescription;
    private boolean licenseRequired;
    protected ResourceAdapterDescriptor resourceAdapterDescriptor;
    private ClassLoader m_loader;
    private HashMap connectorPropertySets;
    private ConnectorArchiveHelper helper;
    private HashMap m_connectionManagers;
    private javax.resource.spi.ResourceAdapter resourceAdapter;
    private ResourceAdapterWrapper m_resourceAdapterWrapper;
    private String resourceAdapterWrapperLocation;
    private ConnectorModule m_connectorModule;
    private Map sharedConnectionPoolDefinitions;
    private Application m_application;
    private TaskManager taskManager;
    private boolean destroyed;
    private File[] m_sharedCodeSources;
    private ImportedSharedLibrariesElement m_importedSharedLibraries;
    private NounIntf connectorNoun;
    private long m_startTime = 0L;
    static final boolean DEBUG_PERSISTENCE = false;
    private int connectorState;
    private boolean m_dataSourceArchive = false;
    private boolean m_maintainStatistics = true;
    private boolean m_maintainMBeans = true;
    private JCAResource m_jcaResourceMBean = null;
    private oracle.oc4j.admin.management.mbeans.ResourceAdapter m_resourceAdapterMBean = null;
    private WorkManagerResource m_workManagerResourceMBean = null;
    private static Set m_standaloneRars = new HashSet();
    private static final String JMS_ADAPTER_PKG = "oracle.j2ee.ra.jms.generic";
    private static final String CONNECTOR_FACTORY_ELEMENT = "connector-factory";
    private static final String CONNECTION_POOL_ELEMENT = "connection-pool";
    private static final String IMPORT_SHARED_LIBS_ELEMENT = "imported-shared-libraries";
    private Map m_connectionSharingPools = new HashMap();
    static /* synthetic */ Class class$javax$resource$spi$ActivationSpec;

    public String initDeployment() throws InstantiationException {
        String retVal = super.initDeployment();
        ResourceAdapterDescriptor rad = this.getResourceAdapterDescriptor();
        if (rad != null) {
            String resourceAdapterClassName = rad.getResourceAdapterClass();
            if (resourceAdapterClassName != null && resourceAdapterClassName.equals("oracle.oc4j.sql.spi.ResourceAdapterImpl")) {
                this.setDataSourceArchive(true);
            } else {
                this.setDataSourceArchive(false);
            }
        }
        return retVal;
    }

    public HashMap getConnectionManagers() {
        return this.m_connectionManagers;
    }

    public void setTaskmanager(TaskManager tManager) {
        this.taskManager = tManager;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public ConnectorArchive(String name) {
        this.setName(name);
    }

    public void parseMainNode(Node node) throws InstantiationException {
        if (this.helper == null) {
            this.helper = this.specificationVersion.equals("1.5") ? new ConnectorArchive15Helper() : new ConnectorArchive10Helper();
        }
        this.helper.parseMainNode(node);
    }

    public void parseDeploymentMainNode(Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (name.equals(CONNECTOR_FACTORY_ELEMENT)) {
            try {
                this.addConnectorPropertySet(new ConnectorPropertySet(this, node));
            }
            catch (IllegalArgumentException e) {
                throw new InstantiationException("Illegal connector-factory declaration. " + e.getMessage());
            }
        } else if (name.equals(CONNECTION_POOL_ELEMENT)) {
            this.addSharedConnectionPoolDefinition(new SharedConnectionPool(this, node));
        } else if (name.equals(IMPORT_SHARED_LIBS_ELEMENT)) {
            this.obtainImportedSharedLibrariesConfig(node);
        } else {
            throw new InstantiationException("Unknown connector subtag: " + name);
        }
    }

    private void obtainImportedSharedLibrariesConfig(Node node) {
        this.m_importedSharedLibraries = new ImportedSharedLibrariesElement();
        this.m_importedSharedLibraries.read(node);
    }

    public void parseRootNodeValue(String name, String value) throws InstantiationException {
        if (name.equals("version")) {
            this.specificationVersion = value;
        } else if (!(name.equals("xmlns") || name.equals("xmlns:xsi") || name.equals("xsi:schemaLocation") || name.equals("display-name"))) {
            throw new InstantiationException("Unknown assembly root-tag attribute: " + name);
        }
    }

    protected void writeConfig(PrintWriter out) throws IOException {
        if (this.helper != null) {
            this.helper.writeConfig(out);
        }
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        if (this.helper != null) {
            this.helper.writeXML(out, indention);
        }
    }

    protected void writeOrionConfig(PrintWriter out) throws IOException {
        out.println("<?xml version=\"1.0\"?>");
        out.println();
        this.writeOrionXML(out, "");
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
        OutboundResourceAdapter outboundRA;
        out.println(indention + "<oc4j-connector-factories xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://www.oracle.com/technology/oracleas/schema/oc4j-connector-factories-10_0.xsd\" " + "schema-major-version=\"10\" schema-minor-version=\"0\"" + " >");
        this.writeSharedLibraryImports(out, indention);
        if (this.sharedConnectionPoolDefinitions != null || this.connectorPropertySets != null) {
            if (this.sharedConnectionPoolDefinitions != null) {
                Collection sharedPoolDefs = this.sharedConnectionPoolDefinitions.values();
                Iterator iter = sharedPoolDefs.iterator();
                while (iter.hasNext()) {
                    ((SharedConnectionPool)iter.next()).writeOrionXML(out, indention + "\t");
                }
            }
            if (this.connectorPropertySets != null) {
                Iterator iter = this.connectorPropertySets.values().iterator();
                while (iter.hasNext()) {
                    ((ConnectorPropertySet)iter.next()).writeOrionXML(out, indention + "\t");
                }
            }
        } else if (this.resourceAdapterDescriptor != null && (outboundRA = this.resourceAdapterDescriptor.getOutboundResourceAdapter()) != null) {
            Iterator connectionDefinitions = outboundRA.getConnectionDefinitions();
            while (connectionDefinitions.hasNext()) {
                ConnectionDefinition connectionDef = (ConnectionDefinition)connectionDefinitions.next();
                out.println(indention + "\t<!-- Default element generated by OC4J. Please uncomment and modify to suit your configuration needs. ");
                ConnectorPropertySet propertySet = new ConnectorPropertySet(this.getDisplayName(), connectionDef.getConnectionFactoryInterface());
                propertySet.setConfigurationProperties(connectionDef.getConfigurationProperties());
                propertySet.writeOrionXML(out, indention + "\t");
                out.println(indention + "\t-->");
            }
        }
        out.println(indention + "</oc4j-connector-factories>");
    }

    private void writeSharedLibraryImports(PrintWriter out, String indention) throws IOException {
        if (this.m_importedSharedLibraries == null) {
            return;
        }
        this.m_importedSharedLibraries.write(out, indention + "\t");
    }

    protected void verifyDocumentType(String name) throws InstantiationException {
        if (this.inDeploymentMode) {
            if (!name.equals("oc4j-connector-factories")) {
                throw new InstantiationException(this.getName() + " contained a " + name + " file, not a oc4j-connector-factories file as expected");
            }
        } else if (!name.equals("connector")) {
            throw new InstantiationException(this.getName() + " contained a " + name + " file, not a connector file as expected");
        }
    }

    public void setSpecificationVersion(String version) {
        this.specificationVersion = version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setEISType(String eisType) {
        this.eisType = eisType;
    }

    protected String getAssemblyDescriptorPath() {
        return "META-INF/ra.xml";
    }

    public String getDeploymentDescriptorPath() {
        return "oc4j-ra.xml";
    }

    protected String getDefaultDeploymentSubname() {
        return "META-INF";
    }

    public ResourceAdapterDescriptor getResourceAdapterDescriptor() {
        return this.resourceAdapterDescriptor;
    }

    public OutboundResourceAdapter getOutboundResourceAdapter() {
        if (this.resourceAdapterDescriptor != null) {
            return this.resourceAdapterDescriptor.getOutboundResourceAdapter();
        }
        return null;
    }

    public void addResourceAdapter(ResourceAdapter adapter) {
    }

    public ResourceAdapter removeResourceAdapter(String name) {
        return null;
    }

    public List getResourceAdapters() {
        return Collections.EMPTY_LIST;
    }

    public void addConnectorPropertySet(ConnectorPropertySet connectorPropertySet) throws IllegalArgumentException {
        if (this.connectorPropertySets == null) {
            this.connectorPropertySets = new HashMap();
        }
        if (this.connectorPropertySets.get(connectorPropertySet.getLocation()) != null) {
            throw new IllegalArgumentException("Connection factory is already defined at location: " + connectorPropertySet.getLocation());
        }
        this.connectorPropertySets.put(connectorPropertySet.getLocation(), connectorPropertySet);
    }

    public void removeConnectorPropertySet(String jndiLocation) {
        if (this.connectorPropertySets == null) {
            this.connectorPropertySets = new HashMap();
        }
        this.connectorPropertySets.remove(jndiLocation);
    }

    public Collection getConnectorPropertySets() {
        if (this.connectorPropertySets == null) {
            return Collections.EMPTY_LIST;
        }
        return this.connectorPropertySets.values();
    }

    public void addSharedConnectionPoolDefinition(SharedConnectionPool sharedConnectionPool) {
        if (this.sharedConnectionPoolDefinitions == null) {
            this.sharedConnectionPoolDefinitions = new HashMap();
        }
        this.sharedConnectionPoolDefinitions.put(sharedConnectionPool.getName(), sharedConnectionPool);
        if (this.getDisplayName() != null && this.getApplicationName() != null && this.getDeployedName() != null) {
            this.addSharedConnectionPoolMBean(sharedConnectionPool);
        }
    }

    public SharedConnectionPool getSharedConnectionPoolDefinition(String name) {
        if (this.sharedConnectionPoolDefinitions == null) {
            return null;
        }
        return (SharedConnectionPool)this.sharedConnectionPoolDefinitions.get(name);
    }

    public boolean removeSharedConnectionPoolDefinition(String name) throws InstantiationException {
        SharedConnectionPool sharedPool = this.getSharedConnectionPoolDefinition(name);
        if (sharedPool == null) {
            return false;
        }
        if (sharedPool.isInUse()) {
            throw new InstantiationException("Cannot remove shared connection pool that is in use by connection factories. Remove the connection factories first");
        }
        this.sharedConnectionPoolDefinitions.remove(name);
        try {
            this.removeSharedConnectionPoolMBean(sharedPool);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public ApplicationConnectionManager addConnectionFactory(ConnectorPropertySet connectorPropertySet, String connectionSharingPoolName) throws InstantiationException {
        if (this.m_application == null) {
            throw new InstantiationException("Cannot call addConnectionFactory before starting the resource adapter.");
        }
        try {
            this.addConnectorPropertySet(connectorPropertySet);
        }
        catch (IllegalArgumentException e) {
            throw new InstantiationException("Illegal connector-factory declaration. " + e.getMessage());
        }
        return this.createConnectionManager(this.m_application, connectorPropertySet, this.taskManager, connectionSharingPoolName);
    }

    public void removeConnectionFactory(String jndiLocation, boolean force) throws InstantiationException {
        if (this.m_application == null) {
            throw new InstantiationException("Cannot call removeConnectionFactory before starting the resource adapter.");
        }
        this.stopConnectionFactory(jndiLocation, force);
        this.removeConnectorPropertySet(jndiLocation);
    }

    public void stopConnectionFactory(String jndiLocation, boolean force) throws InstantiationException {
        ApplicationConnectionManager manager = null;
        if (this.m_connectionManagers != null) {
            manager = (ApplicationConnectionManager)this.m_connectionManagers.get(jndiLocation);
        }
        if (manager == null) {
            throw new InstantiationException("No connection factory found at JNDI location " + jndiLocation);
        }
        this.unregisterJCAConnectionFactoryMBean(manager);
        try {
            if (manager.isPrivateConnectionPoolDefined()) {
                this.removePrivateConnectionPoolMBean(manager);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        manager.stop(this.m_application, force);
    }

    public void addAdminObjectInstance(AdminObjectInstance adminObject) throws InstantiationException {
        if (this.m_application == null) {
            throw new InstantiationException("Cannot call addAdminObjectInstance before starting the resource adapter.");
        }
        if (this.m_connectorModule == null) {
            throw new InstantiationException("Internal error: Missing ra.xml definition");
        }
        this.m_connectorModule.addAdminObjectInstance(adminObject);
        this.createAdminObjectInstance(adminObject, this.m_application);
    }

    public void removeAdminObjectInstance(AdminObjectInstance adminObject) throws InstantiationException {
        if (this.m_application == null) {
            throw new InstantiationException("Cannot call removeAdminObjectInstance before starting the resource adapter.");
        }
        if (this.m_connectorModule == null) {
            throw new InstantiationException("Internal error: Missing ra.xml definition");
        }
        this.stopAdminObjectInstance(adminObject);
        this.m_connectorModule.removeAdminObjectInstance(adminObject);
    }

    public List getAdminObjects() {
        if (this.resourceAdapterDescriptor == null) {
            return Collections.EMPTY_LIST;
        }
        return this.resourceAdapterDescriptor.getAdminObjects();
    }

    public List getAdminObjectInstances() {
        if (this.m_connectorModule == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_connectorModule.getAdminObjectInstances();
    }

    public String getDeployedName() {
        if (this.m_connectorModule == null) {
            return null;
        }
        return this.m_connectorModule.getName();
    }

    public String getApplicationName() {
        if (this.m_application == null) {
            return null;
        }
        return this.m_application.getName();
    }

    public void setApplication(Application application) {
        this.m_application = application;
    }

    public Application getApplication() {
        return this.m_application;
    }

    public void setDmsNoun(NounIntf noun) {
        this.connectorNoun = noun;
    }

    public NounIntf getNoun() {
        return this.connectorNoun;
    }

    public synchronized void unregisterResourceAdapterMBean() {
        if (this.isMaintainMBeans() && this.m_resourceAdapterMBean != null) {
            JCAMBeanFactory.unregisterMBean(this.m_resourceAdapterMBean);
            this.m_resourceAdapterMBean = null;
        }
    }

    public oracle.oc4j.admin.management.mbeans.ResourceAdapter getResourceAdapterMBean() {
        return this.m_resourceAdapterMBean;
    }

    public void setResourceAdapterMBean(oracle.oc4j.admin.management.mbeans.ResourceAdapter mbean) {
        this.m_resourceAdapterMBean = mbean;
    }

    public void startOutboundConnectionFactories(Application _application, TaskManager _taskManager, Notifier _notifier) {
        Iterator propertySets = this.getConnectorPropertySets().iterator();
        while (propertySets.hasNext()) {
            ConnectorPropertySet connectorPropertySet = (ConnectorPropertySet)propertySets.next();
            try {
                this.createConnectionManager(_application, connectorPropertySet, _taskManager, null);
            }
            catch (InstantiationException e) {
                String[] params;
                String jndiLocation = connectorPropertySet.getLocation();
                if (_application == _application.getServer().getDefaultApplication()) {
                    JCADeploymentMessages.warningBadConnFactoryLocationStandalone(jndiLocation, e.getMessage());
                    if (_notifier == null) continue;
                    params = new String[]{jndiLocation};
                    _notifier.sendNotification("WARNING_CANNOT_SET_CONNECTION_FACTORY_FOR_RESOURCE_ADAPTER", params);
                    continue;
                }
                JCADeploymentMessages.warningBadConnFactoryLocation(jndiLocation, _application.getName(), e.getMessage());
                if (_notifier == null) continue;
                params = new String[]{jndiLocation, _application.getName()};
                _notifier.sendNotification("WARNING_CANNOT_SET_CONNECTION_FACTORY_FOR_RESOURCE_ADAPTER_IN", params);
            }
        }
    }

    public void startResourceAdapter(Application _application, Notifier _notifier) throws InstantiationException {
        String className = this.resourceAdapterDescriptor.getResourceAdapterClass();
        if (className != null) {
            List configProps = null;
            if (this.m_connectorModule != null) {
                configProps = this.m_connectorModule.getConfigurationProperties();
                this.resourceAdapterWrapperLocation = this.m_connectorModule.getName();
            }
            this.resourceAdapter = (javax.resource.spi.ResourceAdapter)this.createJavaBeanInstance(className, configProps, "ResourceAdapter implementation class");
            if (this.m_resourceAdapterWrapper == null) {
                this.m_resourceAdapterWrapper = new ResourceAdapterWrapper(this.resourceAdapter, this);
            }
            if (this.resourceAdapterDescriptor.getInboundResourceAdapter() != null) {
                this.ValidateInboundResourceAdapterConfig();
            }
            ThreadState state = ThreadState.getCurrentState();
            ContextContainer savedCtx = state.contextContainer;
            state.contextContainer = _application;
            try {
                BootstrapContext bootContext = _application.getServer().getBootstrapContext();
                if (bootContext instanceof BootstrapContextAdminDetail) {
                    ((BootstrapContextAdminDetail)bootContext).setApplicationName(_application.getName());
                    ((BootstrapContextAdminDetail)bootContext).setConnectorName(this.getDeployedName());
                }
                this.m_resourceAdapterWrapper.start(bootContext);
            }
            catch (ResourceAdapterInternalException e) {
                throw new InstantiationException(e.getMessage());
            }
            finally {
                state.contextContainer = savedCtx;
            }
            if (this.resourceAdapterDescriptor.getInboundResourceAdapter() != null) {
                if (this.resourceAdapterWrapperLocation == null || this.resourceAdapterWrapperLocation == "") {
                    if (_application == _application.getServer().getDefaultApplication()) {
                        JCADeploymentMessages.warningJNDILocationNotDefinedStandalone(this.m_connectorModule.getName());
                    } else {
                        JCADeploymentMessages.warningJNDILocationNotDefined(this.m_connectorModule.getName(), _application.getName());
                    }
                    String[] params = new String[]{this.m_connectorModule.getName(), _application.getName()};
                    this.sendNotification(_application, _notifier, "WARNING_RESOURCE_ADAPTER_JNDI_NOT_DEFINED", params);
                }
                String rmFactoryJndiLocation = this.createRMFactoryJndiLocation();
                RecoveryManagerPresumedAbort.addResourceManagerFactory(rmFactoryJndiLocation, this.m_resourceAdapterWrapper);
                this.m_resourceAdapterWrapper.setRmIdLocation(rmFactoryJndiLocation);
            }
        }
    }

    private String createRMFactoryJndiLocation() {
        String rmFactoryJndiLocation = "";
        Application parentApp = this.m_application;
        while ((parentApp = parentApp.getParent()) != null) {
            rmFactoryJndiLocation = rmFactoryJndiLocation + parentApp.getName() + "/";
        }
        rmFactoryJndiLocation = rmFactoryJndiLocation + this.m_application.getName() + "/" + this.resourceAdapterWrapperLocation;
        return rmFactoryJndiLocation;
    }

    private void ValidateInboundResourceAdapterConfig() throws InstantiationException {
        InboundResourceAdapter inboundAdapter = this.resourceAdapterDescriptor.getInboundResourceAdapter();
        if (inboundAdapter != null) {
            Set mlTypes = inboundAdapter.getMessageListenerTypes();
            Iterator iter = mlTypes.iterator();
            while (iter.hasNext()) {
                String type = (String)iter.next();
                MessageListener msgListenerDesc = inboundAdapter.getMessageListener(type);
                ActivationSpecConfig asc = msgListenerDesc.getActivationSpecConfig();
                String className = asc.getClassName();
                try {
                    Class<?> clazz = Class.forName(className, true, this.getClassLoader());
                    if (!(class$javax$resource$spi$ActivationSpec == null ? ConnectorArchive.class$("javax.resource.spi.ActivationSpec") : class$javax$resource$spi$ActivationSpec).isAssignableFrom(clazz)) {
                        JCADeploymentMessages.warningActivationSpecNotImplementedInterface(className);
                        throw new InstantiationException("<activationspec-class>" + className + "does not implement javax.resource.spi.ActivationSpec interface");
                    }
                    Constructor<?> constructor = clazz.getConstructor(ClassUtils.CLASS_NOARGS);
                    if (constructor == null) {
                        JCADeploymentMessages.warningActivationSpecNullConstructor(className);
                        throw new InstantiationException("<activationspec-class>" + className + "does not contain a null constructor per JCA spec");
                    }
                    BeanInfo info = Introspector.getBeanInfo(clazz);
                    PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
                    if (asc.getRequiredConfigProperties() == null) continue;
                    Iterator iterator = asc.getRequiredConfigProperties().iterator();
                    while (iterator.hasNext()) {
                        NameValueProperty config = (NameValueProperty)iterator.next();
                        for (int i = 0; i < descriptors.length; ++i) {
                            PropertyDescriptor descriptor = descriptors[i];
                            if (!descriptor.getName().equalsIgnoreCase(config.getName()) || descriptor.getReadMethod() != null && descriptor.getWriteMethod() != null) continue;
                            JCADeploymentMessages.warningActivationSpecRequiredCPGetterMethodMissing(className);
                            throw new InstantiationException("<activationspec-class>" + className + "does not provide getter or setter methods for required-config-property: " + descriptor.getName() + "");
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new InstantiationException("Unable to find class " + className + ": " + e.getMessage());
                }
                catch (NoSuchMethodException e) {
                    throw new InstantiationException("Unable to load class " + className + ": " + e.getMessage());
                }
                catch (IntrospectionException e) {
                    throw new InstantiationException("Error introspecting bean properties " + className + ": " + e.getMessage());
                }
                finally {
                    Introspector.flushCaches();
                }
            }
        }
    }

    private void sendNotification(Application _application, Notifier _notifier, String notificationId, String[] params) {
        if (_application == _application.getServer().getDefaultApplication()) {
            if (_notifier != null) {
                _notifier.sendNotification(notificationId, params);
            }
        } else if (_notifier != null) {
            _notifier.sendNotification(notificationId + "_IN", params);
        }
    }

    public void createAdminObjectInstance(AdminObjectInstance _adminObject, Application _application) throws InstantiationException {
        if (_adminObject.isExampleOnly()) {
            return;
        }
        String jndiLocation = _adminObject.getLocation();
        if (jndiLocation == null || jndiLocation == "") {
            throw new InstantiationException("JNDI location not defined for administered object");
        }
        Object obj = null;
        obj = this.createJavaBeanInstance(_adminObject.getAdminObjectClass(), _adminObject.getConfigurationProperties(), "admin object for resource adapter in " + this.getName());
        try {
            Object lookedupObj = _application.getContext().lookup(jndiLocation);
            if (lookedupObj != null) {
                throw new InstantiationException("Failed to bind administered object to " + jndiLocation + ". The location is already bounded by an object of type: " + lookedupObj.getClass().getName());
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        try {
            _application.getContext().rebind(jndiLocation, obj, 0);
        }
        catch (NamingException e) {
            throw new InstantiationException(e.getMessage());
        }
        if (this.isMaintainMBeans()) {
            JCAAdminObjectInstance mbean = new JCAAdminObjectInstance(this.getDisplayName(), this.getDeployedName(), _application.getName(), _adminObject);
            JCAMBeanFactory.registerMBean(mbean);
        }
    }

    public void stopAdminObjectInstance(AdminObjectInstance _adminObject) throws InstantiationException {
        String jndiLocation = _adminObject.getLocation();
        if (jndiLocation == null || jndiLocation == "") {
            throw new InstantiationException("JNDI location not defined for administered object");
        }
        try {
            Object obj = this.m_application.getContext().lookup(jndiLocation);
            if (obj != null) {
                if (!obj.getClass().getName().equals(_adminObject.getAdminObjectClass())) {
                    throw new InstantiationException("Failed to unbind the administered object. A different object: " + obj + " is found at the JNDI location " + jndiLocation);
                }
                this.m_application.getContext().unbind(jndiLocation);
            }
        }
        catch (NamingException e) {
            throw new InstantiationException(e.getMessage());
        }
        if (this.isMaintainMBeans()) {
            JCAAdminObjectInstance mbean = new JCAAdminObjectInstance(this.getDisplayName(), this.getDeployedName(), this.m_application.getName(), _adminObject);
            JCAMBeanFactory.unregisterMBean(mbean);
        }
    }

    private ApplicationConnectionManager createConnectionManager(Application _application, ConnectorPropertySet connectorPropertySet, TaskManager _taskManager, String connectionSharingPoolName) throws InstantiationException {
        ApplicationConnectionManager manager = new ApplicationConnectionManager();
        manager.init(_application, this, connectorPropertySet, _taskManager, connectionSharingPoolName);
        if (this.isMaintainMBeans()) {
            this.registerJCAConnectionFactoryMBean(manager);
            if (manager.isPrivateConnectionPoolDefined() && this.getDisplayName() != null && this.getApplicationName() != null && this.getDeployedName() != null) {
                this.addPrivateConnectionPoolMBean(manager);
            }
        }
        if (this.m_connectionManagers == null) {
            this.m_connectionManagers = new HashMap();
        }
        this.m_connectionManagers.put(manager.getJndiLocation(), manager);
        return manager;
    }

    public Object createJavaBeanInstance(String className, Collection configProperties, String description) throws InstantiationException {
        Object instance = null;
        try {
            Class<?> clazz = Class.forName(className, true, this.getClassLoader());
            instance = clazz.newInstance();
            if (configProperties != null) {
                Iterator iter = configProperties.iterator();
                while (iter.hasNext()) {
                    NameValueProperty config = (NameValueProperty)iter.next();
                    ObjectUtils.setProperty(instance, config.getName(), config.getStringValue(), false, false);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("Error creating a " + description + ". An instance of class '" + className + "' could not be instantiated due to IllegalAccessException: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("Error creating a " + description + ". Unable to find class " + className + "");
        }
        catch (IntrospectionException e) {
            throw new InstantiationException("Error creating a " + description + ". Error introspecting class '" + className + ": " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new InstantiationException("Error creating a " + description + ". Error while setting JavaBean property for class '" + className + ": " + e.getCause());
        }
        catch (IllegalArgumentException e) {
            throw new InstantiationException("Error creating a " + description + ". Error while setting JavaBean property for class '" + className + ": " + e);
        }
        catch (Throwable e) {
            InstantiationException ie = new InstantiationException("Error creating a " + description + ". Error creating a JavaBean of class '" + className + ": " + e);
            ie.setStackTrace(e.getStackTrace());
            throw ie;
        }
        return instance;
    }

    public void preInit(ClassLoader _parentClassLoader, ConnectorModule _connectorModule, Application application) throws InstantiationException {
        this.m_connectorModule = _connectorModule;
        PermissionCollection permissions = null;
        String nativeLibPath = null;
        if (this.m_connectorModule != null) {
            permissions = this.m_connectorModule.getPermissions();
            nativeLibPath = this.m_connectorModule.getNativeLibraryPath();
            boolean setConnectorArchive = false;
            if (!this.m_connectorModule.isDataSourceModule()) {
                setConnectorArchive = true;
            } else if (application.isDefaultApplication()) {
                setConnectorArchive = true;
            }
            if (setConnectorArchive) {
                this.m_connectorModule.setConnectorArchive(this);
            }
        }
        this.initClassLoader(_parentClassLoader, nativeLibPath, permissions);
    }

    public void setConnectorModule(ConnectorModule _connectorModule) {
        this.m_connectorModule = _connectorModule;
    }

    protected void initClassLoader(ClassLoader parentClassLoader, String nativeLibPath, PermissionCollection permissions) throws InstantiationException {
        this.m_loader = parentClassLoader;
        if (!(parentClassLoader instanceof PolicyClassLoader)) {
            return;
        }
        PermissionCollection pc = this.addDefaultPermissions(permissions);
        boolean loadAsSharedLib = this.shouldDeployAsSharedLib();
        try {
            if (loadAsSharedLib) {
                this.setupResourceAsSharedLibrary(nativeLibPath, pc);
            } else {
                this.addCodeSourcesToAppLoader(parentClassLoader, nativeLibPath, pc);
            }
        }
        catch (NamingException e) {
            InstantiationException ie = new InstantiationException("Error while trying to set up class loader context for " + this + ": " + e);
            ie.initCause(e);
            throw ie;
        }
        catch (IOException e) {
            InstantiationException ie = new InstantiationException("Error while trying to set up class loader context for " + this + ": " + e);
            ie.initCause(e);
            throw ie;
        }
    }

    public boolean shouldDeployAsSharedLib() {
        return this.m_connectorModule.isStandalone() && !this.m_connectorModule.isDataSourceModule() && !this.isOracleJmsAdapter();
    }

    private boolean isOracleJmsAdapter() {
        if (this.getResourceAdapter() == null) {
            return false;
        }
        Class<?> adapterImpl = this.getResourceAdapter().getClass();
        Package pkg = adapterImpl.getPackage();
        if (pkg == null) {
            return false;
        }
        return pkg.getName().equals(JMS_ADAPTER_PKG);
    }

    private void setupResourceAsSharedLibrary(String nativeLibPath, PermissionCollection pc) throws NamingException, IOException {
        String contextPath = this.getContext().getNameInNamespace();
        SearchSequence searchPolicy = new SearchSequence("Local-Before-SharedLibs", new SearchPolicy[]{SearchPolicy.FIND_LOADED_CLASS, SearchPolicy.ASK_PARENT, SearchPolicy.FIND_LOCAL, SearchPolicy.CHECK_SHARED_LIBRARIES});
        ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.SERVER_SHARED_CONNECTOR_ELEMENT, contextPath);
        PolicyClassLoader sharedLibLoader = new PolicyClassLoader(this.getName(), new VersionNumber("0.0.0"), (ClassLoader)ClassLoaderQuery.getAPILoader(), origin, ConfigurationPolicy.SHARED, (SearchPolicy)searchPolicy);
        this.m_loader = sharedLibLoader;
        Context nativeLibContext = nativeLibPath == null ? this.getContext() : ContextUtils.getContext(this.getContext(), nativeLibPath, false);
        ConfigurationOrigin nativeOrigin = new ConfigurationOrigin(ConfigurationType.SHARED_CODE_SOURCE_ELEMENT, contextPath);
        sharedLibLoader.addNativeCodeSource(nativeLibContext.getNameInNamespace(), nativeOrigin);
        List l = this.findAllJarsInContext(this.getContext());
        Iterator i = l.iterator();
        File root = ContextUtils.getFile(this.getContext(), false);
        ConfigurationOrigin jarsOrigin = new ConfigurationOrigin(ConfigurationType.SHARED_CODE_SOURCE_ELEMENT, contextPath);
        while (i.hasNext()) {
            File jar = new File(root, (String)i.next());
            sharedLibLoader.addCodeSource(jar, jarsOrigin, new ProtectionPolicy(pc, null));
        }
        this.importSharedLibs(sharedLibLoader, contextPath);
        this.addDeployedStandaloneAdapter(sharedLibLoader);
        try {
            ApplicationServer.getInstance().getDefaultApplication().importStandaloneAdapter(sharedLibLoader);
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeployedStandaloneAdapter(PolicyClassLoader sharedLibLoader) {
        Set set = m_standaloneRars;
        synchronized (set) {
            m_standaloneRars.add(sharedLibLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeployedStandaloneAdapter(PolicyClassLoader sharedLibLoader) {
        Set set = m_standaloneRars;
        synchronized (set) {
            m_standaloneRars.remove(sharedLibLoader);
        }
    }

    private void importSharedLibs(PolicyClassLoader sharedLibLoader, String contextPath) throws IOException {
        PolicyClassLoader[] standaloneRars = ConnectorArchive.getStandaloneImports();
        PolicyClassLoader defaultLoader = (PolicyClassLoader)ApplicationServer.getInstance().getDefaultApplication().getClassLoader();
        PolicyClassLoader[] imports = defaultLoader.getImports();
        int standaloneRarLen = standaloneRars == null ? 0 : standaloneRars.length;
        int importsLen = imports == null ? 0 : imports.length;
        PolicyClassLoader[] loadersToImport = new PolicyClassLoader[standaloneRarLen + importsLen];
        if (standaloneRarLen != 0) {
            System.arraycopy(standaloneRars, 0, loadersToImport, 0, standaloneRarLen);
        }
        if (importsLen != 0) {
            System.arraycopy(imports, 0, loadersToImport, standaloneRarLen, importsLen);
        }
        try {
            ConfigurationConsumer.addImportedSharedLibraries(sharedLibLoader, contextPath, this.m_importedSharedLibraries, loadersToImport);
        }
        catch (ConfigurationException e) {
            IOException ioe = new IOException("Unable to add shared libs to RA loader");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private void addCodeSourcesToAppLoader(ClassLoader parentClassLoader, String nativeLibPath, PermissionCollection pc) throws NamingException, IOException {
        String contextPath = this.getContext().getNameInNamespace();
        PolicyClassLoader policyloader = (PolicyClassLoader)parentClassLoader;
        ConfigurationOrigin nativeOrigin = new ConfigurationOrigin(OC4JConfigurationType.APPLICATION_NATIVE_CONNECTORS, contextPath);
        Context nativeLibContext = null;
        nativeLibContext = nativeLibPath == null ? this.getContext() : ContextUtils.getContext(this.getContext(), nativeLibPath, false);
        policyloader.addNativeCodeSource(nativeLibContext.getNameInNamespace(), nativeOrigin);
        List l = this.findAllJarsInContext(this.getContext());
        File root = ContextUtils.getFile(this.getContext(), false);
        ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.APPLICATION_CONNECTORS, contextPath);
        this.setSharedCodeSources(l, root);
        this.addCodeSources(policyloader, origin, pc);
    }

    protected void setSharedCodeSources(List codeSourceList, File root) {
        this.m_sharedCodeSources = new File[codeSourceList.size()];
        Iterator i = codeSourceList.iterator();
        int n = 0;
        while (i.hasNext()) {
            File jar = new File(root, (String)i.next());
            this.m_sharedCodeSources[n++] = jar;
        }
    }

    private void addCodeSources(PolicyClassLoader policyloader, ConfigurationOrigin origin, PermissionCollection pc) throws IOException {
        for (int i = 0; i < this.m_sharedCodeSources.length; ++i) {
            File jar = this.m_sharedCodeSources[i];
            policyloader.addCodeSource(jar, origin, new ProtectionPolicy(pc, null));
        }
    }

    public javax.resource.spi.ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public ResourceAdapterWrapper getResourceAdapterWrapper() {
        return this.m_resourceAdapterWrapper;
    }

    public String getResourceAdapterWrapperLocation() {
        return this.resourceAdapterWrapperLocation;
    }

    public ClassLoader getClassLoader() {
        return this.m_loader;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setLicenseDescription(String description) {
        this.licenseDescription = description;
    }

    public void setLicenseRequired(boolean required) {
        this.licenseRequired = required;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public boolean isLicenseRequired() {
        return this.licenseRequired;
    }

    public String getEISType() {
        return this.eisType;
    }

    public List getConfigurationProperties() {
        return this.resourceAdapterDescriptor.getResourceAdapterConfigurationProperties();
    }

    public String getRuntimeConfigurationProperty(String name) {
        return this.m_connectorModule.getConfigurationProperty(name);
    }

    public void setRuntimeConfigurationProperty(String name, String value) {
        if (name == null) {
            return;
        }
        try {
            List l = this.m_connectorModule.getConfigurationProperties();
            Iterator iter = l.iterator();
            if (this.resourceAdapter != null) {
                while (iter.hasNext()) {
                    NameValueProperty config = (NameValueProperty)iter.next();
                    if (!config.getName().equals(name)) continue;
                    ObjectUtils.setProperty(this.resourceAdapter, config.getName(), value, false, false);
                }
            }
            l = this.m_connectorModule.getConfigurationProperties();
            iter = l.iterator();
            while (iter.hasNext()) {
                ConfigurationProperty property = (ConfigurationProperty)iter.next();
                if (!property.getName().equals(name)) continue;
                property.setRuntimeValue(value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getResourceAdapterClass() {
        return this.resourceAdapterDescriptor.getResourceAdapterClass();
    }

    public Set getMessageListenerTypes() {
        InboundResourceAdapter inboundAdapter = this.resourceAdapterDescriptor.getInboundResourceAdapter();
        if (inboundAdapter != null) {
            return inboundAdapter.getMessageListenerTypes();
        }
        return Collections.EMPTY_SET;
    }

    public String getActivationSpecClass(String listener) {
        InboundResourceAdapter inboundAdapter = this.resourceAdapterDescriptor.getInboundResourceAdapter();
        if (inboundAdapter != null) {
            MessageListener ml = inboundAdapter.getMessageListener(listener);
            ActivationSpecConfig asc = ml.getActivationSpecConfig();
            return asc.getClassName();
        }
        return null;
    }

    public List getRequiredConfigProperties(String listener) {
        InboundResourceAdapter inboundAdapter = this.resourceAdapterDescriptor.getInboundResourceAdapter();
        if (inboundAdapter != null) {
            MessageListener ml = inboundAdapter.getMessageListener(listener);
            ActivationSpecConfig asc = ml.getActivationSpecConfig();
            return asc.getRequiredConfigProperties();
        }
        return Collections.EMPTY_LIST;
    }

    public List getManagedConnectionFactoryClasses() {
        OutboundResourceAdapter outboundAdapter = this.resourceAdapterDescriptor.getOutboundResourceAdapter();
        if (outboundAdapter != null) {
            ArrayList<String> mcfList = new ArrayList<String>();
            Iterator itr = outboundAdapter.getConnectionDefinitions();
            while (itr.hasNext()) {
                ConnectionDefinition connDef = (ConnectionDefinition)itr.next();
                mcfList.add(connDef.getManagedConnectionFactoryClass());
            }
            return mcfList;
        }
        return Collections.EMPTY_LIST;
    }

    public List getAdminObjectClasses() {
        List adminObjs = this.resourceAdapterDescriptor.getAdminObjects();
        Iterator itr = adminObjs.iterator();
        ArrayList<String> aocList = new ArrayList<String>();
        while (itr.hasNext()) {
            AdminObject aoc = (AdminObject)itr.next();
            String aocClass = aoc.getAdminObjectClass();
            if (aocList.contains(aocClass)) continue;
            aocList.add(aocClass);
        }
        return aocList;
    }

    public String getTxnSupport() {
        OutboundResourceAdapter outboundAdapter = this.resourceAdapterDescriptor.getOutboundResourceAdapter();
        int txnSupport = outboundAdapter.getTransactionSupport();
        switch (txnSupport) {
            case 1: {
                return "NoTransaction";
            }
            case 2: {
                return "LocalTransaction";
            }
            case 3: {
                return "XATransaction";
            }
        }
        return "Undefined";
    }

    public List getAuthMechanisms() {
        OutboundResourceAdapter outboundAdapter = this.resourceAdapterDescriptor.getOutboundResourceAdapter();
        if (outboundAdapter != null) {
            return outboundAdapter.getAuthenticationMechanisms();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean getReauthSupport() {
        OutboundResourceAdapter outboundAdapter = this.resourceAdapterDescriptor.getOutboundResourceAdapter();
        if (outboundAdapter != null) {
            return outboundAdapter.isReauthenticationSupported();
        }
        return false;
    }

    public void addSharedConnectionPool(String name, Map properties) throws Exception {
        SharedConnectionPool pool = new SharedConnectionPool(name, this);
        try {
            Iterator iter = properties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                pool.setConnectionPoolProperty((String)entry.getKey(), (String)entry.getValue());
            }
            this.addSharedConnectionPoolDefinition(pool);
        }
        catch (InstantiationException e) {
            throw new Exception("Unable to created Shared connection pool " + name + " because of the following exception : " + e.getMessage());
        }
    }

    public void removeSharedConnectionPool(String name) throws Exception {
        if (!this.removeSharedConnectionPoolDefinition(name)) {
            throw new Exception(name + " is not a shared connection pool. Unable to remove it.");
        }
    }

    public void setStartTime(long startTime) {
        this.m_startTime = startTime;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public void persistUpdates() {
        try {
            this.m_connectorModule.persistConfigChange();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void registerJCAResourceMBean() {
        if (this.m_jcaResourceMBean != null) {
            return;
        }
        if (this.m_connectorModule == null || this.m_application == null) {
            return;
        }
        if (this.isMaintainMBeans()) {
            this.m_jcaResourceMBean = new JCAResource(this.getDisplayName(), this.m_connectorModule.getName(), this.m_application.getName());
            JCAMBeanFactory.registerMBean(this.m_jcaResourceMBean);
        }
    }

    public synchronized void unregisterJCAResourceMBean() {
        if (this.m_jcaResourceMBean == null || this.m_connectorModule == null || this.m_application == null) {
            return;
        }
        if (this.isMaintainMBeans()) {
            JCAMBeanFactory.unregisterMBean(this.m_jcaResourceMBean);
            this.m_jcaResourceMBean = null;
        }
    }

    public JCAResource getJCAResourceMBean() {
        return this.m_jcaResourceMBean;
    }

    private void registerJCAConnectionFactoryMBean(JCAConnectionFactoryCallBackIf cback) {
        if (this.m_connectorModule == null || this.m_application == null) {
            return;
        }
        if (this.isMaintainMBeans()) {
            JCAConnectionFactory mbean = new JCAConnectionFactory(cback, this.getDisplayName(), this.m_connectorModule.getName(), this.m_application.getName());
            JCAMBeanFactory.registerMBean(mbean);
        }
    }

    private void unregisterJCAConnectionFactoryMBean(JCAConnectionFactoryCallBackIf cback) {
        if (this.m_connectorModule == null || this.m_application == null) {
            return;
        }
        if (this.isMaintainMBeans()) {
            JCAConnectionFactory mbean = new JCAConnectionFactory(cback, this.getDisplayName(), this.m_connectorModule.getName(), this.m_application.getName());
            JCAMBeanFactory.unregisterMBean(mbean);
        }
    }

    public void registerWorkManagerResourceMBean() {
        WorkManagerImpl wm;
        BootstrapContext ctx;
        ApplicationServer as;
        if (this.isMaintainMBeans() && (as = this.m_application.getServer()) != null && (ctx = as.getBootstrapContext()) != null && (wm = (WorkManagerImpl)ctx.getWorkManager()) != null) {
            try {
                WorkManagerResource mbean = new WorkManagerResource(this.getDisplayName(), this.m_connectorModule.getName(), this.m_application.getName(), wm.getThreadPoolName());
                JCAMBeanFactory.registerMBean(mbean);
                this.m_workManagerResourceMBean = mbean;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterWorkManagerResourceMBean() {
        if (this.m_workManagerResourceMBean != null) {
            try {
                JCAMBeanFactory.unregisterMBean(this.m_workManagerResourceMBean);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                this.m_workManagerResourceMBean = null;
            }
        }
    }

    public WorkManagerResource getWorkManagerResourceMBean() {
        return this.m_workManagerResourceMBean;
    }

    public void addEndpointActivationMBean(String endpointName) {
        if (this.isMaintainMBeans()) {
            JCAEndpointActivation mbean = new JCAEndpointActivation(this.getDisplayName(), this.m_connectorModule.getName(), this.m_application.getName(), endpointName);
            JCAMBeanFactory.registerMBean(mbean);
        }
    }

    public void removeEndpointActivationMBean(String endpointName) {
        if (this.isMaintainMBeans()) {
            JCAEndpointActivation mbean = new JCAEndpointActivation(this.getDisplayName(), this.m_connectorModule.getName(), this.m_application.getName(), endpointName);
            JCAMBeanFactory.unregisterMBean(mbean);
        }
    }

    public void addMessageEndpointFactoryMBean(String endpointName, String messageListenerType) {
        if (this.isMaintainMBeans()) {
            JCAMessageEndpointFactory mbean = new JCAMessageEndpointFactory(this.getDisplayName(), this.m_connectorModule.getName(), this.m_application.getName(), endpointName, messageListenerType);
            JCAMBeanFactory.registerMBean(mbean);
        }
    }

    public void removeMessageEndpointFactoryMBean(String endpointName, String messageListenerType) {
        if (this.isMaintainMBeans()) {
            JCAMessageEndpointFactory mbean = new JCAMessageEndpointFactory(this.getDisplayName(), this.m_connectorModule.getName(), this.m_application.getName(), endpointName, messageListenerType);
            JCAMBeanFactory.unregisterMBean(mbean);
        }
    }

    public void addSharedConnectionPoolMBean(JCAConnectionPoolCallBackIf cback) {
        if (this.isMaintainMBeans()) {
            JCASharedConnectionPool mbean = new JCASharedConnectionPool(this.getDisplayName(), this.getDeployedName(), this.getApplicationName(), cback);
            JCAMBeanFactory.registerMBean(mbean);
        }
    }

    public void removeSharedConnectionPoolMBean(JCAConnectionPoolCallBackIf cback) {
        if (this.isMaintainMBeans()) {
            JCASharedConnectionPool mbean = new JCASharedConnectionPool(this.getDisplayName(), this.getDeployedName(), this.getApplicationName(), cback);
            JCAMBeanFactory.unregisterMBean(mbean);
        }
    }

    public void addPrivateConnectionPoolMBean(JCAConnectionPoolCallBackIf cback) {
        if (this.isMaintainMBeans()) {
            JCAConnectionPool mbean = new JCAConnectionPool(this.getDisplayName(), this.getDeployedName(), this.getApplicationName(), cback);
            JCAMBeanFactory.registerMBean(mbean);
        }
    }

    public void removePrivateConnectionPoolMBean(JCAConnectionPoolCallBackIf cback) {
        if (this.isMaintainMBeans()) {
            JCAConnectionPool mbean = new JCAConnectionPool(this.getDisplayName(), this.getDeployedName(), this.getApplicationName(), cback);
            JCAMBeanFactory.unregisterMBean(mbean);
        }
    }

    public boolean isVersion15() {
        return this.helper != null && this.helper instanceof ConnectorArchive15Helper;
    }

    private PermissionCollection addDefaultPermissions(PermissionCollection permissions) {
        PermissionCollection pc = permissions;
        if (pc == null) {
            pc = new Permissions();
        }
        pc.add(new PropertyPermission("*", "read"));
        pc.add(new SocketPermission("*", "connect"));
        return pc;
    }

    private List findAllJarsInContext(Context ctx) throws NamingException {
        ArrayList l = new ArrayList();
        this.findAllJarsInRelativeContext(ctx, "", l);
        return l;
    }

    private void findAllJarsInRelativeContext(Context ctx, String relativePath, List l) throws NamingException {
        NamingEnumeration<NameClassPair> e = ctx.list(relativePath);
        while (e.hasMore()) {
            NameClassPair pair = e.next();
            String fileName = relativePath + File.separatorChar + pair.getName();
            if (fileName.endsWith(".jar")) {
                l.add(fileName);
                continue;
            }
            File file = ContextUtils.getFile(ctx, fileName, false);
            if (file == null || !file.isDirectory()) continue;
            this.findAllJarsInRelativeContext(ctx, fileName, l);
        }
    }

    public synchronized void destroy(Logger logger) {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.stop(true);
    }

    public File[] getCodeSources() {
        return this.m_sharedCodeSources;
    }

    public boolean checkForActiveEndpoints(List dependentAppNames) {
        return this.m_resourceAdapterWrapper != null && this.m_resourceAdapterWrapper.getEndpointDependentApplicationNames(dependentAppNames);
    }

    public void stop(boolean destroy) {
        Iterator adminObjIter = this.getAdminObjectInstances().iterator();
        while (adminObjIter.hasNext()) {
            try {
                this.stopAdminObjectInstance((AdminObjectInstance)adminObjIter.next());
            }
            catch (InstantiationException e) {}
        }
        this.stopResourceAdapter();
        if (this.m_connectionManagers != null) {
            Iterator iter = this.m_connectionManagers.values().iterator();
            while (iter.hasNext()) {
                ApplicationConnectionManager connManager = (ApplicationConnectionManager)iter.next();
                try {
                    this.stopConnectionFactory(connManager.getJndiLocation(), true);
                }
                catch (InstantiationException e) {
                    // empty catch block
                }
                if (!destroy) continue;
                connManager.destroy(this.m_application);
            }
        }
        if (destroy) {
            this.removeStandardDescriptorMBeans();
            this.unregisterJCAResourceMBean();
            this.unregisterResourceAdapterMBean();
            this.unregisterWorkManagerResourceMBean();
            this.unregisterSharedConnectionPoolMBeans();
            this.closeClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopResourceAdapter() {
        if (this.m_resourceAdapterWrapper == null) {
            return;
        }
        ThreadState state = ThreadState.getCurrentState();
        ContextContainer savedCtx = state.contextContainer;
        state.contextContainer = this.m_application;
        try {
            this.m_resourceAdapterWrapper.stop();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            RecoveryManagerPresumedAbort.removeResourceManagerFactory(this.m_resourceAdapterWrapper.getRmIdLocation());
            this.m_resourceAdapterWrapper = null;
            state.contextContainer = savedCtx;
            throw throwable;
        }
        RecoveryManagerPresumedAbort.removeResourceManagerFactory(this.m_resourceAdapterWrapper.getRmIdLocation());
        this.m_resourceAdapterWrapper = null;
        state.contextContainer = savedCtx;
        if (this.resourceAdapterDescriptor.getInboundResourceAdapter() != null && this.resourceAdapterWrapperLocation != null && this.resourceAdapterWrapperLocation != "") {
            try {
                Object obj = this.m_application.getContext().lookup(this.resourceAdapterWrapperLocation);
                if (obj != null && obj.getClass().equals(ResourceAdapterWrapper.class)) {
                    this.m_application.getContext().unbind(this.resourceAdapterWrapperLocation);
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    public void closeClassLoader() {
        if (!this.shouldDeployAsSharedLib()) {
            return;
        }
        if (this.getClassLoader() != null && this.getClassLoader() instanceof PolicyClassLoader) {
            PolicyClassLoader policyClassLoader = (PolicyClassLoader)this.getClassLoader();
            policyClassLoader.close();
            this.removeDeployedStandaloneAdapter(policyClassLoader);
        }
    }

    public void componentStart() throws InstantiationException {
        this.setComponentState(1);
    }

    public synchronized int getComponentState() {
        return this.connectorState;
    }

    public synchronized void setComponentState(int state) {
        this.connectorState = state;
    }

    public void addStandardDescriptorMBeans() {
        if (this.isMaintainMBeans()) {
            OutboundResourceAdapter outboundRA = this.resourceAdapterDescriptor.getOutboundResourceAdapter();
            if (outboundRA != null) {
                String displayName = this.getDisplayName();
                String connectorName = this.m_connectorModule.getName();
                String applicationName = this.getApplicationName();
                Iterator connectionDefinitions = outboundRA.getConnectionDefinitions();
                while (connectionDefinitions.hasNext()) {
                    ConnectionDefinition connectionDef = (ConnectionDefinition)connectionDefinitions.next();
                    String mcfClass = connectionDef.getManagedConnectionFactoryClass();
                    JCAManagedConnectionFactory mcfMbean = new JCAManagedConnectionFactory(displayName, connectorName, applicationName, mcfClass, false);
                    JCAMBeanFactory.registerMBean(mcfMbean);
                    JCAConnectionDefinition connDefMBean = new JCAConnectionDefinition(displayName, connectorName, applicationName, connectionDef, this);
                    JCAMBeanFactory.registerMBean(connDefMBean);
                }
            }
            List l = this.getAdminObjects();
            Iterator itr = l.iterator();
            while (itr.hasNext()) {
                JCAAdminObjectCallBackIf ao = (JCAAdminObjectCallBackIf)itr.next();
                JCAAdminObject mbean = new JCAAdminObject(this.getDisplayName(), this.getDeployedName(), this.getApplicationName(), ao, this);
                JCAMBeanFactory.registerMBean(mbean);
            }
        }
    }

    public void removeStandardDescriptorMBeans() {
        if (this.isMaintainMBeans()) {
            OutboundResourceAdapter outboundRA = this.resourceAdapterDescriptor.getOutboundResourceAdapter();
            if (outboundRA != null) {
                String displayName = this.getDisplayName();
                String connectorName = this.m_connectorModule.getName();
                String applicationName = this.getApplicationName();
                Iterator connectionDefinitions = outboundRA.getConnectionDefinitions();
                while (connectionDefinitions.hasNext()) {
                    ConnectionDefinition connectionDef = (ConnectionDefinition)connectionDefinitions.next();
                    String mcfClass = connectionDef.getManagedConnectionFactoryClass();
                    try {
                        JCAManagedConnectionFactory mcfMbean = new JCAManagedConnectionFactory(displayName, connectorName, applicationName, mcfClass, false);
                        JCAMBeanFactory.unregisterMBean(mcfMbean);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    try {
                        JCAConnectionDefinition connDefMBean = new JCAConnectionDefinition(displayName, connectorName, applicationName, connectionDef, this);
                        JCAMBeanFactory.unregisterMBean(connDefMBean);
                    }
                    catch (Throwable t) {}
                }
            }
            List l = this.getAdminObjects();
            Iterator itr = l.iterator();
            while (itr.hasNext()) {
                JCAAdminObjectCallBackIf ao = (JCAAdminObjectCallBackIf)itr.next();
                try {
                    JCAAdminObject mbean = new JCAAdminObject(this.getDisplayName(), this.getDeployedName(), this.getApplicationName(), ao, this);
                    JCAMBeanFactory.unregisterMBean(mbean);
                }
                catch (Throwable t) {}
            }
        }
    }

    public void registerSharedConnectionPoolMBeans() {
        if (this.isMaintainMBeans() && this.sharedConnectionPoolDefinitions != null) {
            Iterator iter = this.sharedConnectionPoolDefinitions.values().iterator();
            while (iter.hasNext()) {
                SharedConnectionPool poolDef = (SharedConnectionPool)iter.next();
                this.addSharedConnectionPoolMBean(poolDef);
            }
        }
    }

    public void unregisterSharedConnectionPoolMBeans() {
        if (this.isMaintainMBeans() && this.sharedConnectionPoolDefinitions != null) {
            Iterator iter = this.sharedConnectionPoolDefinitions.values().iterator();
            while (iter.hasNext()) {
                SharedConnectionPool poolDef = (SharedConnectionPool)iter.next();
                this.removeSharedConnectionPoolMBean(poolDef);
            }
        }
    }

    public void addConnectionFactory(String jndiLocation, String connectionFactoryInterface, Map configProperties, int poolOption, String sharedPoolName) throws InstantiationException {
        ConnectorPropertySet connProp = new ConnectorPropertySet(this, connectionFactoryInterface, configProperties);
        connProp.setUseWhichConnectionPool(poolOption);
        if (poolOption == 1) {
            connProp.setConnectionPoolProperty("scheme", "fixed_wait");
            connProp.setConnectionPoolProperty("minConnections", "0");
            connProp.setConnectionPoolProperty("maxConnections", "50");
            connProp.setConnectionPoolProperty("waitTimeout", "300");
        }
        if (poolOption == 2) {
            connProp.setSharedConnectionPoolName(sharedPoolName);
        }
        connProp.setLocation(jndiLocation);
        connProp.setName(this.m_connectorModule.getName());
        this.addConnectionFactory(connProp, null);
    }

    public void removeConnectionFactory(String jndiLocation) throws InstanceNotFoundException, InstantiationException {
        this.removeConnectionFactory(jndiLocation, true);
    }

    public void generateAdminObjectInstance(String jndiLocation, String adminObjectClass, Map configProperties) throws InstantiationException {
        List l = this.getAdminObjects();
        Iterator itr = l.iterator();
        AdminObjectInstance instance = null;
        while (itr.hasNext()) {
            AdminObject ao = (AdminObject)itr.next();
            if (!adminObjectClass.equals(ao.getAdminObjectClass())) continue;
            instance = ao.createInstance(configProperties);
            instance.setLocation(jndiLocation);
        }
        this.addAdminObjectInstance(instance);
    }

    public void removeAdminObjectInstance(String jndiLocation) throws InstanceNotFoundException, InstantiationException {
        List l = this.getAdminObjectInstances();
        Iterator itr = l.iterator();
        AdminObjectInstance instance = null;
        while (itr.hasNext()) {
            instance = (AdminObjectInstance)itr.next();
            if (instance.getLocation() == null || !instance.getLocation().equals(jndiLocation)) continue;
            this.removeAdminObjectInstance(instance);
            return;
        }
        throw new InstanceNotFoundException("Unable to remove admin object instance.None bound at " + jndiLocation + ".");
    }

    public void persistConfigChange() {
        ApplicationServer appserver;
        if (this.m_application != null && (appserver = this.m_application.getServer()) != null) {
            try {
                this.storeDeployment();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isDataSourceArchive() {
        return this.m_dataSourceArchive;
    }

    public void setDataSourceArchive(boolean dataSourceArchive) {
        this.m_dataSourceArchive = dataSourceArchive;
        if (dataSourceArchive) {
            this.setMaintainMBeans(false);
            this.setMaintainStatistics(false);
        }
    }

    public ConnectionSharingPool getConnectionSharingPool(String connectionSharingPoolName) {
        ConnectionSharingPool sharingPool = (ConnectionSharingPool)this.m_connectionSharingPools.get(connectionSharingPoolName);
        if (sharingPool == null) {
            sharingPool = new ConnectionSharingPool();
            this.m_connectionSharingPools.put(connectionSharingPoolName, sharingPool);
        }
        return sharingPool;
    }

    public boolean isMaintainStatistics() {
        return this.m_maintainStatistics;
    }

    public void setMaintainStatistics(boolean maintainStatistics) {
        this.m_maintainStatistics = maintainStatistics;
    }

    public boolean isMaintainMBeans() {
        return this.m_maintainMBeans;
    }

    public void setMaintainMBeans(boolean maintainMBeans) {
        this.m_maintainMBeans = maintainMBeans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolicyClassLoader[] getStandaloneImports() {
        Set set = m_standaloneRars;
        synchronized (set) {
            PolicyClassLoader[] standaloneRars = new PolicyClassLoader[m_standaloneRars.size()];
            m_standaloneRars.toArray(standaloneRars);
            return standaloneRars;
        }
    }

    public class ConnectorArchive15Helper
    implements ConnectorArchiveHelper {
        public void parseMainNode(Node node) throws InstantiationException {
            String name = node.getNodeName();
            if (name.equals("display-name")) {
                ConnectorArchive.this.setDisplayName(XMLUtils.getStringValue(node));
            } else if (name.equals("icon")) {
                ConnectorArchive.this.icon = new IconDescriptor(node);
            } else if (name.equals("description")) {
                ConnectorArchive.this.setDescription(XMLUtils.getStringValue(node));
            } else if (name.equals("vendor-name")) {
                ConnectorArchive.this.vendor = XMLUtils.getStringValue(node);
            } else if (name.equals("resourceadapter-version")) {
                ConnectorArchive.this.setVersion(XMLUtils.getStringValue(node));
            } else if (name.equals("version")) {
                ConnectorArchive.this.setSpecificationVersion(XMLUtils.getStringValue(node));
            } else if (name.equals("eis-type")) {
                ConnectorArchive.this.setEISType(XMLUtils.getStringValue(node));
            } else if (name.equals("license")) {
                ConnectorArchive.this.licenseDescription = XMLUtils.getSubnodeValue(node, "description");
                ConnectorArchive.this.licenseRequired = "true".equalsIgnoreCase(XMLUtils.getSubnodeValue(node, "license-required"));
            } else if (!name.equals("resourceadapter-version")) {
                if (name.equals("resourceadapter")) {
                    ConnectorArchive.this.resourceAdapterDescriptor = new ResourceAdapter15(node);
                } else {
                    throw new InstantiationException("Unknown connector subtag: " + name);
                }
            }
        }

        public void writeConfig(PrintWriter out) throws IOException {
            this.writeXML(out, "");
        }

        public void writeXML(PrintWriter out, String indention) throws IOException {
            out.println(indention + "<connector xmlns=\"http://java.sun.com/xml/ns/j2ee\"");
            out.println(indention + "  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            out.println(indention + "  xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee");
            out.println(indention + "      http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd\"");
            out.println(indention + "  version=\"1.5\">");
            out.println(indention + "\t<display-name>" + XMLUtils.encode(ConnectorArchive.this.getDisplayName()) + "</display-name>");
            if (ConnectorArchive.this.icon != null) {
                ConnectorArchive.this.icon.writeXML(out, "\t");
            }
            out.println(indention + "\t<vendor-name>" + XMLUtils.encode(ConnectorArchive.this.vendor) + "</vendor-name>");
            out.println(indention + "\t<resourceadapter-version>" + XMLUtils.encode(ConnectorArchive.this.specificationVersion) + "</resourceadapter-version>");
            out.println(indention + "\t<eis-type>" + XMLUtils.encode(ConnectorArchive.this.eisType) + "</eis-type>");
            out.println(indention + "\t<version>" + XMLUtils.encode(ConnectorArchive.this.version) + "</version>");
            if (ConnectorArchive.this.licenseDescription != null || ConnectorArchive.this.licenseRequired) {
                out.println(indention + "\t<license>");
                out.println(indention + "\t\t<description>" + XMLUtils.encode(ConnectorArchive.this.licenseDescription) + "</description>");
                out.println(indention + "\t\t<license-required>" + ConnectorArchive.this.licenseRequired + "</license-required>");
                out.println(indention + "\t</license>");
            }
            if (ConnectorArchive.this.resourceAdapterDescriptor != null) {
                ConnectorArchive.this.resourceAdapterDescriptor.writeXML(out, "\t");
            }
            out.println(indention + "</connector>");
        }
    }

    public class ConnectorArchive10Helper
    implements ConnectorArchiveHelper {
        public void parseMainNode(Node node) throws InstantiationException {
            String name = node.getNodeName();
            if (name.equals("display-name")) {
                ConnectorArchive.this.setDisplayName(XMLUtils.getStringValue(node));
            } else if (name.equals("icon")) {
                ConnectorArchive.this.icon = new IconDescriptor(node);
            } else if (name.equals("description")) {
                ConnectorArchive.this.setDescription(XMLUtils.getStringValue(node));
            } else if (name.equals("vendor-name")) {
                ConnectorArchive.this.vendor = XMLUtils.getStringValue(node);
            } else if (name.equals("spec-version")) {
                ConnectorArchive.this.setSpecificationVersion(XMLUtils.getStringValue(node));
            } else if (name.equals("version")) {
                ConnectorArchive.this.setVersion(XMLUtils.getStringValue(node));
            } else if (name.equals("eis-type")) {
                ConnectorArchive.this.setEISType(XMLUtils.getStringValue(node));
            } else if (name.equals("license")) {
                ConnectorArchive.this.licenseDescription = XMLUtils.getSubnodeValue(node, "description");
                ConnectorArchive.this.licenseRequired = "true".equalsIgnoreCase(XMLUtils.getSubnodeValue(node, "license-required"));
            } else if (name.equals("resourceadapter")) {
                ConnectorArchive.this.resourceAdapterDescriptor = new ResourceAdapter(node);
            } else {
                throw new InstantiationException("Unknown connector subtag: " + name);
            }
        }

        public void writeConfig(PrintWriter out) throws IOException {
            out.println("<!DOCTYPE connector PUBLIC \"-//Sun Microsystems, Inc.//DTD Connector 1.0//EN\" \"http://java.sun.com/dtd/connector_1_0.dtd\">");
            out.println();
            this.writeXML(out, "");
        }

        public void writeXML(PrintWriter out, String indention) throws IOException {
            out.println(indention + "<connector>");
            out.println(indention + "\t<display-name>" + XMLUtils.encode(ConnectorArchive.this.getDisplayName()) + "</display-name>");
            if (ConnectorArchive.this.icon != null) {
                ConnectorArchive.this.icon.writeXML(out, "\t");
            }
            out.println(indention + "\t<vendor-name>" + XMLUtils.encode(ConnectorArchive.this.vendor) + "</vendor-name>");
            out.println(indention + "\t<specification-version>" + XMLUtils.encode(ConnectorArchive.this.specificationVersion) + "</specification-version>");
            out.println(indention + "\t<eis-type>" + XMLUtils.encode(ConnectorArchive.this.eisType) + "</eis-type>");
            out.println(indention + "\t<version>" + XMLUtils.encode(ConnectorArchive.this.version) + "</version>");
            if (ConnectorArchive.this.licenseDescription != null || ConnectorArchive.this.licenseRequired) {
                out.println(indention + "\t<license>");
                out.println(indention + "\t\t<description>" + XMLUtils.encode(ConnectorArchive.this.licenseDescription) + "</description>");
                out.println(indention + "\t\t<license-required>" + ConnectorArchive.this.licenseRequired + "</license-required>");
                out.println(indention + "\t</license>");
            }
            if (ConnectorArchive.this.resourceAdapterDescriptor != null) {
                ConnectorArchive.this.resourceAdapterDescriptor.writeXML(out, "\t");
            }
            out.println(indention + "</connector>");
        }
    }

    public static interface ConnectorArchiveHelper {
        public void parseMainNode(Node var1) throws InstantiationException;

        public void writeConfig(PrintWriter var1) throws IOException;

        public void writeXML(PrintWriter var1, String var2) throws IOException;
    }
}

