/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.server.deployment.EnvironmentEntry;
import com.evermind.server.ejb.deployment.NameValueProperty;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationProperty
extends AbstractDescribable
implements XMLizable,
NameValueProperty {
    public static final int REQUIRED_CONFIG_PROPERTY = 0;
    public static final int CONFIG_PROPERTY = 1;
    public static final int OC4J_CONFIG_PROPERTY = 2;
    private String type;
    private String value;
    private String runtimeValue;
    private String xmlElementName = "config-property";
    private int mode = 1;

    public ConfigurationProperty(String name, String description, String type, String value) {
        this(name, description, type, value, null);
    }

    private ConfigurationProperty(String name, String description, String type, String value, String runtimeValue) {
        this.setName(name);
        this.setDescription(description);
        this.setType(type);
        this.value = value;
        this.runtimeValue = runtimeValue;
    }

    public ConfigurationProperty(Node parent) throws InstantiationException {
        this(parent, 1);
    }

    public ConfigurationProperty(Node parent, int mode) throws InstantiationException {
        this.mode = mode;
        if (0 == this.mode) {
            this.xmlElementName = "required-config-property";
        }
        NodeList nodes = parent.getChildNodes();
        if (mode == 2) {
            String name = XMLUtils.getNodeAttribute(parent, "name");
            if (name != null) {
                this.setName(name);
            }
            this.runtimeValue = XMLUtils.getNodeAttribute(parent, "value");
        } else if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("description")) {
                    this.setDescription(value);
                    continue;
                }
                if (nodeName.equals("config-property-name")) {
                    this.setName(value);
                    continue;
                }
                if (nodeName.equals("config-property-type")) {
                    this.setTypeWithValidation(value);
                    continue;
                }
                if (nodeName.equals("config-property-value")) {
                    this.value = value;
                    continue;
                }
                throw new InstantiationException("Unknown config-property subtag: " + nodeName);
            }
        }
        if (this.getName() == null || "".equals(this.getName())) {
            if (2 == this.mode) {
                throw new InstantiationException("Missing 'name' attribute in '" + this.xmlElementName + "' element");
            }
            throw new InstantiationException("Missing 'config-property-name' subtag in '" + this.xmlElementName + "' element");
        }
        if (1 == this.mode && this.type == null) {
            throw new InstantiationException("Missing 'config-property-type' subtag in '" + this.xmlElementName + "' element");
        }
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<" + this.xmlElementName + ">");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getName() != null) {
            out.println(indention + "\t<config-property-name>" + XMLUtils.encode(this.getName()) + "</config-property-name>");
        }
        if (this.type != null) {
            out.println(indention + "\t<config-property-type>" + XMLUtils.encode(this.type) + "</config-property-type>");
        }
        if (this.value != null) {
            out.println(indention + "\t<config-property-value>" + XMLUtils.encode(this.value) + "</config-property-value>");
        }
        out.println(indention + "</" + this.xmlElementName + ">");
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        out.println(indention + "<" + this.xmlElementName + " name=\"" + XMLUtils.encode(this.getName()) + "\" value=\"" + XMLUtils.encode(this.getStringValue()) + "\"/>");
    }

    public String getType() {
        return this.type;
    }

    public Object getValue() throws InstantiationException {
        return EnvironmentEntry.getValue("config-property", "config-property-type", this.getName(), this.type, this.runtimeValue == null ? this.value : this.runtimeValue);
    }

    public String getStringValue() {
        if (this.runtimeValue != null) {
            return this.runtimeValue;
        }
        if (this.value == null || "".equals(this.value)) {
            return this.getDefaultStringValue();
        }
        return this.value;
    }

    private String getDefaultStringValue() {
        if ("java.lang.Integer".equals(this.type) || "java.lang.Double".equals(this.type) || "java.lang.Short".equals(this.type) || "java.lang.Long".equals(this.type) || "java.lang.Byte".equals(this.type)) {
            return "0";
        }
        if ("java.lang.Float".equals(this.type)) {
            return "0.0";
        }
        if ("java.lang.Boolean".equals(this.type)) {
            return "false";
        }
        if ("java.lang.Character".equals(this.type)) {
            return " ";
        }
        return "";
    }

    public String getAssembledValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTypeWithValidation(String type) throws InstantiationException {
        if (!("java.lang.Boolean".equals(type) || "java.lang.String".equals(type) || "java.lang.Integer".equals(type) || "java.lang.Double".equals(type) || "java.lang.Byte".equals(type) || "java.lang.Short".equals(type) || "java.lang.Long".equals(type) || "java.lang.Float".equals(type) || "java.lang.Character".equals(type))) {
            throw new InstantiationException("Invalid config-property-type: " + type);
        }
        this.type = type;
    }

    public String getRuntimeValue() {
        return this.runtimeValue;
    }

    public void setRuntimeValue(String value) {
        this.runtimeValue = value;
    }

    public String toString() {
        return "<name: " + this.getName() + ", value: " + this.getStringValue() + ", assembled value: " + this.getAssembledValue() + ", runtime value: " + this.getRuntimeValue() + ">";
    }

    public Object clone() {
        ConfigurationProperty retVal = new ConfigurationProperty(this.getName(), this.getDescription(), this.getType(), this.getAssembledValue(), this.getRuntimeValue());
        return retVal;
    }
}

