/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector;

import com.evermind.security.Group;
import com.evermind.security.User;
import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ThreadState;
import com.evermind.server.TransactionManagerAccess;
import com.evermind.server.connector.CallbackHandlerImpl;
import com.evermind.server.connector.ConnectionContext;
import com.evermind.server.connector.ConnectionHandleContext;
import com.evermind.server.connector.ConnectionSharingPool;
import com.evermind.server.connector.ContainerAuthenticationData;
import com.evermind.server.connector.JCAResourceManagerFactory;
import com.evermind.server.connector.deployment.AuthenticationMechanism;
import com.evermind.server.connector.deployment.ConfigurationProperty;
import com.evermind.server.connector.deployment.ConnectionDefinition;
import com.evermind.server.connector.deployment.ConnectorArchive;
import com.evermind.server.connector.deployment.ConnectorPropertySet;
import com.evermind.server.connector.deployment.OutboundResourceAdapter;
import com.evermind.server.connector.deployment.PrincipalHolder;
import com.evermind.server.connector.deployment.PrincipalMappingEntries;
import com.evermind.server.connector.deployment.ResourceAdapterDescriptor;
import com.evermind.server.connector.deployment.SharedConnectionPool;
import com.evermind.server.deployment.ResourceReference;
import com.evermind.util.JCAProperties;
import com.evermind.util.ObjectUtils;
import com.evermind.util.TaskManager;
import com.oracle.naming.J2EEContext;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.security.Principal;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveryManagerPresumedAbort;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.StateIntf;
import oracle.j2ee.connector.ConnectionPool;
import oracle.j2ee.connector.ConnectionPoolConnFactory;
import oracle.j2ee.connector.ConnectionPoolConnFactoryContext;
import oracle.j2ee.connector.ConnectionPoolImpl;
import oracle.j2ee.connector.ConnectorProxy;
import oracle.j2ee.connector.ConnectorProxyBuilder;
import oracle.j2ee.connector.ConnectorProxyConstructionData;
import oracle.j2ee.connector.ExtendedManagedConnectionFactory;
import oracle.j2ee.connector.InitiatingGroup;
import oracle.j2ee.connector.InitiatingPrincipal;
import oracle.j2ee.connector.OracleConnectionManager;
import oracle.j2ee.connector.PrincipalMapping;
import oracle.j2ee.connector.logging.JCACommonMessages;
import oracle.j2ee.connector.logging.JCASecurityMessages;
import oracle.j2ee.connector.logging.JCATraceLogger;
import oracle.j2ee.connector.proxy.AbstractProxy;
import oracle.j2ee.connector.proxy.BCELProxyClassLoader;
import oracle.j2ee.connector.proxy.BCELProxyFactory;
import oracle.j2ee.transaction.TransactionMessages;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionFactoryCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionFactoryMetricCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionPoolCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionPoolMetricCallBackIf;
import oracle.security.jazn.realm.Realm;
import oracle.security.jazn.realm.RealmPrincipal;
import oracle.security.jazn.realm.RealmRole;
import oracle.security.jazn.realm.RealmUser;
import oracle.security.jazn.realm.RoleManager;

public class ApplicationConnectionManager
implements Serializable,
ConnectionPoolConnFactory,
JCAConnectionFactoryCallBackIf,
JCAConnectionPoolCallBackIf,
JCAConnectionFactoryMetricCallBackIf {
    private static Logger m_logger = JCATraceLogger.getLogger(ConnectionContext.class);
    private List connectionFactoryConfigProperties;
    private String m_jndiLocation;
    private boolean isReAuthenticationSupported;
    int m_transactionSupport;
    private static Map m_proxyFactories = new WeakHashMap();
    transient Map contexts;
    private transient PrintWriter logWriter;
    private transient boolean mcfLogWriterSet;
    private transient ConnectorPropertySet connectorPropertySet;
    transient ConnectionPool connectionPool;
    private transient PrincipalMapping principalMapping;
    private transient PrincipalMappingEntries principalMappingEntries;
    private String jaasApplicationName;
    private String connectionFactoryInterface;
    private String connectionInterface;
    private transient OracleConnectionManager m_ocm;
    private transient Map m_disassociatedHandles = new WeakHashMap();
    private String connectionPoolClassName;
    private Properties connectionPoolProperties;
    private SharedConnectionPool sharedConnectionPoolDefinition;
    private boolean connectionPoolDisabled;
    ManagedConnectionFactory mcf;
    private boolean validatingManagedConnectionFactory;
    private Class principalMappingClass;
    private Properties principalMappingProperties;
    private Map authMechanisms;
    private String logPath;
    private transient ConnectionSharingPool shareablePool;
    private transient Map m_unshareablePool = new HashMap();
    private CallbackHandler jaasCallbackHandler;
    private String m_rmFactoryJndiLocation;
    transient List m_xaRecoveryCredentials;
    String m_displayName;
    private int state;
    private static TransactionManagerAccess m_tmAccess = new TransactionManagerAccess();
    private static int m_isInApplicationServer;
    static final int ISINAPPSERVER_NOTINITIALIZED = 0;
    static final int ISINAPPSERVER_FALSE = 1;
    static final int ISINAPPSERVER_TRUE = 2;
    transient Application application = null;
    private transient NounIntf noun;
    private transient EventIntf closeCountEvent;
    private transient EventIntf createCountEvent;
    private transient PhaseEventIntf useTimeEvent;
    private transient PhaseEventIntf waitTimeEvent;
    private transient StateIntf poolNameState;
    public static final String ORACLE_CONNECTION_MANAGER_JNDI_PREFIX = "_jcaOracleConnectionManager/";
    private static HashMap m_oracleConnectionManagerMap;
    public transient Map boundJNDILocations;
    static final boolean DEBUG_PERSISTENCE = false;
    private transient ClassLoader m_loader;

    public ApplicationConnectionManager() {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        if (m_oracleConnectionManagerMap == null) {
            m_oracleConnectionManagerMap = new HashMap();
        }
        this.boundJNDILocations = new HashMap();
        this.setComponentState(1);
    }

    public void init(Application application, ConnectorArchive connectorArchive, ConnectorPropertySet connectorPropertySet, TaskManager taskManager, String connectionSharingPoolName) throws InstantiationException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",application=" + application + ",connectorArchive=" + connectorArchive + ",connectorPropertySet=" + connectorPropertySet + ",connectionSharingPoolName=" + connectionSharingPoolName);
        }
        if (connectorArchive == null || application == null) {
            JCACommonMessages.severeErrorAcmInit();
            throw new InstantiationException("Error initializing an ApplicationConnectionManager - ConnectorArchive and Application cannot be null");
        }
        this.m_loader = connectorArchive.getClassLoader();
        this.connectorPropertySet = connectorPropertySet;
        this.application = application;
        ResourceAdapterDescriptor resourceAdapter = connectorArchive.getResourceAdapterDescriptor();
        this.m_displayName = application == application.getServer().getDefaultApplication() ? "standalone resource adapter '" + connectorArchive.getDisplayName() + "'" : "embedded resource archive inside application '" + application.getName() + "'";
        if (resourceAdapter == null) {
            JCACommonMessages.severeErrorAcmInitNoRaelement(this.m_displayName);
            throw new InstantiationException("Error initializing " + this.m_displayName + ". No resourceadapter element defined in its deployment desciptor.");
        }
        this.initOutbound(resourceAdapter.getOutboundResourceAdapter(), application, connectorArchive, connectorPropertySet, taskManager, connectionSharingPoolName);
    }

    public void initConnectionPool() {
        if (this.connectionPool != null) {
            ContainerAuthenticationData containerAuthenticationData = this.getContainerAuthenticationData(this.mcf);
            this.connectionPool.createInitialCapacity(this, new ConnectionPoolConnFactoryContext(this.mcf, containerAuthenticationData, null));
        }
    }

    public ManagedConnectionFactory getMcf() {
        return this.mcf;
    }

    public OracleConnectionManager getOCM() {
        return this.m_ocm;
    }

    public String getJndiLocation() {
        return this.m_jndiLocation;
    }

    PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public int getTransactionSupport() {
        return this.m_transactionSupport;
    }

    public boolean areXAResourcesEmulated() {
        return this.m_transactionSupport == 2;
    }

    public static Object getOracleConnectionManager(String lookup) {
        return m_oracleConnectionManagerMap.get(lookup);
    }

    public static Object removeOracleConnectionManager(String lookup) {
        return m_oracleConnectionManagerMap.remove(lookup);
    }

    public static Object addOracleConnectionManager(String lookup, Object object) {
        return m_oracleConnectionManagerMap.put(lookup, object);
    }

    public NounIntf getNoun() {
        return this.noun;
    }

    public EventIntf getCloseCountEvent() {
        return this.closeCountEvent;
    }

    public EventIntf getCreateCountEvent() {
        return this.createCountEvent;
    }

    public PhaseEventIntf getUseTimeEvent() {
        return this.useTimeEvent;
    }

    public PhaseEventIntf getSharedPoolUseTimeEvent() {
        if (this.sharedConnectionPoolDefinition != null && this.connectionPool != null) {
            return this.connectionPool.getUseTimeEvent();
        }
        return null;
    }

    public PhaseEventIntf getWaitTimeEvent() {
        return this.waitTimeEvent;
    }

    public PhaseEventIntf getSharedPoolWaitTimeEvent() {
        if (this.sharedConnectionPoolDefinition != null && this.connectionPool != null) {
            return this.connectionPool.getWaitTimeEvent();
        }
        return null;
    }

    public void setTransactionSupport(int value) {
        this.m_transactionSupport = value;
    }

    void setPrincipalMapping(PrincipalMapping principalMapping) {
        this.principalMapping = principalMapping;
    }

    void setConnectionPool(ConnectionPool pool) {
        this.connectionPool = pool;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    ConnectionSharingPool getShareablePool() {
        return this.shareablePool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInUse() {
        Map map = this.contexts;
        synchronized (map) {
            return !this.contexts.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionContext removeConnectionContext(ManagedConnection mc) {
        ConnectionContext removedContext = null;
        Map map = this.contexts;
        synchronized (map) {
            removedContext = (ConnectionContext)this.contexts.get(mc);
        }
        if (removedContext != null) {
            removedContext.setActive(false);
        }
        return removedContext;
    }

    protected Class getClass(String type, String name, ClassLoader loader) throws InstantiationException {
        try {
            return Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("Unable to find " + type + " class " + name + ".");
        }
    }

    protected void createPrincipalMappingInstance() throws InstantiationException {
        if (this.principalMappingClass != null) {
            try {
                this.principalMapping = (PrincipalMapping)this.principalMappingClass.newInstance();
                this.principalMapping.init(this.principalMappingProperties);
                this.principalMapping.setManagedConnectionFactory(this.mcf);
                this.principalMapping.setAuthenticationMechanisms(this.authMechanisms);
            }
            catch (ClassCastException e) {
                JCASecurityMessages.warningNotImplementPrincipalMapping(this.principalMappingClass.getName());
                throw new InstantiationException("The class " + this.principalMappingClass.getName() + " does not implement oracle.j2ee.connector.PrincipalMapping interface");
            }
            catch (IllegalAccessException e) {
                JCASecurityMessages.warningCannotInstantiatePrincipalMapping(this.principalMappingClass.getName(), e.getMessage());
                throw new InstantiationException("Unable to instantiate PrincipalMapping implementation class " + this.principalMappingClass.getName() + ". Error is " + e.getMessage());
            }
        }
    }

    protected void initContextsMap() {
        this.contexts = this.sharedConnectionPoolDefinition != null && !this.connectionPoolDisabled ? this.sharedConnectionPoolDefinition.getContexts() : new HashMap();
    }

    private ConnectionPool createConnectionPoolInstance(TaskManager taskManager, NounIntf parentNoun) throws InstantiationException {
        ConnectionPool pool = null;
        if (this.sharedConnectionPoolDefinition != null && !this.connectionPoolDisabled) {
            pool = this.sharedConnectionPoolDefinition.getConnectionPool(this.isReAuthenticationSupported, this.logWriter, parentNoun, taskManager, this.mcf.getClass().getName(), this.connectionPoolClassName);
            this.sharedConnectionPoolDefinition.usePool(this.m_jndiLocation);
            if (ApplicationServer.DMS_GATE && this.poolNameState != null) {
                this.poolNameState.update((Object)this.sharedConnectionPoolDefinition.getName());
            }
        } else {
            try {
                Class<?> connectionPoolClass = Class.forName(this.connectionPoolClassName);
                pool = (ConnectionPool)connectionPoolClass.newInstance();
                String poolName = null;
                if (this.connectionPoolDisabled) {
                    poolName = this.m_jndiLocation + "-disabled";
                    pool.init(this, null, null, this.isReAuthenticationSupported, this.logWriter, poolName, parentNoun);
                } else {
                    ContainerAuthenticationData containerAuthenticationData = this.getContainerAuthenticationData(this.mcf);
                    poolName = this.m_jndiLocation + "-private";
                    pool.init(this, new ConnectionPoolConnFactoryContext(this.mcf, containerAuthenticationData, null), this.connectionPoolProperties, this.isReAuthenticationSupported, this.logWriter, poolName, parentNoun);
                    if (taskManager != null) {
                        taskManager.addTask(pool);
                    }
                }
                if (ApplicationServer.DMS_GATE && this.poolNameState != null) {
                    this.poolNameState.update((Object)poolName);
                }
            }
            catch (ClassNotFoundException e) {
                JCACommonMessages.warningCannotFindConnPoolImpl(this.connectionPoolClassName);
                throw new InstantiationException("Unable to find ConnectionPool implementation class " + this.connectionPoolClassName);
            }
            catch (ClassCastException e) {
                JCACommonMessages.warningNotImplementConnPoolInterface(this.connectionPoolClassName);
                e.printStackTrace();
                throw new InstantiationException("The class " + this.connectionPoolClassName + " does not implement oracle.j2ee.connector.ConnectionPool interface");
            }
            catch (Exception e) {
                JCACommonMessages.severeCannotCreateConnPool(this.m_jndiLocation);
                JCACommonMessages.severeException(e);
                throw new InstantiationException("Unable to create a connection pool for JCA connection factory at JNDI location : " + this.m_jndiLocation + ". Error is " + e);
            }
        }
        pool.registerConnectionFactory(this);
        return pool;
    }

    protected void setupLogging() {
        try {
            this.mcf.setLogWriter(this.logWriter);
            this.mcfLogWriterSet = true;
        }
        catch (Exception e) {
            String mcfClassName = null;
            if (this.mcf != null) {
                mcfClassName = this.mcf.getClass().getName();
            }
            JCACommonMessages.warningCannotSetLogwriter(mcfClassName);
        }
    }

    String getRmFactoryJndiLocation() {
        return this.m_rmFactoryJndiLocation;
    }

    public void setRmFactoryJndiLocation(String _rmFactoryJndiLocation) {
        this.m_rmFactoryJndiLocation = _rmFactoryJndiLocation;
    }

    private void initOutbound(OutboundResourceAdapter outboundRA, Application application, ConnectorArchive connectorArchive, ConnectorPropertySet connectorPropertySet, TaskManager taskManager, String connectionSharingPoolName) throws InstantiationException {
        if (outboundRA == null) {
            JCACommonMessages.infoNoOutboundSupport();
            return;
        }
        this.connectionFactoryConfigProperties = connectorPropertySet.getConfigurationProperties();
        this.isReAuthenticationSupported = outboundRA.isReauthenticationSupported();
        this.connectionPoolDisabled = connectorPropertySet.isConnectionPoolDisabled();
        this.m_jndiLocation = connectorPropertySet.getLocation();
        try {
            Object testObj = application.getContext().lookup(this.m_jndiLocation);
            if (testObj != null) {
                throw new InstantiationException("JNDI location '" + this.m_jndiLocation + "' is already used. It is bound to object: " + testObj);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.loadTransactionSupport(connectorPropertySet, outboundRA);
        if (1 != this.m_transactionSupport) {
            this.shareablePool = this.getConnectionSharingPool(connectorArchive, connectionSharingPoolName);
        }
        this.logWriter = connectorPropertySet.getLogWriter();
        this.logPath = connectorPropertySet.getLogPath();
        this.mcfLogWriterSet = false;
        ConnectionDefinition connectionDef = outboundRA.getConnectionDefinition(connectorPropertySet.getConnectionFactoryInterface());
        if (connectionDef == null) {
            throw new InstantiationException("Error creating a ManagedConnectionFactory for connection factory interface . '" + connectorPropertySet.getConnectionFactoryInterface() + "'. No connection definition can be found with this connection factory interface.");
        }
        this.connectionFactoryInterface = connectionDef.getConnectionFactoryInterface();
        this.connectionInterface = connectionDef.getConnectionInterface();
        Class managedConnectionFactoryClass = this.getClass("managedconnectionfactory-class", connectionDef.getManagedConnectionFactoryClass(), this.m_loader);
        this.getClass("connectionfactory-interface", connectionDef.getConnectionFactoryInterface(), this.m_loader);
        this.getClass("connectionfactory-impl-class", connectionDef.getConnectionFactoryImplementationClass(), this.m_loader);
        this.getClass("connection-interface", connectionDef.getConnectionInterface(), this.m_loader);
        this.getClass("connection-impl-class", connectionDef.getConnectionImplementationClass(), this.m_loader);
        try {
            this.mcf = (ManagedConnectionFactory)managedConnectionFactoryClass.newInstance();
            if (this.mcf instanceof ResourceAdapterAssociation) {
                ((ResourceAdapterAssociation)this.mcf).setResourceAdapter(connectorArchive.getResourceAdapter());
            }
            this.validatingManagedConnectionFactory = this.mcf instanceof ValidatingManagedConnectionFactory;
            if (this.logWriter != null) {
                this.setupLogging();
            }
            Iterator iter = this.connectionFactoryConfigProperties.iterator();
            while (iter.hasNext()) {
                ConfigurationProperty config = (ConfigurationProperty)iter.next();
                String propertyName = config.getName();
                try {
                    ObjectUtils.setProperty(this.mcf, propertyName, config.getStringValue(), false, false);
                }
                catch (Exception e) {
                    JCACommonMessages.severeErrorSetJavabeanProperty(propertyName, managedConnectionFactoryClass.getName(), this.m_displayName);
                    JCACommonMessages.severeException(e);
                    throw new InstantiationException("Error setting JavaBean property '" + propertyName + "' for ManagedConnectionFactory class '" + managedConnectionFactoryClass.getName() + " for " + this.m_displayName + ". Exception is: " + e);
                }
            }
            if (connectorPropertySet.getSharedConnectionPoolName() != null) {
                this.sharedConnectionPoolDefinition = connectorArchive.getSharedConnectionPoolDefinition(connectorPropertySet.getSharedConnectionPoolName());
                if (this.sharedConnectionPoolDefinition == null) {
                    JCACommonMessages.severeErrorSharedConnpoolDefinition(this.m_displayName, connectorPropertySet.getSharedConnectionPoolName());
                    throw new InstantiationException("Error setting up resource adapter for " + this.m_displayName + ". Shared connection pool named '" + ". Shared connection pool named '" + connectorPropertySet.getSharedConnectionPoolName() + "' is not defined.");
                }
            }
            this.initContextsMap();
            this.initPrincipalMapping(connectorPropertySet, connectorArchive, outboundRA);
            this.initConnectionPooling(connectorPropertySet, taskManager, connectorArchive);
            this.m_ocm = new OracleConnectionManager(this);
            ApplicationConnectionManager.addOracleConnectionManager(application.getName() + "/" + ORACLE_CONNECTION_MANAGER_JNDI_PREFIX + this.m_jndiLocation, this.m_ocm);
            application.getContext().rebind(this.m_jndiLocation, this.m_ocm.getBindObject(), 0);
            if (3 == this.m_transactionSupport || 2 == this.m_transactionSupport) {
                this.m_xaRecoveryCredentials = connectorPropertySet.getXARecoveryConfigCredentials();
                this.m_rmFactoryJndiLocation = this.createRMFactoryJndiLocation(application);
                JCAResourceManagerFactory jcaRMFcty = new JCAResourceManagerFactory(this);
                RecoveryManagerPresumedAbort.addResourceManagerFactory(this.m_rmFactoryJndiLocation, jcaRMFcty);
            }
        }
        catch (IllegalAccessException e) {
            JCACommonMessages.warningErrorCreatingMcf(this.m_displayName, managedConnectionFactoryClass.getName(), e.getMessage());
            throw new InstantiationException("Error creating a ManagedConnectionFactory for " + this.m_displayName + ". '" + managedConnectionFactoryClass.getName() + "' could not be instantiated due to access problems: " + e.getMessage());
        }
        catch (NamingException e) {
            JCACommonMessages.warningErrorBindingCf(this.m_displayName, e.getMessage());
            throw new InstantiationException("Error binding a Connection Factory for " + this.m_displayName + " to JNDI: " + e.getMessage());
        }
        catch (Exception e) {
            JCACommonMessages.warningErrorSettingupRa(this.m_displayName, managedConnectionFactoryClass.getName(), e.getMessage());
            throw new InstantiationException("Error setting up resource adapter for " + this.m_displayName + ". ManagedConnectionFactory implementation class '" + managedConnectionFactoryClass.getName() + "' cannot be set up: " + e.getMessage());
        }
        this.initDMS(connectorArchive.getNoun());
    }

    private ConnectionSharingPool getConnectionSharingPool(ConnectorArchive connectorArchive, String connectionSharingPoolName) {
        if (connectionSharingPoolName == null || connectionSharingPoolName.equals("")) {
            return new ConnectionSharingPool();
        }
        return connectorArchive.getConnectionSharingPool(connectionSharingPoolName);
    }

    private String createRMFactoryJndiLocation(Application application) {
        String rmFactoryJndiLocation = "";
        String appName = application.getName();
        while ((application = application.getParent()) != null) {
            rmFactoryJndiLocation = application.getName() + "/" + rmFactoryJndiLocation;
        }
        rmFactoryJndiLocation = rmFactoryJndiLocation + appName + "/" + this.m_jndiLocation;
        return rmFactoryJndiLocation;
    }

    private void setCFProperty() throws InstantiationException {
        Iterator iter = this.connectionFactoryConfigProperties.iterator();
        while (iter.hasNext()) {
            ConfigurationProperty config = (ConfigurationProperty)iter.next();
            String propertyName = config.getName();
            try {
                ObjectUtils.setProperty(this.mcf, propertyName, config.getStringValue(), false, false);
            }
            catch (Exception e) {
                JCACommonMessages.severeErrorSetJavabeanProperty(propertyName, this.m_jndiLocation, this.m_displayName);
                JCACommonMessages.severeException(e);
                throw new InstantiationException("Error setting JavaBean property '" + propertyName + "' for connection factory at '" + this.m_jndiLocation + " for " + this.m_displayName + ". Exception is: " + e);
            }
        }
    }

    private void initConnectionPooling(ConnectorPropertySet connectorPropertySet, TaskManager taskManager, ConnectorArchive connectorArchive) throws InstantiationException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        this.connectionPoolClassName = connectorPropertySet.getConnectionPoolImplementationClass();
        this.connectionPoolProperties = connectorPropertySet.getConnectionPoolProperties();
        this.connectionPool = this.createConnectionPoolInstance(taskManager, connectorArchive.getNoun());
    }

    private void initPrincipalMapping(ConnectorPropertySet connectorPropertySet, ConnectorArchive connectorArchive, OutboundResourceAdapter outboundRA) throws InstantiationException {
        int principalMappingMechanism = connectorPropertySet.getPrincipalMappingMechanism();
        if (principalMappingMechanism == 0 || principalMappingMechanism == -1) {
            this.jaasApplicationName = null;
            this.principalMapping = null;
            String principalMappingClassName = connectorPropertySet.getPrincipalMappingImplementationClass();
            this.principalMappingClass = this.getClass("principal-mapping-interface impl-class", principalMappingClassName, this.m_loader);
        } else if (principalMappingMechanism == 3) {
            this.principalMapping = null;
            this.jaasApplicationName = connectorPropertySet.getJaasApplicationName();
            if (this.jaasApplicationName == null) {
                throw new InstantiationException("security-config use attribute is configured as jaas-module but a <jaas-module> element is missing or is not defined properly");
            }
        } else if (principalMappingMechanism == 2 || principalMappingMechanism == 1) {
            String principalMappingClassName = connectorPropertySet.getPrincipalMappingImplementationClass();
            this.jaasApplicationName = null;
            this.principalMappingEntries = connectorPropertySet.getPrincipalMappingEntries();
            if (principalMappingClassName == null && principalMappingMechanism == 1) {
                throw new InstantiationException("security-config use attribute is configured as principal-mapping-interface but a <principal-mapping-interface> element is missing or is not defined properly");
            }
            if (principalMappingClassName != null) {
                this.principalMappingClass = this.getClass("principal-mapping-interface impl-class", principalMappingClassName, this.m_loader);
                this.principalMappingProperties = connectorPropertySet.getPrincipalMappingProperties();
                List authMechanismList = outboundRA.getAuthenticationMechanisms();
                this.authMechanisms = new HashMap();
                if (authMechanismList != null) {
                    Iterator iter = authMechanismList.iterator();
                    while (iter.hasNext()) {
                        AuthenticationMechanism authMech = (AuthenticationMechanism)iter.next();
                        if (authMech == null) continue;
                        String type = authMech.getAuthenticationMechanismType();
                        String credInterface = authMech.getCredentialInterface();
                        if (type == null) continue;
                        this.authMechanisms.put(type, credInterface);
                    }
                }
                this.createPrincipalMappingInstance();
            }
        }
    }

    private void initDMS(NounIntf parentNoun) {
        if (ApplicationServer.DMS_GATE && parentNoun != null) {
            this.noun = ApplicationServer.nounFactory().create(parentNoun, this.m_jndiLocation, "jca_connection_stats");
            this.useTimeEvent = ApplicationServer.phaseEventFactory().create(this.noun, "useTime", "Time spent using a connection");
            this.useTimeEvent.deriveMetric(46);
            this.waitTimeEvent = ApplicationServer.phaseEventFactory().create(this.noun, "waitTime", "Time spent waiting for a connection to be available");
            this.waitTimeEvent.deriveMetric(46);
            this.closeCountEvent = ApplicationServer.eventFactory().create(this.noun, "closeCount", "number of connection handles closed");
            this.createCountEvent = ApplicationServer.eventFactory().create(this.noun, "createCount", "number of connection handles created");
            this.poolNameState = ApplicationServer.stateFactory().create(this.noun, "poolName", "pool name", "name of connection pool", (Object)"");
        }
    }

    void loadTransactionSupport(ConnectorPropertySet connectorPropertySet, OutboundResourceAdapter outboundRA) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        this.m_transactionSupport = 0 != connectorPropertySet.getTransactionSupport() ? connectorPropertySet.getTransactionSupport() : outboundRA.getTransactionSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionContext setupManagedConnection(ManagedConnection mc, ContainerAuthenticationData containerAuthenticationData, ConnectionRequestInfo cxRequestInfo, boolean connectionShareable) throws ResourceException, ConcurrentModificationException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",managedConnection=" + mc + ",containerAuthenticationData=" + containerAuthenticationData + ",cxRequestInfo=" + cxRequestInfo + ",connectionShareable=" + connectionShareable);
        }
        ConnectionContext context = null;
        Object object = this.contexts;
        synchronized (object) {
            context = (ConnectionContext)this.contexts.get(mc);
            if (context == null) {
                context = new ConnectionContext(mc, connectionShareable);
                this.contexts.put(mc, context);
            }
        }
        context.setActive(true);
        mc.addConnectionEventListener((ConnectionEventListener)context);
        object = context;
        synchronized (object) {
            if (context.hasErrorOccurred()) {
                throw new ConcurrentModificationException();
            }
            context.setup(containerAuthenticationData, cxRequestInfo, this);
            if (this.logWriter != null) {
                mc.setLogWriter(this.logWriter);
            }
        }
        return context;
    }

    protected void addToShareablePool(Transaction tx, ConnectionContext context) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",tx=" + tx + ",context=" + context);
        }
        if (tx != null && this.shareablePool != null) {
            this.shareablePool.add(tx, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToUnshareablePool(Transaction tx, ConnectionContext context) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",transaction=" + tx + ",context=" + context);
        }
        if (tx != null && context != null) {
            Map map = this.m_unshareablePool;
            synchronized (map) {
                Object unshareableConnectionHandle;
                WeakHashMap<Object, ConnectionContext> handleAssociations = (WeakHashMap<Object, ConnectionContext>)this.m_unshareablePool.get(tx);
                if (handleAssociations == null) {
                    handleAssociations = new WeakHashMap<Object, ConnectionContext>();
                    this.m_unshareablePool.put(tx, handleAssociations);
                }
                if ((unshareableConnectionHandle = context.getUnshareableConnectionHandle()) != null) {
                    handleAssociations.put(unshareableConnectionHandle, context);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromUnshareablePool(Transaction tx) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",transaction=" + tx);
        }
        Map map = this.m_unshareablePool;
        synchronized (map) {
            this.m_unshareablePool.remove(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionContext getConnectionFromUnshareablePool(Transaction tx, Object handle) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",transaction=" + tx + ",handle=" + handle);
        }
        ConnectionContext connContext = null;
        if (tx != null) {
            Map map = this.m_unshareablePool;
            synchronized (map) {
                Map handleAssociations = (Map)this.m_unshareablePool.get(tx);
                if (handleAssociations != null) {
                    connContext = (ConnectionContext)handleAssociations.get(handle);
                }
            }
        }
        return connContext;
    }

    public synchronized ContainerAuthenticationData getContainerAuthenticationData(ManagedConnectionFactory mcf) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",mcf=" + mcf);
        }
        if (this.principalMapping == null && this.jaasApplicationName == null) {
            return null;
        }
        Subject subject = null;
        Subject loginSubject = ThreadState.getCurrentState().getCurrentSubject();
        subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        String oc4jUserInfo = this.loadInitiatingPrincipals(loginSubject.getPrincipals(), principals);
        Set<Object> publicCredentials = subject.getPublicCredentials();
        Iterator<Object> loginPubCreds = loginSubject.getPublicCredentials().iterator();
        while (loginPubCreds.hasNext()) {
            publicCredentials.add(loginPubCreds.next());
        }
        ContainerAuthenticationData result = this.getContainerAuthenticationData(mcf, subject);
        if (result != null && oc4jUserInfo != null) {
            result.setOc4jUserInfo(oc4jUserInfo);
        }
        return result;
    }

    ContainerAuthenticationData getContainerAuthenticationData(ManagedConnectionFactory mcf, Subject initSubject) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",mcf=" + mcf + ",initSubject=" + initSubject);
        }
        if (this.principalMapping == null && this.jaasApplicationName == null) {
            return null;
        }
        ContainerAuthenticationData caData = new ContainerAuthenticationData();
        Subject resSubject = null;
        if (this.principalMapping != null) {
            resSubject = this.principalMapping.mapping(initSubject);
        } else {
            LoginContext lc = null;
            try {
                if (this.jaasCallbackHandler == null) {
                    this.jaasCallbackHandler = new CallbackHandlerImpl();
                }
                lc = new LoginContext(this.jaasApplicationName, initSubject, this.jaasCallbackHandler);
                caData.setLoginContext(lc);
                lc.login();
                resSubject = lc.getSubject();
            }
            catch (Throwable e) {
                Set<Principal> initPrincipals = null;
                if (initSubject != null) {
                    initPrincipals = initSubject.getPrincipals();
                }
                JCASecurityMessages.severeErrorJaasLogin(this.jaasApplicationName, initPrincipals);
                JCASecurityMessages.severeException(e);
            }
            if (resSubject != null) {
                Iterator<Object> privateCredentials = resSubject.getPrivateCredentials().iterator();
                while (privateCredentials.hasNext()) {
                    PasswordCredential pwCred;
                    Object credential = privateCredentials.next();
                    if (!(credential instanceof PasswordCredential) || (pwCred = (PasswordCredential)credential).getManagedConnectionFactory() != null) continue;
                    pwCred.setManagedConnectionFactory(mcf);
                }
            }
        }
        caData.setSubject(resSubject);
        return caData;
    }

    String loadInitiatingPrincipals(Set currentPrincipals, Set initiatingPrincipals) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        String oc4jUserInfo = null;
        Iterator iter = currentPrincipals.iterator();
        while (iter.hasNext()) {
            User loginPrincipal;
            Object nextPrincipal = iter.next();
            if (nextPrincipal instanceof User) {
                loginPrincipal = (User)nextPrincipal;
                InitiatingPrincipal p = new InitiatingPrincipal(loginPrincipal.getName());
                Set groups = loginPrincipal.getGroups();
                if (groups != null) {
                    Iterator groupsIter = groups.iterator();
                    while (groupsIter.hasNext()) {
                        Group group = (Group)groupsIter.next();
                        p.addGroup(new InitiatingGroup(group.getName()));
                    }
                }
                initiatingPrincipals.add(p);
                oc4jUserInfo = loginPrincipal.getName();
                continue;
            }
            if (!(nextPrincipal instanceof RealmUser)) continue;
            loginPrincipal = (RealmUser)nextPrincipal;
            Realm realm = loginPrincipal.getRealm();
            String realmname = loginPrincipal.getRealm().getName();
            oc4jUserInfo = realmname + "/" + loginPrincipal.getName();
            InitiatingPrincipal p = new InitiatingPrincipal(oc4jUserInfo);
            p.setRealm(realmname);
            try {
                RoleManager roleMgr = realm.getRoleManager();
                Iterator roleIter = roleMgr.getGrantedRoles((RealmPrincipal)loginPrincipal, false).iterator();
                while (roleIter.hasNext()) {
                    RealmRole role = (RealmRole)roleIter.next();
                    p.addGroup(new InitiatingGroup(role.getName().substring(realmname.length() + 1)));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            initiatingPrincipals.add(p);
        }
        return this.m_transactionSupport == 3 ? oc4jUserInfo : null;
    }

    public ManagedConnection createManagedConnection(ConnectionPoolConnFactoryContext context) throws ResourceException {
        if (context == null) {
            JCACommonMessages.severeCannotCreateMcNullContext();
            throw new ResourceAllocationException("Unable to create ManagedConnection - ConnectionPoolConnectionFactoryContext is null");
        }
        ManagedConnectionFactory mcf = context.getManagedConnectionFactory();
        if (mcf == null) {
            JCACommonMessages.severeCannotCreateMcNoMcf();
            throw new ResourceAllocationException("Unable to create ManagedConnection - no ManagedConectionFactory instance is provided");
        }
        ManagedConnection mc = mcf.createManagedConnection(context.getSubject(), context.getConnectionRequestInfo());
        if (mc != null && this.logWriter != null && !this.mcfLogWriterSet) {
            try {
                mcf.setLogWriter(this.logWriter);
                this.mcfLogWriterSet = true;
            }
            catch (ResourceException e) {
                // empty catch block
            }
        }
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",ManagedConnectionFactory=" + mcf + ",managedConnection=" + mc);
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new Exception().printStackTrace(new PrintStream(baos));
            m_logger.finest(baos.toString());
        }
        return mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedConnection matchManagedConnections(ConnectionPoolConnFactoryContext context, Set candidateSet) throws ResourceException {
        if (context == null) {
            return null;
        }
        ManagedConnectionFactory mcf = context.getManagedConnectionFactory();
        if (mcf == null) {
            return null;
        }
        ManagedConnection mc = null;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            mc = mcf.matchManagedConnections(candidateSet, context.getSubject(), context.getConnectionRequestInfo());
        }
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",managedConnection=" + mc);
        }
        return mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyManagedConnection(ManagedConnection mc) throws ResourceException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",managedConnection=" + mc);
        }
        if (mc == null) {
            return;
        }
        Map map = this.contexts;
        synchronized (map) {
            this.contexts.remove(mc);
        }
        mc.destroy();
    }

    public Set getInvalidConnections(Set candidateSet) throws ResourceException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        Set invalidSet = null;
        if (this.validatingManagedConnectionFactory) {
            invalidSet = ((ValidatingManagedConnectionFactory)this.mcf).getInvalidConnections(candidateSet);
        }
        return invalidSet;
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo info, OracleConnectionManager ocm) throws ResourceException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",mcf=" + mcf + ",info=" + info + ",ocm=" + ocm);
        }
        ContainerAuthenticationData containerAuthenticationData = null;
        if (ocm.isContainerAuthentication()) {
            containerAuthenticationData = this.getContainerAuthenticationData(mcf);
        }
        ConnectionContext context = this.acquireConnectionContext(mcf, info, containerAuthenticationData, ocm);
        context.preAddConnectionHandle();
        Subject subject = null;
        if (containerAuthenticationData != null) {
            subject = containerAuthenticationData.getSubject();
        }
        Object connectionHandle = this.createConnectionHandle(context.getManagedConnection(), subject, info, context, mcf, containerAuthenticationData, ocm);
        if (ApplicationServer.DMS_GATE && this.createCountEvent != null) {
            this.createCountEvent.occurred();
        }
        return connectionHandle;
    }

    public ConnectionContext acquireConnectionContext(ManagedConnectionFactory mcf, ConnectionRequestInfo info, ContainerAuthenticationData containerAuthenticationData, OracleConnectionManager ocm) throws ResourceException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",mcf=" + mcf + ",info=" + info + ",containerAuthenticationData=" + containerAuthenticationData + ",ocm=" + ocm);
        }
        if (this.getComponentState() != 1) {
            throw new ApplicationServerInternalException("Unable to create a connection. Connection factory has been stopped.");
        }
        ConnectionContext connectionContext = null;
        if (ocm.areConnectionsShareable()) {
            connectionContext = this.getConnectionFromShareablePool(mcf, containerAuthenticationData, info);
        }
        if (connectionContext == null) {
            connectionContext = this.getConnectionFromPool(mcf, info, containerAuthenticationData, ocm.areConnectionsShareable());
            connectionContext.setSupportsFastSuspend(ocm.canConnectionsBeReassociated());
        }
        return connectionContext;
    }

    public ConnectionContext getConnectionFromPool(ManagedConnectionFactory mcf, ConnectionRequestInfo info, ContainerAuthenticationData containerAuthenticationData, boolean connectionShareable) throws ResourceException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",mcf=" + mcf + ",info=" + info + ",containerAuthenticationData=" + containerAuthenticationData + ",connectionShareable=" + connectionShareable);
        }
        ConnectionContext connectionContext = null;
        ManagedConnection managedConnection = null;
        boolean done = false;
        while (!done) {
            ConnectionPoolConnFactoryContext context = new ConnectionPoolConnFactoryContext(mcf, containerAuthenticationData, info);
            managedConnection = this.connectionPool.getManagedConnection(this, context);
            if (managedConnection == null) continue;
            try {
                connectionContext = this.setupManagedConnection(managedConnection, containerAuthenticationData, info, connectionShareable);
                done = true;
            }
            catch (ConcurrentModificationException e) {}
        }
        return connectionContext;
    }

    public Transaction getTransaction() {
        if (!ApplicationConnectionManager.isInApplicationServer()) {
            return null;
        }
        try {
            return m_tmAccess.getTransactionManager().getTransaction();
        }
        catch (SystemException systemException) {
            TransactionMessages.severe("SystemException from getTransaction : " + (Object)((Object)systemException));
            return null;
        }
    }

    static boolean isInApplicationServer() {
        if (m_isInApplicationServer == 0) {
            ApplicationServer appServer = ApplicationServer.getInstance();
            m_isInApplicationServer = appServer != null && appServer.getTransactionManager() != null ? 2 : 1;
        }
        return m_isInApplicationServer == 2;
    }

    public ConnectionContext getConnectionFromShareablePool(ManagedConnectionFactory mcf, ContainerAuthenticationData cad, ConnectionRequestInfo info) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",mcf=" + mcf + ",cad=" + cad + ",info=" + info);
        }
        ConnectionContext connContext = null;
        Subject subject = null;
        if (cad != null) {
            subject = cad.getSubject();
        }
        if (this.shareablePool == null) {
            return null;
        }
        Transaction tx = this.getTransaction();
        connContext = this._getConnectionFromShareablePool(subject, info, tx);
        return connContext;
    }

    public ConnectionContext getConnectionFromShareablePool(ManagedConnectionFactory mcf, ContainerAuthenticationData cad, ConnectionRequestInfo info, Transaction tx) throws ResourceException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + "mcf=" + mcf + ",cad=" + cad + ",info=" + info + ",tx=" + tx);
        }
        Subject subject = null;
        if (cad != null) {
            subject = cad.getSubject();
        }
        if (this.shareablePool == null) {
            return null;
        }
        return this._getConnectionFromShareablePool(subject, info, tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionContext _getConnectionFromShareablePool(Subject subject, ConnectionRequestInfo info, Transaction tx) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + "entry: this=" + this + ",subject=" + subject + ",info=" + info + ",tx" + tx);
        }
        boolean done = false;
        ConnectionContext connContext = null;
        while (!done) {
            connContext = this.shareablePool.get(subject, info, tx, null);
            if (connContext == null) {
                done = true;
                continue;
            }
            ManagedConnection managedConnection = null;
            ConnectionContext connectionContext = connContext;
            synchronized (connectionContext) {
                if (!connContext.hasErrorOccurred() && !connContext.hasCleanupOccurred()) {
                    managedConnection = connContext.getManagedConnection();
                }
            }
            if (managedConnection == null) continue;
            done = true;
        }
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + "return: this=" + this + ",connContext=" + connContext + ",sharablePool.size=" + this.shareablePool.getSize());
        }
        return connContext;
    }

    protected Object createConnectionHandle(ManagedConnection managedConnection, Subject subject, ConnectionRequestInfo info, ConnectionContext connContext, ManagedConnectionFactory mcf, ContainerAuthenticationData cad, OracleConnectionManager ocm) throws ResourceException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",managedConnection=" + managedConnection + ",subject=" + subject + ",info=" + info + ",connContext=" + connContext + ",mcf=" + mcf + ",cad=" + cad + ",ocm=" + ocm);
        }
        Object connection = null;
        AbstractProxy proxiedConnection = null;
        Throwable stack = null;
        try {
            connection = managedConnection.getConnection(subject, info);
            if (this.areConnectionsWrapped()) {
                proxiedConnection = this.getConnectionProxy(connection, info, mcf, cad, ocm, connContext);
            }
            if (JCAProperties.getJcaConnectionDebug()) {
                stack = new Throwable("JCA Connection " + connection + " created");
            }
        }
        catch (InstantiationException e) {
            throw new ResourceException(e.toString());
        }
        finally {
            connContext.addConnectionHandle(connection, proxiedConnection, stack);
        }
        return proxiedConnection != null ? proxiedConnection : connection;
    }

    public boolean areConnectionsWrapped() {
        if (ApplicationServer.getInstance() == null) {
            return false;
        }
        if (this.mcf instanceof ExtendedManagedConnectionFactory) {
            return false;
        }
        return this.m_transactionSupport != 1;
    }

    public synchronized void stop(Application application, boolean force) throws InstantiationException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        JCACommonMessages.fineStopCalled();
        this.setComponentState(2);
        if (!force && this.isInUse()) {
            throw new InstantiationException("JCA Connection factory is in use by application - cannot be stopped.");
        }
        ApplicationConnectionManager.removeOracleConnectionManager(application.getName() + "/" + ORACLE_CONNECTION_MANAGER_JNDI_PREFIX + this.m_jndiLocation);
        try {
            application.getContext().unbind(this.m_jndiLocation);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (3 == this.m_transactionSupport) {
            RecoveryManagerPresumedAbort.removeResourceManagerFactory(this.m_rmFactoryJndiLocation);
        }
        this.connectionPool.unregisterConnectionFactory(this);
        if (this.sharedConnectionPoolDefinition != null) {
            this.sharedConnectionPoolDefinition.releasePool(this.m_jndiLocation);
        } else {
            this.connectionPool.destroy();
        }
        if (this.shareablePool != null) {
            this.shareablePool.destroy();
        }
        this.m_unshareablePool.clear();
        if (ApplicationServer.DMS_GATE && this.noun != null) {
            this.noun.destroy();
        }
        this.setComponentState(3);
    }

    public synchronized int getComponentState() {
        return this.state;
    }

    public synchronized void setComponentState(int _state) {
        this.state = _state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Application application) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        JCACommonMessages.fineDestroyCalled();
        if (application != null) {
            try {
                this.stop(application, true);
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (this.sharedConnectionPoolDefinition == null || !this.sharedConnectionPoolDefinition.isInUse()) {
                Map map = this.contexts;
                synchronized (map) {
                    Set set = this.contexts.entrySet();
                    if (set != null) {
                        Object[] entries = set.toArray();
                        for (int i = 0; i < entries.length; ++i) {
                            try {
                                Map.Entry entry = (Map.Entry)entries[i];
                                ConnectionContext context = (ConnectionContext)entry.getValue();
                                if (context == null) continue;
                                context.closeConnection();
                                continue;
                            }
                            catch (Exception e) {
                                JCACommonMessages.warningDestroyException(this.m_jndiLocation, e);
                            }
                        }
                    }
                    this.contexts.clear();
                    this.m_disassociatedHandles.clear();
                }
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.principalMapping = null;
        this.jaasApplicationName = null;
        this.application = null;
        this.m_loader = this.getClass().getClassLoader();
        this.m_unshareablePool = new HashMap();
        this.initContextsMap();
        try {
            if (this.logPath != null) {
                this.logWriter = new PrintWriter((Writer)new FileWriter(this.logPath, true), true);
                if (this.logWriter != null) {
                    this.setupLogging();
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.connectionPool = this.createConnectionPoolInstance(null, null);
        }
        catch (InstantiationException e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lazyEnlist(ManagedConnection managedConnection) throws ResourceException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",managedConnection=" + managedConnection);
        }
        JCACommonMessages.fineLazyEnlistCalled(managedConnection);
        ConnectionContext context = null;
        Map map = this.contexts;
        synchronized (map) {
            context = (ConnectionContext)this.contexts.get(managedConnection);
        }
        if (context == null || !context.isActive()) {
            throw new ResourceException("Unable to find context for the given ManagedConnection");
        }
        context.setupForTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionContext getConnectionContext(ManagedConnection managedConnection) throws ResourceException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",managedConnection=" + managedConnection);
        }
        if (managedConnection == null) {
            return null;
        }
        ConnectionContext context = null;
        Map map = this.contexts;
        synchronized (map) {
            context = (ConnectionContext)this.contexts.get(managedConnection);
        }
        return context;
    }

    void logThrowable(String message, Throwable e) {
        JCACommonMessages.severeThrowableWithMessage(message, e);
    }

    public String getManagedConnectionFactoryClass() {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        return this.getMcf().getClass().getName();
    }

    public List getConnectionFactoryConfigProperties() {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        return this.connectionFactoryConfigProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionFactoryConfigProperty(String name, String value) throws InstantiationException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        List configProperties = this.connectorPropertySet.getConfigurationProperties();
        boolean cfPropertySet = false;
        try {
            this.connectorPropertySet.setConfigProperty(name, value);
            this.setCFProperty();
            cfPropertySet = true;
            this.unbindCFJNDI();
            this.markContextsDiscard();
            this.rebindCFJNDI();
        }
        catch (Exception e) {
            JCACommonMessages.warningDestroyException(this.m_jndiLocation, e);
            this.connectorPropertySet.setConfigurationProperties(configProperties);
            this.connectionFactoryConfigProperties = this.connectorPropertySet.getConfigurationProperties();
            this.setCFProperty();
            if (cfPropertySet) {
                this.rebindCFJNDI();
                this.initContextsMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markContextsDiscard() throws InstantiationException {
        block10: {
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
            }
            try {
                if (this.sharedConnectionPoolDefinition != null && this.sharedConnectionPoolDefinition.isInUse()) break block10;
                Map map = this.contexts;
                synchronized (map) {
                    Set set = this.contexts.entrySet();
                    if (set != null) {
                        Object[] entries = set.toArray();
                        for (int i = 0; i < entries.length; ++i) {
                            Map.Entry entry = (Map.Entry)entries[i];
                            ConnectionContext context = (ConnectionContext)entry.getValue();
                            if (context == null) continue;
                            if (context.isActive()) {
                                context.setDiscardFlag(true);
                                continue;
                            }
                            ManagedConnection mc = context.getManagedConnection();
                            this.destroyManagedConnection(mc);
                            if (this.m_ocm.areConnectionsShareable()) {
                                this.shareablePool.remove(context);
                                continue;
                            }
                            this.removeInvalidConnections(mc);
                        }
                    }
                }
            }
            catch (ResourceException e) {
                throw new InstantiationException("Error destroying ManagedConnection " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidConnections(ManagedConnection mc) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            this.connectionPool.remove(mc);
        }
    }

    private void unbindCFJNDI() throws InstantiationException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        try {
            this.application.getContext().unbind(this.m_jndiLocation);
            ApplicationConnectionManager.removeOracleConnectionManager(this.application.getName() + "/" + ORACLE_CONNECTION_MANAGER_JNDI_PREFIX + this.m_jndiLocation);
        }
        catch (NamingException e) {
            throw new InstantiationException("Error unbinding a Connection Factory for " + this.m_jndiLocation + " to JNDI: " + e.getMessage());
        }
    }

    private void rebindCFJNDI() throws InstantiationException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        try {
            ApplicationConnectionManager.addOracleConnectionManager(this.application.getName() + "/" + ORACLE_CONNECTION_MANAGER_JNDI_PREFIX + this.m_jndiLocation, this.m_ocm);
            this.application.getContext().rebind(this.m_jndiLocation, this.m_ocm.getBindObject(), 0);
            Iterator it = this.boundJNDILocations.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry t = it.next();
                Context context = (Context)t.getKey();
                if (context == null) continue;
                ResourceReference reference = (ResourceReference)t.getValue();
                Object newVal = this.m_ocm.getBindObject();
                ((J2EEContext)context).backDoorRebind(reference.getName(), newVal);
            }
        }
        catch (NamingException e) {
            throw new InstantiationException("Error binding a Connection Factory for " + this.m_jndiLocation + " to JNDI: " + e.getMessage());
        }
    }

    public boolean isSharedConnectionPoolUsed() {
        return this.sharedConnectionPoolDefinition != null;
    }

    public String getSharedConnectionPoolName() {
        if (this.sharedConnectionPoolDefinition != null) {
            return this.sharedConnectionPoolDefinition.getName();
        }
        return null;
    }

    public boolean isPrivateConnectionPoolDefined() {
        return this.sharedConnectionPoolDefinition == null && this.connectionPool != null && !this.isConnectionPoolDisabled();
    }

    public String getConnectionFactoryLogLocation() {
        return this.logPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionFactoryLogLocation(String log) {
        try {
            this.connectorPropertySet.setLogPath(log);
            PrintWriter oldLogWriter = this.connectorPropertySet.getLogWriter();
            this.connectorPropertySet.setLogWriter(log);
            this.setupLogging();
            this.logPath = this.connectorPropertySet.getLogPath();
            this.logWriter = this.connectorPropertySet.getLogWriter();
            Map map = this.contexts;
            synchronized (map) {
                Set set = this.contexts.entrySet();
                if (set != null) {
                    Object[] entries = set.toArray();
                    for (int i = 0; i < entries.length; ++i) {
                        try {
                            Map.Entry entry = (Map.Entry)entries[i];
                            ConnectionContext context = (ConnectionContext)entry.getValue();
                            if (context == null || !context.isActive() || context.getConnectionManager() != this) continue;
                            ManagedConnection mc = context.getManagedConnection();
                            mc.setLogWriter(this.logWriter);
                            continue;
                        }
                        catch (Exception e) {
                            JCACommonMessages.warningSetLogwriterException(this.m_jndiLocation, e);
                        }
                    }
                }
            }
            if (oldLogWriter != null) {
                oldLogWriter.close();
            }
        }
        catch (Exception e) {
            JCACommonMessages.warningSetLogwriterLogException(log, e);
        }
    }

    public boolean isPrincipalMappingEntriesDefined() {
        return this.principalMapping != null;
    }

    public PrincipalMappingEntries getPrincipalMappingEntries() {
        return this.principalMappingEntries;
    }

    public boolean isPrincipalMappingInterfaceDefined() {
        return this.principalMappingClass != null;
    }

    public String getPrincipalMappingInterface() {
        return this.principalMappingClass.getName();
    }

    public void setPrincipalMappingInterfaceClass(String clazz) {
        this.connectorPropertySet.setPrincipalMappingImplementationClass(clazz);
        this.connectorPropertySet.persistConfigChange();
    }

    public boolean isJaasModuleDefined() {
        return this.jaasApplicationName != null;
    }

    public String getJaasModule() {
        return this.jaasApplicationName;
    }

    public void setJaasModule(String name) {
        this.connectorPropertySet.setJaasApplicationName(name);
        this.connectorPropertySet.persistConfigChange();
    }

    public List getXARecoveryCredentials() {
        return this.connectorPropertySet.getXARecoveryConfigCredentials();
    }

    public void clearXARecoveryCredentials() {
        this.connectorPropertySet.clearXARecoveryConfigCredentials();
    }

    public void setXARecoveryCredential(String name, String value) {
        this.connectorPropertySet.addXaRecoveryConfigCredentials(new PrincipalHolder(name, value));
    }

    public String getConnectionFactoryInterface() {
        return this.connectionFactoryInterface;
    }

    public String getConnectionInterface() {
        return this.connectionInterface;
    }

    public void useConnectionPool(String poolName) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",poolName=" + poolName);
        }
        if (poolName.endsWith("-private")) {
            this.connectorPropertySet.setUseWhichConnectionPool(1);
        } else {
            this.connectorPropertySet.setUseWhichConnectionPool(2);
            this.connectorPropertySet.setSharedConnectionPoolName(poolName);
        }
        this.connectorPropertySet.persistConfigChange();
    }

    public void disableConnectionPooling() {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        this.connectorPropertySet.setUseWhichConnectionPool(0);
        this.connectorPropertySet.persistConfigChange();
    }

    public void addPrivateConnectionPool(Map properties) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        Iterator iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.connectorPropertySet.setConnectionPoolProperty((String)entry.getKey(), (String)entry.getValue());
        }
        this.connectorPropertySet.persistConfigChange();
    }

    public void setEISSignOnScheme(String scheme) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",scheme=" + scheme);
        }
        try {
            int value = -1;
            if (scheme.equals("principal-mapping-entries")) {
                value = 2;
                if (!this.isPrincipalMappingEntriesDefined()) {
                    this.connectorPropertySet.setPrincipalMappingMechanism(value);
                    this.createPrincipalMappingInstance();
                }
            }
            if (scheme.equals("none")) {
                value = 0;
                this.connectorPropertySet.setPrincipalMappingMechanism(value);
                this.principalMapping = null;
            }
        }
        catch (Exception e) {
            JCACommonMessages.warningSetPrincipalMapException(scheme, e);
        }
    }

    public void initPrincipalMappingProperties() {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        this.principalMappingProperties = this.connectorPropertySet.getPrincipalMappingProperties();
        this.principalMapping.init(this.principalMappingProperties);
    }

    public PrincipalMappingEntries createPrincipalMappingEntries() {
        PrincipalMappingEntries entries = this.connectorPropertySet.getPrincipalMappingEntries();
        if (entries == null) {
            this.connectorPropertySet.createPrincipalMappings();
            entries = this.connectorPropertySet.getPrincipalMappingEntries();
        }
        this.principalMappingEntries = entries;
        return entries;
    }

    public void persistConfigChange() {
        this.connectorPropertySet.persistConfigChange();
    }

    public JCAConnectionFactoryMetricCallBackIf getFactoryMetrics() {
        return this;
    }

    private String getConnectionPoolProperty(String property) {
        return this.connectionPoolProperties.getProperty(property);
    }

    private void setConnectionPoolProperty(String property, String value) {
        this.connectionPoolProperties.setProperty(property, value);
    }

    private void setConnectionPoolProperty(String property, int value) {
        this.setConnectionPoolProperty(property, Integer.toString(value));
    }

    public String getPoolName() {
        return this.m_jndiLocation + "-private";
    }

    public String getScheme() {
        if (this.connectionPool != null) {
            return this.connectionPool.getScheme();
        }
        return this.getConnectionPoolProperty("scheme");
    }

    public void setScheme(String newScheme) throws Exception {
        if (this.connectionPool != null) {
            this.connectionPool.setScheme(newScheme);
        }
        this.setConnectionPoolProperty("scheme", newScheme);
    }

    public int getInitialCapacity() {
        if (this.connectionPool != null) {
            return this.connectionPool.getInitialCapacity();
        }
        return Integer.parseInt(this.getConnectionPoolProperty("initial-capacity"));
    }

    public void setInitialCapacity(int newValue) throws Exception {
        if (this.connectionPool != null) {
            this.connectionPool.setInitialCapacity(newValue);
        }
        this.setConnectionPoolProperty("initial-capacity", newValue);
    }

    public int getMinConnections() {
        if (this.connectionPool != null) {
            return this.connectionPool.getMinConnections();
        }
        return Integer.parseInt(this.getConnectionPoolProperty("minConnections"));
    }

    public void setMinConnections(int newValue) throws Exception {
        if (this.connectionPool != null) {
            this.connectionPool.setMinConnections(newValue);
        }
        this.setConnectionPoolProperty("minConnections", newValue);
    }

    public int getMaxConnections() {
        if (this.connectionPool != null) {
            return this.connectionPool.getMaxConnections();
        }
        return Integer.parseInt(this.getConnectionPoolProperty("maxConnections"));
    }

    public void setMaxConnections(int newValue) throws Exception {
        if (this.connectionPool != null) {
            this.connectionPool.setMaxConnections(newValue);
        }
        this.setConnectionPoolProperty("maxConnections", newValue);
    }

    public int getWaitTimeout() {
        String timeout = this.getConnectionPoolProperty("waitTimeout");
        if (timeout != null) {
            return Integer.parseInt(timeout);
        }
        return ConnectionPoolImpl.DEFAULT_WAIT_TIMEOUT;
    }

    public void setWaitTimeout(int newValue) throws Exception {
        if (this.connectionPool != null) {
            this.connectionPool.setWaitTimeout(newValue);
        }
        this.setConnectionPoolProperty("waitTimeout", newValue);
    }

    public String getInactivityTimeoutCheck() {
        return this.getConnectionPoolProperty("inactivity-timeout-check");
    }

    public void setInactivityTimeoutCheck(String newValue) throws Exception {
        if (this.connectionPool != null) {
            this.connectionPool.setInactivityTimeoutCheck(newValue);
        }
        this.setConnectionPoolProperty("inactivity-timeout-check", newValue);
    }

    public int getInactivityTimeout() {
        String timeout = this.getConnectionPoolProperty("inactivity-timeout");
        if (timeout != null) {
            return Integer.parseInt(timeout);
        }
        return ConnectionPoolImpl.DEFAULT_INACTIVITY_TIMEOUT;
    }

    public void setInactivityTimeout(int newValue) throws Exception {
        if (this.connectionPool != null) {
            this.connectionPool.setInactivityTimeout(newValue);
        }
        this.setConnectionPoolProperty("inactivity-timeout", newValue);
    }

    public void pruneInvalidAndExpiredConnections() {
        if (this.connectionPool != null) {
            this.connectionPool.purgeCandidateSet();
        }
    }

    public boolean isPoolInUse() {
        return this.connectorPropertySet.getUseWhichConnectionPool() == 1;
    }

    public boolean isConnectionPoolDisabled() {
        boolean connectionPoolInstanceIsDisabled = false;
        if (this.connectionPool != null) {
            connectionPoolInstanceIsDisabled = this.connectionPool.isDisabled();
        }
        return this.connectorPropertySet.isConnectionPoolDisabled() || connectionPoolInstanceIsDisabled;
    }

    public JCAConnectionPoolMetricCallBackIf getDMSMetrics() {
        return (JCAConnectionPoolMetricCallBackIf)((Object)this.connectionPool);
    }

    private AbstractProxy getConnectionProxy(Object connection, ConnectionRequestInfo info, ManagedConnectionFactory mcf, ContainerAuthenticationData cad, OracleConnectionManager ocm, ConnectionContext context) throws InstantiationException {
        BCELProxyFactory bcelProxyfactory = this.getProxyFactory(mcf, ocm);
        ConnectorProxyConstructionData data = new ConnectorProxyConstructionData(ocm, info, mcf, cad, context);
        ConnectorProxyBuilder builder = new ConnectorProxyBuilder(connection, null, data, null);
        AbstractProxy proxy = bcelProxyfactory.getProxy(builder);
        return proxy;
    }

    private synchronized BCELProxyFactory getProxyFactory(ManagedConnectionFactory mcf, OracleConnectionManager ocm) {
        BCELProxyFactory bcelProxyfactory = null;
        bcelProxyfactory = (BCELProxyFactory)m_proxyFactories.get(mcf);
        if (bcelProxyfactory == null) {
            Map superClassMap = ocm.getProxySuperClassMap();
            bcelProxyfactory = new BCELProxyFactory(new BCELProxyClassLoader(this.m_loader), null, superClassMap, this.getProxySuperClassType(), ocm.wrapSubObjects() ? 3 : (superClassMap == null ? 0 : 1));
            bcelProxyfactory.setNoProxyResultMethods(this.getProxySuperClassType(), ocm.getNoProxyResultMethods());
            m_proxyFactories.put(mcf, bcelProxyfactory);
        }
        return bcelProxyfactory;
    }

    ClassLoader getClassLoader() {
        return this.m_loader;
    }

    public Class getProxySuperClassType() {
        return ConnectorProxy.class;
    }

    void addDisassociatedHandleContext(Object handle, ConnectionHandleContext context) {
        this.m_disassociatedHandles.put(handle, context);
    }

    public ConnectionHandleContext getDisassociatedHandleContext(Object handle) {
        return (ConnectionHandleContext)this.m_disassociatedHandles.remove(handle);
    }
}

