/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.security.Group;
import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.AdministrationPermission;
import com.evermind.server.ApplicationServerGroup;
import com.evermind.server.ApplicationServerUser;
import com.evermind.server.rmi.RMIPermission;
import com.evermind.util.ClassUtils;
import com.evermind.xml.XMLConfig;
import com.evermind.xml.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUserManager
extends XMLConfig
implements UserManager {
    protected UserManager parent;
    protected Map groups = new HashMap();
    protected Map users = new HashMap();
    protected User anonymousUser;

    public void setParent(UserManager parent) {
        this.parent = parent;
    }

    public void init(Properties properties) throws InstantiationException {
        String path = properties.getProperty("path");
        if (path == null) {
            throw new InstantiationException("Missing 'path' property, required for XMLUserManager");
        }
        try {
            this.init(new File(path).toURL());
        }
        catch (IOException e) {
            throw new InstantiationException("Error reading configuration '" + path + "': " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User createUser(String username, String password) {
        if (this.getUser(username) != null) {
            throw new IllegalArgumentException("User '" + username + "' already exists");
        }
        ApplicationServerUser user = new ApplicationServerUser(this, username, password);
        Map map = this.users;
        synchronized (map) {
            this.users.put(username, user);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(User user) {
        Map map = this.users;
        synchronized (map) {
            this.users.remove(user.getName());
        }
        return true;
    }

    protected void parseDeploymentMainNode(Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (name.equals("users")) {
            this.parseUsersNode(node);
        } else if (name.equals("groups")) {
            this.parseGroupsNode(node);
        } else {
            super.parseDeploymentMainNode(node);
        }
    }

    protected void reset() {
        super.reset();
        this.groups.clear();
        this.users.clear();
    }

    protected void parseUsersNode(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            String name = node.getNodeName();
            if (!name.equals("user")) continue;
            this.parseUserNode(node);
        }
    }

    protected void parseGroupsNode(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            String name = node.getNodeName();
            if (!name.equals("group")) continue;
            this.parseGroupNode(node);
        }
    }

    protected void parseUserNode(Node parent) throws InstantiationException {
        ApplicationServerUser user = new ApplicationServerUser(parent, this);
        if (this.users.containsKey(user.getName())) {
            throw new InstantiationException("Duplicate user: " + user.getName() + " in " + this.getURL());
        }
        this.users.put(user.getName(), user);
    }

    protected void parseGroupNode(Node parent) throws InstantiationException {
        ApplicationServerGroup group = new ApplicationServerGroup(XMLUtils.getNodeAttribute(parent, "name"));
        if (group.getName() == null) {
            return;
        }
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            String name = node.getNodeName();
            if (name.equals("description")) {
                group.setDescription(XMLUtils.getStringValue(node));
                continue;
            }
            if (!name.equals("permission")) continue;
            String permissionName = XMLUtils.getNodeAttribute(node, "name");
            if (permissionName == null) {
                permissionName = XMLUtils.getStringValue(node);
            }
            if (permissionName == null) continue;
            if (permissionName.equalsIgnoreCase("administration")) {
                group.addPermission(AdministrationPermission.INSTANCE);
                continue;
            }
            if (permissionName.equalsIgnoreCase("rmi:login")) {
                group.addPermission(new RMIPermission("login"));
                continue;
            }
            try {
                Permission permission = (Permission)ClassUtils.getInstance(permissionName, this.getClass().getClassLoader());
                if (permission == null) continue;
                group.addPermission(permission);
                continue;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        if (this.groups.containsKey(group.getName())) {
            throw new InstantiationException("Duplicate group: " + group.getName() + " in " + this.getURL());
        }
        if ("true".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "default"))) {
            this.addDefaultGroup(group.getName());
            group.setDefault(true);
        }
        this.groups.put(group.getName(), group);
    }

    protected ApplicationServerUser getOrCreateUser(String username) {
        ApplicationServerUser user = (ApplicationServerUser)this.users.get(username);
        if (user == null) {
            user = new ApplicationServerUser(this, username);
            this.users.put(username, user);
        }
        return user;
    }

    protected Group getOrCreateGroup(String groupname) {
        Group group = (Group)this.groups.get(groupname);
        if (group == null) {
            group = new ApplicationServerGroup(groupname);
            this.groups.put(groupname, group);
        }
        return group;
    }

    protected void initialize(Node node) {
    }

    public User getAnonymousUser() {
        if (this.anonymousUser == null) {
            if (this.parent != null) {
                this.anonymousUser = this.parent.getAnonymousUser();
            } else {
                ApplicationServerUser guest = new ApplicationServerUser(this, "guest");
                guest.setLocked(true);
                this.anonymousUser = guest;
                if (this.users != null) {
                    this.users.put("guest", this.anonymousUser);
                }
            }
        }
        return this.anonymousUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroup(String name) {
        if (this.groups != null) {
            Map map = this.groups;
            synchronized (map) {
                Group group = (Group)this.groups.get(name);
                if (group != null) {
                    return group;
                }
            }
        }
        if (this.parent != null) {
            return this.parent.getGroup(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String username) {
        if (this.users != null) {
            Map map = this.users;
            synchronized (map) {
                ApplicationServerUser user = (ApplicationServerUser)this.users.get(username);
                if (user != null) {
                    return user;
                }
            }
        }
        if (this.parent != null) {
            return this.parent.getUser(username);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getAdminUser() {
        if (this.users != null) {
            Map map = this.users;
            synchronized (map) {
                Iterator iterator = this.users.values().iterator();
                while (iterator.hasNext()) {
                    ApplicationServerUser user = (ApplicationServerUser)iterator.next();
                    if (!user.hasPermission(AdministrationPermission.INSTANCE)) continue;
                    return user;
                }
            }
        }
        return null;
    }

    protected synchronized void writeConfig(PrintWriter out) throws IOException {
        out.println("<?xml version=\"1.0\"?>");
        out.println();
        this.writeXML(out, "");
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<principals " + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://xmlns.oracle.com/oracleas/schema/principals-10_0.xsd\" " + " schema-major-version=\"10\" schema-minor-version=\"0\" " + " >");
        out.println(indention + "\t<groups>");
        if (this.groups != null) {
            XMLUtils.writeAll(this.groups.values(), out, indention + "\t\t");
        }
        out.println(indention + "\t</groups>");
        out.println(indention + "\t<users>");
        if (this.users != null) {
            XMLUtils.writeAll(this.users.values(), out, indention + "\t\t");
        }
        out.println(indention + "\t</users>");
        out.println(indention + "</principals>");
    }

    protected void verifyDocumentType(String name) throws InstantiationException {
        if (!name.equals("principals")) {
            throw new InstantiationException(this.getName() + " contained a " + name + " file, not a principals file as expected");
        }
    }

    public Set getDefaultGroups() {
        return Collections.EMPTY_SET;
    }

    public void addDefaultGroup(String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String issuerDN, BigInteger serial) {
        if (this.users != null) {
            Map map = this.users;
            synchronized (map) {
                Iterator iterator = this.users.values().iterator();
                while (iterator.hasNext()) {
                    ApplicationServerUser user = (ApplicationServerUser)iterator.next();
                    BigInteger userSerial = user.getCertificateSerial();
                    if (userSerial == null || !userSerial.equals(serial) || !issuerDN.equals(user.getCertificateIssuerDN())) continue;
                    return user;
                }
            }
        }
        if (this.parent != null) {
            return this.parent.getUser(issuerDN, serial);
        }
        return null;
    }

    public User getUser(X509Certificate certificate) {
        return this.getUser(certificate.getIssuerDN().getName(), certificate.getSerialNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group createGroup(String name) throws InstantiationException {
        Map map = this.groups;
        synchronized (map) {
            if (this.getGroup(name) != null) {
                throw new IllegalArgumentException("group " + name + " already exists");
            }
            ApplicationServerGroup group = new ApplicationServerGroup(name);
            this.groups.put(name, group);
            return group;
        }
    }

    public UserManager getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getUsers(int start, int length) {
        Map map = this.users;
        synchronized (map) {
            ArrayList users = new ArrayList(this.users.values());
            Collections.sort(users);
            return users.subList(start, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getGroups(int start, int length) {
        Map map = this.groups;
        synchronized (map) {
            ArrayList groups = new ArrayList(this.groups.values());
            Collections.sort(groups);
            return groups.subList(start, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUserCount() {
        Map map = this.users;
        synchronized (map) {
            return this.users.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGroupCount() {
        Map map = this.groups;
        synchronized (map) {
            return this.groups.size();
        }
    }

    public boolean remove(Group group) {
        Iterator entries = this.users.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            User user = (User)entry.getValue();
            if (!user.isMemberOf(group)) continue;
            user.removeFromGroup(group);
        }
        return this.groups.remove(group.getName()) != null;
    }
}

