/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.TransactionManagerAccess;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import oracle.j2ee.transaction.TransactionSynchronizationRegistry;

public class TransactionSynchronizationRegistryImpl
implements TransactionSynchronizationRegistry {
    private static TransactionManagerAccess m_tmAccess = new TransactionManagerAccess();
    private static TransactionSynchronizationRegistry m_instance = null;

    private TransactionSynchronizationRegistryImpl() {
    }

    static TransactionSynchronizationRegistry getInstance() {
        if (m_instance == null) {
            m_instance = new TransactionSynchronizationRegistryImpl();
        }
        return m_instance;
    }

    public Object getTransactionKey() {
        ApplicationServerTransaction tx;
        try {
            tx = this.getApplicationServerTransaction();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
        return tx == null ? null : new TransactionKey(tx);
    }

    public void putResource(Object key, Object value) throws IllegalStateException {
        ApplicationServerTransaction tx = this.getApplicationServerTransaction();
        if (tx == null) {
            throw new IllegalStateException("Current thread is not associated with a transaction");
        }
        tx.putResource(key, value);
    }

    public Object getResource(Object key) throws IllegalStateException {
        ApplicationServerTransaction tx = this.getApplicationServerTransaction();
        if (tx == null) {
            throw new IllegalStateException("Current thread is not associated with a transaction");
        }
        return tx.getResource(key);
    }

    public void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
        ApplicationServerTransaction applicationServerTransaction = this.getApplicationServerTransaction();
        try {
            applicationServerTransaction.registerInterposedSynchronization(sync);
        }
        catch (RollbackException rollbackException) {
            IllegalStateException illegalStateException = new IllegalStateException("RollbackException from registerInterposedSynchronization");
            illegalStateException.initCause(rollbackException);
            throw illegalStateException;
        }
        catch (SystemException systemException) {
            IllegalStateException illegalStateException = new IllegalStateException("SystemException from registerInterposedSynchronization");
            illegalStateException.initCause(systemException);
            throw illegalStateException;
        }
    }

    public int getTransactionStatus() {
        try {
            return m_tmAccess.getTransactionManager().getStatus();
        }
        catch (SystemException systemException) {
            RuntimeException runtimeException = new RuntimeException("SystemException from getTransactionStatus()");
            runtimeException.initCause(systemException);
            throw runtimeException;
        }
    }

    public void setRollbackOnly() throws IllegalStateException {
        try {
            m_tmAccess.getTransactionManager().setRollbackOnly();
        }
        catch (SystemException systemException) {
            IllegalStateException illegalStateException = new IllegalStateException("Unable to setRollbackOnly");
            illegalStateException.initCause(systemException);
            throw illegalStateException;
        }
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        ApplicationServerTransaction tx = this.getApplicationServerTransaction();
        if (tx == null) {
            throw new IllegalStateException("Current thread is not associated with a transaction");
        }
        return tx.getRollbackOnly();
    }

    private ApplicationServerTransaction getApplicationServerTransaction() throws IllegalStateException {
        try {
            return (ApplicationServerTransaction)m_tmAccess.getTransactionManager().getTransaction();
        }
        catch (SystemException systemException) {
            IllegalStateException illegalStateException = new IllegalStateException("Unable to obtain transaction");
            illegalStateException.initCause(systemException);
            throw illegalStateException;
        }
    }

    private class TransactionKey {
        private byte[] m_tid;

        private TransactionKey(ApplicationServerTransaction tx) {
            this.m_tid = tx.getGlobalID();
        }

        public int hashCode() {
            return this.m_tid.hashCode();
        }

        public boolean equals(Object obj) {
            return this.m_tid.equals(((TransactionKey)obj).m_tid);
        }
    }
}

