/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ApplicationServerTransactionManager;
import com.evermind.server.DMSEvent;
import com.evermind.server.ResourceXidHolder;
import com.evermind.server.TwoPhaseCommitProvider;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.propagation.ParentReference;
import oracle.as.j2ee.transaction.tpc.NormalXid;
import oracle.as.j2ee.transaction.tpc.ProtocolError;
import oracle.as.j2ee.transaction.tpc.ProtocolErrorWithNotification;

class SubordinateTransaction
extends ApplicationServerTransaction {
    SubordinateTransaction(Xid xid, int timeout, ApplicationServerTransactionManager manager, ParentReference pr) {
        super(xid, timeout, manager, pr);
    }

    void enlistSinglePhaseResource(XAResource resource, String jndiLocation, NormalXid xid) throws SystemException {
        this.throwSystemExceptionFromEnlist("SinglePhaseResource can't be enlisted in subordinate transaction", null);
    }

    public void commit() {
        this.m_manager.cleanupForProtocolError(this);
        throw new ProtocolErrorWithNotification("Attempted to unilaterally commit branch transaction on a subordinate node.");
    }

    public void rollback() {
        this.m_manager.cleanupForProtocolError(this);
        throw new ProtocolErrorWithNotification("Attempted to unilaterally rollback branch transaction on a subordinate node.");
    }

    int prepare() throws XAException {
        this.checkForRollbackOnly();
        this.checkStateForPrepare();
        if (this.checkReadOnly()) {
            return 3;
        }
        DMSEvent prepareEvent = DMSEvent.create(5);
        prepareEvent.start();
        try {
            this.setCoordinator(this.m_manager.createCoordinator(this));
            this.doPrepare();
        }
        catch (RollbackException e) {
            this.m_manager.freeResources(this);
            XAException xe = new XAException(100);
            xe.initCause(e);
            throw xe;
        }
        finally {
            prepareEvent.stop();
        }
        return 0;
    }

    void commit(boolean heuristic, boolean onePhase) throws XAException {
        if (onePhase) {
            this.commitOnePhase();
        } else {
            boolean protoErrorOccurred = false;
            try {
                this.checkCoordinatorSet();
                this.doDistinctCommit(heuristic);
                this.updateCompletionStatistics();
            }
            catch (ProtocolError e) {
                protoErrorOccurred = true;
                throw e;
            }
            finally {
                if (!protoErrorOccurred) {
                    this.m_manager.freeResources(this);
                }
            }
        }
    }

    public void rollback(boolean heuristic) throws XAException {
        boolean protoErrorOccurred = false;
        try {
            if (!this.hasBranchBeenPrepared()) {
                super.rollback(null);
            } else {
                this.doRollback(heuristic);
                this.updateCompletionStatistics();
            }
        }
        catch (SystemException e) {
            XAException xe = new XAException(-3);
            xe.initCause(e);
            throw xe;
        }
        catch (ProtocolError e) {
            protoErrorOccurred = true;
            throw e;
        }
        finally {
            if (!protoErrorOccurred) {
                this.m_manager.freeResources(this);
            }
        }
    }

    private void commitOnePhase() throws XAException {
        try {
            super.doCommit();
        }
        catch (SystemException e) {
            XAException xe = new XAException(-3);
            xe.initCause(e);
            throw xe;
        }
        catch (RollbackException e) {
            XAException xe = new XAException(100);
            xe.initCause(e);
            throw xe;
        }
        catch (HeuristicCommitException e) {
            XAException xe = new XAException(7);
            xe.initCause(e);
            throw xe;
        }
        catch (HeuristicRollbackException e) {
            XAException xe = new XAException(6);
            xe.initCause(e);
            throw xe;
        }
        catch (HeuristicMixedException e) {
            XAException xe = new XAException(5);
            xe.initCause(e);
            throw xe;
        }
        catch (IllegalStateException e) {
            throw new ProtocolErrorWithNotification("Illegal State Exception occurred during commit: " + e);
        }
        catch (SecurityException e) {
            XAException xe = new XAException(-3);
            xe.initCause(e);
            throw xe;
        }
    }

    private void doPrepare() throws XAException {
        ResourceXidHolder resources = new ResourceXidHolder(this.m_resources);
        this.setTransactionState(6);
        try {
            this.m_tpcEngine.prepare(resources.getXids(), resources.getResources(), this.m_parentReference);
        }
        catch (SystemException e) {
            this.handlePrepareSystemException();
        }
        this.setTransactionState(9);
        this.m_timePrepared = System.currentTimeMillis();
    }

    private void doDistinctCommit(boolean heuristic) throws XAException {
        try {
            this.setStatusCommitting(heuristic);
            this.m_tpcEngine.commit(heuristic);
            this.setStatusCommitted(heuristic);
        }
        catch (SystemException se) {
            this.handleCommitSystemException(se);
        }
    }

    private void doRollback(boolean heuristic) throws XAException {
        try {
            this.setStatusRollingBack(heuristic);
            this.m_tpcEngine.rollback(heuristic);
            this.setStatusRolledBack(heuristic);
        }
        catch (SystemException se) {
            this.handleRollbackSystemException(se);
        }
    }

    private void checkStateForPrepare() {
        if (this.getTransactionState() != 0 && this.getTransactionState() != 2) {
            throw new ProtocolErrorWithNotification("Invalid state in prepare: " + this.getTransactionState());
        }
    }

    private void handlePrepareSystemException() throws XAException {
        this.m_manager.addRecoveredTransaction(this.m_tpcEngine.getGlobalTransaction());
        this.m_manager.freeResources(this);
        this.m_tpcEngine = null;
        this.setTransactionState(13);
        throw new XAException(100);
    }

    private void handleCommitSystemException(SystemException se) throws XAException {
        XAException xae = null;
        this.m_manager.addRecoveredTransaction(this.m_tpcEngine.getGlobalTransaction());
        switch (this.m_tpcEngine.getGlobalTransaction().getTransactionState()) {
            case 12: {
                break;
            }
            case 5: {
                this.m_tpcEngine = null;
                this.setTransactionState(12);
                break;
            }
            case 7: {
                this.m_tpcEngine = null;
                this.setTransactionState(10);
            }
            case 10: {
                xae = new XAException("Some branches have been committed heuristically");
                xae.errorCode = 7;
                xae.initCause(se);
                throw xae;
            }
            case 11: {
                xae = new XAException("All branches heuristically rolled back");
                xae.errorCode = 6;
                xae.initCause(se);
                throw xae;
            }
            case 14: 
            case 15: {
                xae = new XAException("Branches have been completed inconsistently");
                xae.errorCode = 5;
                xae.initCause(se);
                throw xae;
            }
            default: {
                ProtocolErrorWithNotification pe = new ProtocolErrorWithNotification("Invalid state: " + this.m_tpcEngine.getGlobalTransaction().getTransactionState() + " for transaction " + this.m_tpcEngine.getGlobalTransaction());
                pe.initCause(se);
                throw pe;
            }
        }
    }

    private void handleRollbackSystemException(SystemException se) throws XAException {
        this.m_manager.addRecoveredTransaction(this.m_tpcEngine.getGlobalTransaction());
        XAException xae = null;
        switch (this.m_tpcEngine.getGlobalTransaction().getTransactionState()) {
            case 13: {
                break;
            }
            case 3: {
                this.m_tpcEngine = null;
                this.setTransactionState(13);
                break;
            }
            case 11: {
                break;
            }
            case 8: {
                this.m_tpcEngine = null;
                this.setTransactionState(11);
                break;
            }
            case 10: {
                xae = new XAException("Heuristically completed");
                xae.errorCode = 7;
                xae.initCause(se);
                throw xae;
            }
            case 15: {
                xae = new XAException("Heuristic Inconsistent Outcome");
                xae.errorCode = 5;
                xae.initCause(se);
                throw xae;
            }
            case 14: {
                xae = new XAException("Inconsistent outcome");
                xae.errorCode = 5;
                xae.initCause(se);
                throw xae;
            }
            case 16: {
                throw new ProtocolErrorWithNotification("Transaction " + this.m_tpcEngine.getGlobalTransaction() + " state is INVALID");
            }
            default: {
                ProtocolErrorWithNotification pe = new ProtocolErrorWithNotification("Invalid state: " + this.m_tpcEngine.getGlobalTransaction().getTransactionState() + " for transaction " + this.m_tpcEngine.getGlobalTransaction());
                pe.initCause(se);
                throw pe;
            }
        }
    }

    void handleCommitSystemException(TwoPhaseCommitProvider commitDriver, SystemException se) throws RollbackException, HeuristicCommitException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        super.handleCommitSystemException(commitDriver, se);
        if (this.m_tpcEngine == null) {
            return;
        }
        if (this.m_tpcEngine.getGlobalTransaction().getTransactionState() == 10) {
            HeuristicCommitException hce = new HeuristicCommitException();
            hce.initCause((Throwable)se);
            throw hce;
        }
    }

    private boolean checkReadOnly() {
        if (this.m_resources.isEmpty()) {
            this.setTransactionState(1);
            this.m_manager.freeResources(this);
            return true;
        }
        return false;
    }

    private void checkForRollbackOnly() throws XAException {
        if (this.getTransactionState() == 2) {
            try {
                super.rollback();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
            throw new XAException(100);
        }
    }

    private void checkCoordinatorSet() {
        if (this.m_tpcEngine == null) {
            throw new ProtocolErrorWithNotification("TPC Engine is null in commit");
        }
    }

    private void setStatusCommitting(boolean heuristic) {
        if (heuristic) {
            this.setTransactionState(7);
        } else {
            this.setTransactionState(5);
        }
    }

    private void setStatusCommitted(boolean heuristic) {
        if (heuristic) {
            this.setTransactionState(10);
        } else {
            this.setTransactionState(12);
        }
    }

    private void setStatusRollingBack(boolean heuristic) {
        if (heuristic) {
            this.setTransactionState(8);
        } else {
            this.setTransactionState(3);
        }
    }

    private void setStatusRolledBack(boolean heuristic) {
        if (heuristic) {
            this.setTransactionState(11);
        } else {
            this.setTransactionState(13);
        }
    }

    private boolean hasBranchBeenPrepared() {
        return this.m_tpcEngine != null;
    }
}

