/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.connector.deployment.ConnectorArchive;
import com.evermind.server.deployment.ConnectorModule;
import com.evermind.server.deployment.EnterpriseArchive;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.management.ObjectName;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.SharedCodeSource;
import oracle.j2ee.connector.DeployedAdapter;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.shared.SharedModuleType;

public class RuntimeRarUpdater
extends Notifier {
    private static final String ARCHIVE_DEFAULT_APPLICATION_IS_NOT_FOUND = "EnterpriseArchive for default application is not found!";
    private static final String A_STANDALONE_RESOURCE_ADAPTER_WITH_NAME_0_WAS_NOT_FOUND = "Standalone ResourceAdapter not found";
    private static final String KEY_CANT_UNDEPLOY_THE_DATA_SOURCES_CONNECTOR = "UnDeployment Failed: You may not undeploy the data sources connector.";
    private String name;
    private Map parameterMap;

    public RuntimeRarUpdater(String name) {
        this.name = name;
    }

    public RuntimeRarUpdater(String name, Map parameterMap) {
        this.name = name;
        this.parameterMap = parameterMap;
    }

    public void addGlobalRarToRuntime() throws DeployerException {
        try {
            Application application = ApplicationServer.getInstance().getDefaultApplication();
            EnterpriseArchive archive = (EnterpriseArchive)application.getConfig();
            if (archive == null) {
                throw new DeployerException(ARCHIVE_DEFAULT_APPLICATION_IS_NOT_FOUND);
            }
            if (application.getActiveDeployedAdapter(this.name) != null) {
                this.removeGlobalRarFromRuntime();
            }
            String nativeLibPath = null;
            boolean grantAllPermissions = false;
            if (this.parameterMap != null) {
                nativeLibPath = (String)this.parameterMap.get("nativeLibPath");
                grantAllPermissions = "true".equals(this.parameterMap.get("grantAllPermissions"));
            }
            String deploymentDir = ApplicationServer.getInstance().getConfig().getConnectorDirectory() + File.separator + this.name;
            String rarFileName = this.name + SharedModuleType.RAR.getModuleExtention();
            ConnectorModule module = new ConnectorModule(rarFileName, this.name, grantAllPermissions);
            if (nativeLibPath != null) {
                module.setNativeLibraryPath(nativeLibPath);
            }
            archive.addModule(module, true);
            application.addConnector(module, null, this);
        }
        catch (InstantiationException e) {
            throw new DeployerException(e);
        }
        catch (IOException e) {
            throw new DeployerException(e);
        }
    }

    public void removeGlobalRarFromRuntime() throws DeployerException {
        Application application = ApplicationServer.getInstance().getDefaultApplication();
        File[] codeSources = null;
        try {
            DeployedAdapter adapter = this.getDeployedAdapterToBeUnDeployed(application, this.name);
            String deploymentDir = ApplicationServer.getInstance().getConfig().getConnectorDirectory() + File.separator + this.name;
            EnterpriseArchive archive = (EnterpriseArchive)application.getConfig();
            ConnectorModule module = adapter.getOc4jDeploymentConfig();
            this.ensureNoDependentApplication(adapter);
            archive.removeConnectorModule(module);
            ConnectorArchive ca = module.getConnectorArchive();
            if (ca != null) {
                codeSources = ca.getCodeSources();
            }
            adapter.stop(true);
            this.suspendCodeSources(codeSources);
            this.releaseCodeSources(codeSources);
        }
        catch (IOException e) {
            try {
                throw new DeployerException(e);
            }
            catch (Throwable throwable) {
                this.releaseCodeSources(codeSources);
                throw throwable;
            }
        }
    }

    DeployedAdapter getDeployedAdapterToBeUnDeployed(Application application, String connectorModuleName) throws DeployerException {
        DeployedAdapter adapter = application.getActiveDeployedAdapter(connectorModuleName);
        if (adapter == null) {
            throw new DeployerException(A_STANDALONE_RESOURCE_ADAPTER_WITH_NAME_0_WAS_NOT_FOUND);
        }
        if (adapter.isDatasourceAdapter()) {
            throw new DeployerException(KEY_CANT_UNDEPLOY_THE_DATA_SOURCES_CONNECTOR);
        }
        return adapter;
    }

    private void suspendCodeSources(File[] sharedCodeSources) {
        if (sharedCodeSources != null) {
            for (int i = 0; i < sharedCodeSources.length; ++i) {
                SharedCodeSource sharedCodeSource = ClassLoaderQuery.findCodeSource((File)sharedCodeSources[i]);
                if (sharedCodeSource == null) continue;
                sharedCodeSource.suspend();
            }
        }
    }

    private void releaseCodeSources(File[] sharedCodeSources) {
        if (sharedCodeSources != null) {
            for (int i = 0; i < sharedCodeSources.length; ++i) {
                SharedCodeSource sharedCodeSource = ClassLoaderQuery.findCodeSource((File)sharedCodeSources[i]);
                if (sharedCodeSource == null) continue;
                sharedCodeSource.release();
            }
        }
    }

    private void ensureNoDependentApplication(DeployedAdapter adapter) throws DeployerException {
        ArrayList apps = new ArrayList();
        if (adapter.checkForActiveEndpoints(apps)) {
            String msg1 = "Unable to undeploy resource adapter with deployment name '";
            String msg2 = "' due to active endpoints in application: ";
            String msg3 = "Please stop the application first before undeploying the resource adapter";
            throw new DeployerException(msg1 + adapter.getOc4jDescriptorConfig().getName() + msg2 + apps + msg3);
        }
    }

    protected String getNotificationType() {
        return "deploy." + this.name;
    }

    protected boolean isVerbose() {
        return ApplicationServer.getInstance().getVerbosityLevel() >= 3;
    }

    protected Object getNotificationSource() {
        return "Runtime Rar Updater";
    }

    protected ObjectName getTargetObjectName() {
        return ObjectNameFactory.create((String)("oc4j:j2eeType=ResourceAdapterModule,name=" + this.name + ",J2EEApplication=default,J2EEServer=" + "standalone"));
    }
}

