/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.Application;
import com.evermind.server.ApplicationConfig;
import com.evermind.server.ApplicationConfigReference;
import com.evermind.server.ApplicationServer;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.ejb.compilation.Compilation;
import com.evermind.util.ConfigUtils;
import java.io.File;
import java.net.URL;
import java.util.Map;
import javax.management.ObjectName;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.internal.WebApplicationBinder;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;

public class RuntimeApplicationUpdater
extends Notifier {
    private String applicationName;
    private Map parameterMap;

    public RuntimeApplicationUpdater(String applicationName) {
        this.applicationName = applicationName;
    }

    public RuntimeApplicationUpdater(String applicationName, Map parameterMap) {
        this.applicationName = applicationName;
        this.parameterMap = parameterMap;
    }

    public void addApplicationToRuntime() throws DeployerException {
        this.removeExisitingApplication();
        EnterpriseArchive newArchive = this.createNewArchive();
        try {
            this.createAndStartApplication(newArchive);
            this.bindWebApplications();
        }
        catch (DeployerException de) {
            this.removeExisitingApplication();
            throw de;
        }
    }

    private void removeExisitingApplication() throws DeployerException {
        try {
            ApplicationServer appServer = ApplicationServer.getInstance();
            Application app = appServer.getApplication(this.applicationName);
            if (app != null) {
                appServer.uninstall(app, false, false);
            }
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    public void removeApplicationFromRuntime() throws DeployerException {
        ApplicationServer appServer = ApplicationServer.getInstance();
        try {
            Application application = appServer.getApplication(this.applicationName);
            if (application == null) {
                throw new DeployerException("Unable to find application: " + this.applicationName + " for undeployment");
            }
            appServer.uninstall(application, false);
        }
        catch (InstantiationException e) {
            DeployerException de = new DeployerException("Unable to remove application: " + this.applicationName + " from runtime");
            de.initCause(e);
            throw de;
        }
    }

    private EnterpriseArchive createNewArchive() throws DeployerException {
        try {
            ApplicationServer appServer = ApplicationServer.getInstance();
            String _deploymentDirPath = this.getParam("deploymentDirectory");
            if (_deploymentDirPath == null) {
                _deploymentDirPath = appServer.getConfig().getDeploymentDirectory();
            }
            URL _deploymentURL = ConfigUtils.getURL(appServer.getConfig().getURL(), _deploymentDirPath + File.separator + this.applicationName);
            String targetPath = this.getParam("targetPath");
            String appDirPath = targetPath == null ? appServer.getConfig().getApplicationDirectory() : targetPath;
            File earFile = new File(appDirPath + File.separator + this.applicationName + ".ear");
            if (!earFile.exists()) {
                throw new DeployerException("Application: " + this.applicationName + " has not been previously deployed. " + "Cannot update runtime.");
            }
            URL archiveURL = earFile.toURL();
            String parentName = this.getParam("parent");
            ApplicationConfig parentConfig = appServer.getConfig().getApplicationConfig(parentName);
            return new EnterpriseArchive(this.applicationName, archiveURL, _deploymentURL, appServer.getConfig(), parentConfig, true, null);
        }
        catch (Throwable t) {
            throw new DeployerException(t);
        }
    }

    private void createAndStartApplication(EnterpriseArchive newArchive) throws DeployerException {
        try {
            boolean enableIIOP;
            String path;
            ApplicationServer appServer = ApplicationServer.getInstance();
            String targetPath = this.getParam("targetPath");
            String string = path = targetPath == null ? appServer.getConfig().getApplicationDirectoryString() : targetPath;
            if (!path.endsWith(File.separator) && !path.endsWith("/")) {
                path = path + File.separatorChar;
            }
            path = path + newArchive.getName();
            URL configURL = appServer.getConfig().getURL();
            String parentName = newArchive.getParent().getName();
            ApplicationConfigReference appConfigReference = new ApplicationConfigReference(configURL, this.applicationName, path, parentName);
            if (this.getParam("deploymentDirectory") != null) {
                appConfigReference.setDeploymentDirectory(configURL, newArchive.getDeploymentURL().toString());
            }
            boolean bl = enableIIOP = "true".equals(this.getParam("enableIIOP")) && Compilation.iiopGen;
            if (enableIIOP) {
                appConfigReference.setIiopEnabled(true);
            }
            appConfigReference.setConfig(newArchive);
            Application application = new Application(appServer, appServer.getApplication(parentName), appConfigReference);
            application.setNotifier(this);
            appServer.addApplication(newArchive, application, RuntimeApplicationUpdater.getNotifier());
            appServer.getConfig().addApplicationConfigReference(appConfigReference);
        }
        catch (Throwable t) {
            throw new DeployerException(t);
        }
    }

    private void bindWebApplications() throws DeployerException {
        String[] moduleBindings;
        String webSiteBindings;
        WebApplicationBinder webApplicationBinder = new WebApplicationBinder();
        String siteName = this.getParam("bindWebApp");
        if (siteName != null) {
            webApplicationBinder.bindWebApp(this.applicationName, siteName);
        }
        if ((webSiteBindings = this.getParam("webSiteBindings")) != null && webSiteBindings.trim().length() > 0 && (moduleBindings = webSiteBindings.split(";")).length > 0) {
            for (int n = 0; n < moduleBindings.length; ++n) {
                if (moduleBindings[n] == null) continue;
                String[] moduleBinding = moduleBindings[n].split(":");
                String moduleName = null;
                String[] webSites = null;
                if (moduleBinding[0] != null) {
                    moduleName = moduleBinding[0].trim();
                }
                if (moduleBinding.length > 1 && moduleBinding[1].trim().length() > 0) {
                    webSites = moduleBinding[1].split(",");
                }
                if (moduleName == null || webSites.length <= 0) continue;
                for (int m = 0; m < webSites.length; ++m) {
                    if (webSites[m] == null) continue;
                    String webSite = webSites[m].trim();
                    if (moduleName.equals(".")) {
                        webApplicationBinder.bindWebApp(this.applicationName, webSite);
                        continue;
                    }
                    webApplicationBinder.bindWebApp(this.applicationName, moduleName, webSite);
                }
            }
        }
    }

    protected String getNotificationType() {
        return "deploy." + this.applicationName;
    }

    protected boolean isVerbose() {
        return ApplicationServer.getInstance().getVerbosityLevel() >= 3;
    }

    protected Object getNotificationSource() {
        return "Runtime Application Updater";
    }

    protected ObjectName getTargetObjectName() {
        return ObjectNameFactory.create((String)("oc4j:j2eeType=J2EEApplication,name=" + this.applicationName + ",J2EEServer=" + "standalone"));
    }

    protected String getParam(String key) {
        if (this.parameterMap == null) {
            return null;
        }
        Object val = this.parameterMap.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        return val.toString();
    }
}

