/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.reflect.Proxy;
import com.evermind.server.ApplicationContextClassLoader;
import com.evermind.util.EJBProperties;
import com.sun.corba.ee.impl.io.ObjectStreamClass;
import com.sun.corba.ee.impl.util.IdentityHashtable;
import com.sun.corba.ee.impl.util.RepositoryId;
import com.sun.corba.ee.impl.util.Utility;
import java.awt.Frame;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import oracle.classloader.EventDispatcher;
import oracle.classloader.LoaderLifeCycleListener;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.ApplicationLogManager;

public final class ObjectReferenceCleaner
implements LoaderLifeCycleListener {
    private static ObjectReferenceCleaner singleton;

    public static void activate() {
        if (singleton == null) {
            singleton = new ObjectReferenceCleaner();
            EventDispatcher.addListener((LoaderLifeCycleListener)singleton);
            ObjectReferenceCleaner.initializeDisposerThread();
        }
    }

    public void loaderCreated(PolicyClassLoader loader) {
    }

    public void loaderCommitted(PolicyClassLoader loader) {
    }

    public void loaderClosing(PolicyClassLoader loader) {
    }

    public void loaderCollected(String loaderName, String loaderIdentityHashCode) {
    }

    public void loaderDestroyed(PolicyClassLoader loader) {
        if (!loader.isApplicationLoader()) {
            return;
        }
        ObjectReferenceCleaner.cleanupApplicationLogger(loader);
        this.cleanupApplicationLogLevels(loader);
        Proxy.cleanupProxyClasses((ClassLoader)loader);
        if (EJBProperties.getGenerateIIOP()) {
            ObjectReferenceCleaner.cleanupIiopRelatedInstances(loader);
            ApplicationContextClassLoader.resetThreadLocalApplicationContextClassLoader();
        }
    }

    public void loaderFinalized(String loaderName, int loaderIdentityHashCode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupApplicationLogger(PolicyClassLoader loader) {
        ArrayList<Logger> loggersToClear = null;
        Map loggers = ApplicationLogManager.getApplicationLoggers();
        if (loggers == null) {
            return;
        }
        boolean obtainedLoggersToClear = false;
        while (!obtainedLoggersToClear) {
            try {
                Map map = loggers;
                synchronized (map) {
                    Iterator iterator = loggers.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry e = iterator.next();
                        Logger key = (Logger)e.getKey();
                        PolicyClassLoader value = (PolicyClassLoader)e.getValue();
                        if (value != loader) continue;
                        if (loggersToClear == null) {
                            loggersToClear = new ArrayList<Logger>();
                        }
                        loggersToClear.add(key);
                    }
                    obtainedLoggersToClear = true;
                }
            }
            catch (ConcurrentModificationException e) {
            }
        }
        if (loggersToClear == null) {
            return;
        }
        Iterator iterator = loggersToClear.iterator();
        while (iterator.hasNext()) {
            Logger logger = (Logger)iterator.next();
            ObjectReferenceCleaner.resetApplicationLogger(logger);
        }
        ObjectReferenceCleaner.rebuildLoggerTree();
    }

    private void cleanupApplicationLogLevels(PolicyClassLoader loader) {
        if (ObjectReferenceCleaner.getCachedLogLevels() == null) {
            return;
        }
        Object[] copyOfLogLevels = ObjectReferenceCleaner.getCachedLogLevels().toArray();
        for (int i = 0; i < copyOfLogLevels.length; ++i) {
            if (copyOfLogLevels[i] == null || copyOfLogLevels[i].getClass().getClassLoader() != loader) continue;
            ObjectReferenceCleaner.resetLogLevel((Level)copyOfLogLevels[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getCachedLoggersFromLogManager() {
        Hashtable loggersTbl = null;
        try {
            Class logManagerClass = LogManager.class;
            Field loggers = logManagerClass.getDeclaredField("loggers");
            loggers.setAccessible(true);
            Class clazz = logManagerClass;
            synchronized (clazz) {
                loggersTbl = (Hashtable)loggers.get(ApplicationLogManager.getLogManager());
            }
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        return loggersTbl;
    }

    private static void removeLoggerFromNodeTree(Object node, Logger deleteLogger) {
        HashMap children;
        Logger logger = (Logger)ObjectReferenceCleaner.getReflected(node.getClass(), node, "logger");
        if (logger == deleteLogger) {
            ObjectReferenceCleaner.setReflected(node.getClass(), node, "logger", null);
        }
        if ((children = (HashMap)ObjectReferenceCleaner.getReflected(node.getClass(), node, "children")) != null) {
            boolean obtainedLoggersToClear = false;
            while (!obtainedLoggersToClear) {
                try {
                    Iterator values = children.values().iterator();
                    while (values.hasNext()) {
                        Object childNode = values.next();
                        ObjectReferenceCleaner.removeLoggerFromNodeTree(childNode, deleteLogger);
                    }
                    obtainedLoggersToClear = true;
                }
                catch (ConcurrentModificationException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetApplicationLogger(Logger logger) {
        String loggerName = logger.getName();
        Hashtable loggersTbl = ObjectReferenceCleaner.getCachedLoggersFromLogManager();
        Class clazz = LogManager.class;
        synchronized (clazz) {
            loggersTbl.remove(loggerName);
        }
        Object rootNode = ObjectReferenceCleaner.getReflected(LogManager.class, ApplicationLogManager.getLogManager(), "root");
        if (rootNode != null) {
            LogManager logManager = ApplicationLogManager.getLogManager();
            synchronized (logManager) {
                ObjectReferenceCleaner.removeLoggerFromNodeTree(rootNode, logger);
            }
        }
        ApplicationLogManager.removeApplicationLoggerFromList((Logger)logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rebuildLoggerTree() {
        Object rootNode = ObjectReferenceCleaner.getReflected(LogManager.class, ApplicationLogManager.getLogManager(), "root");
        if (rootNode != null) {
            LogManager logManager = ApplicationLogManager.getLogManager();
            synchronized (logManager) {
                ObjectReferenceCleaner.rebuildLoggerTree(rootNode, null);
            }
        }
    }

    private static void rebuildLoggerTree(Object logNode, Object parentNode) {
        Logger logger = (Logger)ObjectReferenceCleaner.getReflected(logNode.getClass(), logNode, "logger");
        if (parentNode == null) {
            parentNode = logNode;
        } else if (logger != null) {
            Logger parentLogger = (Logger)ObjectReferenceCleaner.getReflected(parentNode.getClass(), parentNode, "logger");
            logger.setParent(parentLogger);
            parentNode = logNode;
        }
        HashMap children = (HashMap)ObjectReferenceCleaner.getReflected(logNode.getClass(), logNode, "children");
        if (children != null) {
            boolean obtainedLoggersToClear = false;
            while (!obtainedLoggersToClear) {
                try {
                    Iterator values = children.values().iterator();
                    while (values.hasNext()) {
                        Object childNode = values.next();
                        ObjectReferenceCleaner.rebuildLoggerTree(childNode, parentNode);
                    }
                    obtainedLoggersToClear = true;
                }
                catch (ConcurrentModificationException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List getCachedLogLevels() {
        ArrayList levelsList = null;
        try {
            Class cls = Level.class;
            Field reqdFld = cls.getDeclaredField("known");
            reqdFld.setAccessible(true);
            Class clazz = cls;
            synchronized (clazz) {
                levelsList = (ArrayList)reqdFld.get(null);
            }
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        return levelsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetLogLevel(Level levelToReset) {
        ArrayList levelsList = (ArrayList)ObjectReferenceCleaner.getCachedLogLevels();
        Object[] levelsListCopy = levelsList.toArray();
        Class clazz = Level.class;
        synchronized (clazz) {
            for (int i = 0; i < levelsListCopy.length; ++i) {
                Level level = (Level)levelsListCopy[i];
                if (level != levelToReset) continue;
                levelsList.remove(i);
            }
        }
    }

    private static void initializeDisposerThread() {
        try {
            Frame f = new Frame();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void cleanupIiopRelatedInstances(PolicyClassLoader loader) {
        ObjectReferenceCleaner.cleanupIdentityHashtable(RepositoryId.class, null, "classToRepStr", loader);
        ObjectReferenceCleaner.cleanupIdentityHashtable(RepositoryId.class, null, "classIDLToRepStr", loader);
        ObjectReferenceCleaner.cleanupIdentityHashtable(RepositoryId.class, null, "classSeqToRepStr", loader);
        ObjectReferenceCleaner.cleanupHashtable(RepositoryId.class, null, "repStrToClass", loader);
        Utility.clearCaches();
        ObjectReferenceCleaner.cleanupObjectStreamClassEntry(loader);
    }

    private static void cleanupIdentityHashtable(Class clazz, Object obj, String field, PolicyClassLoader loader) {
        ArrayList<Class> deleteList = new ArrayList<Class>();
        IdentityHashtable ih = (IdentityHashtable)ObjectReferenceCleaner.getReflected(clazz, obj, field);
        Enumeration en = ih.keys();
        while (en.hasMoreElements()) {
            Class keyClazz = (Class)en.nextElement();
            if (!ObjectReferenceCleaner.isDestroyableClassLoader(keyClazz.getClassLoader(), (ClassLoader)loader)) continue;
            deleteList.add(keyClazz);
        }
        Iterator it = deleteList.iterator();
        while (it.hasNext()) {
            ih.remove(it.next());
        }
    }

    private static void cleanupHashtable(Class clazz, Object obj, String field, PolicyClassLoader loader) {
        ArrayList deleteList = new ArrayList();
        Hashtable hashtable = (Hashtable)ObjectReferenceCleaner.getReflected(clazz, obj, field);
        Enumeration en = hashtable.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            Class valueClazz = (Class)hashtable.get(key);
            if (!ObjectReferenceCleaner.isDestroyableClassLoader(valueClazz.getClassLoader(), (ClassLoader)loader)) continue;
            deleteList.add(key);
        }
        Iterator it = deleteList.iterator();
        while (it.hasNext()) {
            hashtable.remove(it.next());
        }
    }

    private static boolean isDestroyableClassLoader(ClassLoader loader1, ClassLoader loader2) {
        if (loader1 == null || loader2 == null) {
            return false;
        }
        ClassLoader value = loader1;
        do {
            boolean result;
            if (value == loader2) {
                return true;
            }
            Class<?> loaderClass = value.getClass();
            if (!loaderClass.getName().equals("sun.rmi.rmic.iiop.ClassPathLoader") || !(result = ObjectReferenceCleaner.isDestroyableClassLoader(loaderClass.getClassLoader(), loader2))) continue;
            return true;
        } while ((value = value.getParent()) != null);
        return false;
    }

    private static void cleanupObjectStreamClassEntry(PolicyClassLoader loader) {
        Object descriptorFor = ObjectReferenceCleaner.getReflected(ObjectStreamClass.class, "", "descriptorFor");
        if (!descriptorFor.getClass().isArray()) {
            return;
        }
        Object[] descriptorForArray = (Object[])descriptorFor;
        for (int i = 0; i < descriptorForArray.length; ++i) {
            Object next;
            Object prev = null;
            Object current = descriptorForArray[i];
            if (current == null) continue;
            do {
                ObjectStreamClass currentObjectStreamClass = (ObjectStreamClass)ObjectReferenceCleaner.getReflected(current.getClass(), current, "c");
                next = ObjectReferenceCleaner.getReflected(current.getClass(), current, "next");
                Class currentClass = currentObjectStreamClass.forClass();
                if (ObjectReferenceCleaner.isDestroyableClassLoader(currentClass.getClassLoader(), (ClassLoader)loader)) {
                    if (prev == null) {
                        descriptorForArray[i] = next;
                        continue;
                    }
                    ObjectReferenceCleaner.setReflected(prev.getClass(), prev, "next", next);
                    continue;
                }
                prev = current;
            } while ((current = next) != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getReflected(Class clazz, Object obj, String fieldName) {
        try {
            Class clazz2 = clazz;
            synchronized (clazz2) {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(obj);
            }
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setReflected(Class clazz, Object obj, String fieldName, Object value) {
        try {
            Class clazz2 = clazz;
            synchronized (clazz2) {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(obj, value);
            }
        }
        catch (NoSuchFieldException e) {
            return;
        }
        catch (IllegalAccessException e) {
            return;
        }
    }
}

