/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationServer;
import com.evermind.server.OC4JServer;
import com.evermind.server.OC4JServiceInfo;
import com.evermind.server.http.HttpConnectionListener;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.XMLHttpSiteConfig;
import com.evermind.server.jms.JMSServer;
import com.evermind.server.rmi.RMIServer;
import com.evermind.util.Logger;
import com.evermind.util.ServerProperties;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.dms.instrument.State;
import oracle.j2ee.jms.oc4j.v1.XMLJMSServerConfig;
import oracle.oc4j.api.MetricCollector;
import oracle.ons.BodyBlock;
import oracle.ons.HeaderBlock;
import oracle.ons.Notification;
import oracle.ons.Publisher;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionException;
import oracle.ons.opmn.OpmnProcReady;
import oracle.ons.opmn.ProcReadyApp;
import oracle.ons.opmn.ProcReadyPort;

public class OC4JMonitorThread
implements Runnable {
    private static Logger logger;
    private static String ONS_OC4J_COMPONENT_NAME;
    private static String ONS_READY_EVENT;
    private static String ONS_PM_READY_EVENT;
    private static String ONS_FIRST_EVENT;
    private static long ONS_SUB_TIMEOUT;
    private static final String OC4J_LOADBALANCING_METRIC = "oc4jlbmetric";
    private static final int OVERRIDE_METRIC;
    private static String UID;
    private static Publisher pub;
    private static Subscriber sub;
    private static String Interest;
    private static String DEFAULT_ROUTINGID;
    private static final String OC4J_INSTANCENAME;
    private static final String OC4J_ISLAND;
    private static final String OPMN_UID;
    protected static ApplicationServer appSrv;
    public static final long DefaultInterval = 30L;
    protected static long interval;
    private MetricCollector m_metricCollector;
    private static Thread _thread;
    private static OC4JMonitorThread _singleton;
    OpmnProcReady procReady = new OpmnProcReady("oc4j");
    private static Hashtable appInfos;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String getDefaultRoutingId() {
        return DEFAULT_ROUTINGID;
    }

    public static void setDefaultRoutingId(String rid) {
        DEFAULT_ROUTINGID = rid;
    }

    public static synchronized void start(ApplicationServer appSrv) {
        if (_singleton != null) {
            return;
        }
        _singleton = new OC4JMonitorThread(appSrv);
        _thread = new Thread((Runnable)_singleton, "OC4J Monitor Thread");
        _thread.setDaemon(true);
        _thread.start();
    }

    protected OC4JMonitorThread() {
    }

    protected OC4JMonitorThread(ApplicationServer appSrv) {
        OC4JMonitorThread.appSrv = appSrv;
        UID = ServerProperties.getOracleOnsClusterName() + "#" + ServerProperties.getOracleOnsInstanceName() + "#" + ServerProperties.getOracleOnsUID() + "#D#" + ServerProperties.getOracleOc4jInstanceName() + "#" + ServerProperties.getOracleOc4JIslandName();
        try {
            interval = 1000 * ServerProperties.getOpmnPingInterval();
        }
        catch (NumberFormatException nfe) {
            interval = 30000L;
        }
        logger = appSrv.getConfig().getLogger();
        pub = new Publisher(ONS_OC4J_COMPONENT_NAME);
        try {
            sub = new Subscriber(Interest, ONS_OC4J_COMPONENT_NAME, ONS_SUB_TIMEOUT);
        }
        catch (SubscriptionException e) {
            sub = null;
        }
    }

    private void scanPorts() {
        Object jmsSrv;
        ServerSocket socket;
        RMIServer rmiSrv;
        List listeners;
        HttpServer httpSrv = appSrv.getHttpServer();
        if (httpSrv != null && (listeners = httpSrv.getListeners()) != null) {
            HttpConnectionListener listener = null;
            for (int i = 0; i < listeners.size(); ++i) {
                listener = (HttpConnectionListener)listeners.get(i);
                String id = ((XMLHttpSiteConfig)listener.getConfig()).getShortName();
                String hostname = OC4JMonitorThread.getHostname(listener.getInetAddress().getHostName());
                int port = listener.getPort();
                String protocol = listener.getProtocol();
                OC4JServer.updateService(id, protocol, port, hostname);
            }
        }
        if ((rmiSrv = appSrv.getRMIServer()) != null) {
            socket = rmiSrv.getSocket();
            if (socket != null) {
                OC4JMonitorThread.updateServiceAndSetSystemProperties(OC4JServiceInfo.RMI, socket);
            }
            if ((socket = rmiSrv.getSslSocket()) != null) {
                OC4JMonitorThread.updateServiceAndSetSystemProperties(OC4JServiceInfo.RMIS, socket);
            }
        }
        if (XMLJMSServerConfig.useNewJMSServer()) {
            jmsSrv = appSrv.getNewJMSServer();
            if (jmsSrv != null) {
                String hostname = jmsSrv.getHost();
                int port = jmsSrv.getPort();
                OC4JMonitorThread.updateServiceAndSetSystemPropertiesForNewJMS(OC4JServiceInfo.JMS, hostname, port);
            }
        } else {
            jmsSrv = appSrv.getJMSServer();
            if (jmsSrv != null && (socket = ((JMSServer)jmsSrv).getSocket()) != null) {
                OC4JMonitorThread.updateServiceAndSetSystemProperties(OC4JServiceInfo.JMS, socket);
            }
        }
    }

    protected static void updateServiceAndSetSystemPropertiesForNewJMS(String protocol, String hostname, int port) {
        if (!$assertionsDisabled && null == protocol) {
            throw new AssertionError();
        }
        OC4JServer.updateService(null, protocol, port, hostname);
        StringBuffer buff = new StringBuffer(16);
        System.setProperty(buff.append("hostname.").append(protocol).toString(), hostname);
        buff.setLength(0);
        System.setProperty(buff.append("port.").append(protocol).toString(), Integer.toString(port));
    }

    protected static void updateServiceAndSetSystemProperties(String protocol, ServerSocket socket) {
        if (!$assertionsDisabled && null == protocol) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && null == socket) {
            throw new AssertionError();
        }
        String hostname = OC4JMonitorThread.getHostname(socket.getInetAddress().getHostName());
        int port = socket.getLocalPort();
        OC4JServer.updateService(null, protocol, port, hostname);
        StringBuffer buff = new StringBuffer(16);
        System.setProperty(buff.append("hostname.").append(protocol).toString(), hostname);
        buff.setLength(0);
        System.setProperty(buff.append("port.").append(protocol).toString(), Integer.toString(port));
    }

    protected static String getHostname(String inHost) {
        String outHost = null;
        if (inHost == null || inHost.compareTo("0.0.0.0") == 0) {
            try {
                outHost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return outHost;
        }
        return inHost;
    }

    private synchronized void sendNotification(boolean first, int metric) {
        ArrayList servicesList;
        this.procReady.newMessage();
        BodyBlock bodyBlock = new BodyBlock();
        HeaderBlock headerBlock = new HeaderBlock();
        if (metric >= 0) {
            bodyBlock.putBodyElement("OpmnDms", OC4J_LOADBALANCING_METRIC, String.valueOf(metric));
            bodyBlock.putBodyElement(ONS_OC4J_COMPONENT_NAME, OC4J_LOADBALANCING_METRIC, String.valueOf(metric));
        }
        if ((servicesList = OC4JServer.getServicesList()) != null && servicesList.size() > 0) {
            for (int i = 0; i < servicesList.size(); ++i) {
                OC4JServiceInfo service = (OC4JServiceInfo)servicesList.get(i);
                if (!service.validate()) continue;
                ProcReadyPort portBlock = new ProcReadyPort(service.getProcReadyId(), service.getHostname(), service.getPortStr(), service.getProcReadyDescription(), service.getProtocol());
                this.procReady.addPort(portBlock);
            }
        }
        Enumeration e = appInfos.elements();
        while (e.hasMoreElements()) {
            AppInfo appInfo = (AppInfo)e.nextElement();
            this.procReady.addApplication(appInfo.genProcReadyApp());
            ProcReadyPort portInfo = appInfo.genProcReadyPort();
            if (portInfo == null) continue;
            this.procReady.addPort(portInfo);
        }
        this.procReady.addSpecialized("oc4jInstance", OC4J_INSTANCENAME);
        this.procReady.addSpecialized("oc4jIsland", OC4J_ISLAND);
        this.procReady.addToProcReady(headerBlock, bodyBlock);
        Notification n = new Notification(ONS_READY_EVENT, "", "", bodyBlock.generateBody());
        headerBlock.setHeader(n);
        n.setProperty("OPMN_UID", OPMN_UID);
        if (first) {
            n.setProperty(ONS_FIRST_EVENT, "true");
        } else {
            n.setProperty(ONS_FIRST_EVENT, "false");
        }
        pub.publish(n);
    }

    public static void oc4jRuntimeConfigChanged() {
        if (_singleton != null) {
            _singleton.sendNotification(false, -1);
        }
    }

    private void initMetricCollector() {
        String metricCollectorClassName = appSrv.getConfig().getMetricCollectorClassName();
        if (metricCollectorClassName != null && metricCollectorClassName.length() > 0) {
            try {
                Class<?> metricCollectorClass = Class.forName(metricCollectorClassName, true, appSrv.getDefaultApplication().getClassLoader());
                MetricCollector mc = (MetricCollector)metricCollectorClass.newInstance();
                mc.setParameters(appSrv.getConfig().getMetricCollectorParams());
                this.m_metricCollector = mc;
            }
            catch (IllegalArgumentException e) {
                System.err.println(e);
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                System.err.println("Error: could not find metric collector class: " + metricCollectorClassName);
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                System.err.println("Error: Class is not a MetricCollector: " + metricCollectorClassName);
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                System.err.println("Error: could not instantiate metric collector class: " + metricCollectorClassName);
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                System.err.println("Error: Illegal access exception in metric collector class: " + metricCollectorClassName);
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                System.err.println("Error: could not use metric collector class: " + metricCollectorClassName);
                e.printStackTrace();
            }
        }
        if (this.m_metricCollector != null) {
            this.m_metricCollector.setEnabled(true);
        }
    }

    public void run() {
        Thread.currentThread().setName("OC4JMonitorThread");
        this.initMetricCollector();
        this.scanPorts();
        State.create((String)"/oc4j/opmnInfo/vmId", (String)"", (String)"vmId", (Object)UID);
        this.sendNotification(true, -1);
        try {
            while (true) {
                Notification in_n = null;
                if (sub == null) {
                    Thread.sleep(interval);
                    try {
                        sub = new Subscriber(Interest, ONS_OC4J_COMPONENT_NAME, ONS_SUB_TIMEOUT);
                    }
                    catch (SubscriptionException e) {
                        sub = null;
                    }
                } else {
                    in_n = sub.receive(interval);
                }
                if (in_n != null && in_n.type().compareTo(ONS_READY_EVENT) != 0 && in_n.type().compareTo(ONS_PM_READY_EVENT) != 0) continue;
                int metric = -1;
                if (this.m_metricCollector != null) {
                    metric = this.m_metricCollector.getMetric();
                    if (MetricCollector.DEBUG) {
                        System.out.println("OC4J collected metric, value is:" + metric);
                    }
                    if (OVERRIDE_METRIC > 0) {
                        if (MetricCollector.DEBUG) {
                            System.out.println("Overriding the computed metric=" + metric + " with :" + OVERRIDE_METRIC);
                        }
                        metric = OVERRIDE_METRIC;
                    }
                }
                this.sendNotification(false, metric);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static void addRoutingInfo(String routingId, String appName, String root, boolean routable) {
        AppInfo appInfo;
        if (root == null || appName == null) {
            return;
        }
        if (routingId == null) {
            routingId = DEFAULT_ROUTINGID;
        }
        if ((appInfo = (AppInfo)appInfos.get(appName)) == null) {
            appInfo = new AppInfo(appName);
            appInfo.setRoutingId(routingId);
            appInfos.put(appName, appInfo);
        }
        if (appInfo.routingId == null) {
            appInfo.setRoutingId(routingId);
        }
        appInfo.addContextRoot(root, routable);
    }

    public static void changeAppRoutingId(String appName, String newRid) {
        AppInfo appInfo = (AppInfo)appInfos.get(appName);
        if (appInfo == null) {
            return;
        }
        appInfo.setRoutingId(newRid);
    }

    public static void removeAppRoutingId(String appName) {
        appInfos.remove(appName);
    }

    public static void addJGroupInfo(String appName, String jgrpName, String host, String port, String protocol) {
        if (appName == null) {
            return;
        }
        AppInfo appInfo = (AppInfo)appInfos.get(appName);
        if (appInfo == null) {
            appInfo = new AppInfo(appName);
            appInfos.put(appName, appInfo);
        }
        appInfo.setJGroupInfo(jgrpName, host, port, protocol);
    }

    public static void resetJGroupInfo(String appName) {
        if (appName == null) {
            return;
        }
        AppInfo appInfo = (AppInfo)appInfos.get(appName);
        if (appInfo != null) {
            appInfo.resetJGroupInfo();
        }
    }

    public static void setAppParent(String appName, String parentName) {
        if (appName == null) {
            return;
        }
        AppInfo appInfo = (AppInfo)appInfos.get(appName);
        if (appInfo == null) {
            appInfo = new AppInfo(appName);
            appInfos.put(appName, appInfo);
        }
        appInfo.parent = parentName;
    }

    public static void setAppClassification(String appName, String appClassification) {
        if (appName == null) {
            return;
        }
        AppInfo appInfo = (AppInfo)appInfos.get(appName);
        if (appInfo == null) {
            appInfo = new AppInfo(appName);
            appInfos.put(appName, appInfo);
        }
        appInfo.classification = appClassification;
    }

    public static void setAppState(String appName, String state) {
        if (appName == null) {
            return;
        }
        AppInfo appInfo = (AppInfo)appInfos.get(appName);
        if (appInfo == null) {
            appInfo = new AppInfo(appName);
            appInfos.put(appName, appInfo);
        }
        appInfo.state = state;
        OC4JMonitorThread.oc4jRuntimeConfigChanged();
    }

    public static void postAppDestroy(String appName) {
        Object obj = appInfos.remove(appName);
        if (obj != null) {
            OC4JMonitorThread.oc4jRuntimeConfigChanged();
        }
    }

    static {
        $assertionsDisabled = !OC4JMonitorThread.class.desiredAssertionStatus();
        ONS_OC4J_COMPONENT_NAME = "IAS/OC4J";
        ONS_READY_EVENT = "IAS/PM/PROC_READY";
        ONS_PM_READY_EVENT = "IAS/PM/PM_READY";
        ONS_FIRST_EVENT = "OPMFirst";
        ONS_SUB_TIMEOUT = 5000L;
        OVERRIDE_METRIC = Integer.getInteger("oc4j.metric.override", -1);
        Interest = "((\"generatingComponent=IAS/APACHE\")&(\"OPMFirst=true\"))|((\"generatingComponent=IAS/PM\")&(\"eventType=IAS/PM/PM_READY\"))";
        DEFAULT_ROUTINGID = ServerProperties.getOracleOPMNRoutingID();
        OC4J_INSTANCENAME = ServerProperties.getOracleOc4jInstanceName();
        OC4J_ISLAND = ServerProperties.getOracleOc4JIslandName();
        OPMN_UID = ServerProperties.getOracleOnsUID();
        _thread = null;
        _singleton = null;
        appInfos = new Hashtable();
    }

    static class AppInfo {
        String appName;
        String jgroupName;
        String jgroupHost;
        String jgroupPort;
        String jgroupProtocol;
        String routingId;
        String parent;
        String state;
        ArrayList roots;
        ArrayList routables;
        String classification;

        public AppInfo(String appName) {
            this.appName = appName;
            this.roots = new ArrayList();
            this.routables = new ArrayList();
            this.jgroupName = null;
            this.jgroupHost = null;
            this.jgroupPort = null;
            this.jgroupProtocol = null;
            this.routingId = DEFAULT_ROUTINGID;
            this.parent = null;
            this.state = "stopped";
            this.classification = null;
        }

        void setRoutingId(String rid) {
            this.routingId = rid;
        }

        void setClassification(String appClassification) {
            this.classification = appClassification;
        }

        void setJGroupInfo(String name, String host, String port, String protocol) {
            this.jgroupName = name;
            this.jgroupHost = host;
            this.jgroupPort = port;
            this.jgroupProtocol = protocol;
        }

        void resetJGroupInfo() {
            this.jgroupName = null;
            this.jgroupHost = null;
            this.jgroupPort = null;
            this.jgroupProtocol = null;
        }

        void addContextRoot(String root, boolean routable) {
            if (root == null || root.length() == 0) {
                return;
            }
            int idx = this.roots.indexOf(root);
            if (idx == -1) {
                this.roots.add(root);
                this.routables.add(routable ? Boolean.TRUE : Boolean.FALSE);
            } else {
                this.routables.set(idx, routable ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        void removeContextRoot(String root) {
            if (root == null || root.length() == 0) {
                return;
            }
            int idx = this.roots.indexOf(root);
            if (idx != -1) {
                this.roots.remove(idx);
                this.routables.remove(idx);
            }
        }

        private boolean isRoutable() {
            boolean result = true;
            for (int i = 0; i < this.routables.size(); ++i) {
                result = result && (Boolean)this.routables.get(i) != false;
            }
            return result;
        }

        ProcReadyApp genProcReadyApp() {
            ProcReadyApp appBlock = new ProcReadyApp(this.appName, this.state);
            if (this.jgroupName != null) {
                appBlock.addElement("jgroup", this.jgroupName);
            }
            if (this.jgroupProtocol != null) {
                appBlock.addElement("jgroup.protocol", this.jgroupProtocol);
            }
            if (this.parent != null) {
                appBlock.addElement("parent", this.parent);
            }
            if (this.classification != null) {
                appBlock.addElement("classification", this.classification);
            }
            appBlock.addElement("rtid", this.routingId);
            appBlock.addElement("routable", Boolean.toString(this.isRoutable()));
            appBlock.addNamedList("appctx", (List)this.roots);
            return appBlock;
        }

        ProcReadyPort genProcReadyPort() {
            if (this.jgroupHost == null || this.jgroupPort == null) {
                return null;
            }
            return new ProcReadyPort(this.jgroupName, this.jgroupHost, this.jgroupPort, "jgroup");
        }
    }
}

