/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.net.AddressContainer;
import com.evermind.security.Group;
import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.RuntimeSecurityRole;
import com.evermind.server.deployment.SecurityRole;
import com.evermind.util.PathTreeMap;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespaceAccessController {
    private UserManager manager;
    private PathTreeMap readMap = new PathTreeMap();
    private PathTreeMap writeMap = new PathTreeMap();

    public NamespaceAccessController() {
    }

    public NamespaceAccessController(PathTreeMap readMap, PathTreeMap writeMap) {
        this.readMap = readMap;
        this.writeMap = writeMap;
    }

    public NamespaceAccessController(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.startsWith("#")) continue;
                if (name.equals("read-access")) {
                    this.parseAccessNode(node, this.readMap);
                    continue;
                }
                if (name.equals("write-access")) {
                    this.parseAccessNode(node, this.writeMap);
                    continue;
                }
                throw new InstantiationException("Unknown tag: " + name);
            }
        }
    }

    protected void parseAccessNode(Node parent, PathTreeMap map) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.startsWith("#")) continue;
                if (name.equals("namespace-resource")) {
                    String path = XMLUtils.getNodeAttribute(node, "root");
                    if (path != null) {
                        SecurityRole role = new SecurityRole("<jndi-user-role>");
                        Node subNode = XMLUtils.getSubnode(node, "security-role-mapping");
                        if (subNode != null) {
                            role.parseOrionXML(subNode);
                            map.put(path, role);
                            continue;
                        }
                        throw new InstantiationException("namespace-resource tag with missing security-role-mapping subtag");
                    }
                    throw new InstantiationException("namespace-resource tag with missing 'root' attribute");
                }
                throw new InstantiationException("Unknown tag: " + name);
            }
        }
    }

    public boolean hasReadAccess(String path, User user, AddressContainer addressContainer) {
        return this.hasAccess(this.readMap, path, user, addressContainer);
    }

    public boolean hasWriteAccess(String path, User user, AddressContainer addressContainer) {
        return this.hasAccess(this.writeMap, path, user, addressContainer);
    }

    public boolean hasAccess(PathTreeMap map, String path, User user, AddressContainer addressContainer) {
        Object object = map.get(path);
        if (object == null) {
            return false;
        }
        if (object instanceof SecurityRole) {
            HashSet<SecurityRole> roles = new HashSet<SecurityRole>();
            roles.add((SecurityRole)object);
            RuntimeSecurityRole role = new RuntimeSecurityRole(this.manager, roles);
            map.put(map.getRootPath(path), role);
            return role.impliesUser(user, addressContainer);
        }
        RuntimeSecurityRole role = (RuntimeSecurityRole)object;
        return role.impliesUser(user, addressContainer);
    }

    public void setReadAccess(String path, RuntimeSecurityRole role) {
        this.readMap.put(path, role);
    }

    public void setWriteAccess(String path, RuntimeSecurityRole role) {
        this.writeMap.put(path, role);
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<namespace-access>");
        out.println(indention + "\t<read-access>");
        this.writeMap(out, indention + "\t\t", this.readMap);
        out.println(indention + "\t</read-access>");
        out.println(indention + "\t<write-access>");
        this.writeMap(out, indention + "\t\t", this.writeMap);
        out.println(indention + "\t</write-access>");
        out.println(indention + "</namespace-access>");
    }

    protected void writeMap(PrintWriter out, String indention, PathTreeMap map) throws IOException {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            SecurityRole role;
            Map.Entry entry = (Map.Entry)iterator.next();
            out.println(indention + "<namespace-resource root=\"" + XMLUtils.encode(entry.getKey().toString()) + "\">");
            if (entry.getValue() instanceof SecurityRole) {
                role = (SecurityRole)entry.getValue();
            } else {
                RuntimeSecurityRole runtimeRole = (RuntimeSecurityRole)entry.getValue();
                role = new SecurityRole(null, runtimeRole.impliesAll());
                Iterator groups = runtimeRole.getGroups().iterator();
                Iterator users = runtimeRole.getUsers().iterator();
                while (groups.hasNext()) {
                    role.addGroup(((Group)groups.next()).getName());
                }
                while (users.hasNext()) {
                    role.addUser(((User)users.next()).getName());
                }
            }
            role.writeOrionXML(out, indention + "\t");
            out.println(indention + "</namespace-resource>");
        }
    }

    public void setUserManager(UserManager manager) {
        this.manager = manager;
    }

    public PathTreeMap getReadMap() {
        return this.readMap;
    }

    public PathTreeMap getWriteMap() {
        return this.readMap;
    }

    public void setReadMap(PathTreeMap map) {
        this.readMap = map;
    }

    public void setWriteMap(PathTreeMap map) {
        this.writeMap = map;
    }
}

