/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.evermind.server.ApplicationContextClassLoader;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerThreadGroup;
import com.evermind.server.ApplicationServerThreadPoolConfig;
import com.evermind.server.ApplicationServerThreadPoolFactory;
import com.evermind.server.ServerMessages;
import com.evermind.util.ReleasableResourcePooledExecutor;
import com.evermind.xml.XMLConfig;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.ThreadPoolCallBackIf;
import oracle.oc4j.admin.management.mbeans.SystemThreadPool;
import oracle.oc4j.admin.management.mbeans.ThreadPool;

public class ApplicationServerThreadPool
extends com.evermind.util.ThreadPool
implements ThreadPoolCallBackIf {
    private static int _poolId = 0;
    private static Logger m_logger = TraceLogger.getLogger(ApplicationServerThreadPool.class);
    private ApplicationServerThreadPoolConfig _threadPoolConfig;
    ApplicationServerThreadPoolConfig.ConfigX newConfig;
    private String _poolThreadName;

    public ApplicationServerThreadPool(String poolName, ThreadGroup threadGroup, ApplicationServerThreadPoolConfig.ConfigX config) {
        super(threadGroup, false);
        this._poolThreadName = poolName;
        this.newConfig = config;
        m_logger.finest("ApplicationServerThreadPool created with name: " + this._poolThreadName);
        this.registerMBean();
        this.setClassLoader(new ApplicationContextClassLoader());
        this.setThreadPoolFactory(new ApplicationServerThreadPoolFactory(this, threadGroup, false));
    }

    public void init() {
        super.setStackSize(this.newConfig.getStackSize());
        this.setPoolSize(this.newConfig.getMinPoolSize(), this.newConfig.getMaxPoolSize());
        super.setKeepAliveTime(this.newConfig.getKeepAliveTime());
        this.setQueueSize(this.newConfig.getQueueSize());
        this.setDebug(this.newConfig.isDebug());
        if (this.isDebug()) {
            m_logger.fine(this._poolThreadName + " Min Pool Size          : " + this.getMinPoolSize());
            m_logger.fine(this._poolThreadName + " Max Pool Size          : " + this.getMaxPoolSize());
            m_logger.fine(this._poolThreadName + " Queue Size             : " + this.getQueueSize());
            m_logger.fine(this._poolThreadName + " Thread Keep Alive Time : " + this.getKeepAliveTime());
        }
        super.initPooled();
    }

    protected PooledExecutor newPooledExecutor(int maxPoolSize) {
        return new ReleasableResourcePooledExecutor(maxPoolSize);
    }

    protected PooledExecutor newPooledExecutor(Channel queue, int maxPoolSize) {
        return new ReleasableResourcePooledExecutor(queue, maxPoolSize);
    }

    protected PooledExecutor newPooledExecutor() {
        return new ReleasableResourcePooledExecutor();
    }

    public void printShort() {
        ApplicationServer server = ApplicationServer.getInstance();
        if (server != null) {
            if (server.getHttpServer() != null && server.getRMIServer() != null) {
                System.out.println(System.currentTimeMillis() + ":ThrP[" + this.getPoolSize() + "] " + "ThrQ[" + this.getQueueSize() + "]");
            }
        } else {
            System.out.println(System.currentTimeMillis() + ": TPool - P[" + this.getPoolSize() + "] " + "Q[" + this.getQueueSize() + "]");
        }
    }

    public void setMinPoolSizeConfig(int size) {
    }

    public void setMaxPoolSizeConfig(int size) {
    }

    public void setKeepAliveTimeConfig(long timeInMs) {
    }

    public void setDebugConfig(boolean d) {
    }

    public void persistConfigChange() {
        ApplicationServer server = ApplicationServer.getInstance();
        if (!this.newConfig.isImplicit() && server != null) {
            try {
                m_logger.finest("persisting configuration changes.");
                ((XMLConfig)((Object)server.getConfig())).store();
            }
            catch (ClassCastException e) {
            }
            catch (Exception e) {
                throw new JMXRuntimeException((Throwable)e);
            }
        }
    }

    public void setDebugFromMBean(boolean _debug) {
        super.setDebug(_debug);
        this.newConfig.setDebug(_debug);
    }

    public void setDebug(boolean _debug) {
        this.setDebugFromMBean(_debug);
    }

    public String getName() {
        return this._poolThreadName;
    }

    public synchronized void destroy() {
        super.destroy();
        this.unregisterMBean();
    }

    public void setMinPoolSizeFromMBean(int size) {
        super.setMinPoolSize(size);
        this.newConfig.setMinPoolSize(size);
    }

    public void setMaxPoolSizeFromMBean(int size) {
        super.setMaxPoolSize(size);
        this.newConfig.setMaxPoolSize(size);
    }

    public void setKeepAliveTimeFromMBean(long timeInMs) {
        super.setKeepAliveTime(timeInMs);
        this.newConfig.setKeepAliveTime(timeInMs);
    }

    public void setQueueCapacityFromMBean(int queueCapacity) {
        super.setQueueSize(queueCapacity);
        this.newConfig.setQueueSize(queueCapacity);
    }

    public void setStackSize(long threadStackSize) {
        super.setStackSize(threadStackSize);
    }

    public String[] getExecutingThreadNames() {
        return ((ReleasableResourcePooledExecutor)this.getPool()).getExecutingThreadNames();
    }

    public Set getConnectedUsers() {
        return ((ReleasableResourcePooledExecutor)this.getPool()).getConnectedUsers();
    }

    public Map getApplicationsInUse() {
        return ((ReleasableResourcePooledExecutor)this.getPool()).getApplicationsInUse();
    }

    private void registerMBean() {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        ThreadPool mbean = null;
        mbean = this._poolThreadName.equals("system") ? new SystemThreadPool(this, this._poolThreadName) : new ThreadPool(this, this._poolThreadName);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private void unregisterMBean() {
        try {
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            ThreadPool mbean = null;
            mbean = this._poolThreadName.equals("system") ? new SystemThreadPool(this, this._poolThreadName) : new ThreadPool(this, this._poolThreadName);
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    static Holder createThreadPool(String groupName, String poolName, ApplicationServerThreadPoolConfig.ConfigX configX) {
        Holder holder = new Holder();
        holder.group = new ApplicationServerThreadGroup(groupName);
        holder.pool = new ApplicationServerThreadPool(poolName, holder.group, configX);
        holder.pool.init();
        ServerMessages.infoThreadPoolInit(poolName);
        return holder;
    }

    static Holder createCustomThreadPool(String poolName) {
        ApplicationServerThreadPoolConfig.ConfigX configX = ApplicationServerThreadPoolConfig.getCustomConfig(poolName);
        if (configX == null) {
            return null;
        }
        return ApplicationServerThreadPool.createThreadPool(poolName, poolName, configX);
    }

    static Holder createThreadPool(String groupName, String poolName) {
        ApplicationServerThreadPoolConfig.ConfigX configX = ApplicationServerThreadPoolConfig.getConfig(poolName);
        if (configX.isImplicit() && (poolName.equals("rmi request") || poolName.equals("rmi connection"))) {
            return null;
        }
        return ApplicationServerThreadPool.createThreadPool(groupName, poolName, configX);
    }

    static class Holder {
        com.evermind.util.ThreadPool pool;
        ThreadGroup group;

        Holder() {
        }
    }
}

