/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.Application;
import com.evermind.server.ThreadState;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.EvermindHttpServletResponse;
import com.evermind.server.http.HttpRequestHandler;
import com.evermind.server.http.ServletInstanceInfo;
import com.evermind.util.ThreadPool;
import com.evermind.util.ThreadPoolThread;
import java.io.PrintStream;

public final class ApplicationServerThread
extends ThreadPoolThread {
    public PrintStream out;
    public PrintStream err;
    public final ThreadState state = new ThreadState(this, this);
    public ServletInstanceInfo servletInfo;
    public HttpRequestHandler httpHandler;
    public HttpRequestHandler httpHandlerCache;
    private static final ClassLoader MAIN_LOADER = ApplicationServerThread.class.getClassLoader();
    private boolean useThreadStateLoader = true;
    private boolean isCCLMainLoader = super.getContextClassLoader() == MAIN_LOADER;

    public ApplicationServerThread(ThreadPool pool, Runnable runnable, String name, long stackSize) {
        super(pool, runnable, name, false, stackSize);
    }

    public ApplicationServerThread(ThreadPool pool, Runnable runnable, String name, boolean daemon, long stackSize) {
        super(pool, runnable, name, daemon, stackSize);
    }

    public ApplicationServerThread(ThreadPool pool, Runnable runnable, String name, ThreadGroup group) {
        super(pool, runnable == null ? (Runnable)Application.getInternalError("runnable was null") : runnable, name, group == null ? (ThreadGroup)Application.getInternalError("group was null") : group, 0L);
    }

    public void reset() {
        this.httpHandler = null;
        this.httpHandlerCache = null;
        this.servletInfo = null;
        this.resetUseThreadStateLoader();
    }

    public EvermindHttpServletRequest getRequest() {
        if (this.httpHandler != null) {
            return this.httpHandler.request;
        }
        return null;
    }

    public EvermindHttpServletResponse getResponse() {
        if (this.httpHandler != null) {
            return this.httpHandler.response;
        }
        return null;
    }

    public void setContextClassLoader(ClassLoader ccl) {
        if (ccl == this.state.getClassLoader()) {
            this.useThreadStateLoader = true;
            if (!this.isCCLMainLoader) {
                super.setContextClassLoader(MAIN_LOADER);
                this.isCCLMainLoader = true;
            }
        } else {
            super.setContextClassLoader(ccl);
            this.useThreadStateLoader = false;
            this.isCCLMainLoader = ccl == MAIN_LOADER;
        }
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader result = super.getContextClassLoader();
        if (this.useThreadStateLoader) {
            result = this.state.getClassLoader();
        }
        return result;
    }

    boolean useThreadStateLoader() {
        return this.useThreadStateLoader;
    }

    public void resetUseThreadStateLoader() {
        this.useThreadStateLoader = true;
        if (!this.isCCLMainLoader) {
            super.setContextClassLoader(MAIN_LOADER);
            this.isCCLMainLoader = true;
        }
    }
}

