/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationServer;
import com.evermind.server.OC4JServer;
import com.evermind.server.XMLApplicationServerConfig;
import com.evermind.server.administration.DefaultApplicationServerAdministrator;
import com.evermind.server.deployment.InternalSettingsDescriptor;
import com.evermind.util.ConfigUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import oracle.oc4j.hooks.ServerProtocol;

public class ApplicationServerLauncher
implements Runnable {
    protected String configPath;
    protected boolean secure;
    protected int verbosity;
    protected boolean monitorEvents;
    protected InetAddress defaultHost;
    protected String clusterIDString;
    protected ApplicationServer server;
    protected boolean executed;
    protected boolean waiting;
    protected String failureReason;
    protected String propPath;

    public ApplicationServerLauncher(String configPath, boolean secure, int verbosity, boolean monitorEvents, InetAddress defaultHost, String clusterIDString) {
        this.configPath = configPath;
        this.secure = secure;
        this.verbosity = verbosity;
        this.monitorEvents = monitorEvents;
        this.clusterIDString = clusterIDString;
        this.defaultHost = defaultHost;
        this.propPath = null;
    }

    public ApplicationServerLauncher(String configPath, boolean secure, int verbosity, boolean monitorEvents, InetAddress defaultHost, String clusterIDString, String propPath) {
        this(configPath, secure, verbosity, monitorEvents, defaultHost, clusterIDString);
        this.propPath = propPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = DefaultApplicationServerAdministrator.iASDeploymentTransactionMutex_;
        synchronized (object) {
            ApplicationServerLauncher applicationServerLauncher;
            try {
                ApplicationServer server = null;
                InternalSettingsDescriptor internalSettings = new InternalSettingsDescriptor();
                URL internalSettingsURL = this.getClass().getResource("/internal-settings.xml");
                try {
                    if (internalSettingsURL != null) {
                        internalSettings.init(internalSettingsURL);
                    }
                    ApplicationServer.initInternalSettings(internalSettings);
                }
                catch (IOException e) {
                    System.err.println("Error reading internal-settings.xml: " + e.getMessage());
                }
                catch (InstantiationException e) {
                    System.err.println("Error parsing internal-settings.xml: " + e.getMessage());
                }
                try {
                    XMLApplicationServerConfig config = new XMLApplicationServerConfig();
                    config.init(new File(this.configPath).toURL());
                    config.setNodeID(OC4JServer.getNodeId());
                    config.setPassword(System.out);
                    config.setPropPath(this.propPath);
                    System.setProperty("oracle.j2ee.home", new File(config.getURL().getFile()).getParentFile().getParentFile().getAbsolutePath());
                    if (this.defaultHost != null) {
                        config.setAddress(this.defaultHost);
                    }
                    if (this.clusterIDString != null) {
                        try {
                            config.setNodeID(Long.parseLong(this.clusterIDString));
                        }
                        catch (NumberFormatException e) {
                            throw new InstantiationException("Invalid -clusterID specified: " + this.clusterIDString + " (must be a number)");
                        }
                    }
                    this.parseSepConfig(config);
                    server = new ApplicationServer(this.secure, this.verbosity, config);
                    if (this.monitorEvents) {
                        server.launchEventThreadChecker();
                    }
                    try {
                        XMLApplicationServerConfig e = config;
                        synchronized (e) {
                            config.store();
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Error writing server.xml");
                    }
                    server.setConfig(config);
                    if (server.getVerbosityLevel() >= 2) {
                        System.out.println(ApplicationServer.INFO + " initialized");
                    }
                    this.server = server;
                    ServerProtocol.SERVER_INITIALIZED.fire(server);
                }
                catch (InstantiationException e) {
                    this.failureReason = "Error initializing server: " + e.getMessage();
                    System.err.println(this.failureReason);
                    if (server != null) {
                        server.destroy("Critical error during startup");
                    }
                }
                catch (IOException e) {
                    this.failureReason = "Unable to read config file: " + this.configPath + (e.getMessage() == null ? "" : " (" + e.getMessage() + ")");
                    System.err.println(this.failureReason);
                }
                catch (Exception e) {
                    this.failureReason = "Error parsing application-server config file: " + e.getMessage();
                    System.err.println(this.failureReason);
                    e.printStackTrace(System.err);
                }
                Object var9_15 = null;
                applicationServerLauncher = this;
            }
            catch (Throwable throwable) {
                Object var9_16 = null;
                ApplicationServerLauncher applicationServerLauncher2 = this;
                synchronized (applicationServerLauncher2) {
                    this.executed = true;
                    if (this.waiting) {
                        this.notify();
                    }
                }
                throw throwable;
            }
            synchronized (applicationServerLauncher) {
                this.executed = true;
                if (this.waiting) {
                    this.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationServer waitFor() {
        ApplicationServerLauncher applicationServerLauncher = this;
        synchronized (applicationServerLauncher) {
            this.waiting = true;
            try {
                while (!this.executed) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.server;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    void parseSepConfig(XMLApplicationServerConfig config) {
        String sepPath;
        if (config != null && (sepPath = config.getSepConfigPath()) != null) {
            try {
                URL internalSettingsURL = ConfigUtils.getURL(config.getURL(), sepPath);
                InternalSettingsDescriptor internalSettings = new InternalSettingsDescriptor();
                internalSettings.init(internalSettingsURL);
                ApplicationServer.initInternalSettings(internalSettings);
                config.getAttributes().put("SEPS", internalSettings.getAttributes());
            }
            catch (IOException e) {
                System.err.println("Error reading internal-settings.xml: " + e.getMessage());
            }
            catch (InstantiationException e) {
                System.err.println("Error parsing internal-settings.xml: " + e.getMessage());
            }
        }
    }
}

