/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.util.DelegatingClassLoader;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Logger;
import oracle.classloader.ClassLoaderQuery;
import oracle.j2ee.util.TraceLogger;

public class ApplicationContextClassLoader
extends ClassLoader
implements DelegatingClassLoader {
    private static Logger m_logger = TraceLogger.getLogger(ApplicationContextClassLoader.class);
    private static ThreadLocal threadLocalApplicationContextClassLoader;

    public static void resetThreadLocalApplicationContextClassLoader() {
        threadLocalApplicationContextClassLoader = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new ApplicationContextClassLoader();
            }
        };
    }

    public static ApplicationContextClassLoader getThreadLocalApplicationContextClassLoader() {
        return (ApplicationContextClassLoader)threadLocalApplicationContextClassLoader.get();
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(name, true, this.getDelegatedLoader());
        if (clazz != null) {
            return clazz;
        }
        return super.loadClass(name);
    }

    public URL getResource(String name) {
        URL url;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((url = this.getDelegatedLoader().getResource(name)) != null) {
            return url;
        }
        return super.getResource(name);
    }

    public Enumeration findResources(String name) throws IOException {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return this.getDelegatedLoader().getResources(name);
    }

    public ClassLoader getDelegatedLoader() {
        ThreadState state = ThreadState.getCurrentState();
        ContextContainer container = state.getContextContainer();
        if (container != null && container.getClassLoader() != null) {
            return container.getClassLoader();
        }
        if (state.applicationThread != null && state.applicationThread.httpHandler != null && state.applicationThread.httpHandler.request.getApplication() != null) {
            return state.applicationThread.httpHandler.request.getApplication().getClassLoader();
        }
        ApplicationServer server = ApplicationServer.getInstance();
        if (server == null) {
            m_logger.warning("WARNING: Unable to get delegatedLoader as Application Server instance is null.");
            return null;
        }
        if (server.getSystemApplication() == null) {
            Object result = ClassLoaderQuery.getSystemLoader();
            if (result == null) {
                result = ClassLoader.getSystemClassLoader();
            }
            return result;
        }
        ClassLoader result = server.getSystemApplication().getClassLoader();
        if (result == null) {
            result = server.getLibraryClassLoader();
        }
        return result;
    }

    public String toString() {
        return "[ThreadContextLoader, current context: " + this.getDelegatedLoader() + "]";
    }

    static {
        ApplicationContextClassLoader.resetThreadLocalApplicationContextClassLoader();
    }
}

