/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationConfig;
import com.evermind.server.ApplicationServer;
import com.evermind.util.ConfigUtils;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.oc4j.transport.ApplicationTransportConfig;
import org.w3c.dom.Node;

public class ApplicationConfigReference
implements ApplicationTransportConfig,
XMLizable {
    public static final int USERS_LOCAL = 1;
    public static final int USERS_PARENT = 2;
    public String name;
    public String parentName;
    public int userDelegation;
    public String urlPath;
    public URL url;
    public String deploymentDirectoryPath;
    public URL deploymentDescriptorURL;
    private boolean isDefault;
    public boolean lazyLoading = false;
    private boolean _start = true;
    private String routingId;
    private boolean _enableIIOP = false;
    protected ApplicationConfig archive;
    private boolean _explodedDeployment = false;

    public ApplicationConfigReference(URL base, String name, String urlPath, String parentApplicationName) throws IOException {
        this.name = name;
        this.urlPath = urlPath;
        this.url = ConfigUtils.getURL(base, urlPath);
        this.parentName = parentApplicationName;
    }

    public ApplicationConfigReference(URL base, String name) throws InstantiationException {
        this.name = name;
        this.parentName = null;
        this.url = base;
        try {
            this.setDeploymentDirectory(this.url, ".." + File.separatorChar + "application-deployments");
        }
        catch (IOException e) {
            InstantiationException ie = new InstantiationException("Exception while reading configuration for system application");
            ie.initCause(e);
            throw ie;
        }
    }

    public ApplicationConfigReference(Node parent, URL base, boolean isDefault) throws InstantiationException {
        this.isDefault = isDefault;
        try {
            this.name = XMLUtils.getNodeAttribute(parent, "name");
            this.urlPath = XMLUtils.getNodeAttribute(parent, "path");
            this.parentName = isDefault ? ApplicationServer.getSystemApplicationName() : XMLUtils.getNodeAttribute(parent, "parent");
            this._start = !"false".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "start"));
            this.routingId = XMLUtils.getNodeAttribute(parent, "routing-id");
            String delegationType = XMLUtils.getNodeAttribute(parent, "user-delegation");
            this.userDelegation = delegationType != null && delegationType.equals("parent") ? 2 : 1;
            if (this.name == null) {
                throw new InstantiationException("<application> tag with missing name attribute");
            }
            if (this.urlPath == null) {
                throw new InstantiationException("<application> tag with missing path attribute");
            }
            this.url = ConfigUtils.getURL(base, this.urlPath);
            this.setDeploymentDirectory(base, XMLUtils.getNodeAttribute(parent, "deployment-directory"));
            this._enableIIOP = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "enable-iiop"));
            this._explodedDeployment = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "exploded-deployment"));
        }
        catch (MalformedURLException e) {
            throw new InstantiationException("Malformed URL: " + e.getMessage());
        }
        catch (IOException e) {
            throw new InstantiationException("IO Error: " + e.getMessage());
        }
    }

    public URL getURL() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public URL getDeploymentDescriptorURL() {
        return this.deploymentDescriptorURL;
    }

    public boolean isExplodedDeployment() {
        return this._explodedDeployment;
    }

    public void setExplodedDeployment(boolean explodedDeployment) {
        this._explodedDeployment = explodedDeployment;
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + this);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<" + (this.isDefault ? "global-" : "") + "application name=\"" + XMLUtils.encode(this.name) + "\" path=\"" + XMLUtils.encode(this.urlPath) + "\"");
        if (this.deploymentDirectoryPath != null) {
            buffer.append(" deployment-directory=\"" + XMLUtils.encode(this.deploymentDirectoryPath) + "\"");
        }
        if (this.parentName != null) {
            buffer.append(" parent=\"" + XMLUtils.encode(this.parentName) + "\"");
        }
        if (!this.name.equals(ApplicationServer.getSystemApplicationName())) {
            buffer.append(" start=\"" + this._start + "\"");
        }
        if (this.routingId != null) {
            buffer.append(" routing-id=\"" + this.routingId + "\"");
        }
        if (this._enableIIOP) {
            buffer.append(" enable-iiop=\"" + this._enableIIOP + "\"");
        }
        if (this.userDelegation != 1 && this.userDelegation == 2) {
            buffer.append(" user-delegation=\"parent\"");
        }
        if (this._explodedDeployment) {
            buffer.append(" exploded-deployment=\"true\"");
        }
        buffer.append(" />");
        return buffer.toString();
    }

    public void setRoutingId(String rid) {
        this.routingId = rid;
    }

    public String getRoutingId() {
        return this.routingId;
    }

    public String getParentName() {
        return this.parentName;
    }

    public int getUserDelegation() {
        return this.userDelegation;
    }

    public void setConfig(ApplicationConfig archive) {
        this.archive = archive;
    }

    public ApplicationConfig getConfig() {
        return this.archive;
    }

    public void setDeploymentDirectory(URL base, String deploymentDirectoryPath) throws MalformedURLException, IOException {
        this.deploymentDirectoryPath = deploymentDirectoryPath;
        this.deploymentDescriptorURL = deploymentDirectoryPath != null && !"[none]".equalsIgnoreCase(deploymentDirectoryPath) ? ConfigUtils.getURL(base, deploymentDirectoryPath) : null;
    }

    public void setIiopEnabled(boolean enableIIOP) {
        this._enableIIOP = enableIIOP;
    }

    public boolean isIiopEnabled() {
        return this._enableIIOP;
    }

    public final void setStart(boolean start) {
        this._start = start;
    }

    public final boolean getStart() {
        return this._start;
    }

    public final boolean isDefaultApplication() {
        return this.isDefault;
    }
}

