/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.security;

import com.evermind.security.Group;
import com.evermind.security.User;
import java.math.BigInteger;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class MemoryUser
implements User {
    private String username;
    private String password;
    private String description;
    private Locale locale;
    private Set groups = Collections.synchronizedSet(new HashSet());
    protected Set permissions = new HashSet();
    private String certificateIssuerDN;
    private BigInteger certificateSerial;

    public MemoryUser(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.username;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void addToGroup(Group group) {
        this.groups.add(group);
    }

    public void removeFromGroup(Group group) {
        this.groups.remove(group);
    }

    public boolean authenticate(String password) {
        return password.equals(this.password);
    }

    public boolean hasPermission(Permission permission) {
        Iterator iterator = this.permissions.iterator();
        while (iterator.hasNext()) {
            if (!((Permission)iterator.next()).implies(permission)) continue;
            return true;
        }
        return false;
    }

    public void setCertificate(String issuerDN, BigInteger serial) {
        this.certificateIssuerDN = issuerDN;
        this.certificateSerial = serial;
    }

    public boolean isMemberOf(Group group) {
        return this.groups.contains(group);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public BigInteger getCertificateSerial() {
        return this.certificateSerial;
    }

    public String getCertificateIssuerDN() {
        return this.certificateIssuerDN;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificateIssuerDN = certificate.getIssuerDN().getName();
        this.certificateSerial = certificate.getSerialNumber();
    }

    public Set getGroups() {
        return this.groups;
    }
}

