/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.security;

import com.evermind.security.AbstractUserManager;
import com.evermind.security.Group;
import com.evermind.security.User;
import com.evermind.security.UserAlreadyExistsException;
import com.evermind.security.UserManager;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class IndirectUserManager
implements UserManager {
    private UserManager underlying;
    private AbstractUserManager abstractUserManager;

    public IndirectUserManager() {
        this(null);
    }

    public IndirectUserManager(UserManager underlying) {
        this.setUnderlying(underlying);
    }

    public synchronized void setUnderlying(UserManager underlying) {
        this.underlying = underlying;
    }

    public final synchronized UserManager getUnderlying() {
        return this.underlying;
    }

    public synchronized UserManager delegatee() {
        UserManager d = this.underlying;
        if (this.underlying == null) {
            if (this.abstractUserManager == null) {
                this.abstractUserManager = new AbstractUserManager(){

                    public void setParent(UserManager userManager) {
                    }
                };
            }
            d = this.abstractUserManager;
        }
        return this.underlying;
    }

    public void init(Properties properties) throws InstantiationException {
        this.delegatee().init(properties);
    }

    public void setParent(UserManager parent) {
        this.delegatee().setParent(parent);
    }

    public UserManager getParent() {
        return this.delegatee().getParent();
    }

    public User getUser(String username) {
        UserManager d = this.delegatee();
        return d.getUser(username);
    }

    public User getAnonymousUser() {
        return this.delegatee().getAnonymousUser();
    }

    public Group getGroup(String name) {
        return this.delegatee().getGroup(name);
    }

    public User createUser(String username, String password) throws InstantiationException, UserAlreadyExistsException {
        return this.delegatee().createUser(username, password);
    }

    public Group createGroup(String name) throws InstantiationException {
        return this.delegatee().createGroup(name);
    }

    public User getUser(String issuerDN, BigInteger serial) {
        return this.delegatee().getUser(issuerDN, serial);
    }

    public User getUser(X509Certificate certificate) {
        return this.delegatee().getUser(certificate);
    }

    public User getAdminUser() {
        return this.delegatee().getAdminUser();
    }

    public boolean remove(User user) {
        return this.delegatee().remove(user);
    }

    public boolean remove(Group group) {
        return this.delegatee().remove(group);
    }

    public void addDefaultGroup(String name) {
        this.delegatee().addDefaultGroup(name);
    }

    public Set getDefaultGroups() {
        return this.delegatee().getDefaultGroups();
    }

    public int getUserCount() {
        return this.delegatee().getUserCount();
    }

    public int getGroupCount() {
        return this.delegatee().getGroupCount();
    }

    public List getUsers(int start, int max) {
        return this.delegatee().getUsers(start, max);
    }

    public List getGroups(int start, int max) {
        return this.delegatee().getGroups(start, max);
    }

    public boolean isUpdated() {
        return this.delegatee().isUpdated();
    }

    public void update() throws InstantiationException {
        this.delegatee().update();
    }

    public void invalidate() {
        this.delegatee().invalidate();
    }

    public void store() throws IOException {
        this.delegatee().store();
    }
}

