/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.parser;

import com.evermind.compiler.CompilationException;
import com.evermind.parser.BooleanExpression;
import com.evermind.parser.BooleanNotEqualsExpression;
import com.evermind.parser.Expression;
import com.evermind.parser.ExpressionParser;
import com.evermind.parser.ExpressionType;
import com.evermind.parser.NumberExpression;
import com.evermind.parser.NumberNotEqualsExpression;
import com.evermind.parser.StringExpression;
import com.evermind.parser.StringNotEqualsExpression;

public class NotEqualsExpressionType
implements ExpressionType {
    private String token;

    public NotEqualsExpressionType(String token) {
        this.token = token;
    }

    public boolean implies(String keyword) {
        return keyword.equals(this.token);
    }

    public Expression parse(ExpressionParser parser, String token, Expression left, Expression right) throws CompilationException {
        if (left instanceof NumberExpression && right instanceof NumberExpression) {
            return new NumberNotEqualsExpression((NumberExpression)left, (NumberExpression)right);
        }
        if (left instanceof StringExpression && right instanceof StringExpression) {
            if (!(right instanceof StringExpression)) {
                throw new CompilationException("Expected string expression");
            }
            return new StringNotEqualsExpression((StringExpression)left, (StringExpression)right);
        }
        if (left instanceof BooleanExpression && right instanceof BooleanExpression) {
            if (!(right instanceof BooleanExpression)) {
                throw new CompilationException("Expected boolean expression");
            }
            return new BooleanNotEqualsExpression((BooleanExpression)left, (BooleanExpression)right);
        }
        if (left instanceof NumberExpression) {
            throw new CompilationException("Expected numeric expression after <>");
        }
        if (left instanceof StringExpression) {
            throw new CompilationException("Expected string expression after <>");
        }
        if (left instanceof BooleanExpression) {
            throw new CompilationException("Expected boolean expression after <>");
        }
        throw new CompilationException("Expected numeric, string or boolean expression as <> operator arguments");
    }
}

