/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.parser;

import com.evermind.parser.Expression;
import com.evermind.parser.ExpressionContext;
import com.evermind.parser.NotExpression;
import com.evermind.parser.PowerExpression;
import com.evermind.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class DefaultExpressionContext
implements ExpressionContext {
    private Map variables;

    public double getDoubleParameter(String name) {
        Object value;
        Object v0 = value = this.variables == null ? null : this.variables.get(name);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.parseDouble(value);
    }

    public String getParameter(String name) {
        Object value;
        Object object = value = this.variables == null ? null : (Object)this.variables.get(name);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public void setParameter(String name, double value) {
        if (this.variables == null) {
            this.variables = new HashMap();
        }
        this.variables.put(name, new Double(value));
    }

    public void setParameter(String name, String value) {
        if (this.variables == null) {
            this.variables = new HashMap();
        }
        this.variables.put(name, value);
    }

    public String getOrSign() {
        return "or";
    }

    public String getAndSign() {
        return "and";
    }

    public String getBooleanName(int type) {
        switch (type) {
            case 0: {
                return "FALSE";
            }
            case 1: {
                return "TRUE";
            }
        }
        return "UNKNOWN";
    }

    public String getBooleanEqualsSign() {
        return "==";
    }

    public String getBooleanNotEqualsSign() {
        return "!=";
    }

    public String getAssignmentEqualsSign() {
        return "=";
    }

    public String getLessSign() {
        return "<";
    }

    public String getLessOrEqualsSign() {
        return "<=";
    }

    public String getMoreSign() {
        return ">";
    }

    public String getMoreOrEqualsSign() {
        return ">=";
    }

    public void writeStringLiteral(StringBuffer buffer, String value, Expression enclosing) {
        buffer.append('\'');
        buffer.append(StringUtils.replace(value, '\'', "\\'"));
        buffer.append('\'');
    }

    public void writeParameter(StringBuffer buffer, String value, Expression enclosing) {
        buffer.append(value);
    }

    public void writeNotEquals(StringBuffer buffer, Expression left, Expression right, Expression notEqualsExpression, Expression enclosing) {
        buffer.append('(');
        left.write(buffer, this, notEqualsExpression);
        buffer.append(" != ");
        right.write(buffer, this, notEqualsExpression);
        buffer.append(')');
    }

    public void writePowerExpression(StringBuffer buffer, Expression left, Expression right, PowerExpression powerExpression, Expression enclosing) {
        buffer.append('(');
        left.write(buffer, this, powerExpression);
        buffer.append(" ^ ");
        right.write(buffer, this, powerExpression);
        buffer.append(')');
    }

    public void writeNotExpression(StringBuffer buffer, NotExpression notExpression, Expression expression, Expression enclosing) {
        buffer.append("!(");
        expression.write(buffer, this, notExpression);
        buffer.append(')');
    }
}

