/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.net;

public class MulticastMessage {
    public long clientID;
    public int id;
    public int partCount;
    public int receivedParts;
    public int totalLength;
    public byte[][] parts = new byte[4][];
    public long lastPieceReceived;

    public MulticastMessage(long clientID, int messageID) {
        this.id = messageID;
        this.clientID = clientID;
    }

    public boolean isComplete() {
        return this.partCount != 0 && this.receivedParts == this.partCount;
    }

    public void addPart(byte[] part, int length, int segmentID) {
        while (this.parts.length <= segmentID) {
            byte[][] newParts = new byte[this.parts.length * 2][];
            System.arraycopy(this.parts, 0, newParts, 0, this.parts.length);
            this.parts = newParts;
        }
        if (part[0] == 1) {
            this.partCount = segmentID + 1;
        }
        this.totalLength += length - 17;
        this.parts[segmentID] = part;
        ++this.receivedParts;
    }

    public byte[] construct() {
        byte[] data = new byte[this.totalLength];
        for (int i = 0; i < this.partCount - 1; ++i) {
            System.arraycopy(this.parts[i], 17, data, 983 * i, 983);
        }
        System.arraycopy(this.parts[this.partCount - 1], 17, data, 983 * (this.partCount - 1), this.totalLength - 983 * (this.partCount - 1));
        return data;
    }
}

