/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming;

import com.evermind.naming.ContextRemote;
import com.evermind.naming.ContextUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class DefaultContextRemote
implements ContextRemote {
    private Context context;

    public DefaultContextRemote(Context context) {
        this.context = context;
    }

    public Map list(String name) throws NamingException {
        NamingEnumeration<NameClassPair> enumeration = this.context.list(name);
        HashMap<String, String> map = new HashMap<String, String>();
        while (enumeration.hasMore()) {
            NameClassPair pair = enumeration.next();
            map.put(pair.getName(), pair.getClassName());
        }
        return map;
    }

    public Map listBindings(String name) throws NamingException {
        NamingEnumeration<Binding> enumeration = this.context.listBindings(name);
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        while (enumeration.hasMore()) {
            Binding binding = enumeration.next();
            Object[] values = new Object[]{binding.getClassName(), binding.getObject()};
            map.put(binding.getName(), values);
        }
        return map;
    }

    public Object lookup(String name) throws NamingException {
        Object object = this.context.lookup(name);
        if (object instanceof Context) {
            return new DefaultContextRemote((Context)object);
        }
        return object;
    }

    public void bind(String name, Object object) throws NamingException {
        this.context.bind(name, object);
    }

    public void rebind(String name, Object object) throws NamingException {
        this.context.rebind(name, object);
    }

    public void unbind(String name) throws NamingException {
        this.context.unbind(name);
    }

    public void rename(String name, String newName) throws NamingException {
        this.context.rename(name, newName);
    }

    public ContextRemote createSubcontext(String name) throws NamingException {
        return new DefaultContextRemote(this.context.createSubcontext(name));
    }

    public void destroySubcontext(String name) throws NamingException {
        this.context.destroySubcontext(name);
    }

    public void storeToParent() throws NamingException {
        try {
            ContextUtils.flush(this.context);
        }
        catch (IOException e) {
            throw new NamingException("IO Error: " + e.getMessage());
        }
    }
}

