/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io.serialization;

import com.evermind.io.serialization.MoldedObjectInputStream;
import com.evermind.io.serialization.MoldedObjectOutputStream;
import com.evermind.io.serialization.MoldedSerializer;
import java.io.IOException;
import java.lang.reflect.Field;

public class MoldedSerializationField {
    public String name;
    public Field field;
    public MoldedSerializer serializer;
    public byte type;

    public MoldedSerializationField(MoldedSerializer serializer, Field field) {
        this.field = field;
        field.setAccessible(true);
        this.name = field.getName();
        this.serializer = serializer;
        Class<?> type = field.getType();
        this.type = MoldedSerializationField.getType(type);
    }

    public void write(MoldedObjectOutputStream out, Object object) throws IOException {
        try {
            switch (this.type) {
                case 73: {
                    out.writeInt(this.field.getInt(object));
                    break;
                }
                case 70: {
                    out.writeFloat(this.field.getFloat(object));
                    break;
                }
                case 74: {
                    out.writeLong(this.field.getLong(object));
                    break;
                }
                case 68: {
                    out.writeDouble(this.field.getDouble(object));
                    break;
                }
                case 66: {
                    out.writeByte(this.field.getByte(object));
                    break;
                }
                case 83: {
                    out.writeShort(this.field.getShort(object));
                    break;
                }
                case 67: {
                    out.writeChar(this.field.getChar(object));
                    break;
                }
                case 90: {
                    out.writeBoolean(this.field.getBoolean(object));
                    break;
                }
                case 98: {
                    byte[] array = (byte[])this.field.get(object);
                    if (array == null) {
                        out.writeInt(-1);
                        break;
                    }
                    out.writeInt(array.length);
                    out.write(array);
                    break;
                }
                case 115: {
                    String string = (String)this.field.get(object);
                    if (string == null) {
                        out.writeInt(-1);
                        break;
                    }
                    int length = string.length();
                    out.writeInt(length);
                    for (int i = 0; i < length; ++i) {
                        out.writeInt(string.charAt(i));
                    }
                    break;
                }
                case 76: {
                    this.serializer.write(out, this.field.get(object));
                    break;
                }
                default: {
                    throw new InternalError("Unsupported type: " + (char)this.type);
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new SecurityException("Error accessing " + this.field + ": " + e.getMessage());
        }
    }

    public void read(MoldedObjectInputStream in, Object object) throws IOException, ClassNotFoundException {
        System.out.println("Read: " + this.name + " (" + (char)this.type + ")");
        try {
            switch (this.type) {
                case 73: {
                    this.field.setInt(object, in.readInt());
                    break;
                }
                case 70: {
                    this.field.setFloat(object, in.readFloat());
                    break;
                }
                case 74: {
                    this.field.setLong(object, in.readLong());
                    break;
                }
                case 68: {
                    this.field.setDouble(object, in.readDouble());
                    break;
                }
                case 66: {
                    this.field.setByte(object, in.readByte());
                    break;
                }
                case 83: {
                    this.field.setShort(object, in.readShort());
                    break;
                }
                case 67: {
                    this.field.setChar(object, in.readChar());
                    break;
                }
                case 90: {
                    this.field.setBoolean(object, in.readBoolean());
                    break;
                }
                case 98: {
                    int size = in.readInt();
                    if (size < 0) {
                        this.field.set(object, null);
                        break;
                    }
                    byte[] array = new byte[size];
                    in.readFully(array);
                    this.field.set(object, array);
                    break;
                }
                case 115: {
                    int size = in.readInt();
                    if (size < 0) {
                        this.field.set(object, null);
                        break;
                    }
                    char[] data = new char[size];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = (char)in.readInt();
                    }
                    this.field.set(object, new String(data));
                    break;
                }
                case 76: {
                    this.field.set(object, this.serializer.read(in));
                    break;
                }
                default: {
                    throw new InternalError("Unsupported type: " + (char)this.type);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new SecurityException(e.getMessage());
        }
    }

    public static byte getType(Class type) {
        if (type == Integer.TYPE) {
            return 73;
        }
        if (type == Float.TYPE) {
            return 70;
        }
        if (type == Long.TYPE) {
            return 74;
        }
        if (type == Double.TYPE) {
            return 68;
        }
        if (type == Byte.TYPE) {
            return 66;
        }
        if (type == Short.TYPE) {
            return 83;
        }
        if (type == Character.TYPE) {
            return 67;
        }
        if (type == Boolean.TYPE) {
            return 90;
        }
        if (type == [B.class) {
            return 98;
        }
        if (type == String.class) {
            return 115;
        }
        return 76;
    }
}

