/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io.serialization;

import com.evermind.io.serialization.MoldedObjectInputStream;
import com.evermind.io.serialization.MoldedObjectOutputStream;
import com.evermind.io.serialization.MoldedSerializationContext;
import com.evermind.io.serialization.MoldedSerializationField;
import com.evermind.io.serialization.MoldedSerializer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class GenericMoldedSerializer
extends MoldedSerializer {
    public static final int READ_OBJECT = 1;
    public static final int WRITE_OBJECT = 2;
    static final Class[] CLASSES_OBJECTINPUTSTREAM = new Class[]{ObjectInputStream.class};
    static final Class[] CLASSES_OBJECTOUTPUTSTREAM = new Class[]{ObjectOutputStream.class};
    private MoldedSerializationContext context;
    private MoldedSerializer parent;
    private Class type;
    private MoldedSerializationField[] fields;
    private int flags;
    private Method readObjectMethod;
    private Method writeObjectMethod;
    private boolean externalizable;

    public GenericMoldedSerializer(MoldedSerializationContext context, Class type) throws ClassNotFoundException {
        Class superType = type.getSuperclass();
        if (superType != Object.class && superType != null) {
            this.parent = context.getSerializer(superType);
        }
        this.type = type;
        System.out.println("Type: " + type);
        try {
            this.readObjectMethod = type.getMethod("readObject", CLASSES_OBJECTINPUTSTREAM);
            this.readObjectMethod.setAccessible(true);
            if (!Modifier.isPrivate(this.readObjectMethod.getModifiers())) {
                this.readObjectMethod = null;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        System.out.println("Read: " + this.readObjectMethod);
        try {
            this.writeObjectMethod = type.getMethod("readObject", CLASSES_OBJECTOUTPUTSTREAM);
            this.writeObjectMethod.setAccessible(true);
            if (!Modifier.isPrivate(this.writeObjectMethod.getModifiers())) {
                this.writeObjectMethod = null;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (type != null && (this.readObjectMethod == null || this.writeObjectMethod == null)) {
            int modifiers;
            int i;
            Field[] typeFields = type.getDeclaredFields();
            int count = 0;
            for (i = 0; i < typeFields.length; ++i) {
                modifiers = typeFields[i].getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                ++count;
            }
            this.fields = new MoldedSerializationField[count];
            count = 0;
            for (i = 0; i < typeFields.length; ++i) {
                modifiers = typeFields[i].getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                Field typeField = typeFields[i];
                MoldedSerializationField field = new MoldedSerializationField(context.getSerializer(typeField.getType()), typeField);
                this.fields[count++] = field;
            }
        }
    }

    public void write(MoldedObjectOutputStream out, Object object) throws IOException {
        if (this.externalizable) {
            ((Externalizable)object).writeExternal(out);
        } else {
            if (this.parent != null) {
                this.parent.write(out, object);
            }
            if (this.writeObjectMethod != null) {
                try {
                    this.writeObjectMethod.invoke(object, out.getArgumentArray());
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e.toString());
                }
                catch (InvocationTargetException e) {
                    Throwable root = e.getTargetException();
                    if (root instanceof IOException) {
                        throw (IOException)root;
                    }
                    if (root instanceof Error) {
                        throw (Error)root;
                    }
                    if (root instanceof RuntimeException) {
                        throw (RuntimeException)root;
                    }
                    throw new IOException(root.toString());
                }
            } else {
                this.writeDefault(out, object);
            }
        }
    }

    public void writeDefault(MoldedObjectOutputStream out, Object object) throws IOException {
        MoldedSerializationField[] fields = this.fields;
        int fieldCount = fields.length;
        for (int i = 0; i < fieldCount; ++i) {
            fields[i].write(out, object);
        }
    }

    public Object read(MoldedObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            Object object = this.type.newInstance();
            in.currentlyReading = object;
            this.read(in, object);
            return object;
        }
        catch (InstantiationException e) {
            throw new IOException("Error creating object instance of type " + this.type.getName() + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SecurityException("Error creating object instance of type " + this.type.getName() + ": " + e.getMessage());
        }
    }

    public void read(MoldedObjectInputStream in, Object object) throws IOException, ClassNotFoundException {
        if (this.externalizable) {
            ((Externalizable)object).readExternal(in);
        } else {
            if (this.parent != null) {
                this.parent.read(in, object);
            }
            if (this.readObjectMethod != null) {
                try {
                    this.readObjectMethod.invoke(object, in.getArgumentArray());
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e.toString());
                }
                catch (InvocationTargetException e) {
                    Throwable root = e.getTargetException();
                    if (root instanceof IOException) {
                        throw (IOException)root;
                    }
                    if (root instanceof Error) {
                        throw (Error)root;
                    }
                    if (root instanceof RuntimeException) {
                        throw (RuntimeException)root;
                    }
                    throw new IOException(root.toString());
                }
            } else {
                this.readDefault(in, object);
            }
        }
    }

    public void readDefault(MoldedObjectInputStream in, Object object) throws IOException, ClassNotFoundException {
        int fieldCount = this.fields.length;
        for (int i = 0; i < fieldCount; ++i) {
            this.fields[i].read(in, object);
        }
    }
}

