/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import com.evermind.io.FilePostParser;
import java.io.IOException;
import java.io.InputStream;

public class PostFileInputStream
extends InputStream {
    private FilePostParser parser;
    private String name;
    private String filename;
    byte[] boundary;
    int endPos = -1;
    boolean eof;

    PostFileInputStream(FilePostParser parser, String boundary, String name, String filename) throws IOException {
        this.parser = parser;
        this.name = name;
        this.filename = filename;
        this.boundary = ("\r\n" + boundary).getBytes();
        this.findEndPos();
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.filename;
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.endPos >= 0 && this.parser.pos >= this.endPos || this.parser.length == 0 && this.parser.pos > this.parser.buffer.length - this.boundary.length) {
            this.eof = true;
            return -1;
        }
        if (this.parser.pos >= this.parser.buffer.length - this.boundary.length) {
            this.nextPage();
        }
        return (char)this.parser.buffer[this.parser.pos++] & 0xFF;
    }

    public int read(byte[] data, int start, int length) throws IOException {
        if (start < 0 || length < 0 || start + length > data.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.eof) {
            return -1;
        }
        int bytesRead = 0;
        if (this.endPos >= 0) {
            int lengthToRead = Math.min(this.endPos - this.parser.pos, length);
            System.arraycopy(this.parser.buffer, this.parser.pos, data, start, lengthToRead);
            bytesRead = lengthToRead;
            this.parser.pos += lengthToRead;
            if (this.parser.pos == this.endPos) {
                this.eof = true;
                this.parser.pos += this.boundary.length;
            }
            return bytesRead;
        }
        while (length > this.parser.buffer.length - this.boundary.length - this.parser.pos && this.endPos < 0) {
            System.arraycopy(this.parser.buffer, this.parser.pos, data, start, this.parser.buffer.length - this.boundary.length - this.parser.pos);
            int bytesReadNow = this.parser.buffer.length - this.boundary.length - this.parser.pos;
            bytesRead += bytesReadNow;
            this.parser.pos += bytesReadNow;
            length -= bytesReadNow;
            start += bytesReadNow;
            this.nextPage();
        }
        if (this.endPos > 0) {
            int bytesAvailable = this.endPos - this.parser.pos;
            if (length > bytesAvailable) {
                this.eof = true;
                length = bytesAvailable;
            }
            System.arraycopy(this.parser.buffer, this.parser.pos, data, start, length);
            this.parser.pos += length;
            return bytesRead += length;
        }
        System.arraycopy(this.parser.buffer, this.parser.pos, data, start, length);
        bytesRead += length;
        this.parser.pos += length;
        length -= length;
        start += length;
        return bytesRead;
    }

    private void nextPage() throws IOException {
        this.parser.nextPage(this.boundary.length);
        this.findEndPos();
    }

    private void findEndPos() {
        byte[] boundary = this.boundary;
        byte[] buffer = this.parser.buffer;
        int endOfRead = buffer.length - boundary.length;
        byte boundaryStartChar1 = boundary[0];
        byte boundaryStartChar2 = boundary[1];
        byte boundaryStartChar3 = boundary[2];
        if (this.parser.pos >= endOfRead) {
            return;
        }
        for (int i = this.parser.pos; i < endOfRead; ++i) {
            if (buffer[i] != boundaryStartChar1 || buffer[i + 1] != boundaryStartChar2 || buffer[i + 2] != boundaryStartChar3) continue;
            int x = 1;
            while (buffer[i + x] == boundary[x]) {
                if (++x != boundary.length) continue;
                this.endPos = i;
                return;
            }
        }
        this.endPos = this.parser.length == 0 ? buffer.length : -1;
    }
}

