/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class FileStreamFactory {
    private RandomAccessFile file;
    int pos;

    public FileStreamFactory(String name) throws FileNotFoundException {
        this.file = new RandomAccessFile(name, "rw");
    }

    public InputStream getInputStream() {
        FileStreamFactory masterFactory = this;
        return new InputStream(){
            FileStreamFactory factory;
            int pos;
            {
                this.factory = FileStreamFactory.this;
            }

            public int read() throws IOException {
                return this.factory.read(this.pos++);
            }

            public int read(byte[] data) throws IOException {
                return this.read(data, 0, data.length);
            }

            public int read(byte[] data, int start, int length) throws IOException {
                int l = this.factory.read(this.pos, data, start, length);
                this.pos += l;
                return l;
            }
        };
    }

    public OutputStream getOutputStream() {
        return new OutputStream(){
            FileStreamFactory factory;
            int pos;
            {
                this.factory = FileStreamFactory.this;
            }

            public void write(int i) throws IOException {
                this.factory.write(this.pos++, i);
            }

            public void write(byte[] data) throws IOException {
                this.write(data, 0, data.length);
            }

            public void write(byte[] data, int start, int length) throws IOException {
                this.factory.write(this.pos, data, start, length);
                this.pos += length;
            }
        };
    }

    synchronized int read(int pos) throws IOException {
        if (pos != this.pos) {
            this.file.seek(pos);
        }
        int i = this.file.read();
        ++pos;
        return i;
    }

    synchronized int read(int pos, byte[] data, int start, int length) throws IOException {
        if (pos != this.pos) {
            this.file.seek(pos);
        }
        int l = this.file.read(data, start, length);
        pos += length;
        return l;
    }

    synchronized void write(int pos, int i) throws IOException {
        if (pos != this.pos) {
            this.file.seek(pos);
        }
        this.file.write(i);
        ++pos;
    }

    synchronized void write(int pos, byte[] data, int start, int length) throws IOException {
        if (pos != this.pos) {
            this.file.seek(pos);
        }
        this.file.write(data, start, length);
        pos += length;
    }
}

